/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.enums;

import kd.bos.dataentity.resource.ResManager;

public enum AccountTypeEnum {
    ADD_AVERAGE("A", AccountTypeEnum.getAddAverage()),
    MOVE_WEIGHTED_AVERAGE("B", AccountTypeEnum.getMoveWeightedAverage()),
    MOVE_ADD_AVERAGE("C", AccountTypeEnum.getMoveAddAverage()),
    STANDARDCOST("D", AccountTypeEnum.getStandardCost()),
    FIN_FOUT("E", AccountTypeEnum.getFinFout()),
    SPECIAL_ACCT("F", AccountTypeEnum.getSpecialAcct()),
    FIN_FOUT_PERIOD("G", AccountTypeEnum.getFinFoutPeriod());

    private String value;
    private String desc;

    private static String getAddAverage() {
        return ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6cd5", (String)"AccountTypeEnum_0", (String)"fi-cal-common", (Object[])new Object[0]);
    }

    private static String getMoveWeightedAverage() {
        return ResManager.loadKDString((String)"\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6cd5", (String)"AccountTypeEnum_1", (String)"fi-cal-common", (Object[])new Object[0]);
    }

    private static String getMoveAddAverage() {
        return ResManager.loadKDString((String)"\u5b9e\u65f6\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6cd5", (String)"AccountTypeEnum_2", (String)"fi-cal-common", (Object[])new Object[0]);
    }

    private static String getStandardCost() {
        return ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u6cd5", (String)"AccountTypeEnum_3", (String)"fi-cal-common", (Object[])new Object[0]);
    }

    private static String getFinFout() {
        return ResManager.loadKDString((String)"\u5148\u8fdb\u5148\u51fa\u6cd5\uff08\u5b9e\u65f6\uff09", (String)"AccountTypeEnum_4", (String)"fi-cal-common", (Object[])new Object[0]);
    }

    private static String getSpecialAcct() {
        return ResManager.loadKDString((String)"\u4e2a\u522b\u8ba1\u4ef7\u6cd5", (String)"AccountTypeEnum_5", (String)"fi-cal-common", (Object[])new Object[0]);
    }

    private static String getFinFoutPeriod() {
        return ResManager.loadKDString((String)"\u5148\u8fdb\u5148\u51fa\u6cd5\uff08\u6708\u672b\uff09", (String)"AccountTypeEnum_6", (String)"fi-cal-common", (Object[])new Object[0]);
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    private AccountTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getName(String value) {
        String name = null;
        for (AccountTypeEnum type : AccountTypeEnum.values()) {
            if (!type.getValue().equals(value)) continue;
            name = type.desc;
            break;
        }
        return name;
    }

    public String getDesEveryTime() {
        String desc;
        switch (this.value) {
            case "A": {
                desc = ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6cd5", (String)"AccountTypeEnum_0", (String)"fi-cal-common", (Object[])new Object[0]);
                break;
            }
            case "B": {
                desc = ResManager.loadKDString((String)"\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6cd5", (String)"AccountTypeEnum_1", (String)"fi-cal-common", (Object[])new Object[0]);
                break;
            }
            case "C": {
                desc = ResManager.loadKDString((String)"\u5b9e\u65f6\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u6cd5", (String)"AccountTypeEnum_2", (String)"fi-cal-common", (Object[])new Object[0]);
                break;
            }
            case "D": {
                desc = ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u6cd5", (String)"AccountTypeEnum_3", (String)"fi-cal-common", (Object[])new Object[0]);
                break;
            }
            case "E": {
                desc = ResManager.loadKDString((String)"\u5148\u8fdb\u5148\u51fa\u6cd5\uff08\u5b9e\u65f6\uff09", (String)"AccountTypeEnum_4", (String)"fi-cal-common", (Object[])new Object[0]);
                break;
            }
            case "F": {
                desc = ResManager.loadKDString((String)"\u4e2a\u522b\u8ba1\u4ef7\u6cd5", (String)"AccountTypeEnum_5", (String)"fi-cal-common", (Object[])new Object[0]);
                break;
            }
            case "G": {
                desc = ResManager.loadKDString((String)"\u5148\u8fdb\u5148\u51fa\u6cd5\uff08\u6708\u672b\uff09", (String)"AccountTypeEnum_6", (String)"fi-cal-common", (Object[])new Object[0]);
                break;
            }
            default: {
                desc = "";
            }
        }
        return desc;
    }

    public static AccountTypeEnum getEnumByValue(String value) {
        for (AccountTypeEnum type : AccountTypeEnum.values()) {
            if (!type.getValue().equals(value)) continue;
            return type;
        }
        return null;
    }
}

