/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.function;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cal.common.util.CommonUtils;

public class FilterRepairByAllocDimValsFunction
extends FilterFunction {
    private static final Log logger = LogFactory.getLog(FilterRepairByAllocDimValsFunction.class);
    private RowMeta rowMeta;
    private Set<String> allocDimKeyCols;
    private String allDims;
    private static final long serialVersionUID = 1L;
    private static final Set<String> CAlSYS_DIFFALLOC_DIMS = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("configuredcode");
            this.add("assist");
            this.add("tracknumber");
            this.add("project");
            this.add("lot");
            this.add("costaccount");
            this.add("material");
            this.add("calorg");
        }
    };

    public FilterRepairByAllocDimValsFunction(RowMeta rowMeta, Set<String> allocDimKeyCols, String allDims) {
        this.rowMeta = rowMeta;
        this.allocDimKeyCols = allocDimKeyCols;
        this.allDims = allDims;
    }

    public boolean test(Row row) {
        String allocDimValsKeyCol = this.getValuesKeyCol(row);
        logger.info("FilterRepairByAllocDimValsFunction allocDimValsKeyCol=" + allocDimValsKeyCol);
        logger.info("FilterRepairByAllocDimValsFunction allocDimKeyCols=" + this.allocDimKeyCols);
        if (null == this.allocDimKeyCols || this.allocDimKeyCols.isEmpty()) {
            return Boolean.TRUE;
        }
        return this.allocDimKeyCols.contains(allocDimValsKeyCol);
    }

    private String getValuesKeyCol(Row row) {
        StringBuilder costDomainStr = new StringBuilder();
        String[] dims = this.allDims.split(",");
        List<String> dimsKeys = Arrays.asList(dims);
        Collections.sort(dimsKeys);
        for (String field : dimsKeys) {
            if (!CAlSYS_DIFFALLOC_DIMS.contains(field)) continue;
            costDomainStr.append(this.getRowValue(row, field));
        }
        return CommonUtils.getSHA256Base64Str(costDomainStr.toString());
    }

    protected Object getRowValue(Row row, String field) {
        int index = this.rowMeta.getFieldIndex(field);
        Object value = row.get(index);
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.BigDecimalType)) {
            value = BigDecimal.ZERO;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.StringType)) {
            value = " ";
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.LongType)) {
            value = 0L;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.IntegerType)) {
            value = 0;
        }
        if (value == null && this.rowMeta.getDataType(index).equals((Object)DataType.BooleanType)) {
            value = Boolean.FALSE;
        }
        return value;
    }
}

