/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.function;

import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.cal.common.model.CalRange;
import kd.fi.cal.common.model.CostAccount;

public class MatchCalRangeDataSetFunction
extends MapFunction {
    private CostAccount costAccount;
    RowMeta rowMeta;
    private String calrangeField;
    private String caldimensionField;
    private String materialGroupNum;
    private String materialId;

    public MatchCalRangeDataSetFunction(RowMeta rowMeta, Long costAccountId, String[] calGroupFields) {
        this.rowMeta = rowMeta;
        this.costAccount = new CostAccount(costAccountId);
        this.calrangeField = calGroupFields[0];
        this.caldimensionField = calGroupFields[1];
        this.materialGroupNum = calGroupFields[2];
        this.materialId = calGroupFields[3];
    }

    public Object[] map(Row row) {
        Object[] newRow = new Object[this.rowMeta.getFieldCount()];
        for (int i = 0; i < newRow.length; ++i) {
            int calrange_index = this.rowMeta.getFieldIndex(this.calrangeField);
            int caldimension_index = this.rowMeta.getFieldIndex(this.caldimensionField);
            int material_index = this.rowMeta.getFieldIndex(this.materialId);
            if (i != calrange_index || i != caldimension_index) {
                newRow[i] = row.get(i);
            }
            boolean matchNotEmpty = false;
            CalRange target = null;
            for (CalRange calrange : this.costAccount.getNotEmptyCalRange()) {
                CalRange.CalRangeEntry rangeEntry = calrange.getValidCalRangeEntry(row, this.rowMeta);
                if (rangeEntry == null) continue;
                matchNotEmpty = true;
                int calrangeid_index = this.rowMeta.getFieldIndex(this.calrangeField);
                if (calrangeid_index == -1) break;
                newRow[calrangeid_index] = rangeEntry.getRangeId();
                target = calrange;
                break;
            }
            if (!matchNotEmpty) {
                CalRange emptyCalRange = this.costAccount.getEmptyCalRange();
                int calrangeid_index = this.rowMeta.getFieldIndex(this.calrangeField);
                if (calrangeid_index != -1) {
                    newRow[calrangeid_index] = emptyCalRange.getRangeId();
                    target = emptyCalRange;
                }
            }
            if (target == null) continue;
            int mal_group_longnumber_index = this.rowMeta.getFieldIndex(this.materialGroupNum);
            if (caldimension_index == -1) continue;
            String spCaldimension = null;
            if (material_index != -1 && mal_group_longnumber_index != -1) {
                Long materialId = row.getLong(material_index);
                String mGroupNum = row.getString(mal_group_longnumber_index);
                spCaldimension = this.costAccount.getSpCaldimension(target.getRangeId().toString(), materialId.toString(), mGroupNum);
            }
            if (spCaldimension == null) {
                Long calDimensionID = target.getCalDimensionID();
                newRow[caldimension_index] = calDimensionID;
                continue;
            }
            String[] spArr = spCaldimension.split("@");
            Long calDimensionID = Long.valueOf(spArr[0]);
            newRow[caldimension_index] = calDimensionID;
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

