/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.function;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.algox.Collector;
import kd.bos.algox.FlatMapFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.model.CalRange;
import kd.fi.cal.common.model.CostAccount;

public class MatchCalRangeDataXFunction
extends FlatMapFunction {
    private CostAccount costAccount;
    RowMeta rowMeta;
    private String calrangeField;
    private String caldimensionField;
    private String materialGroupNum;
    private String materialId;
    private String[] calrange_field = new String[]{"warehouse", "location", "owner", "storageorgunit", "invstatus", "invtype"};

    public MatchCalRangeDataXFunction(RowMeta rowMeta, Long costAccountId, String[] calGroupFields) {
        this.rowMeta = rowMeta;
        this.costAccount = new CostAccount(costAccountId);
        this.calrangeField = calGroupFields[0];
        this.caldimensionField = calGroupFields[1];
        this.materialGroupNum = calGroupFields[2];
        this.materialId = calGroupFields[3];
    }

    public void flatMap(RowX rowX, Collector collector) {
        boolean matchNotEmpty = false;
        CalRange target = null;
        for (CalRange calrange : this.costAccount.getNotEmptyCalRange()) {
            CalRange.CalRangeEntry rangeEntry = calrange.getValidCalRangeEntry(rowX, this.rowMeta);
            if (rangeEntry == null) continue;
            matchNotEmpty = true;
            int calrangeid_index = this.rowMeta.getFieldIndex(this.calrangeField);
            if (calrangeid_index != -1) {
                rowX.set(calrangeid_index, (Object)rangeEntry.getRangeId());
                target = calrange;
            }
            List<CalRange.CalRangeEntry> entrys = calrange.getEntrys();
            Map<String, Long> fieldValue = rangeEntry.getFieldValue();
            Set<String> cal_fields = fieldValue.keySet();
            Set diff = Stream.of(this.calrange_field).collect(Collectors.toSet());
            diff.removeAll(cal_fields);
            if (diff.contains("owner")) {
                diff.add("ownertype");
            }
            if (entrys.size() > 1) {
                for (String cal_field : cal_fields) {
                    rowX.set(this.rowMeta.getFieldIndex(cal_field), this.getDeFaultValue(this.rowMeta, cal_field));
                }
            }
            if (entrys.size() == 1 && this.rowMeta.getFieldIndex("calrangeid") != -1) {
                rowX.set(this.rowMeta.getFieldIndex("calrangeid"), this.getDeFaultValue(this.rowMeta, "calrangeid"));
            }
            for (String s2 : diff) {
                rowX.set(this.rowMeta.getFieldIndex(s2), this.getDeFaultValue(this.rowMeta, s2));
            }
        }
        if (!matchNotEmpty) {
            CalRange emptyCalRange = this.costAccount.getEmptyCalRange();
            int calrangeid_index = this.rowMeta.getFieldIndex(this.calrangeField);
            if (calrangeid_index != -1 && emptyCalRange != null) {
                rowX.set(calrangeid_index, (Object)emptyCalRange.getRangeId());
                target = emptyCalRange;
                String[] dividebasis = emptyCalRange.getDividebasis();
                Set diff = Stream.of(this.calrange_field).collect(Collectors.toSet());
                if (dividebasis != null) {
                    Set cal_fields = Stream.of(dividebasis).map(s -> s.split(",")).flatMap(Arrays::stream).filter(s -> !StringUtils.isEmpty((String)s)).collect(Collectors.toSet());
                    diff.removeAll(cal_fields);
                    if (diff.contains("owner")) {
                        diff.add("ownertype");
                    }
                }
                for (String s3 : diff) {
                    rowX.set(this.rowMeta.getFieldIndex(s3), this.getDeFaultValue(this.rowMeta, s3));
                }
                rowX.set(this.rowMeta.getFieldIndex("calrangeid"), this.getDeFaultValue(this.rowMeta, "calrangeid"));
            }
        }
        if (target != null) {
            int caldimension_index = this.rowMeta.getFieldIndex(this.caldimensionField);
            int mal_group_longnumber_index = this.rowMeta.getFieldIndex(this.materialGroupNum);
            int material_index = this.rowMeta.getFieldIndex(this.materialId);
            if (caldimension_index != -1) {
                HashSet<String> containsField;
                String spCaldimension = null;
                if (material_index != -1 && mal_group_longnumber_index != -1) {
                    Long materialId = rowX.getLong(material_index);
                    String mGroupNum = rowX.getString(mal_group_longnumber_index);
                    spCaldimension = this.costAccount.getSpCaldimension(target.getRangeId().toString(), materialId.toString(), mGroupNum);
                }
                if (spCaldimension == null) {
                    Long calDimensionID = target.getCalDimensionID();
                    rowX.set(caldimension_index, (Object)calDimensionID);
                    String caldimension = target.getCaldimension();
                    containsField = new HashSet<String>();
                    if (StringUtils.isEmpty((String)caldimension)) {
                        this.clearField(rowX, containsField, true);
                    } else {
                        for (String s4 : caldimension.split(",")) {
                            if (StringUtils.isEmpty((String)s4)) continue;
                            containsField.add(s4);
                        }
                        this.clearField(rowX, containsField, false);
                    }
                } else {
                    String[] spArr = spCaldimension.split("@");
                    Long calDimensionID = Long.valueOf(spArr[0]);
                    rowX.set(caldimension_index, (Object)calDimensionID);
                    containsField = new HashSet();
                    for (String s5 : spArr) {
                        if (StringUtils.isEmpty((String)s5)) continue;
                        containsField.add(s5);
                    }
                    this.clearField(rowX, containsField, false);
                }
            }
        }
        collector.collect(rowX);
    }

    private void clearField(RowX rowX, Set<String> containsFields, boolean all) {
        if (this.rowMeta.getFieldIndex("lot") != -1 && (all || !containsFields.contains("lot"))) {
            rowX.set(this.rowMeta.getFieldIndex("lot"), this.getDeFaultValue(this.rowMeta, "lot"));
        }
        if (this.rowMeta.getFieldIndex("assist") != -1 && (all || !containsFields.contains("assist"))) {
            rowX.set(this.rowMeta.getFieldIndex("assist"), this.getDeFaultValue(this.rowMeta, "assist"));
        }
        if (this.rowMeta.getFieldIndex("project") != -1 && (all || !containsFields.contains("project"))) {
            rowX.set(this.rowMeta.getFieldIndex("project"), this.getDeFaultValue(this.rowMeta, "project"));
        }
        if (this.rowMeta.getFieldIndex("tracknumber") != -1 && (all || !containsFields.contains("tracknumber"))) {
            rowX.set(this.rowMeta.getFieldIndex("tracknumber"), this.getDeFaultValue(this.rowMeta, "tracknumber"));
        }
        if (this.rowMeta.getFieldIndex("configuredcode") != -1 && (all || !containsFields.contains("configuredcode"))) {
            rowX.set(this.rowMeta.getFieldIndex("configuredcode"), this.getDeFaultValue(this.rowMeta, "configuredcode"));
        }
    }

    private Object getDeFaultValue(RowMeta resultRowMeta, String field) {
        DataType dataType = resultRowMeta.getField(field).getDataType();
        Object defaultValue = null;
        if (dataType instanceof LongType) {
            defaultValue = 0L;
        } else if (dataType instanceof StringType) {
            defaultValue = "";
        } else if (dataType instanceof IntegerType) {
            defaultValue = 0;
        } else if (dataType instanceof BigDecimalType) {
            defaultValue = BigDecimal.ZERO;
        } else if (dataType instanceof BooleanType) {
            defaultValue = Boolean.TRUE;
        }
        return defaultValue;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

