/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.model.CalRangeInfo;

public class AccountType4InitCalBillHelper {
    public static DynamicObject getDefaultCalRange(long costAccountId) {
        DynamicObject[] calRanges;
        DynamicObject defaultCalRange = null;
        QFilter defaultCalRangeQFilter = new QFilter("costaccount", "=", (Object)costAccountId);
        defaultCalRangeQFilter.and(new QFilter("status", "=", (Object)"C"));
        defaultCalRangeQFilter.and(new QFilter("enable", "=", (Object)"1"));
        for (DynamicObject calRange : calRanges = BusinessDataServiceHelper.load((String)"cal_bd_calrange", (String)"id,accounttype,caldimension,entry.id", (QFilter[])new QFilter[]{defaultCalRangeQFilter})) {
            if (calRange.getDynamicObjectCollection("entry").size() != 0) continue;
            defaultCalRange = calRange;
            break;
        }
        return defaultCalRange;
    }

    public static CalRangeInfo getCalRangeInfo(DynamicObject costAccount, Map<String, Object> divideParams, DynamicObject material) {
        CalRangeInfo calRangeInfo = new CalRangeInfo();
        if (costAccount == null || divideParams == null || divideParams.size() == 0) {
            return calRangeInfo;
        }
        boolean isLocationEmpty = false;
        Long costAccountId = costAccount.getLong("id");
        boolean checkDivideBasisVal = true;
        for (Map.Entry<String, Object> param : divideParams.entrySet()) {
            if (!"location".equals(param.getKey()) && param.getValue() == null) {
                checkDivideBasisVal = false;
                break;
            }
            if (!"location".equals(param.getKey()) || !(param.getValue() instanceof Integer)) continue;
            isLocationEmpty = true;
        }
        DynamicObject defaultCalRange = AccountType4InitCalBillHelper.getDefaultCalRange(costAccountId);
        long calRangeId = 0L;
        if (defaultCalRange != null) {
            calRangeId = defaultCalRange.getLong("id");
            calRangeInfo.setCalRange(defaultCalRange);
            calRangeInfo.setAccountType(defaultCalRange.getString("accounttype"));
            calRangeInfo.setCalDimension(defaultCalRange.getDynamicObject("caldimension"));
        }
        if (!checkDivideBasisVal && defaultCalRange == null) {
            return calRangeInfo;
        }
        if (checkDivideBasisVal) {
            String[] dividebasisArr;
            QFilter calRangeQFilter = new QFilter("costaccount", "=", (Object)costAccountId);
            calRangeQFilter.and(new QFilter("status", "=", (Object)"C"));
            calRangeQFilter.and(new QFilter("enable", "=", (Object)"1"));
            String dividebasisStr = (String)divideParams.get("dividebasisStr");
            for (String field : dividebasisArr = dividebasisStr.split(",")) {
                if (isLocationEmpty && "location".equals(field)) {
                    calRangeQFilter.and("entry." + field, "=", divideParams.get(field));
                    continue;
                }
                calRangeQFilter.and("entry." + field, "=", (Object)((DynamicObject)divideParams.get(field)).getLong("id"));
            }
            DynamicObject calRange = BusinessDataServiceHelper.loadSingle((String)"cal_bd_calrange", (String)"id,accounttype,caldimension", (QFilter[])new QFilter[]{calRangeQFilter});
            if (calRange != null) {
                calRangeId = calRange.getLong("id");
                calRangeInfo.setCalRange(calRange);
                calRangeInfo.setCalDimension(calRange.getDynamicObject("caldimension"));
                calRangeInfo.setAccountType(calRange.getString("accounttype"));
            } else if (defaultCalRange == null) {
                return calRangeInfo;
            }
        }
        long materialId = material.getLong("id");
        if (calRangeId == 0L || materialId == 0L) {
            return calRangeInfo;
        }
        Set<Long> groupIds = AccountType4InitCalBillHelper.getGroupIds(materialId);
        AccountType4InitCalBillHelper.dealAccountType(materialId, calRangeInfo, calRangeId, groupIds);
        AccountType4InitCalBillHelper.dealCalDimension(materialId, calRangeInfo, calRangeId, groupIds);
        return calRangeInfo;
    }

    private static Set<Long> getGroupIds(long materialId) {
        HashSet<Long> groupIds = new HashSet<Long>(8);
        DynamicObject materialInfo = QueryServiceHelper.queryOne((String)"bd_material", (String)"group.id,group.longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)materialId)});
        long groupId = materialInfo.getLong("group.id");
        if (groupId == 0L) {
            return groupIds;
        }
        String longNumber = materialInfo.getString("group.longnumber");
        String[] groupNumbers = longNumber.split("!");
        DynamicObjectCollection matGroups = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)groupNumbers)});
        for (DynamicObject matGroup : matGroups) {
            groupIds.add(matGroup.getLong("id"));
        }
        return groupIds;
    }

    private static void dealCalDimension(long materialId, CalRangeInfo calRangeInfo, long calRangeId, Set<Long> groupIds) {
        QFilter accountTypeQFilter = new QFilter("calrange", "=", (Object)calRangeId);
        accountTypeQFilter.and(new QFilter("status", "=", (Object)"C"));
        accountTypeQFilter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter materialFilter = new QFilter("entry.material", "=", (Object)materialId);
        if (groupIds.size() > 0) {
            materialFilter.or("entry.materialgroup", "in", groupIds);
        }
        Map dimensionMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_materialdimension", (QFilter[])new QFilter[]{accountTypeQFilter, materialFilter});
        boolean isMaterialSet = false;
        for (Map.Entry mapRntry : dimensionMap.entrySet()) {
            DynamicObject materialCaldimension = (DynamicObject)mapRntry.getValue();
            for (DynamicObject dimEntry : materialCaldimension.getDynamicObjectCollection("entry")) {
                DynamicObject caldimensionDyn = dimEntry.getDynamicObject("caldimension");
                DynamicObject material = dimEntry.getDynamicObject("material");
                if (material != null) {
                    calRangeInfo.setCalDimension(caldimensionDyn);
                    isMaterialSet = true;
                    break;
                }
                calRangeInfo.setCalDimension(caldimensionDyn);
            }
            if (!isMaterialSet) continue;
            break;
        }
    }

    private static void dealAccountType(long materialId, CalRangeInfo calRangeInfo, long calRangeId, Set<Long> groupIds) {
        DynamicObject bdAccountObj;
        QFilter accountTypeQFilter = new QFilter("calrange", "=", (Object)calRangeId);
        accountTypeQFilter.and(new QFilter("status", "=", (Object)"C"));
        accountTypeQFilter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter materialFilter = new QFilter("entry.material", "=", (Object)materialId);
        if (groupIds.size() > 0) {
            materialFilter.or("entry.materialgroup", "in", groupIds);
        }
        if ((bdAccountObj = QueryServiceHelper.queryOne((String)"cal_bd_accounttype", (String)"id,entry.accounttype", (QFilter[])new QFilter[]{accountTypeQFilter, materialFilter})) != null) {
            calRangeInfo.setAccountType(bdAccountObj.getString("entry.accounttype"));
        }
    }
}

