/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.AccountTypeHelperNew;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalBillRuleHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.model.CalBillRule;

public class AccountTypeExplainHelper {
    private String entity;
    private Collection<Long> billIds = new HashSet<Long>(0);
    private DynamicObject[] billDycs = new DynamicObject[0];
    private HashSet<String> divideBasisSet;
    private HashSet<String> calDimensionSet;
    private HashSet<String> allDims;
    private static final Map<String, String> costrecordCalBillFieldMap = new HashMap<String, String>(16);
    private String billNoKey = "billno";
    private boolean isExplainFromDb = false;
    private Map<Long, DynamicObjectCollection> costAccountMap = new HashMap<Long, DynamicObjectCollection>(16);
    private String[] entryKeys;
    private Map<String, Integer> costRecordFieldIndexMap;
    private Map<String, Set<String>> entryBizFieldKeyMap;
    private Map<String, String> bizCalFieldKeyMap;
    private Map<String, List<CalBillRule>> inCalBillRuleMap;
    private Map<String, List<CalBillRule>> outCalBillRuleMap;
    private boolean accountIdSplit = false;

    public AccountTypeExplainHelper() {
    }

    public AccountTypeExplainHelper(String entity) {
        this.entity = entity;
    }

    public Map<String, Map<String, Object>> explain() {
        Map<String, Map<String, Object>> entryFieldValueMap = new HashMap<String, Map<String, Object>>(16);
        this.billIds.remove(0L);
        if (this.billIds.isEmpty() && this.billDycs.length < 1) {
            return entryFieldValueMap;
        }
        this.init();
        List<DynamicObject> allcosRecordDycs = this.getAllCostRecordDyc();
        new AccountTypeHelperNew(allcosRecordDycs.toArray(new DynamicObject[0])).handleCalRangeAccountType();
        entryFieldValueMap = this.buildResult(allcosRecordDycs);
        return entryFieldValueMap;
    }

    public void setBillIds(Collection<Long> billIds) {
        this.billIds = billIds;
    }

    public void setBillDycs(DynamicObject[] billDycs) {
        this.billDycs = billDycs;
    }

    private Map<String, Map<String, Object>> buildResult(List<DynamicObject> costRecordDycs) {
        HashMap<String, Map<String, Object>> entryFieldValueMap = new HashMap<String, Map<String, Object>>(16);
        for (DynamicObject costRecordDyc : costRecordDycs) {
            String calBillType = costRecordDyc.getString("calbilltype");
            long bizBillId = costRecordDyc.getLong("bizbillid");
            DynamicObjectCollection entryDycs = costRecordDyc.getDynamicObjectCollection("entry");
            String bizBillNo = costRecordDyc.getString("billno");
            DataEntityPropertyCollection headProps = costRecordDyc.getDataEntityType().getProperties();
            for (DynamicObject entryDyc : entryDycs) {
                HashMap<String, Object> fieldValueMap;
                String key;
                String accountType = entryDyc.getString("accounttype");
                if (accountType == null) continue;
                long bizBillEntryId = entryDyc.getLong("bizbillentryid");
                if (this.isExplainFromDb()) {
                    key = this.buildEntryKey(calBillType, bizBillEntryId);
                } else {
                    int seq = entryDyc.getInt("seq");
                    key = this.buildSeqKey(calBillType, bizBillNo, seq);
                }
                if (this.getAccountIdSplit()) {
                    key = key + "," + costRecordDyc.getLong("costaccount");
                }
                if ((fieldValueMap = (HashMap<String, Object>)entryFieldValueMap.get(key)) == null) {
                    fieldValueMap = new HashMap<String, Object>(16);
                    fieldValueMap.put("calbilltype", calBillType);
                    fieldValueMap.put("bizbillid", bizBillId);
                    fieldValueMap.put("bizbillentryid", bizBillEntryId);
                    fieldValueMap.put("billno", bizBillNo);
                    fieldValueMap.put("bizentityobject", this.entity);
                    this.putDimResult(costRecordDyc, fieldValueMap, headProps);
                    entryFieldValueMap.put(key, fieldValueMap);
                }
                fieldValueMap.put("accounttype", accountType);
                fieldValueMap.put("accounttypename", AccountTypeEnum.getName(accountType));
                fieldValueMap.put("calrange", entryDyc.get("calrange"));
                fieldValueMap.put("caldimension", entryDyc.get("caldimension_id"));
                fieldValueMap.put("material", entryDyc.get("material"));
                DataEntityPropertyCollection entryProps = entryDyc.getDataEntityType().getProperties();
                this.putDimResult(entryDyc, fieldValueMap, entryProps);
            }
        }
        return entryFieldValueMap;
    }

    private void putDimResult(DynamicObject entryDyc, Map<String, Object> fieldValueMap, DataEntityPropertyCollection entryProps) {
        for (String dim : this.allDims) {
            if (!entryProps.containsKey((Object)dim)) continue;
            IDataEntityProperty property = (IDataEntityProperty)entryProps.get((Object)dim);
            Object value = entryDyc.get(dim);
            if (property instanceof BasedataProp) {
                value = entryDyc.get(dim + "_id");
            }
            fieldValueMap.put(dim, value);
        }
    }

    private String buildEntryKey(String calBillType, long bizBillEntryId) {
        String key = bizBillEntryId + "," + calBillType;
        return key;
    }

    private String buildSeqKey(String calBillType, String bizBillNo, int seq) {
        int parentSeq = seq / 10000;
        String seqStr = "";
        seqStr = parentSeq != 0 ? parentSeq + "." + seq : String.valueOf(seq %= 10000);
        String key = bizBillNo + "," + seqStr + "," + calBillType;
        return key;
    }

    private void init() {
        if (this.billDycs != null && this.billDycs.length > 0) {
            this.entity = this.billDycs[0].getDataEntityType().getName();
        }
        String dividebasisStr = CommonSettingHelper.getDivideBasisStr();
        String[] divideBasisStrs = dividebasisStr.split(",");
        this.divideBasisSet = new HashSet<String>(Arrays.asList(divideBasisStrs));
        String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
        String[] calDimensionStrs = calDimensionStr.split(",");
        this.calDimensionSet = new HashSet<String>(Arrays.asList(calDimensionStrs));
        this.allDims = new HashSet(16);
        this.allDims.addAll(this.divideBasisSet);
        this.allDims.addAll(this.calDimensionSet);
        CalBillRuleHelper calBillRuleHelper = new CalBillRuleHelper();
        calBillRuleHelper.loadRulesByBills(new HashSet<String>(Collections.singletonList(this.entity)));
        this.inCalBillRuleMap = calBillRuleHelper.getInCalBillRuleMap();
        this.outCalBillRuleMap = calBillRuleHelper.getOutCalBillRuleMap();
        BillEntityType entityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.entity);
        this.billNoKey = entityType.getBillNo();
    }

    private List<DynamicObject> getAllCostRecordDyc() {
        DataSet billDs = this.loadBillFromDbDs();
        RowMeta rowMeta = billDs.getRowMeta();
        DataSet bulidDs = this.loadBillFromDycs(rowMeta);
        ArrayList<DynamicObject> allcosRecordDycs = new ArrayList<DynamicObject>(16);
        DynamicObject[] costRecordDycs = this.buildCostRecordDycs(billDs);
        allcosRecordDycs.addAll(Arrays.asList(costRecordDycs));
        if (bulidDs != null) {
            costRecordDycs = this.buildCostRecordDycs(bulidDs);
            allcosRecordDycs.addAll(Arrays.asList(costRecordDycs));
        }
        return allcosRecordDycs;
    }

    private DynamicObject[] buildCostRecordDycs(DataSet billDs) {
        HashMap<String, DynamicObject> accountCostRecordDycMap = new HashMap<String, DynamicObject>(16);
        try (DataSet bizBillDs = billDs;){
            for (Row row : bizBillDs) {
                DynamicObjectCollection accountDycs;
                Long ownerId = row.getLong("owner");
                if (ownerId == null || ownerId.equals(0L) || (accountDycs = this.getAllCostAccount(ownerId)).isEmpty()) continue;
                if (this.getAccountIdSplit()) {
                    for (DynamicObject accountDyc : accountDycs) {
                        Long accountId = accountDyc.getLong("id");
                        Long calOrgId = accountDyc.getLong("calorg");
                        String key = accountId + row.getString("billno") + row.getString("calbilltype");
                        DynamicObject curCostRecordDyc = accountCostRecordDycMap.computeIfAbsent(key, k -> this.createCostRecord(calOrgId, accountId, row));
                        this.createEntryDycs(curCostRecordDyc, row);
                    }
                    continue;
                }
                Long accountId = ((DynamicObject)accountDycs.get(0)).getLong("id");
                Long calOrgId = ((DynamicObject)accountDycs.get(0)).getLong("calorg");
                String key = accountId + row.getString("billno") + row.getString("calbilltype");
                DynamicObject curCostRecordDyc = accountCostRecordDycMap.computeIfAbsent(key, k -> this.createCostRecord(calOrgId, accountId, row));
                this.createEntryDycs(curCostRecordDyc, row);
            }
        }
        return accountCostRecordDycMap.values().toArray(new DynamicObject[0]);
    }

    private void createEntryDycs(DynamicObject curCostRecordDyc, Row row) {
        DynamicObjectCollection entryDycs = curCostRecordDyc.getDynamicObjectCollection("entry");
        DynamicObject newEntryDyc = entryDycs.addNew();
        DataEntityPropertyCollection entryProps = newEntryDyc.getDataEntityType().getProperties();
        DataEntityPropertyCollection headProps = curCostRecordDyc.getDataEntityType().getProperties();
        for (String dim : this.allDims) {
            IDataEntityProperty entryProp = (IDataEntityProperty)entryProps.get((Object)dim);
            IDataEntityProperty headProp = (IDataEntityProperty)headProps.get((Object)dim);
            if (entryProp != null) {
                newEntryDyc.set(dim, row.get(dim));
                if (!(entryProp instanceof BasedataProp)) continue;
                newEntryDyc.set(dim + "_id", row.get(dim));
                continue;
            }
            if (headProp == null) continue;
            curCostRecordDyc.set(dim, row.get(dim));
            if (!(headProp instanceof BasedataProp)) continue;
            curCostRecordDyc.set(dim + "_id", row.get(dim));
        }
        newEntryDyc.set("material", row.get("material"));
        newEntryDyc.set("material_id", row.get("material"));
        newEntryDyc.set("bizbillentryid", row.get("entryid"));
        newEntryDyc.set("seq", row.get("seq"));
    }

    private DynamicObject createCostRecord(Long calOrgId, Long accountId, Row row) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_costrecord");
        DynamicObject newCostRecordDyc = new DynamicObject((DynamicObjectType)entityType);
        newCostRecordDyc.set("costaccount", (Object)accountId);
        newCostRecordDyc.set("costaccount_id", (Object)accountId);
        newCostRecordDyc.set("calorg", (Object)calOrgId);
        newCostRecordDyc.set("calorg_id", (Object)calOrgId);
        newCostRecordDyc.set("storageorgunit", row.get("storageorgunit"));
        newCostRecordDyc.set("storageorgunit_id", row.get("storageorgunit"));
        newCostRecordDyc.set("calbilltype", row.get("calbilltype"));
        newCostRecordDyc.set("billno", row.get("billno"));
        newCostRecordDyc.set("bizbillid", row.get("billid"));
        return newCostRecordDyc;
    }

    private DataSet loadBillFromDbDs() {
        List<OrmInput> billOIs = this.loadBillRuleOrmInputMap(this.entity);
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet allBillDs = algo.createDataSet((Input[])billOIs.toArray(new OrmInput[billOIs.size()]));
        return allBillDs;
    }

    private List<OrmInput> loadBillRuleOrmInputMap(String entity) {
        ArrayList<OrmInput> billOIs = new ArrayList<OrmInput>(16);
        QFilter idFilter = new QFilter("id", "in", this.billIds);
        ArrayList inCalBillRules = this.inCalBillRuleMap.get(entity);
        inCalBillRules = inCalBillRules == null ? new ArrayList(0) : inCalBillRules;
        for (CalBillRule inCalBillRule : inCalBillRules) {
            List<QFilter> inBizFilters = inCalBillRule.getBillFilters();
            Map<String, String> inBillFielsMap = inCalBillRule.getCalBizFieldMap();
            inBizFilters.add(idFilter);
            QFilter ruleFilter = inBizFilters.get(0);
            this.skipBillStatusFilter(ruleFilter);
            StringBuilder selectSB = new StringBuilder();
            this.appenDivAndDim(inBillFielsMap, selectSB);
            selectSB.append("'IN' as calbilltype");
            OrmInput inOI = new OrmInput(this.getClass().getName(), entity, selectSB.toString(), inBizFilters.toArray(new QFilter[0]));
            billOIs.add(inOI);
        }
        ArrayList outCalBillRules = this.outCalBillRuleMap.get(entity);
        outCalBillRules = outCalBillRules == null ? new ArrayList(0) : outCalBillRules;
        for (CalBillRule outCalBillRule : outCalBillRules) {
            List<QFilter> outBillFilter = outCalBillRule.getBillFilters();
            Map<String, String> outBillFieldsMap = outCalBillRule.getCalBizFieldMap();
            outBillFilter.add(idFilter);
            QFilter ruleFilter = outBillFilter.get(0);
            this.skipBillStatusFilter(ruleFilter);
            StringBuilder selectSB = new StringBuilder();
            this.appenDivAndDim(outBillFieldsMap, selectSB);
            selectSB.append("'OUT' as calbilltype");
            OrmInput outOI = new OrmInput(this.getClass().getName(), entity, selectSB.toString(), outBillFilter.toArray(new QFilter[0]));
            billOIs.add(outOI);
        }
        return billOIs;
    }

    private void skipBillStatusFilter(QFilter ruleFilter) {
        if ("billstatus".equals(ruleFilter.getProperty())) {
            ruleFilter.__setProperty("1");
            ruleFilter.__setCP("=");
            ruleFilter.__setValue((Object)1);
        }
        List nests = ruleFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter curFilter = nest.getFilter();
            if (!"billstatus".equals(curFilter.getProperty())) continue;
            curFilter.__setProperty("1");
            curFilter.__setCP("=");
            curFilter.__setValue((Object)1);
        }
    }

    private void appenDivAndDim(Map<String, String> billFieldMap, StringBuilder selectSB) {
        Iterator<String> iterator = this.allDims.iterator();
        while (iterator.hasNext()) {
            String div;
            String calBillField = div = iterator.next();
            String diffCalField = costrecordCalBillFieldMap.get(div);
            if (diffCalField != null) {
                calBillField = diffCalField;
            }
            selectSB.append(billFieldMap.get(calBillField));
            selectSB.append(" as ");
            selectSB.append(div);
            selectSB.append(",");
        }
        String materialField = billFieldMap.get("material");
        String entryKey = materialField.substring(0, materialField.replace(".masterid", "").lastIndexOf("."));
        selectSB.append(this.billNoKey);
        selectSB.append(" as billno,");
        selectSB.append(entryKey);
        selectSB.append(".seq as seq,");
        selectSB.append(materialField);
        selectSB.append(" as material,");
        selectSB.append("id as billid,");
        selectSB.append(entryKey);
        selectSB.append(".id as entryid,");
    }

    private DynamicObjectCollection getAllCostAccount(long ownerId) {
        DynamicObjectCollection accountcoll = this.costAccountMap.get(ownerId);
        if (accountcoll == null) {
            DynamicObjectCollection coll = AccountingSysHelper.getAccountingSysCollsByOwner(ownerId, null);
            QFilter q = QFilter.of((String)"1 <> 1", (Object[])new Object[0]);
            for (DynamicObject info : coll) {
                long calSystemId = info.getLong("id");
                long calOrgId = info.getLong("calorgid");
                QFilter q1 = new QFilter("calsystem", "=", (Object)calSystemId);
                q1.and("calorg", "=", (Object)calOrgId);
                q.or(q1);
            }
            q.and("status", "=", (Object)"C");
            q.and("enable", "=", (Object)"1");
            accountcoll = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,ismainaccount,calorg", (QFilter[])q.toArray(), (String)"ismainaccount desc");
            this.costAccountMap.put(ownerId, accountcoll);
        }
        return accountcoll;
    }

    private DataSet loadBillFromDycs(RowMeta rowMeta) {
        if (this.billDycs.length < 1) {
            return null;
        }
        DataSetBuilder builder = Algo.create((String)this.getClass().getSimpleName()).createDataSetBuilder(rowMeta);
        ArrayList inCalBillRules = this.inCalBillRuleMap.get(this.entity);
        inCalBillRules = inCalBillRules == null ? new ArrayList(0) : inCalBillRules;
        for (CalBillRule inCalBillRule : inCalBillRules) {
            Map<String, String> inBillFielsMap = inCalBillRule.getCalBizFieldMap();
            this.appendValue(builder, rowMeta, inBillFielsMap, "IN");
        }
        ArrayList outCalBillRules = this.outCalBillRuleMap.get(this.entity);
        outCalBillRules = outCalBillRules == null ? new ArrayList(0) : outCalBillRules;
        for (CalBillRule outCalBillRule : outCalBillRules) {
            Map<String, String> outBillFieldsMap = outCalBillRule.getCalBizFieldMap();
            this.appendValue(builder, rowMeta, outBillFieldsMap, "OUT");
        }
        return builder.build();
    }

    private void appendValue(DataSetBuilder builder, RowMeta rowMeta, Map<String, String> billFieldsMap, String calBillType) {
        this.costRecordFieldIndexMap = new HashMap<String, Integer>(16);
        Field[] fields = rowMeta.getFields();
        for (int i = 0; i < fields.length; ++i) {
            this.costRecordFieldIndexMap.put(fields[i].getName(), i);
        }
        String materialField = billFieldsMap.get("material");
        String entryKey = materialField.substring(0, materialField.replace(".masterid", "").lastIndexOf("."));
        this.entryKeys = entryKey.split("\\.");
        this.entryBizFieldKeyMap = new HashMap<String, Set<String>>(16);
        this.bizCalFieldKeyMap = new HashMap<String, String>(16);
        HashSet<String> allDims = new HashSet<String>(this.allDims);
        allDims.add("material");
        DynamicObject[] dynamicObjectArray = allDims.iterator();
        while (dynamicObjectArray.hasNext()) {
            String bizBillField;
            String div;
            String calBillField = div = (String)dynamicObjectArray.next();
            String diffCalField = costrecordCalBillFieldMap.get(div);
            if (diffCalField != null) {
                calBillField = diffCalField;
            }
            if ((bizBillField = billFieldsMap.get(calBillField)) == null) continue;
            String maxEntryKey = this.entity;
            for (String item : this.entryKeys) {
                if (!bizBillField.contains(item + ".")) continue;
                maxEntryKey = item;
                bizBillField = bizBillField.replace(item + ".", "");
            }
            Set bizFiledKeys = this.entryBizFieldKeyMap.computeIfAbsent(maxEntryKey, k -> new HashSet(16));
            bizFiledKeys.add(bizBillField);
            this.bizCalFieldKeyMap.put(bizBillField, div);
        }
        for (DynamicObject billDyc : this.billDycs) {
            Object[] values = new Object[fields.length];
            values[this.costRecordFieldIndexMap.get((Object)"billno").intValue()] = billDyc.get(this.billNoKey);
            values[this.costRecordFieldIndexMap.get((Object)"calbilltype").intValue()] = calBillType;
            values[this.costRecordFieldIndexMap.get((Object)"billid").intValue()] = billDyc.getPkValue();
            Set<String> curFieldKeys = this.entryBizFieldKeyMap.get(billDyc.getDataEntityType().getName());
            if (curFieldKeys != null) {
                for (String curField : curFieldKeys) {
                    Object valueObj = billDyc.get(curField);
                    if (valueObj instanceof DynamicObject) {
                        valueObj = ((DynamicObject)valueObj).get("id");
                    }
                    values[this.costRecordFieldIndexMap.get((Object)this.bizCalFieldKeyMap.get((Object)curField)).intValue()] = valueObj;
                }
            }
            this.buildDsValue(builder, values, billDyc, 0);
        }
    }

    private void buildDsValue(DataSetBuilder builder, Object[] values, DynamicObject parentDyc, int entryKeyIndex) {
        if (entryKeyIndex >= this.entryKeys.length) {
            return;
        }
        for (DynamicObject entryDyc : parentDyc.getDynamicObjectCollection(this.entryKeys[entryKeyIndex])) {
            values = Arrays.asList(values).toArray();
            Set<String> curFieldKeys = this.entryBizFieldKeyMap.get(entryDyc.getDataEntityType().getName());
            if (curFieldKeys != null) {
                for (String bizField : curFieldKeys) {
                    Object valueObj = entryDyc.get(bizField);
                    if (valueObj instanceof DynamicObject) {
                        valueObj = ((DynamicObject)valueObj).get("id");
                    }
                    values[this.costRecordFieldIndexMap.get((Object)this.bizCalFieldKeyMap.get((Object)bizField)).intValue()] = valueObj;
                }
            }
            if (entryKeyIndex == this.entryKeys.length - 1) {
                int seq = 0;
                if (parentDyc.getDataEntityType() instanceof EntryType) {
                    seq = parentDyc.getInt("seq") * 10000;
                }
                values[this.costRecordFieldIndexMap.get((Object)"seq").intValue()] = seq + entryDyc.getInt("seq");
                values[this.costRecordFieldIndexMap.get((Object)"entryid").intValue()] = entryDyc.get("id");
            }
            this.buildDsValue(builder, values, entryDyc, entryKeyIndex + 1);
            builder.append(values);
        }
    }

    public boolean isExplainFromDb() {
        return this.isExplainFromDb;
    }

    public void setExplainFromDb(boolean explainFromDb) {
        this.isExplainFromDb = explainFromDb;
    }

    public void setAccountIdSplit(boolean accountIdSplit) {
        this.accountIdSplit = accountIdSplit;
    }

    public boolean getAccountIdSplit() {
        return this.accountIdSplit;
    }

    static {
        costrecordCalBillFieldMap.put("storageorgunit", "storageorg");
        costrecordCalBillFieldMap.put("assist", "assistproperty");
    }
}

