/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostDomainKeyHelper;
import kd.fi.cal.common.model.SynBillErrInfo;

public class AccountTypeHelperNew {
    private static final Log logger = LogFactory.getLog(AccountTypeHelperNew.class);
    private DynamicObject[] billInfos;
    private Set<Object> costAccountIDs;
    private Set<Object> calRangeIDs;
    private Map<Object, DynamicObject> calRangeMap;
    private Map<Object, DynamicObject> costAccountMap;
    private Map<Object, Map<Object, List<String>>> AccountCalRangeValueMap;
    private Map<String, Object> calRangeValueMap;
    private Map<String, String> DivideBasisValueMap;
    private Map<String, String> accountTypeMaterialValueMap;
    private Map<String, String> accountTypeMaterialGroupValueMap;
    private Map<String, DynamicObject> caldimensionMaterialValueMap;
    private Map<String, DynamicObject> caldimensionMaterialGroupValueMap;
    private Map<Long, String> materialGroupCache;
    private CostDomainKeyHelper costDomainKeyHelper = new CostDomainKeyHelper();
    private String totalDivideBasisStr;
    private static final String DEFAULTVALUE = "0";
    private boolean isBalance = false;

    public AccountTypeHelperNew(DynamicObject[] infos) {
        this.init(infos);
    }

    public AccountTypeHelperNew(DynamicObject[] infos, Boolean isBalance) {
        this.isBalance = isBalance;
        this.init(infos);
    }

    private void init(DynamicObject[] infos) {
        this.billInfos = infos;
        this.costAccountIDs = new HashSet<Object>(16);
        HashSet<Long> materialIdSet = new HashSet<Long>();
        for (DynamicObject info : infos) {
            if (info == null) continue;
            this.costAccountIDs.add(info.get("costaccount_id"));
            if (this.isBalance) {
                materialIdSet.add(info.getLong("material_id"));
                continue;
            }
            for (DynamicObject entry : info.getDynamicObjectCollection(this.getEntryName())) {
                materialIdSet.add(entry.getLong("material_id"));
            }
        }
        this.costAccountMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_costaccount", (String)"id,dividebasis.dividebasis", (QFilter[])new QFilter("id", "in", this.costAccountIDs).toArray());
        this.calRangeValueMap = new HashMap<String, Object>();
        this.DivideBasisValueMap = new HashMap<String, String>();
        this.accountTypeMaterialValueMap = new HashMap<String, String>();
        this.accountTypeMaterialGroupValueMap = new HashMap<String, String>();
        this.caldimensionMaterialValueMap = new HashMap<String, DynamicObject>();
        this.caldimensionMaterialGroupValueMap = new HashMap<String, DynamicObject>();
        this.materialGroupCache = new HashMap<Long, String>();
        this.totalDivideBasisStr = CommonSettingHelper.getDivideBasisStr();
        this.initMaterialGroupCache(materialIdSet);
        this.initCalRangeValue();
        this.initAccountTypeValue();
        this.initCaldimensionValue();
    }

    public void handleCalRangeAccountType() {
        for (DynamicObject info : this.billInfos) {
            Object costAccountId = info.get("costaccount_id");
            DynamicObjectCollection coll = info.getDynamicObjectCollection(this.getEntryName());
            for (DynamicObject entryInfo : coll) {
                Object calRangeId = this.getCalRangeId(costAccountId, entryInfo, false);
                String accountType = this.getAccountType(entryInfo, calRangeId);
                DynamicObject caldimension = this.getCaldimension(entryInfo, calRangeId);
                this.costDomainKeyHelper.setCalDimensionValue(this.getCalDimensionValue(entryInfo, caldimension));
                String costdomainKey = this.costDomainKeyHelper.getCostDomainDimsionKey();
                entryInfo.set("calrange", calRangeId);
                entryInfo.set("accounttype", (Object)accountType);
                entryInfo.set("caldimension", (Object)caldimension);
                entryInfo.set("costdomainkey", (Object)costdomainKey);
            }
        }
    }

    public void handleCalRangeAccountType4CostRecord(Set<Long> isCalInvSchemeIds, Set<Long> isCalInvTypeIds, Set<Long> notUpdbizTypeIds) {
        for (DynamicObject info : this.billInfos) {
            Object costAccountId = info.get("costaccount_id");
            DynamicObjectCollection coll = info.getDynamicObjectCollection(this.getEntryName());
            boolean joinCal = isCalInvSchemeIds.contains(info.getLong("invscheme"));
            boolean notUpdBalance = notUpdbizTypeIds.contains(info.getLong("biztype"));
            for (DynamicObject entryInfo : coll) {
                Object calRangeId = this.getCalRangeId(costAccountId, entryInfo, false);
                String accountType = this.getAccountType(entryInfo, calRangeId);
                DynamicObject caldimension = this.getCaldimension(entryInfo, calRangeId);
                entryInfo.set("calrange", calRangeId);
                entryInfo.set("caldimension", (Object)caldimension);
                this.costDomainKeyHelper.setCalDimensionValue(this.getCalDimensionValue(entryInfo, caldimension));
                String costdomainKey = this.costDomainKeyHelper.getCostDomainDimsionKey();
                entryInfo.set("costdomainkey", (Object)costdomainKey);
                if ((!joinCal || !isCalInvTypeIds.contains(entryInfo.getLong("invtype_id"))) && !notUpdBalance) continue;
                entryInfo.set("accounttype", (Object)accountType);
            }
        }
    }

    public void handleCalRangeAccType4InitBill() {
        for (DynamicObject info : this.billInfos) {
            Object costAccountId = info.get("costaccount_id");
            DynamicObjectCollection coll = info.getDynamicObjectCollection(this.getEntryName());
            for (DynamicObject entryInfo : coll) {
                String oldAccounttype;
                Object calRangeId = this.getCalRangeId(costAccountId, entryInfo, false);
                String accountType = this.getAccountType(entryInfo, calRangeId);
                DynamicObject caldimension = this.getCaldimension(entryInfo, calRangeId);
                this.costDomainKeyHelper.setCalDimensionValue(this.getCalDimensionValue(entryInfo, caldimension));
                String costdomainKey = this.costDomainKeyHelper.getCostDomainDimsionKey();
                entryInfo.set("costdomainkey", (Object)costdomainKey);
                entryInfo.set("calrange", (Object)this.calRangeMap.get(calRangeId));
                if (accountType != null && !accountType.equals(oldAccounttype = entryInfo.getString("accounttype"))) {
                    if (AccountTypeEnum.STANDARDCOST.getValue().equals(oldAccounttype)) {
                        entryInfo.set("costdiff", (Object)BigDecimal.ZERO);
                        entryInfo.set("createtype", (Object)"");
                    }
                    if (AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) {
                        entryInfo.set("price", (Object)BigDecimal.ZERO);
                    }
                }
                entryInfo.set("accounttype", (Object)accountType);
                entryInfo.set("caldimension", (Object)caldimension);
            }
        }
    }

    public void handleCalRangeAccType4InitBill(Map<Long, SynBillErrInfo> errMap) {
        block0: for (DynamicObject info : this.billInfos) {
            Object costAccountId = info.get("costaccount_id");
            DynamicObjectCollection coll = info.getDynamicObjectCollection(this.getEntryName());
            int seq = 0;
            for (DynamicObject entryInfo : coll) {
                ++seq;
                Object calRangeId = this.getCalRangeId(costAccountId, entryInfo, false);
                if (0L == (Long)calRangeId) {
                    DynamicObject costAccountInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount", (String)"id,number,name");
                    String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\uff08%2$s\uff09\u201d\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u6838\u7b97\u8303\u56f4\u3002", (String)"SyncBizBill4AuditServiceProcess_21", (String)"fi-cal-business", (Object[])new Object[0]), costAccountInfo.getString("number"), costAccountInfo.getString("name"));
                    errMap.put(info.getLong("bizbillid"), new SynBillErrInfo("3", msg));
                    continue block0;
                }
                String accountType = this.getAccountType(entryInfo, calRangeId);
                DynamicObject caldimension = this.getCaldimension(entryInfo, calRangeId);
                this.costDomainKeyHelper.setCalDimensionValue(this.getCalDimensionValue(entryInfo, caldimension));
                String costdomainKey = this.costDomainKeyHelper.getCostDomainDimsionKey();
                entryInfo.set("costdomainkey", (Object)costdomainKey);
                entryInfo.set("calrange", (Object)this.calRangeMap.get(calRangeId));
                entryInfo.set("accounttype", (Object)accountType);
                entryInfo.set("caldimension", (Object)caldimension);
            }
        }
    }

    public void handleCalRangeAccountType4InitBalance() {
        HashSet<Long> balIdSet = new HashSet<Long>(32);
        for (DynamicObject info : this.billInfos) {
            balIdSet.add(info.getLong("id"));
        }
        HashSet<DynamicObject> updateSet = new HashSet<DynamicObject>();
        HashSet<DynamicObject> insertSet = new HashSet<DynamicObject>();
        Map balMap = BusinessDataServiceHelper.loadFromCache((String)"cal_balance_calrange", (QFilter[])new QFilter("id", "in", balIdSet).toArray());
        for (DynamicObject info : this.billInfos) {
            Object costAccountId = info.get("costaccount_id");
            Object calRangeId = this.getCalRangeId(costAccountId, info, true);
            String accountType = this.getAccountType(info, calRangeId);
            long balId = info.getLong("id");
            DynamicObject caldimension = this.getCaldimension(info, calRangeId);
            DynamicObject balCalRangeInfo = (DynamicObject)balMap.get(balId);
            if (balCalRangeInfo != null) {
                balCalRangeInfo.set("calrange", calRangeId);
                balCalRangeInfo.set("accounttype", (Object)accountType);
                if (caldimension != null) {
                    balCalRangeInfo.set("caldimension", (Object)caldimension.getLong("id"));
                }
                updateSet.add(balCalRangeInfo);
                continue;
            }
            balCalRangeInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_calrange");
            balCalRangeInfo.set("calrange", calRangeId);
            balCalRangeInfo.set("accounttype", (Object)accountType);
            if (caldimension != null) {
                balCalRangeInfo.set("caldimension", (Object)caldimension.getLong("id"));
            }
            balCalRangeInfo.set("id", (Object)balId);
            insertSet.add(balCalRangeInfo);
        }
        if (!updateSet.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateSet.toArray(new DynamicObject[0]));
        }
        if (!insertSet.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])insertSet.toArray(new DynamicObject[0]));
        }
    }

    public void handleCalRangeAccountType4NewBal() {
        HashSet<DynamicObject> updateSet = new HashSet<DynamicObject>();
        for (DynamicObject info : this.billInfos) {
            Boolean isUpdate = Boolean.FALSE;
            Object costAccountId = info.get("costaccount_id");
            Object calRangeId = this.getCalRangeId(costAccountId, info, true);
            String accountType = this.getAccountType(info, calRangeId);
            DynamicObject caldimension = this.getCaldimension(info, calRangeId);
            if (calRangeId != null && Long.valueOf(calRangeId.toString()).compareTo(info.getLong("calrange_id")) != 0) {
                info.set("calrange", calRangeId);
                isUpdate = Boolean.TRUE;
            }
            if (accountType != null && !accountType.equals(info.getString("accounttype"))) {
                info.set("accounttype", (Object)accountType);
                isUpdate = Boolean.TRUE;
            }
            if (caldimension != null && info.getLong("caldimension_id") != caldimension.getLong("id")) {
                info.set("caldimension", (Object)caldimension.getLong("id"));
                isUpdate = Boolean.TRUE;
            } else if (caldimension == null && info.getLong("caldimension_id") != 0L) {
                info.set("caldimension", (Object)0L);
                isUpdate = Boolean.TRUE;
            }
            if (!isUpdate.booleanValue()) continue;
            updateSet.add(info);
        }
        if (!updateSet.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateSet.toArray(new DynamicObject[0]));
        }
    }

    public String getAccountType(DynamicObject entryInfo, Object calRangeId) {
        if (calRangeId.equals(0L)) {
            return null;
        }
        long materialId = entryInfo.getLong("material_id");
        this.costDomainKeyHelper.setMaterial(materialId);
        String key = calRangeId + "_" + materialId;
        String accountType = this.accountTypeMaterialValueMap.get(key);
        if (accountType == null) {
            String groupLongNum = this.materialGroupCache.get(materialId);
            if (!this.materialGroupCache.containsKey(materialId)) {
                QFilter q = new QFilter("standard", "=", (Object)730148448254487552L);
                q.and("material", "=", (Object)materialId);
                DynamicObject material = QueryServiceHelper.queryOne((String)"bd_materialgroupdetail", (String)"id,group.number,group.longnumber", (QFilter[])q.toArray());
                if (material != null) {
                    groupLongNum = material.getString("group.longnumber");
                }
                this.materialGroupCache.put(materialId, groupLongNum);
            }
            if (groupLongNum != null) {
                String[] groupNums = groupLongNum.split("!");
                for (int i = groupNums.length - 1; i >= 0; --i) {
                    String groupNum = groupNums[i];
                    if (!this.accountTypeMaterialGroupValueMap.containsKey(calRangeId + "_" + groupNum)) continue;
                    accountType = this.accountTypeMaterialGroupValueMap.get(calRangeId + "_" + groupNum);
                    break;
                }
            }
            if (accountType == null) {
                accountType = this.calRangeMap.get(calRangeId).getString("accounttype");
            }
            this.accountTypeMaterialValueMap.put(key, accountType);
        }
        return accountType;
    }

    protected DynamicObject getCaldimension(DynamicObject entryInfo, Object calRangeId) {
        if (calRangeId.equals(0L)) {
            return null;
        }
        long materialId = entryInfo.getLong("material_id");
        String key = calRangeId + "_" + materialId;
        DynamicObject caldimension = this.caldimensionMaterialValueMap.get(key);
        if (caldimension == null) {
            String groupLongNum = this.materialGroupCache.get(materialId);
            if (!this.materialGroupCache.containsKey(materialId)) {
                QFilter q = new QFilter("standard", "=", (Object)730148448254487552L);
                q.and("material", "=", (Object)materialId);
                DynamicObject material = QueryServiceHelper.queryOne((String)"bd_materialgroupdetail", (String)"id,group.number,group.longnumber", (QFilter[])q.toArray());
                if (material != null) {
                    groupLongNum = material.getString("group.number");
                }
                this.materialGroupCache.put(materialId, groupLongNum);
            }
            if (groupLongNum != null) {
                String[] groupNums = groupLongNum.split("!");
                for (int i = groupNums.length - 1; i >= 0; --i) {
                    String groupNum = groupNums[i];
                    if (!this.caldimensionMaterialGroupValueMap.containsKey(calRangeId + "_" + groupNum)) continue;
                    caldimension = this.caldimensionMaterialGroupValueMap.get(calRangeId + "_" + groupNum);
                    break;
                }
            }
            if (caldimension == null) {
                caldimension = this.calRangeMap.get(calRangeId).getDynamicObject("caldimension");
            }
            this.caldimensionMaterialValueMap.put(key, caldimension);
        }
        return caldimension;
    }

    public Object getCalRangeId(Object costAccountId, DynamicObject entryInfo, boolean isBalance) {
        String dividebasis = this.costAccountMap.get(costAccountId).getDynamicObject("dividebasis").getString("dividebasis");
        String key = null;
        key = isBalance ? this.generatorDivideValue(entryInfo, dividebasis) : this.generatorDivideValue(entryInfo, dividebasis, true);
        this.costDomainKeyHelper.setCostaccount((Long)costAccountId);
        String totalkey = costAccountId + "_" + key;
        Object calRangeId = this.calRangeValueMap.get(totalkey);
        String divideBasisValue = this.DivideBasisValueMap.get(totalkey);
        Long defaultCalRangeId = 0L;
        if (calRangeId == null) {
            calRangeId = 0L;
            Map map = this.AccountCalRangeValueMap.computeIfAbsent(costAccountId, k -> new HashMap());
            for (Map.Entry entry : map.entrySet()) {
                List values = (List)entry.getValue();
                if (values.contains(key)) {
                    calRangeId = entry.getKey();
                    divideBasisValue = "";
                    break;
                }
                if (!values.contains(DEFAULTVALUE)) continue;
                defaultCalRangeId = entry.getKey();
                divideBasisValue = key;
            }
            if (calRangeId.equals(0L) && !((Object)defaultCalRangeId).equals(0L)) {
                calRangeId = defaultCalRangeId;
                divideBasisValue = key;
            }
            this.calRangeValueMap.put(totalkey, calRangeId);
            this.DivideBasisValueMap.put(totalkey, divideBasisValue);
        }
        this.costDomainKeyHelper.setDivideBasisValue(divideBasisValue);
        this.costDomainKeyHelper.setCalrange((Long)calRangeId);
        return calRangeId;
    }

    protected void initCalRangeValue() {
        this.AccountCalRangeValueMap = new HashMap<Object, Map<Object, List<String>>>();
        this.calRangeIDs = new HashSet<Object>(16);
        QFilter calRangeQFilter = new QFilter("costaccount.id", "in", this.costAccountIDs);
        calRangeQFilter.and("status", "=", (Object)"C");
        calRangeQFilter.and("enable", "=", (Object)"1");
        this.calRangeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_calrange", (String)("id,costaccount,accounttype,dividebasis.dividebasis,caldimension," + this.totalDivideBasisStr), (QFilter[])calRangeQFilter.toArray());
        for (Map.Entry<Object, DynamicObject> entry : this.calRangeMap.entrySet()) {
            Object calRangeId = entry.getKey();
            this.calRangeIDs.add(calRangeId);
            DynamicObject calRange = this.calRangeMap.get(calRangeId);
            Object accountId = calRange.getDynamicObject("costaccount").getPkValue();
            Map calRangeValueMap = this.AccountCalRangeValueMap.computeIfAbsent(accountId, k -> new HashMap());
            List valuesList = calRangeValueMap.computeIfAbsent(calRangeId, k -> new ArrayList());
            DynamicObjectCollection calRangeEntryCol = calRange.getDynamicObjectCollection("entry");
            if (calRangeEntryCol.isEmpty()) {
                valuesList.add(DEFAULTVALUE);
                continue;
            }
            for (DynamicObject calRangeEntry : calRangeEntryCol) {
                String value = this.generatorDivideValue(calRangeEntry, calRange.getDynamicObject("dividebasis").getString("dividebasis"), false);
                valuesList.add(value);
            }
            calRangeValueMap.put(calRangeId, valuesList);
        }
    }

    protected String getCalDimensionValue(DynamicObject entry, DynamicObject calDimension) {
        if (calDimension == null) {
            return "";
        }
        String caldimensionStr = calDimension.getString("caldimension");
        if (StringUtils.isEmpty((String)caldimensionStr)) {
            return "";
        }
        String[] calDimensionFields = caldimensionStr.split(",");
        StringBuilder sb = new StringBuilder();
        for (String fieldkey : calDimensionFields) {
            Object value;
            boolean isBasedata;
            if (StringUtils.isEmpty((String)fieldkey)) continue;
            EntryType entrytype = (EntryType)entry.getDataEntityType();
            DynamicObject info = entry;
            if (entrytype.findProperty(fieldkey) == null) {
                info = (DynamicObject)entry.getParent();
                MainEntityType dataEntityType = (MainEntityType)info.getDataEntityType();
                isBasedata = dataEntityType.findProperty(fieldkey) instanceof BasedataProp;
            } else {
                isBasedata = entrytype.findProperty(fieldkey) instanceof BasedataProp;
            }
            if (isBasedata) {
                fieldkey = fieldkey + "_id";
            }
            if ((value = info.get(fieldkey)) == null || "".equals(value)) {
                value = "#";
            }
            sb.append(value);
            sb.append('_');
        }
        return sb.toString();
    }

    protected String generatorDivideValue(DynamicObject entry, String dividebasis, boolean isCostRecordEntry) {
        String[] divideFields = dividebasis.split(",");
        StringBuilder sb = new StringBuilder();
        for (String fieldkey : divideFields) {
            EntryType entrytype = (EntryType)entry.getDataEntityType();
            Long field = null;
            field = entrytype.findProperty(fieldkey) == null ? Long.valueOf(((DynamicObject)entry.getParent()).getLong(fieldkey + "_id")) : Long.valueOf(entry.getLong(fieldkey + "_id"));
            sb.append(field == null ? DEFAULTVALUE : field.toString());
            sb.append('_');
        }
        return sb.toString();
    }

    protected String generatorDivideValue(DynamicObject entry, String dividebasis) {
        String[] divideFields = dividebasis.split(",");
        StringBuilder sb = new StringBuilder();
        for (String fieldkey : divideFields) {
            Long field = entry.getLong(fieldkey + "_id");
            sb.append(field == null ? DEFAULTVALUE : field.toString());
            sb.append('_');
        }
        return sb.toString();
    }

    protected void initAccountTypeValue() {
        QFilter q = new QFilter("calrange.id", "in", this.calRangeIDs);
        q.and("status", "=", (Object)"C");
        q.and("enable", "=", (Object)"1");
        Map accountTypeMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_accounttype", (String)"calrange,material,materialgroup.longnumber,accounttype", (QFilter[])q.toArray());
        for (Map.Entry entry : accountTypeMap.entrySet()) {
            DynamicObject accountType = (DynamicObject)entry.getValue();
            Object calRangeId = accountType.getDynamicObject("calrange").getPkValue();
            for (DynamicObject accountTypeEntry : accountType.getDynamicObjectCollection("entry")) {
                String accounttype = accountTypeEntry.getString("accounttype");
                DynamicObject material = accountTypeEntry.getDynamicObject("material");
                if (material == null) {
                    DynamicObject materialgroup = accountTypeEntry.getDynamicObject("materialgroup");
                    String groupNo = materialgroup.getString("number");
                    this.accountTypeMaterialGroupValueMap.put(calRangeId + "_" + groupNo, accounttype);
                    continue;
                }
                this.accountTypeMaterialValueMap.put(calRangeId + "_" + material.getPkValue(), accounttype);
            }
        }
    }

    protected void initCaldimensionValue() {
        QFilter q = new QFilter("calrange.id", "in", this.calRangeIDs);
        q.and("status", "=", (Object)"C");
        q.and("enable", "=", (Object)"1");
        Map caldimensionMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_materialdimension", (String)"calrange,material,materialgroup.longnumber,caldimension", (QFilter[])q.toArray());
        for (Map.Entry entry : caldimensionMap.entrySet()) {
            DynamicObject materialCaldimension = (DynamicObject)entry.getValue();
            Object calRangeId = materialCaldimension.getDynamicObject("calrange").getPkValue();
            for (DynamicObject accountTypeEntry : materialCaldimension.getDynamicObjectCollection("entry")) {
                DynamicObject caldimension = accountTypeEntry.getDynamicObject("caldimension");
                DynamicObject material = accountTypeEntry.getDynamicObject("material");
                if (material == null) {
                    DynamicObject materialgroup = accountTypeEntry.getDynamicObject("materialgroup");
                    String groupNo = materialgroup.getString("number");
                    this.caldimensionMaterialGroupValueMap.put(calRangeId + "_" + groupNo, caldimension);
                    continue;
                }
                this.caldimensionMaterialValueMap.put(calRangeId + "_" + material.getPkValue(), caldimension);
            }
        }
    }

    private void initMaterialGroupCache(Set<Long> materialIdSet) {
        for (long materialId : materialIdSet) {
            this.materialGroupCache.put(materialId, null);
        }
        QFilter q = new QFilter("standard", "=", (Object)730148448254487552L);
        q.and("material", "in", materialIdSet);
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"id,group.number,group.longnumber,material", (QFilter[])q.toArray());
        for (DynamicObject material : materials) {
            this.materialGroupCache.put(material.getLong("material"), material.getString("group.longnumber"));
        }
    }

    protected String getEntryName() {
        return "entry";
    }
}

