/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.cal.common.util.ArrayUtils;

public class AddDomainKeyFunction
extends MapFunction {
    private static final long serialVersionUID = 4663308139807869938L;
    private Set<Long> emptyEntryRangeIds;
    private String divStrKey = "dividebasisstr";
    private String calDimensionStrKey = "caldimensionstr";
    private String calRangeKey = "calrange";
    private String domainKeyField = "domainkeyfield";
    private String materialKey = "material";

    public AddDomainKeyFunction(Set<Long> emptyEntryRangeIds, RowMeta sourceRowMeta, String materialKey, String calRangeKey, String divStr, String calDimStr, String domainKeyField) {
        this.emptyEntryRangeIds = emptyEntryRangeIds;
        if (!StringUtils.isEmpty((CharSequence)divStr)) {
            this.divStrKey = divStr;
        }
        if (!StringUtils.isEmpty((CharSequence)calDimStr)) {
            this.calDimensionStrKey = calDimStr;
        }
        if (!StringUtils.isEmpty((CharSequence)calRangeKey)) {
            this.calRangeKey = calRangeKey;
        }
        if (!StringUtils.isEmpty((CharSequence)domainKeyField)) {
            this.domainKeyField = domainKeyField;
        }
        if (!StringUtils.isEmpty((CharSequence)materialKey)) {
            this.materialKey = materialKey;
        }
        this.sourceRowMeta = sourceRowMeta;
    }

    public Object[] map(Row row) {
        RowMeta resultRowMeta = this.getResultRowMeta();
        Object[] newRow = new Object[resultRowMeta.getFieldCount()];
        for (String fieldName : this.sourceRowMeta.getFieldNames()) {
            int fieldIndex = resultRowMeta.getFieldIndex(fieldName);
            newRow[fieldIndex] = row.get(fieldName);
        }
        Long calRangeId = row.getLong(this.calRangeKey);
        Long materialId = row.getLong(this.materialKey);
        StringBuilder domainKey = new StringBuilder();
        domainKey.append(materialId);
        domainKey.append(calRangeId);
        String[] divFields = row.getString(this.divStrKey).split(",");
        for (int i = 0; i < divFields.length; ++i) {
            String div = divFields[i];
            int fieldIndex = resultRowMeta.getFieldIndex(div);
            Object defaultValue = row.get(fieldIndex);
            if (!this.emptyEntryRangeIds.contains(calRangeId)) {
                defaultValue = this.getDeFaultValue(resultRowMeta, div);
            }
            domainKey.append(defaultValue);
        }
        String calDimensionStr = row.getString(this.calDimensionStrKey);
        if (!StringUtils.isEmpty((CharSequence)calDimensionStr)) {
            String[] calDimFields = calDimensionStr.split(",");
            for (int i = 0; i < calDimFields.length; ++i) {
                String calDimField = calDimFields[i];
                int fieldIndex = resultRowMeta.getFieldIndex(calDimField);
                Object defaultValue = row.get(fieldIndex);
                domainKey.append(defaultValue);
            }
        }
        int fieldIndex = resultRowMeta.getFieldCount() - 1;
        newRow[fieldIndex] = domainKey.toString();
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        RowMeta sourceRowMeta = this.sourceRowMeta;
        Field domainKeyField = new Field(this.domainKeyField, (DataType)DataType.StringType);
        sourceRowMeta = new RowMeta(ArrayUtils.concatAll(sourceRowMeta.getFields(), new Field[][]{{domainKeyField}}));
        return sourceRowMeta;
    }

    private Object getDeFaultValue(RowMeta resultRowMeta, String field) {
        DataType dataType = resultRowMeta.getField(field).getDataType();
        Object defaultValue = null;
        if (dataType instanceof LongType) {
            defaultValue = 0L;
        } else if (dataType instanceof StringType) {
            defaultValue = "";
        } else if (dataType instanceof IntegerType) {
            defaultValue = 0;
        } else if (dataType instanceof BigDecimalType) {
            defaultValue = BigDecimal.ZERO;
        } else if (dataType instanceof BooleanType) {
            defaultValue = Boolean.TRUE;
        }
        return defaultValue;
    }
}

