/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.balance.BalanceServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.cal.common.util.CommonUtils;

public class BalanceDistinctValidatorHelper {
    private Set<String> mainFieldSet = new HashSet<String>(16);
    private Set<String> dimFieldList = new HashSet<String>(16);
    private Set<Long> costaccountIds;
    private String balanceNumberFields = "id,periodinqty,periodinstandardcost,periodinactualcost,periodincostdiff,periodissueqty,periodissuestandardcost,periodissueactualcost,periodissuecostdiff,periodbeginqty,beginstandardcost,periodbeginactualcost,periodbegincostdiff,periodendqty ,periodendstandardcost,periodendactualcost,periodendcostdiff,yearinqty,yearinstandradcost,yearinactualcost,yearincostdiff,yearissueqty,yearissuestandradcost,yearissueactualcost,yearissuecostdiff";
    private String balanceDetailFields = "id,balid,costelement,costsubelement,periodinqty,periodinstandardcost,periodinactualcost,periodincostdiff,periodissueqty,periodissuestandardcost,periodissueactualcost,periodissuecostdiff,periodbeginqty,beginstandardcost,periodbeginactualcost,periodbegincostdiff,periodendqty ,periodendstandardcost,periodendactualcost,periodendcostdiff,yearinqty,yearinstandradcost,yearinactualcost,yearincostdiff,yearissueqty,yearissuestandradcost,yearissueactualcost,yearissuecostdiff";
    private String balanceDetailBeginFields = "id,periodbeginqty,beginstandardcost,periodbeginactualcost";
    private String balanceUpdateSql = "update t_cal_balance set fperiodinqty = fperiodinqty + ?,fperiodinstandardcost = fperiodinstandardcost + ?,fperiodinactualcost = fperiodinactualcost + ?,fperiodincostdiff = fperiodincostdiff + ?,fperiodissueqty = fperiodissueqty + ?,fperiodissuestandardcost = fperiodissuestandardcost + ?,fperiodissueactualcost = fperiodissueactualcost + ?,fperiodissuecostdiff = fperiodissuecostdiff + ?, fperiodbeginqty = fperiodbeginqty + ?,fbeginstandardcost = fbeginstandardcost + ?,fperiodbeginactualcost = fperiodbeginactualcost + ?,fperiodbegincostdiff = fperiodbegincostdiff + ?,fperiodendqty = fperiodendqty + ?,fperiodendstandardcost = fperiodendstandardcost + ?,fperiodendactualcost = fperiodendactualcost + ?,fperiodendcostdiff = fperiodendcostdiff + ?,fyearinqty = fyearinqty + ?,fyearinstandradcost = fyearinstandradcost + ?,fyearinactualcost = fyearinactualcost + ?,fyearincostdiff = fyearincostdiff + ?,fyearissueqty = fyearissueqty + ?,fyearissuestandradcost = fyearissuestandradcost + ?,fyearissueactualcost = fyearissueactualcost + ?,fyearissuecostdiff = fyearissuecostdiff + ?  where fid = ?";
    private String detailUpdateSql = "update t_cal_balance_detail set fperiodinqty = fperiodinqty + ?,fperiodinstandardcost = fperiodinstandardcost + ?,fperiodinactualcost = fperiodinactualcost + ?,fperiodincostdiff = fperiodincostdiff + ?,fperiodissueqty = fperiodissueqty + ?,fperiodissuestandardcost = fperiodissuestandardcost + ?,fperiodissueactualcost = fperiodissueactualcost + ?,fperiodissuecostdiff = fperiodissuecostdiff + ?, fperiodbeginqty = fperiodbeginqty + ?,fbeginstandardcost = fbeginstandardcost + ?,fperiodbeginactualcost = fperiodbeginactualcost + ?,fperiodbegincostdiff = fperiodbegincostdiff + ?,fperiodendqty = fperiodendqty + ?,fperiodendstandardcost = fperiodendstandardcost + ?,fperiodendactualcost = fperiodendactualcost + ?,fperiodendcostdiff = fperiodendcostdiff + ?,fyearinqty = fyearinqty + ?,fyearinstandradcost = fyearinstandradcost + ?,fyearinactualcost = fyearinactualcost + ?,fyearincostdiff = fyearincostdiff + ?,fyearissueqty = fyearissueqty + ?,fyearissuestandradcost = fyearissuestandradcost + ?,fyearissueactualcost = fyearissueactualcost + ?,fyearissuecostdiff = fyearissuecostdiff + ?  where fid = ? and fcostelementid = ? and fcostsubelementid = ?";
    private String snapShootUpdateSql = "update t_cal_snapshootbalance set fqty = ?,fstandardcost = ?,factualcost = ? where fmainid = ?";

    public BalanceDistinctValidatorHelper(Set<Long> costaccountIds) {
        this.costaccountIds = costaccountIds;
        this.handleBalanceFields();
    }

    public void mergeDuplicateDimensions() {
        QFilter balFilter = new QFilter("costaccount", "in", this.costaccountIds);
        balFilter.and("period", "=", (Object)0);
        HashMap<String, Long> updateBalIds = new HashMap<String, Long>(16);
        ArrayList<Object[]> balUpdateList = new ArrayList<Object[]>(16);
        HashMap<Long, Long> delBalIdUpdateBalIdMap = new HashMap<Long, Long>(16);
        StringBuilder balKey = new StringBuilder();
        try (DataSet balDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance", (String)(String.join((CharSequence)",", this.dimFieldList) + "," + this.balanceNumberFields), (QFilter[])balFilter.toArray(), null);){
            for (Row row : balDataSet) {
                long balId = row.getLong("id");
                for (String dimField : this.dimFieldList) {
                    balKey.append(row.getString(dimField));
                    balKey.append("_");
                }
                String balKeyStr = balKey.toString();
                Long updateBalId = (Long)updateBalIds.get(balKeyStr);
                if (updateBalId == null) {
                    updateBalIds.put(balKeyStr, balId);
                } else {
                    Object[] balUpdate = new Object[]{row.get("periodinqty"), row.get("periodinstandardcost"), row.get("periodinactualcost"), row.get("periodincostdiff"), row.get("periodissueqty"), row.get("periodissuestandardcost"), row.get("periodissueactualcost"), row.get("periodissuecostdiff"), row.get("periodbeginqty"), row.get("beginstandardcost"), row.get("periodbeginactualcost"), row.get("periodissuecostdiff"), row.get("periodendqty"), row.get("periodendstandardcost"), row.get("periodendactualcost"), row.get("yearincostdiff"), row.get("yearinqty"), row.get("yearinstandradcost"), row.get("yearinactualcost"), row.get("yearincostdiff"), row.get("yearissueqty"), row.get("yearissuestandradcost"), row.get("yearissueactualcost"), row.get("yearissuecostdiff"), updateBalId};
                    balUpdateList.add(balUpdate);
                    delBalIdUpdateBalIdMap.put(balId, updateBalId);
                }
                balKey.delete(0, balKey.length());
            }
        }
        if (delBalIdUpdateBalIdMap.isEmpty()) {
            return;
        }
        HashSet<Long> delBalDetailIdSet = new HashSet<Long>(16);
        ArrayList<Object[]> balDetailUpdateList = new ArrayList<Object[]>(16);
        QFilter balDetailFilter = new QFilter("balid", "in", delBalIdUpdateBalIdMap.keySet());
        try (DataSet balDetailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_detail", (String)this.balanceDetailFields, (QFilter[])balDetailFilter.toArray(), null);){
            for (Row row : balDetailDataSet) {
                long balDetailId = row.getLong("id");
                long delBalId = row.getLong("balid");
                long updateBalId = (Long)delBalIdUpdateBalIdMap.get(delBalId);
                Object[] balDetailUpdate = new Object[]{row.get("periodinqty"), row.get("periodinstandardcost"), row.get("periodinactualcost"), row.get("periodincostdiff"), row.get("periodissueqty"), row.get("periodissuestandardcost"), row.get("periodissueactualcost"), row.get("periodissuecostdiff"), row.get("periodbeginqty"), row.get("beginstandardcost"), row.get("periodbeginactualcost"), row.get("periodissuecostdiff"), row.get("periodendqty"), row.get("periodendstandardcost"), row.get("periodendactualcost"), row.get("yearincostdiff"), row.get("yearinqty"), row.get("yearinstandradcost"), row.get("yearinactualcost"), row.get("yearincostdiff"), row.get("yearissueqty"), row.get("yearissuestandradcost"), row.get("yearissueactualcost"), row.get("yearissuecostdiff"), updateBalId, row.get("costelement"), row.get("costsubelement")};
                delBalDetailIdSet.add(balDetailId);
                balDetailUpdateList.add(balDetailUpdate);
            }
        }
        if (!balUpdateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.balanceUpdateSql, balUpdateList);
        }
        if (!balDetailUpdateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.detailUpdateSql, balDetailUpdateList);
        }
        if (!delBalIdUpdateBalIdMap.isEmpty()) {
            QFilter delBalFilter = new QFilter("id", "in", delBalIdUpdateBalIdMap.keySet());
            DeleteServiceHelper.delete((String)"cal_balance", (QFilter[])delBalFilter.toArray());
        }
        if (!delBalDetailIdSet.isEmpty()) {
            QFilter delBalDetailFilter = new QFilter("id", "in", delBalDetailIdSet);
            DeleteServiceHelper.delete((String)"cal_balance_detail", (QFilter[])delBalDetailFilter.toArray());
            QFilter snapShootFilter = new QFilter("mainid", "in", delBalDetailIdSet);
            DeleteServiceHelper.delete((String)"cal_balance_snapshoot", (QFilter[])snapShootFilter.toArray());
        }
        ArrayList<Object[]> updateBalSnapShootList = new ArrayList<Object[]>(16);
        QFilter updateBalDetailFilter = new QFilter("balid", "in", delBalIdUpdateBalIdMap.values());
        DataSet updateBalDetailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance_detail", (String)this.balanceDetailBeginFields, (QFilter[])updateBalDetailFilter.toArray(), null);
        Object object = null;
        try {
            for (Row row : updateBalDetailDataSet) {
                updateBalSnapShootList.add(new Object[]{row.get("periodbeginqty"), row.get("beginstandardcost"), row.get("periodbeginactualcost"), row.get("id")});
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (updateBalDetailDataSet != null) {
                if (object != null) {
                    try {
                        updateBalDetailDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    updateBalDetailDataSet.close();
                }
            }
        }
        if (!updateBalSnapShootList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.snapShootUpdateSql, updateBalSnapShootList);
        }
    }

    public void distinctValidator() {
        QFilter q = new QFilter("costaccount", "in", this.costaccountIds);
        q.and("period", "=", (Object)0);
        this.handleBalanceFields();
        ArrayList<String> dimFieldListAndMaterialName = new ArrayList<String>(16);
        dimFieldListAndMaterialName.addAll(this.dimFieldList);
        dimFieldListAndMaterialName.add("materialname");
        HashSet<String> dupMaterialSet = new HashSet<String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance", (String)this.getSelectFields(), (QFilter[])q.toArray(), null).groupBy(dimFieldListAndMaterialName.toArray(new String[0])).count("count").finish();){
            for (Row row : dataSet) {
                int count = row.getInteger("count");
                if (count <= 1) continue;
                String materialName = row.getString("materialname");
                String materialNumber = row.getString("material");
                dupMaterialSet.add(materialName + "(" + materialNumber + ")");
            }
        }
        if (!dupMaterialSet.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u5141\u8bb8\u5b58\u5728\u540c\u4e00\u7ef4\u5ea6\u591a\u6761\u521d\u59cb\u6570\u636e\u3002", (String)"BalanceDistinctValidatorHelper_0", (String)"fi-cal-common", (Object[])new Object[0]);
            throw new KDBizException(msg + String.join((CharSequence)",", dupMaterialSet));
        }
    }

    public Map<Long, Set<Long>> distinctValidatorReturnError() {
        QFilter q = new QFilter("costaccount", "in", this.costaccountIds);
        q.and("period", "=", (Object)0);
        this.handleBalanceFields();
        ArrayList<String> dimFieldListAndMaterialName = new ArrayList<String>(16);
        dimFieldListAndMaterialName.addAll(this.dimFieldList);
        dimFieldListAndMaterialName.add("materialname");
        HashMap<Long, Set<Long>> orgAndCostAccountIds = new HashMap<Long, Set<Long>>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_balance", (String)this.getSelectFields(), (QFilter[])q.toArray(), null).groupBy(dimFieldListAndMaterialName.toArray(new String[0])).count("count").finish();){
            for (Row row : dataSet) {
                int count = row.getInteger("count");
                if (count <= 1) continue;
                Long calOrgId = row.getLong("calorg");
                Long costAccountId = row.getLong("costaccount");
                HashSet<Long> costAccountIds = (HashSet<Long>)orgAndCostAccountIds.get(calOrgId);
                if (costAccountIds == null) {
                    costAccountIds = new HashSet<Long>(16);
                    costAccountIds.add(costAccountId);
                    orgAndCostAccountIds.put(calOrgId, costAccountIds);
                    continue;
                }
                costAccountIds.add(costAccountId);
            }
        }
        if (!orgAndCostAccountIds.isEmpty()) {
            return orgAndCostAccountIds;
        }
        return null;
    }

    private String getSelectFields() {
        DataEntityPropertyCollection propertys = EntityMetadataCache.getDataEntityType((String)"cal_balance").getProperties();
        StringBuilder selectField = new StringBuilder();
        for (IDataEntityProperty property : propertys) {
            String name = property.getName();
            LocaleString displayName = property.getDisplayName();
            if (!this.dimFieldList.contains(name)) continue;
            if (property instanceof BasedataProp && !"assist".equals(name)) {
                selectField.append(name).append(".number as ").append(name).append(',');
                continue;
            }
            selectField.append(name).append(',');
        }
        selectField.append("material.name as materialname");
        String result = selectField.substring(0, selectField.length());
        return result;
    }

    private void handleBalanceFields() {
        HashSet<BizDataType> bizDataTypeSet = new HashSet<BizDataType>();
        bizDataTypeSet.add(BizDataType.MAIN);
        bizDataTypeSet.add(BizDataType.DIM);
        Map fieldMap = BalanceServiceHelper.loadBizData((String)"cal_balancemodel", bizDataTypeSet);
        if (fieldMap.get(BizDataType.MAIN) != null) {
            this.mainFieldSet.addAll((Collection)fieldMap.get(BizDataType.MAIN));
        }
        if (fieldMap.get(BizDataType.DIM) != null) {
            this.dimFieldList.addAll((Collection)fieldMap.get(BizDataType.DIM));
        }
        this.dimFieldList.addAll(this.mainFieldSet);
        if (this.dimFieldList.isEmpty()) {
            this.dimFieldList.add("costaccount");
            this.dimFieldList.add("storageorgunit");
            this.dimFieldList.add("ownertype");
            this.dimFieldList.add("owner");
            this.dimFieldList.add("material");
            this.dimFieldList.add("assist");
            this.dimFieldList.add("lot");
            this.dimFieldList.add("warehouse");
            this.dimFieldList.add("location");
            this.dimFieldList.add("invtype");
            this.dimFieldList.add("invstatus");
            this.dimFieldList.add("project");
            this.dimFieldList.add("mversion");
        }
    }
}

