/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BatchFillEntryHelper {
    private Set<String> needFillFields = new HashSet<String>(Arrays.asList("storageorgunit", "warehouse", "invtype", "invstatus", "owner", "project", "invbiztype"));
    private Set<String> allFillFields = new HashSet<String>(Arrays.asList("storageorgunit", "warehouse", "invtype", "invstatus", "owner", "location", "lot", "material", "project", "invbiztype"));

    public void batchFill(IFormView view, String entryName) {
        this.batchFillRow(view, entryName);
    }

    public void batchFillRow(IFormView view, String entryName) {
        IDataModel model = view.getModel();
        int currentRow = model.getEntryCurrentRowIndex(entryName);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryName);
        Object costaccount = model.getValue("costaccount");
        boolean calByCostelement = false;
        if (costaccount != null) {
            Object accountID = ((DynamicObject)costaccount).getPkValue();
            DynamicObject rs = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg,calpolicy.currency.id,calpolicy.calbycostelement,costtype", (QFilter[])new QFilter[]{new QFilter("id", "=", accountID)});
            calByCostelement = rs.getBoolean("calpolicy.calbycostelement");
        }
        String selKey = entryGrid.getEntryState().getFocusField();
        if (currentRow == -1 || StringUtils.isEmpty((String)selKey) || "0".equals(selKey)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u5143\u683c\u3002", (String)"BatchFillEntryHelper_0", (String)"fi-cal-common", (Object[])new Object[0]));
            return;
        }
        if (!calByCostelement) {
            this.allFillFields.add("adjustamt");
        }
        if (!this.allFillFields.contains(selKey)) {
            String fieldName = model.getProperty(selKey) == null ? "" : model.getProperty(selKey).getDisplayName().toString();
            String content = String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u652f\u6301\u6279\u91cf\u586b\u5145\u3002", (String)"BatchFillEntryHelper_3", (String)"fi-cal-common", (Object[])new Object[0]), fieldName);
            view.showTipNotification(content);
            return;
        }
        if (model.getDataEntityType().getAllFields().get(selKey) == null) {
            return;
        }
        Object selValue = model.getValue(selKey, currentRow);
        if (ObjectUtils.isEmpty((Object)selValue)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u9009\u62e9\u503c\u586b\u5145\u3002", (String)"BatchFillEntryHelper_1", (String)"fi-cal-common", (Object[])new Object[0]));
            return;
        }
        int rowCount = model.getEntryRowCount(entryName);
        for (int i = currentRow + 1; i < rowCount; ++i) {
            Object object = model.getValue(selKey, i);
            if (!(object == null || object instanceof String && StringUtils.isEmpty((String)((String)object)) || object instanceof Long && (Long)object == 0L || object instanceof BigDecimal && ((BigDecimal)object).compareTo(BigDecimal.ZERO) == 0) && (!(object instanceof Integer) || (Integer)object != 0)) continue;
            if (this.needFillFields.contains(selKey)) {
                model.setValue(selKey, selValue, i);
                continue;
            }
            if ("location".equals(selKey)) {
                this.fillCell(model, entryName, "warehouse", "location", selValue, currentRow, i);
                continue;
            }
            if ("lot".equals(selKey)) {
                this.fillCell(model, entryName, "material", "lot", selValue, currentRow, i);
                continue;
            }
            if (!"material".equals(selKey)) continue;
            this.fillCell(model, entryName, "storageorgunit", "material", selValue, currentRow, i);
        }
    }

    private void fillCell(IDataModel model, String entryName, String compareField, String fillField, Object selValue, int currentRow, int fillRow) {
        DynamicObject currentRowCompareValue = (DynamicObject)model.getValue(compareField, currentRow);
        DynamicObject fillRowCompareValue = (DynamicObject)model.getValue(compareField, fillRow);
        if (currentRowCompareValue == null || fillRowCompareValue == null) {
            return;
        }
        if (currentRowCompareValue.getPkValue().equals(fillRowCompareValue.getPkValue())) {
            model.setValue(fillField, selValue, fillRow);
        }
    }

    public void addNeedFillNoCheckField(String field) {
        this.needFillFields.add(field);
    }

    public void addNeedFillNoCheckFields(Collection<String> noCheckFields) {
        this.needFillFields.addAll(noCheckFields);
    }

    public void setNeedFillFields(Collection<String> needFillFields) {
        this.needFillFields = new HashSet<String>(needFillFields.size());
        this.needFillFields.addAll(needFillFields);
        this.allFillFields.addAll(needFillFields);
    }
}

