/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cal.common.helper.QfilterHelper;
import kd.fi.cal.common.util.CommonUtils;

public class BizDataExistHelper {
    private static final String[] BIZ_ENTITY_NUMS = new String[]{"cal_costrecord_subentity", "cal_costadjust_subentity", "cal_initbill"};

    public static Map<String, Set<Object>> getBizData(String[] filedNames, QFilter qFilter) {
        ArrayList<OrmInput> allBillIOs = new ArrayList<OrmInput>(16);
        for (String entityNum : BIZ_ENTITY_NUMS) {
            MainEntityType mainEntity = MetadataServiceHelper.getDataEntityType((String)entityNum);
            StringBuilder selectFieldBuilder = new StringBuilder();
            String[] stringArray = filedNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String fieldName;
                String fieldHead = fieldName = stringArray[i];
                if (fieldName.contains(".")) {
                    fieldHead = fieldName.split("\\.")[0];
                }
                IDataEntityProperty fieldProperty = mainEntity.findProperty(fieldHead);
                String newFieldName = null;
                newFieldName = fieldProperty.getParent() instanceof EntryType ? fieldProperty.getParent().getName() + "." + fieldName : fieldName;
                selectFieldBuilder.append(newFieldName);
                selectFieldBuilder.append(" as ");
                selectFieldBuilder.append(fieldName);
                selectFieldBuilder.append(',');
            }
            QfilterHelper Qfunc = new QfilterHelper(mainEntity);
            QFilter transQ = qFilter.copy().trans((Function)Qfunc);
            String selectField = CommonUtils.trimComma(selectFieldBuilder.toString());
            OrmInput billIO = new OrmInput("BizDataExistHelper-querybizdata", entityNum, selectField, new QFilter[]{transQ});
            allBillIOs.add(billIO);
        }
        if (allBillIOs.isEmpty()) {
            return null;
        }
        Algo algo = Algo.create((String)"BizDataExistHelper-querybizdata");
        DataSet bizDataSet = algo.createDataSet((Input[])allBillIOs.toArray(new OrmInput[allBillIOs.size()]));
        HashMap<String, Set<Object>> filedBizDataMap = new HashMap<String, Set<Object>>(16);
        for (Row row : bizDataSet) {
            for (String filedName : filedNames) {
                HashSet<Object> fieldBizDataSet = (HashSet<Object>)filedBizDataMap.get(filedName);
                if (fieldBizDataSet == null) {
                    fieldBizDataSet = new HashSet<Object>(16);
                }
                fieldBizDataSet.add(row.get(filedName));
                filedBizDataMap.put(filedName, fieldBizDataSet);
            }
        }
        return filedBizDataMap;
    }
}

