/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.WriteLogHelper;

public class CalAuxValueHelper {
    private static final Log logger = LogFactory.getLog(CalAuxValueHelper.class);

    public static Map<Long, String> getAuxValueNameMap(Set<Long> auxptyIds) {
        HashMap<Long, String> auxValueNameMap = new HashMap<Long, String>(16);
        DynamicObjectCollection auxPropObj = QueryServiceHelper.query((String)"bd_flexauxprop", (String)"id,value", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyIds)});
        HashSet auxptyTypes = new HashSet(16);
        HashSet<Long> auxptyValue = new HashSet<Long>(16);
        HashMap<Long, String> auxptyMap = new HashMap<Long, String>(16);
        for (DynamicObject aux : auxPropObj) {
            if (StringUtils.isEmpty((String)aux.getString("value"))) continue;
            JSONObject value = (JSONObject)JSON.parse((String)aux.getString("value"));
            for (Map.Entry val : value.entrySet()) {
                auxptyTypes.add(val.getKey());
                try {
                    auxptyValue.add(Long.parseLong(val.getValue().toString()));
                }
                catch (Exception e) {
                    WriteLogHelper.writeErrorLog(logger, "CalAuxValueHelper-getAuxValueNameMap", e);
                }
                auxptyMap.put(aux.getLong("id"), aux.getString("value"));
            }
        }
        DynamicObjectCollection auxProptys = QueryServiceHelper.query((String)"bd_auxproperty", (String)"flexfield,name,valuesource", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", auxptyTypes)});
        HashMap<String, String> typeNameMap = new HashMap<String, String>(16);
        HashSet<String> valuesourceSet = new HashSet<String>(16);
        for (DynamicObject aux : auxProptys) {
            typeNameMap.put(aux.getString("flexfield"), aux.getString("name"));
            String valuesource = aux.getString("valuesource");
            if (StringUtils.isBlank((String)valuesource)) continue;
            valuesourceSet.add(valuesource);
        }
        HashMap<Long, String> auxpValueMap = new HashMap<Long, String>(16);
        for (String valuesource : valuesourceSet) {
            DynamicObjectCollection auxProptyValues = QueryServiceHelper.query((String)valuesource, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyValue)});
            for (DynamicObject aux : auxProptyValues) {
                auxpValueMap.put(aux.getLong("id"), aux.getString("name"));
            }
        }
        for (Long auxpropId : auxptyIds) {
            String auxValueStr = (String)auxptyMap.get(auxpropId);
            JSONObject value = (JSONObject)JSON.parse((String)auxValueStr);
            if (value == null) continue;
            StringBuilder auxStr = new StringBuilder();
            for (Map.Entry val : value.entrySet()) {
                try {
                    auxStr.append((String)typeNameMap.get(val.getKey())).append(';').append((String)auxpValueMap.get(Long.parseLong(val.getValue().toString()))).append(';');
                }
                catch (Exception e) {
                    auxStr.append(val.getValue());
                    auxStr.append(";");
                    WriteLogHelper.writeErrorLog(logger, "CalAuxValueHelper-getAuxValueNameMap", e);
                }
            }
            String auxStrss = null;
            if (auxStr.length() > 0) {
                auxStrss = auxStr.substring(0, auxStr.length() - 1);
            }
            auxValueNameMap.put(auxpropId, auxStrss);
        }
        return auxValueNameMap;
    }
}

