/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.balance.BalanceServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class CalBalanceModelHelper {
    public static Set<String> getDimField() {
        HashSet<String> dimFieldSet = new HashSet<String>();
        if (CalBalanceModelHelper.isNewBalance()) {
            BalanceTB tb = BalanceTB.getBalanceTB((String)"cal_bal");
            Set dimFields = tb.getColsByDataType(new BizDataType[]{BizDataType.DIM});
            dimFields.remove("costelement");
            dimFields.remove("costsubelement");
            dimFieldSet.addAll(dimFields);
        } else {
            HashSet<BizDataType> bizDataTypeSet = new HashSet<BizDataType>();
            bizDataTypeSet.add(BizDataType.DIM);
            Map fieldMap = BalanceServiceHelper.loadBizData((String)"cal_balancemodel", bizDataTypeSet);
            dimFieldSet.addAll((Collection)fieldMap.get(BizDataType.DIM));
        }
        if (dimFieldSet.isEmpty()) {
            dimFieldSet.add("storageorgunit");
            dimFieldSet.add("lot");
            dimFieldSet.add("owner");
            dimFieldSet.add("invtype");
            dimFieldSet.add("material");
            dimFieldSet.add("ownertype");
            dimFieldSet.add("project");
            dimFieldSet.add("assist");
            dimFieldSet.add("location");
            dimFieldSet.add("invstatus");
            dimFieldSet.add("warehouse");
            dimFieldSet.add("mversion");
            dimFieldSet.add("configuredcode");
            dimFieldSet.add("tracknumber");
        }
        return dimFieldSet;
    }

    public static Set<String> getExDimField() {
        HashSet<String> exDimFieldSet = new HashSet<String>(16);
        Set<String> dimFieldSet = CalBalanceModelHelper.getDimField();
        exDimFieldSet.addAll(dimFieldSet);
        exDimFieldSet.remove("storageorgunit");
        exDimFieldSet.remove("lot");
        exDimFieldSet.remove("owner");
        exDimFieldSet.remove("invtype");
        exDimFieldSet.remove("material");
        exDimFieldSet.remove("ownertype");
        exDimFieldSet.remove("project");
        exDimFieldSet.remove("assist");
        exDimFieldSet.remove("location");
        exDimFieldSet.remove("invstatus");
        exDimFieldSet.remove("warehouse");
        exDimFieldSet.remove("mversion");
        exDimFieldSet.remove("tracknumber");
        exDimFieldSet.remove("configuredcode");
        return exDimFieldSet;
    }

    public static Set<String> getStdDimField() {
        HashSet<String> dimFieldSet = new HashSet<String>();
        if (CalBalanceModelHelper.isNewBalance()) {
            BalanceTB tb = BalanceTB.getBalanceTB((String)"cal_standcost_bal");
            Set dimFields = tb.getColsByDataType(new BizDataType[]{BizDataType.DIM});
            dimFields.remove("costelement");
            dimFields.remove("costsubelement");
            dimFieldSet.addAll(dimFields);
        } else {
            HashSet<BizDataType> bizDataTypeSet = new HashSet<BizDataType>();
            bizDataTypeSet.add(BizDataType.DIM);
            Map fieldMap = BalanceServiceHelper.loadBizData((String)"cal_purpricediffmodel", bizDataTypeSet);
            dimFieldSet.addAll((Collection)fieldMap.get(BizDataType.DIM));
        }
        if (dimFieldSet.isEmpty()) {
            dimFieldSet.add("storageorgunit");
            dimFieldSet.add("lot");
            dimFieldSet.add("owner");
            dimFieldSet.add("invtype");
            dimFieldSet.add("material");
            dimFieldSet.add("ownertype");
            dimFieldSet.add("project");
            dimFieldSet.add("assist");
            dimFieldSet.add("location");
            dimFieldSet.add("invstatus");
            dimFieldSet.add("warehouse");
            dimFieldSet.add("mversion");
            dimFieldSet.add("configuredcode");
        }
        return dimFieldSet;
    }

    public static Set<String> getAllDimField() {
        Set<String> dimFieldSet = CalBalanceModelHelper.getDimField();
        dimFieldSet.add("costaccount");
        return dimFieldSet;
    }

    public static Set<String> getAllStdDimField() {
        Set<String> dimFieldSet = CalBalanceModelHelper.getStdDimField();
        dimFieldSet.add("costaccount");
        return dimFieldSet;
    }

    public static boolean isNewBalance() {
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
    }

    public static String getDimFields(boolean hasElement) {
        BalanceTB tb = BalanceTB.getBalanceTB((String)"cal_bal");
        Set dimFields = tb.getColsByDataType(new BizDataType[]{BizDataType.DIM, BizDataType.MAIN});
        ArrayList dimList = new ArrayList(dimFields);
        Collections.sort(dimList);
        StringBuilder fields = new StringBuilder();
        for (String field : dimList) {
            if (!hasElement && ("costelement".equals(field) || "costsubelement".equals(field))) continue;
            fields.append(field).append(",");
        }
        return fields.substring(0, fields.length() - 1);
    }

    public static List<String> getDimFieldList(boolean hasElement) {
        return new ArrayList<String>(Arrays.asList(CalBalanceModelHelper.getDimFields(hasElement).split(",")));
    }

    public static String getDimFields4Group() {
        BalanceTB tb = BalanceTB.getBalanceTB((String)"cal_bal");
        Set dimFields = tb.getColsByDataType(new BizDataType[]{BizDataType.DIM, BizDataType.MAIN});
        ArrayList dimList = new ArrayList(dimFields);
        Collections.sort(dimList);
        StringBuilder fields = new StringBuilder();
        for (String field : dimList) {
            if ("costelement".equals(field) || "costsubelement".equals(field)) {
                fields.append("0 as ").append(field).append(",");
                continue;
            }
            fields.append(field).append(",");
        }
        return fields.substring(0, fields.length() - 1);
    }

    public static Set<String> getBalanceDimField() {
        HashSet<String> dimFieldSet = new HashSet<String>();
        HashSet<BizDataType> bizDataTypeSet = new HashSet<BizDataType>();
        bizDataTypeSet.add(BizDataType.DIM);
        Map fieldMap = BalanceServiceHelper.loadBizData((String)"cal_balancemodel", bizDataTypeSet);
        dimFieldSet.addAll((Collection)fieldMap.get(BizDataType.DIM));
        if (dimFieldSet.isEmpty()) {
            dimFieldSet.add("storageorgunit");
            dimFieldSet.add("lot");
            dimFieldSet.add("owner");
            dimFieldSet.add("invtype");
            dimFieldSet.add("material");
            dimFieldSet.add("ownertype");
            dimFieldSet.add("project");
            dimFieldSet.add("assist");
            dimFieldSet.add("location");
            dimFieldSet.add("invstatus");
            dimFieldSet.add("warehouse");
            dimFieldSet.add("mversion");
            dimFieldSet.add("configuredcode");
            dimFieldSet.add("tracknumber");
        }
        dimFieldSet.add("costaccount");
        return dimFieldSet;
    }

    public static void updateBalRuleStatus(String operater, List<String> pks) {
        OperateOption option = OperateOption.create();
        OperationResult operResult = OperationServiceHelper.executeOperate((String)operater, (String)"bal_balanceupdaterule", (Object[])pks.toArray(), (OperateOption)option);
        if (!operResult.isSuccess()) {
            String errorMsg = ResManager.loadKDString((String)"\u542f\u7528/\u7981\u7528\u4f59\u989d\u66f4\u65b0\u89c4\u5219\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalBalanceModelHelper_0", (String)"fi-cal-common", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
    }
}

