/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.common.helper.CalBillRuleHelper;

public class CalBillRuleCheckHelper {
    private String entity;
    private Set<Long> srcBillIds;
    private boolean noUseRules = false;
    private Set<String> skipProperties = new HashSet<String>(16);

    public CalBillRuleCheckHelper(String entity, Set<Long> srcBillIds) {
        this.entity = entity;
        this.srcBillIds = new HashSet<Long>(srcBillIds);
    }

    public Set<Long> check() {
        Collection<DynamicObject> calBillRules = CalBillRuleHelper.getCalBillRules(this.entity);
        if (calBillRules.isEmpty()) {
            this.noUseRules = true;
            return this.srcBillIds;
        }
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        QFilter idf = new QFilter("id", "in", this.srcBillIds);
        for (DynamicObject item : calBillRules) {
            String filterStr = item.getString("filter_tag");
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)this.entity), filterCondition);
            filterBuilder.buildFilter();
            QFilter ruleFilter = filterBuilder.getQFilter();
            if (!this.skipProperties.isEmpty() && ruleFilter != null) {
                if (this.skipProperties.contains(ruleFilter.getProperty())) {
                    ruleFilter.__setProperty("1");
                    ruleFilter.__setCP("=");
                    ruleFilter.__setValue((Object)1);
                }
                List nests = ruleFilter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    QFilter curFilter = nest.getFilter();
                    if (!this.skipProperties.contains(curFilter.getProperty())) continue;
                    curFilter.__setProperty("1");
                    curFilter.__setCP("=");
                    curFilter.__setValue((Object)1);
                }
            }
            OrmInput billIO = new OrmInput(this.getClass().getName() + this.entity, this.entity, "id", new QFilter[]{idf, ruleFilter});
            billIOs.add(billIO);
        }
        HashSet<Long> successIds = new HashSet<Long>(16);
        Algo algo = Algo.create((String)this.getClass().getName());
        try (DataSet unionDataSet = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));){
            for (Row row : unionDataSet) {
                if (successIds.size() == this.srcBillIds.size()) {
                    break;
                }
                successIds.add(row.getLong("id"));
            }
        }
        this.srcBillIds.removeAll(successIds);
        return this.srcBillIds;
    }

    public boolean isNoUseRules() {
        return this.noUseRules;
    }

    public void setSkipProperties(Set<String> skipProperties) {
        this.skipProperties = skipProperties;
    }

    public void addSkipProperty(String skipProperty) {
        this.skipProperties.add(skipProperty);
    }
}

