/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.common.model.CalBillRule;

public class CalBillRuleHelper {
    private Set<String> srcBills;
    private DynamicObject[] calBillRuleDycsCache;
    private Map<String, List<CalBillRule>> inCalBillRuleMap = new HashMap<String, List<CalBillRule>>(16);
    private Map<String, List<CalBillRule>> outCalBillRuleMap = new HashMap<String, List<CalBillRule>>(16);
    private Map<String, List<CalBillRule>> initCalBillRuleMap = new HashMap<String, List<CalBillRule>>(16);

    public void loadAllRules() {
        this.loadCalBillRules(false);
    }

    public void loadRulesByBills(Set<String> srcBills) {
        this.srcBills = srcBills;
        this.loadCalBillRules(false);
    }

    public void loadAllRules(DynamicObject[] calBillRuleDycs) {
        this.calBillRuleDycsCache = calBillRuleDycs;
        this.loadCalBillRules(false);
    }

    public void loadRulesWithInitBill(DynamicObject[] calBillRuleDycs) {
        this.calBillRuleDycsCache = calBillRuleDycs;
        this.loadCalBillRules(true);
    }

    private void loadCalBillRules(boolean isNeedInitBill) {
        DynamicObject[] calBillRuleDycs = null;
        calBillRuleDycs = this.calBillRuleDycsCache != null ? this.getReloadCalBillRules() : this.getCalBillRules();
        for (DynamicObject rule : calBillRuleDycs) {
            List calBillRules;
            String calBillNumber = rule.getDynamicObject("calbill").getString("number");
            DynamicObject sourceBillDyc = rule.getDynamicObject("sourcebill");
            if (!isNeedInitBill && "cal_initbill".equals(calBillNumber) || sourceBillDyc == null) continue;
            String bizBillNumber = sourceBillDyc.getString("number");
            String filter = rule.getString("filter_tag");
            ArrayList<QFilter> list = new ArrayList<QFilter>(16);
            if (kd.bos.util.StringUtils.isNotEmpty((String)filter)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)bizBillNumber), filterCondition);
                filterBuilder.buildFilter();
                list.add(filterBuilder.getQFilter());
            }
            HashMap<String, String> fieldMap = new HashMap<String, String>(16);
            CalBillRule calBillRule = this.getCalBillRule(bizBillNumber, list, fieldMap, calBillNumber, rule.getLong("id"), rule);
            if ("cal_incalbill".equals(calBillNumber)) {
                calBillRules = this.inCalBillRuleMap.computeIfAbsent(bizBillNumber, k -> new ArrayList(16));
                calBillRules.add(calBillRule);
            } else if ("cal_outcalbill".equals(calBillNumber)) {
                calBillRules = this.outCalBillRuleMap.computeIfAbsent(bizBillNumber, k -> new ArrayList(16));
                calBillRules.add(calBillRule);
            } else if ("cal_initbill".equals(calBillNumber)) {
                calBillRules = this.initCalBillRuleMap.computeIfAbsent(bizBillNumber, k -> new ArrayList(16));
                calBillRules.add(calBillRule);
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizBillNumber);
            Map billAllFields = dataEntityType.getAllFields();
            for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("fieldmap")) {
                String bizFieldName = ruleEntry.getString("sourcefield");
                if (StringUtils.isEmpty((CharSequence)bizFieldName)) continue;
                String calFieldName = ruleEntry.getString("calfield");
                IDataEntityProperty prop = (IDataEntityProperty)billAllFields.get(bizFieldName.split("\\.")[0]);
                if (prop == null) continue;
                IDataEntityType parentProp = prop.getParent();
                fieldMap.put(calFieldName, this.getFieldPath(bizFieldName, parentProp));
            }
        }
    }

    private CalBillRule getCalBillRule(String bizBillNumber, List<QFilter> list, Map<String, String> fieldMap, String calBillNumber, long id, DynamicObject rule) {
        CalBillRule calBillRule = new CalBillRule();
        calBillRule.setEntity(bizBillNumber);
        calBillRule.setBillFilters(list);
        calBillRule.setCalBizFieldMap(fieldMap);
        calBillRule.setCalEntity(calBillNumber);
        calBillRule.setRuleId(id);
        calBillRule.setRuleDyn(rule);
        return calBillRule;
    }

    private DynamicObject[] getCalBillRules() {
        if (this.calBillRuleDycsCache != null) {
            return this.calBillRuleDycsCache;
        }
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (this.srcBills != null && this.srcBills.size() > 0) {
            filter.and("sourcebill.number", "in", this.srcBills);
        }
        String selects = "id,number,calbill.id,calbill.number,sourcebill.number,fieldmap.calfield,fieldmap.sourcefield,fieldmap.isorgfield,fieldmap.orgtype,filter,filter_tag,fieldmap.isextendfield";
        DynamicObject[] billRules = BusinessDataServiceHelper.load((String)"cal_calbillrule", (String)selects, (QFilter[])filter.toArray());
        return billRules;
    }

    private DynamicObject[] getReloadCalBillRules() {
        HashSet<Long> ruleIdSet = new HashSet<Long>(16);
        for (DynamicObject calBillRule : this.calBillRuleDycsCache) {
            ruleIdSet.add(calBillRule.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", ruleIdSet);
        String selects = "id,number,calbill.id,calbill.number,sourcebill.number,fieldmap.calfield,fieldmap.sourcefield,fieldmap.isorgfield,fieldmap.orgtype,filter,filter_tag,fieldmap.isextendfield";
        DynamicObject[] billRules = BusinessDataServiceHelper.load((String)"cal_calbillrule", (String)selects, (QFilter[])filter.toArray());
        return billRules;
    }

    public static Collection<DynamicObject> getCalBillRules(String billType) {
        QFilter filter = new QFilter("sourcebill.number", "=", (Object)billType);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] billRules = BusinessDataServiceHelper.load((String)"cal_calbillrule", (String)"filter_tag", (QFilter[])filter.toArray());
        HashSet<DynamicObject> billRuleSet = new HashSet<DynamicObject>(billRules.length);
        for (DynamicObject rull : billRules) {
            if (rull == null) continue;
            billRuleSet.add(rull);
        }
        return billRuleSet;
    }

    public static Collection<DynamicObject> getCalBillRulesWithFieldMap(String billType) {
        QFilter filter = new QFilter("sourcebill.number", "=", (Object)billType);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] billRules = BusinessDataServiceHelper.load((String)"cal_calbillrule", (String)"filter_tag,fieldmap.calfield,fieldmap.sourcefield", (QFilter[])filter.toArray());
        HashSet<DynamicObject> billRuleSet = new HashSet<DynamicObject>(billRules.length);
        for (DynamicObject rull : billRules) {
            if (rull == null) continue;
            billRuleSet.add(rull);
        }
        return billRuleSet;
    }

    public static Map<String, Set<DynamicObject>> getCalBillRules(Set<String> billTypes) {
        QFilter filter = new QFilter("sourcebill.number", "in", billTypes);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] billRules = BusinessDataServiceHelper.load((String)"cal_calbillrule", (String)"filter_tag,sourcebill.number", (QFilter[])filter.toArray());
        HashMap<String, Set<DynamicObject>> billRuleMap = new HashMap<String, Set<DynamicObject>>();
        for (DynamicObject rule : billRules) {
            if (rule == null) continue;
            String billTypeNumber = rule.getString("sourcebill.number");
            HashSet<DynamicObject> billRuleSet = (HashSet<DynamicObject>)billRuleMap.get(billTypeNumber);
            if (billRuleSet == null) {
                billRuleSet = new HashSet<DynamicObject>(16);
                billRuleSet.add(rule);
            } else {
                billRuleSet.add(rule);
            }
            billRuleMap.put(billTypeNumber, billRuleSet);
        }
        return billRuleMap;
    }

    private String getFieldPath(String field, IDataEntityType parentProp) {
        if (parentProp instanceof EntryType) {
            field = parentProp.getName() + "." + field;
            return this.getFieldPath(field, parentProp.getParent());
        }
        return field;
    }

    public Map<String, List<CalBillRule>> getInCalBillRuleMap() {
        return this.inCalBillRuleMap;
    }

    public Map<String, List<CalBillRule>> getOutCalBillRuleMap() {
        return this.outCalBillRuleMap;
    }

    public Map<String, List<CalBillRule>> getInitCalBillRuleMap() {
        return this.initCalBillRuleMap;
    }
}

