/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.CalculateInParams;
import kd.fi.cal.common.model.InputCalDetailRowInfo;
import kd.fi.cal.common.model.SimpleSettleAccountParam;

public class CalCustomEventCallHelper {
    private static final Log logger = LogFactory.getLog(CalCustomEventCallHelper.class);
    private static final String calCheckoutCode = "cal_checkout_notice";
    private static final String calRecSumExceptionCode = "cal_receisum_exception_notice";
    private static final String calImmediateCode = "cal_immediate_accounting_notice";
    private static final String calApiCostUpdateCode = "cal_api_costupdate_notice";
    public static final String calSalesSplitOrderNotice = "cal_sales_splitorder_notice";

    public static void calCheckoutEventCall(SimpleSettleAccountParam simpleParam) {
        logger.info("\u7ed3\u8d26\u901a\u77e5\u4e8b\u4ef6\u89e6\u53d1\u3002");
        if (!CalCustomEventCallHelper.getEvenIsActive(calCheckoutCode)) {
            logger.info("\u7ed3\u8d26\u901a\u77e5\uff0c\u5f53\u524d\u4e8b\u4ef6\u5df2\u7981\u7528\u6216\u65e0\u6d3b\u8dc3\u7684\u8ba2\u9605\u4e8b\u4ef6\u3002");
            return;
        }
        try {
            QFilter filter = new QFilter("id", "=", (Object)simpleParam.getCostAccountId());
            filter.and("ismainaccount", "=", (Object)true);
            DynamicObject costAccountObj = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{filter});
            if (costAccountObj != null) {
                DynamicObject periodObj = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)simpleParam.getCurrentPeriodId())});
                HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
                paramMap.put("org", costAccountObj.getLong("calorg"));
                paramMap.put("account", simpleParam.getCostAccountId());
                paramMap.put("startDate", periodObj.getDate("begindate"));
                paramMap.put("endDate", periodObj.getDate("enddate"));
                paramMap.put("entityNumber", "cal_costrecord");
                String json = JSONUtils.toString(paramMap);
                EventServiceHelper.triggerEventSubscribe((String)calCheckoutCode, (String)json);
            }
        }
        catch (Exception e) {
            logger.info("\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u8c03\u7528\u5931\u8d25,\u4e8b\u4ef6\u7f16\u7801==>{},\u5931\u8d25\u4fe1\u606f==>{}", (Object)calCheckoutCode, (Object)e);
        }
    }

    public static void calExceptionCostEventCall(Map<String, Object> paramMap) {
        logger.info("\u5f02\u5e38\u6210\u672c\u66f4\u65b0\u901a\u77e5\u4e8b\u4ef6\u89e6\u53d1");
        if (!CalCustomEventCallHelper.getEvenIsActive(calRecSumExceptionCode)) {
            logger.info("\u5f02\u5e38\u6210\u672c\u66f4\u65b0\u901a\u77e5\uff0c\u5f53\u524d\u4e8b\u4ef6\u5df2\u7981\u7528\u6216\u65e0\u6d3b\u8dc3\u7684\u8ba2\u9605\u4e8b\u4ef6\u3002");
            return;
        }
        if (paramMap.get("BILLSTATUS").equals("C")) {
            try {
                long costAccountId = Long.parseLong(paramMap.get("COSTACCOUNT").toString());
                QFilter accountFilter = new QFilter("id", "=", (Object)costAccountId);
                accountFilter.and("ismainaccount", "=", (Object)true);
                DynamicObject accountObj = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg,calpolicy.periodtype as periodtype", (QFilter[])new QFilter[]{accountFilter});
                if (accountObj != null) {
                    QFilter periodFilter = new QFilter("periodtype", "=", (Object)accountObj.getLong("periodtype"));
                    periodFilter.and("periodyear", "=", paramMap.get("YEAR"));
                    periodFilter.and("periodnumber", "=", paramMap.get("PERIODNUM"));
                    DynamicObject periodObj = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{periodFilter});
                    if (periodObj == null) {
                        logger.info("\u5f02\u5e38\u6210\u672c\u66f4\u65b0\u901a\u77e5\u4e8b\u4ef6\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4");
                        return;
                    }
                    List paramList = (List)SerializationUtils.fromJsonString((String)((String)paramMap.get("PARAMLIST")), ArrayList.class);
                    ArrayList<Map> resultList = new ArrayList<Map>(200);
                    Set<String> salOutBillNums = CalCustomEventCallHelper.getSalOutBillNums();
                    for (Map map : paramList) {
                        Object billType = map.get("billtype");
                        if (!salOutBillNums.contains(billType.toString())) continue;
                        resultList.add(map);
                    }
                    if (resultList.isEmpty()) {
                        return;
                    }
                    Integer patchSize = CalDbParamServiceHelper.getInteger(CalDbParamConstant.COST_UPDATE_NOTICE_BATCHSIZE);
                    logger.info("\u5f02\u5e38\u6210\u672c\u66f4\u65b0\u901a\u77e5\u5206\u6279\u6570\u91cf==>{}", (Object)patchSize);
                    List partition = Lists.partition(resultList, (int)patchSize);
                    for (List mapList : partition) {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>(mapList.size());
                        HashSet materialIds = new HashSet(mapList.size());
                        HashSet<String> bizObject = new HashSet<String>(mapList.size());
                        HashSet bizBillId = new HashSet(mapList.size());
                        HashSet bizBillEntryId = new HashSet(mapList.size());
                        resultMap.put("org", accountObj.getLong("calorg"));
                        resultMap.put("account", costAccountId);
                        resultMap.put("startDate", periodObj.getDate("begindate"));
                        resultMap.put("endDate", periodObj.getDate("enddate"));
                        resultMap.put("entityNumber", "cal_costrecord");
                        bizObject.add("im_saloutbill");
                        for (Map map : mapList) {
                            materialIds.add(map.get("material"));
                            bizBillId.add(map.get("bizbillid"));
                            bizBillEntryId.add(map.get("bizentryid"));
                        }
                        resultMap.put("materialId", materialIds);
                        resultMap.put("bizObject", bizObject);
                        resultMap.put("bizBillId", bizBillId);
                        resultMap.put("bizBillEntryId", bizBillEntryId);
                        EventServiceHelper.triggerEventSubscribe((String)calRecSumExceptionCode, (String)JSONUtils.toString(resultMap));
                    }
                }
            }
            catch (Exception e) {
                logger.info("\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u8c03\u7528\u5931\u8d25,\u4e8b\u4ef6\u7f16\u7801==>{},\u5931\u8d25\u4fe1\u606f==>{}", (Object)calRecSumExceptionCode, (Object)e);
            }
        }
    }

    public static void calRecSumEventCall(List<CalculateInParams> paramsList, Map<String, List> detailMap, long costAccount) {
        logger.info("\u5165\u5e93\u6c47\u603b\u6838\u7b97\u6210\u672c\u901a\u77e5\u4e8b\u4ef6\u89e6\u53d1");
        if (!CalCustomEventCallHelper.getEvenIsActive(calRecSumExceptionCode)) {
            logger.info("\u5165\u5e93\u6c47\u603b\u6838\u7b97\u6210\u672c\u901a\u77e5\uff0c\u5f53\u524d\u4e8b\u4ef6\u5df2\u7981\u7528\u6216\u65e0\u6d3b\u8dc3\u7684\u8ba2\u9605\u4e8b\u4ef6\u3002");
            return;
        }
        try {
            List keyLists = paramsList.stream().map(CalculateInParams::getGatherID).collect(Collectors.toList());
            QFilter accountFilter = new QFilter("id", "=", (Object)costAccount);
            accountFilter.and("ismainaccount", "=", (Object)true);
            DynamicObject accountObj = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{accountFilter});
            if (accountObj != null) {
                ArrayList paramList = new ArrayList();
                for (Map.Entry<String, List> entry : detailMap.entrySet()) {
                    if (!keyLists.contains(entry.getKey())) continue;
                    paramList.addAll(entry.getValue());
                }
                ArrayList<InputCalDetailRowInfo> list = new ArrayList<InputCalDetailRowInfo>();
                Set<String> salOutBillNums = CalCustomEventCallHelper.getSalOutBillNums();
                for (String param : paramList) {
                    InputCalDetailRowInfo info = (InputCalDetailRowInfo)JSONUtils.cast((String)param, InputCalDetailRowInfo.class);
                    if (!salOutBillNums.contains(info.getBillTypeNum())) continue;
                    list.add(info);
                }
                if (list.isEmpty()) {
                    return;
                }
                Integer maxSize = CalDbParamServiceHelper.getInteger(CalDbParamConstant.COST_UPDATE_NOTICE_OPENDETAIL_COUNT);
                logger.info("\u5165\u5e93\u6c47\u603b\u6838\u7b97\u6210\u672c\u5bf9\u8c61\u9500\u552e\u51fa\u5e93\u5355\u6761\u6570==>{}\uff0c\u5206\u6279\u6570\u91cf==>", (Object)list.size(), (Object)maxSize);
                if (list.size() > maxSize) {
                    QFilter filter = new QFilter("id", "=", (Object)((InputCalDetailRowInfo)list.get(0)).getId());
                    filter.and("costaccount.ismainaccount", "=", (Object)true);
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_costrecord", (String)"calorg,costaccount,period.begindate as begindate,period.enddate as enddate", (QFilter[])new QFilter[]{filter});
                    if (dynamicObject != null) {
                        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
                        resultMap.put("org", dynamicObject.getLong("calorg"));
                        resultMap.put("account", dynamicObject.getLong("costaccount"));
                        resultMap.put("startDate", dynamicObject.getDate("begindate"));
                        resultMap.put("endDate", dynamicObject.getDate("enddate"));
                        resultMap.put("entityNumber", "cal_costrecord");
                        resultMap.put("materialId", Sets.newHashSet());
                        resultMap.put("bizObject", Sets.newHashSet());
                        resultMap.put("bizBillId", Sets.newHashSet());
                        resultMap.put("bizBillEntryId", Sets.newHashSet());
                        EventServiceHelper.triggerEventSubscribe((String)calRecSumExceptionCode, (String)JSONUtils.toString(resultMap));
                    }
                } else {
                    Set recordIds = list.stream().map(InputCalDetailRowInfo::getId).collect(Collectors.toSet());
                    Set matIds = list.stream().map(InputCalDetailRowInfo::getMaterial).collect(Collectors.toSet());
                    QFilter filter = new QFilter("id", "in", recordIds);
                    filter.and("costaccount.ismainaccount", "=", (Object)true);
                    filter.and("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.ADD_AVERAGE.getValue(), AccountTypeEnum.SPECIAL_ACCT.getValue(), AccountTypeEnum.FIN_FOUT_PERIOD.getValue(), AccountTypeEnum.MOVE_WEIGHTED_AVERAGE.getValue()});
                    filter.and("entry.material", "in", matIds);
                    Map<String, Map<String, Object>> recodedList = CalCustomEventCallHelper.getRecodedList(filter);
                    if (recodedList.isEmpty()) {
                        logger.info("\u5165\u5e93\u6c47\u603b\u6838\u7b97\u6210\u672c\u901a\u77e5\u67e5\u8be2\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u8fc7\u6ee4\u6761\u4ef6==>{}", (Object)filter);
                    } else {
                        for (Map.Entry<String, Map<String, Object>> recodeEntry : recodedList.entrySet()) {
                            String key = recodeEntry.getKey();
                            Map<String, Object> valueParam = recodeEntry.getValue();
                            WriteLogHelper.writeInfoLog(logger, "calInCostOrgAcctEvent,key==>{}", key);
                            EventServiceHelper.triggerEventSubscribe((String)calRecSumExceptionCode, (String)JSONUtils.toString(valueParam));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.info("\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u8c03\u7528\u5931\u8d25,\u4e8b\u4ef6\u7f16\u7801==>{},\u5931\u8d25\u4fe1\u606f==>{}", (Object)calRecSumExceptionCode, (Object)e);
        }
    }

    public static void calImmediateAccountingEventCall(Set<Long> idSet) {
        logger.info("\u5373\u65f6\u6838\u7b97\u6210\u672c\u66f4\u65b0\u901a\u77e5\u4e8b\u4ef6\u89e6\u53d1");
        if (!CalCustomEventCallHelper.getEvenIsActive(calImmediateCode)) {
            logger.info("\u5373\u65f6\u6838\u7b97\u6210\u672c\u66f4\u65b0\u901a\u77e5\uff0c\u5f53\u524d\u4e8b\u4ef6\u5df2\u7981\u7528\u6216\u65e0\u6d3b\u8dc3\u7684\u8ba2\u9605\u4e8b\u4ef6\u3002");
            return;
        }
        try {
            QFilter filter = new QFilter("bizbillid", "in", idSet);
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
            filter.and("issplitcreate", "=", (Object)Boolean.FALSE);
            filter.and("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.MOVE_ADD_AVERAGE.getValue(), AccountTypeEnum.FIN_FOUT.getValue()});
            filter.and("invscheme.isforwardamount", "=", (Object)Boolean.TRUE);
            filter.and("entry.invtype.isforwardamount", "=", (Object)Boolean.TRUE);
            filter.and("biztype", "not in", CommonSettingHelper.getNotUpdBalBizType());
            filter.and("billtype.billformid", "=", (Object)"im_saloutbill");
            filter.and("costaccount.ismainaccount", "=", (Object)true);
            Map<String, Map<String, Object>> recodedList = CalCustomEventCallHelper.getRecodedList(filter);
            if (recodedList.isEmpty()) {
                logger.info("\u5373\u65f6\u6838\u7b97\u6210\u672c\u66f4\u65b0\u901a\u77e5\u67e5\u8be2\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u8fc7\u6ee4\u6761\u4ef6==>{}", (Object)filter);
            } else {
                for (Map.Entry<String, Map<String, Object>> recodeEntry : recodedList.entrySet()) {
                    String key = recodeEntry.getKey();
                    Map<String, Object> valueParam = recodeEntry.getValue();
                    WriteLogHelper.writeInfoLog(logger, "calintime-update-event-org-acct\uff0ckey==>{}", key);
                    EventServiceHelper.triggerEventSubscribe((String)calImmediateCode, (String)JSONUtils.toString(valueParam));
                }
            }
        }
        catch (Exception e) {
            logger.info("\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u8c03\u7528\u5931\u8d25,\u4e8b\u4ef6\u7f16\u7801==>{},\u5931\u8d25\u4fe1\u606f==>{}", (Object)calImmediateCode, (Object)e);
        }
    }

    public static void calApiCostUpdateEventCall(List<Long> idList) {
        logger.info("API\u6210\u672c\u66f4\u65b0\u901a\u77e5\u4e8b\u4ef6\u89e6\u53d1");
        if (!CalCustomEventCallHelper.getEvenIsActive(calApiCostUpdateCode)) {
            logger.info("API\u6210\u672c\u66f4\u65b0\u901a\u77e5\uff0c\u5f53\u524d\u4e8b\u4ef6\u5df2\u7981\u7528\u6216\u65e0\u6d3b\u8dc3\u7684\u8ba2\u9605\u4e8b\u4ef6\u3002");
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                QFilter filter = new QFilter("id", "in", idList);
                filter.and("entry.accounttype", "in", (Object)new String[]{AccountTypeEnum.ADD_AVERAGE.getValue(), AccountTypeEnum.SPECIAL_ACCT.getValue(), AccountTypeEnum.FIN_FOUT_PERIOD.getValue(), AccountTypeEnum.MOVE_WEIGHTED_AVERAGE.getValue()});
                filter.and("billtype.billformid", "=", (Object)"im_saloutbill");
                filter.and("costaccount.ismainaccount", "=", (Object)true);
                Map<String, Map<String, Object>> recodedList = CalCustomEventCallHelper.getRecodedList(filter);
                if (recodedList.isEmpty()) {
                    logger.info("API\u6210\u672c\u66f4\u65b0\u901a\u77e5\u67e5\u8be2\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u8fc7\u6ee4\u6761\u4ef6==>{}", (Object)filter);
                } else {
                    for (Map.Entry<String, Map<String, Object>> recodeEntry : recodedList.entrySet()) {
                        String key = recodeEntry.getKey();
                        Map<String, Object> valueParam = recodeEntry.getValue();
                        WriteLogHelper.writeInfoLog(logger, "calintimeUpdateEventOrgAcct001\uff0ckey==>{}", key);
                        EventServiceHelper.triggerEventSubscribe((String)calApiCostUpdateCode, (String)JSONUtils.toString(valueParam));
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.info("\u81ea\u5b9a\u4e49\u4e8b\u4ef6\u8c03\u7528\u5931\u8d25,\u4e8b\u4ef6\u7f16\u7801==>{},\u5931\u8d25\u4fe1\u606f==>{}", (Object)calApiCostUpdateCode, (Object)e);
            }
        }
    }

    public static void calSalesSplitOrderEventCall(List<Long> recordIds) {
        logger.info("\u9500\u552e\u62c6\u5355\u901a\u77e5\u4e8b\u4ef6\u89e6\u53d1");
        if (!CalCustomEventCallHelper.getEvenIsActive(calSalesSplitOrderNotice)) {
            logger.info("\u9500\u552e\u62c6\u5355\u901a\u77e5\uff0c\u5f53\u524d\u4e8b\u4ef6\u5df2\u7981\u7528\u6216\u65e0\u6d3b\u8dc3\u7684\u8ba2\u9605\u4e8b\u4ef6\u3002");
            return;
        }
        QFilter filter = new QFilter("id", "in", recordIds);
        filter.and("billtype.billformid", "=", (Object)"im_saloutbill");
        filter.and("costaccount.ismainaccount", "=", (Object)true);
        Map<String, Map<String, Object>> recodedList = CalCustomEventCallHelper.getRecodedList(filter);
        if (recodedList.isEmpty()) {
            logger.info("\u9500\u552e\u62c6\u5355\u83b7\u53d6\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u8fc7\u6ee4\u6761\u4ef6==>{}", (Object)filter);
        } else {
            for (Map.Entry<String, Map<String, Object>> recodeEntry : recodedList.entrySet()) {
                String key = recodeEntry.getKey();
                Map<String, Object> valueParam = recodeEntry.getValue();
                WriteLogHelper.writeErrorLog(logger, "salwfCalintimeUpdateEventOrgAcct\uff0ckey==>{}", key);
                TXHandle tx = TX.requiresNew();
                Throwable throwable = null;
                try {
                    try {
                        EventServiceHelper.triggerEventSubscribe((String)calSalesSplitOrderNotice, (String)JSONUtils.toString(valueParam));
                    }
                    catch (Exception e) {
                        WriteLogHelper.writeErrorLog(logger, "salwfError-cal_sales_splitorder_notice\uff1a", e);
                        tx.markRollback();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }
    }

    private static Map<String, Map<String, Object>> getRecodedList(QFilter filter) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_costrecord", (String)"calorg,costaccount,period.begindate as begindate,period.enddate as enddate,billtype.billformid as billtype,bizbillid,entry.material as material,entry.bizbillentryid as bizbillentryid", (QFilter[])new QFilter[]{filter});
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(16);
        HashMap<String, List> dynamicMap = new HashMap<String, List>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String key = dynamicObject.getString("calorg") + "@" + dynamicObject.getString("costaccount");
            dynamicMap.computeIfAbsent(key, s -> new ArrayList()).add(dynamicObject);
        }
        Integer patchSize = CalDbParamServiceHelper.getInteger(CalDbParamConstant.COST_UPDATE_NOTICE_BATCHSIZE);
        for (Map.Entry entry : dynamicMap.entrySet()) {
            List value = (List)entry.getValue();
            List patchList = Lists.partition((List)value, (int)patchSize);
            for (int i = 0; i < patchList.size(); ++i) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                List list = (List)patchList.get(i);
                DynamicObject dynamicObject = (DynamicObject)list.get(0);
                param.put("org", dynamicObject.getLong("calorg"));
                param.put("account", dynamicObject.getLong("costaccount"));
                param.put("startDate", dynamicObject.getDate("begindate"));
                param.put("endDate", dynamicObject.getDate("enddate"));
                param.put("entityNumber", "cal_costrecord");
                HashSet materialIds = new HashSet(list.size());
                HashSet<String> bizObject = new HashSet<String>(list.size());
                HashSet<Long> bizBillId = new HashSet<Long>(list.size());
                HashSet<Long> bizBillEntryId = new HashSet<Long>(list.size());
                for (DynamicObject object : list) {
                    bizObject.add(object.getString("billtype"));
                    bizBillId.add(object.getLong("bizbillid"));
                    bizBillEntryId.add(object.getLong("bizbillentryid"));
                }
                param.put("materialId", materialIds);
                param.put("bizObject", bizObject);
                param.put("bizBillId", bizBillId);
                param.put("bizBillEntryId", bizBillEntryId);
                resultMap.put((String)entry.getKey() + "@" + i, param);
            }
        }
        return resultMap;
    }

    private static boolean getEvenIsActive(String eventCode) {
        QFilter filter = new QFilter("numberview", "=", (Object)eventCode);
        filter.and("status", "=", (Object)true);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"evt_event", (String)"id", (QFilter[])new QFilter[]{filter});
        if (dynamicObject == null) {
            return false;
        }
        QFilter subFilter = new QFilter("event", "=", (Object)dynamicObject.getLong("id"));
        subFilter.and("status", "=", (Object)true);
        return QueryServiceHelper.exists((String)"evt_subscription", (QFilter[])new QFilter[]{subFilter});
    }

    private static Set<String> getSalOutBillNums() {
        QFilter filter = new QFilter("enable", "=", (Object)true);
        filter.and("status", "=", (Object)"C");
        filter.and("billformid", "=", (Object)"im_saloutbill");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_billtype", (String)"number", (QFilter[])new QFilter[]{filter});
        return dynamicObjects.stream().map(r -> r.getString("number")).collect(Collectors.toSet());
    }
}

