/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;

public class CalDbParamServiceHelper {
    private static final String KEY_NAME = "key";
    private static final String VALUE_NAME = "value";
    private static final String ORG_NAME = "org";
    private static final String BATCH_CACHE = "batch_cache";

    public static Map<String, String> getKeyOrgValueMap(String key) {
        QFilter keyFilter = new QFilter(KEY_NAME, "=", (Object)key);
        String batchCacheKey = key + BATCH_CACHE;
        HashMap<String, String> keyOrgValueMap = (HashMap<String, String>)ThreadCache.get((Object)batchCacheKey);
        if (keyOrgValueMap == null) {
            DynamicObject[] paramDycs;
            keyOrgValueMap = new HashMap<String, String>(16);
            Map cacheParamDycs = BusinessDataServiceHelper.loadFromCache((String)"cal_dbparam", (QFilter[])keyFilter.toArray());
            for (DynamicObject paramDyc : paramDycs = cacheParamDycs.values().toArray(new DynamicObject[0])) {
                String keyStr = paramDyc.getString(KEY_NAME);
                String valueStr = paramDyc.getString(VALUE_NAME);
                Long orgId = paramDyc.getLong("org_id");
                keyOrgValueMap.put(keyStr + orgId, valueStr);
            }
            ThreadCache.put((Object)batchCacheKey, keyOrgValueMap);
        }
        return keyOrgValueMap;
    }

    public static String getString(String key, String orgId) {
        String paramValue = null;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cal_dbparam");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        QFilter keyFilter = new QFilter(KEY_NAME, "=", (Object)key);
        filters.add(keyFilter);
        String cacheKey = key;
        if (StringUtils.isNotEmpty((String)orgId)) {
            Long orgIdLong = Long.valueOf(orgId);
            QFilter orgIdFilter = new QFilter(ORG_NAME, "=", (Object)orgIdLong);
            filters.add(orgIdFilter);
            cacheKey = cacheKey + orgId;
        }
        if ((paramValue = (String)ThreadCache.get((Object)cacheKey)) == null) {
            Map cacheParamDycs = BusinessDataServiceHelper.loadFromCache((String)"cal_dbparam", (QFilter[])filters.toArray(new QFilter[0]));
            DynamicObject[] paramDycs = cacheParamDycs.values().toArray(new DynamicObject[0]);
            if (paramDycs.length < 1) {
                DynamicObject newParamDyc = new DynamicObject((DynamicObjectType)entityType);
                String defaultValue = CalDbParamConstant.keyDefaultValueMap.get(key);
                newParamDyc.set(KEY_NAME, (Object)key);
                newParamDyc.set(ORG_NAME, (Object)orgId);
                newParamDyc.set(VALUE_NAME, (Object)defaultValue);
                paramValue = defaultValue;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newParamDyc});
            } else {
                paramValue = paramDycs[0].getString(VALUE_NAME);
            }
            if (paramValue != null) {
                ThreadCache.put((Object)cacheKey, (Object)paramValue);
            }
        }
        return paramValue;
    }

    public static Integer getInteger(String key) {
        return CalDbParamServiceHelper.getInteger(key, null);
    }

    public static Integer getInteger(String key, String orgId) {
        String param = CalDbParamServiceHelper.getString(key, orgId);
        if (StringUtils.isEmpty((String)param)) {
            return null;
        }
        return Integer.valueOf(param);
    }

    public static Long getLong(String key) {
        return CalDbParamServiceHelper.getLong(key, null);
    }

    public static Long getLong(String key, String orgId) {
        String param = CalDbParamServiceHelper.getString(key, orgId);
        if (StringUtils.isEmpty((String)param)) {
            return null;
        }
        return Long.valueOf(param);
    }

    public static BigDecimal getBigDecimal(String key) {
        return CalDbParamServiceHelper.getBigDecimal(key, null);
    }

    public static BigDecimal getBigDecimal(String key, String orgId) {
        String param = CalDbParamServiceHelper.getString(key, orgId);
        if (StringUtils.isEmpty((String)param)) {
            return null;
        }
        return new BigDecimal(param);
    }

    public static Boolean getBoolean(String key) {
        return CalDbParamServiceHelper.getBoolean(key, null);
    }

    public static Boolean getBoolean(String key, String orgId) {
        String param = CalDbParamServiceHelper.getString(key, orgId);
        if (StringUtils.isEmpty((String)param)) {
            return null;
        }
        return Boolean.valueOf(param);
    }

    public static void updateParam(String key, String value, Long orgId) {
        DynamicObject paramDyc;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        QFilter keyFilter = new QFilter(KEY_NAME, "=", (Object)key);
        filters.add(keyFilter);
        if (orgId != null && !orgId.equals(0L)) {
            QFilter orgIdFilter = new QFilter(ORG_NAME, "=", (Object)orgId);
            filters.add(orgIdFilter);
        }
        if ((paramDyc = BusinessDataServiceHelper.loadSingle((String)"cal_dbparam", (QFilter[])filters.toArray(new QFilter[0]))) != null) {
            paramDyc.set(VALUE_NAME, (Object)value);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{paramDyc});
        }
        String cacheKey = key;
        if (orgId != null && !orgId.equals(0L)) {
            cacheKey = cacheKey + orgId;
        }
        ThreadCache.remove((Object)cacheKey);
    }
}

