/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.util.CommonUtils;
import org.apache.commons.lang.StringUtils;

public class CalDiffGroupBillHelper {
    public static boolean getIsgroupdiff() {
        String isgroupdiffbill = CalDbParamServiceHelper.getString("isgroupdiffbill", null);
        return isgroupdiffbill != null && "true".equals(isgroupdiffbill);
    }

    public static void deleteGroupDiffBill(Set<Long> diffGroupIdSet, Set<Long> accountIdSet) {
        if (!CalDiffGroupBillHelper.getIsgroupdiff()) {
            return;
        }
        if (!diffGroupIdSet.isEmpty()) {
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_stdcostdiff", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccount", FilterType.in_range, accountIdSet)});){
                ctx.set();
                DeleteServiceHelper.delete((String)"cal_costdiffgroupbill", (QFilter[])new QFilter[]{new QFilter("id", "in", diffGroupIdSet)});
                String updateSql = "UPDATE t_cal_stdcostdiffentry SET FGROUPDIFFBILLNUM = ' ',FGROUPDIFFBILLID = 0 WHERE FGROUPDIFFBILLID in (" + StringUtils.join(diffGroupIdSet, (String)",") + ")";
                DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateSql);
            }
        }
    }

    public static Set<Long> getHasVoucherDiffBill(Set<Long> diffGroupIdSet, Map<Long, Set<Long>> diffBillAndGroupBillMap) {
        QFilter q = new QFilter("id", "in", diffGroupIdSet);
        q.and("isvoucher", "=", (Object)true);
        DataSet hasVoucherGroupBillDs = QueryServiceHelper.queryDataSet((String)"CalDiffGroupBillHelper-querydiffgroupbill", (String)"cal_costdiffgroupbill", (String)"id", (QFilter[])q.toArray(), null);
        HashSet<Long> hasVoucherDiffBillIds = new HashSet<Long>(16);
        HashSet<Long> hasVoucherDiffGroupBillIds = new HashSet<Long>(16);
        for (Row row : hasVoucherGroupBillDs) {
            hasVoucherDiffGroupBillIds.add(row.getLong("id"));
        }
        if (hasVoucherDiffGroupBillIds.isEmpty()) {
            return hasVoucherDiffBillIds;
        }
        block1: for (Map.Entry<Long, Set<Long>> entry : diffBillAndGroupBillMap.entrySet()) {
            Long diffBillId = entry.getKey();
            Set<Long> diffGroupBillSet = entry.getValue();
            for (Long diffGroupBillId : diffGroupBillSet) {
                if (!hasVoucherDiffGroupBillIds.contains(diffGroupBillId)) continue;
                hasVoucherDiffBillIds.add(diffBillId);
                continue block1;
            }
        }
        return hasVoucherDiffBillIds;
    }
}

