/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.util.CommonUtils;

public class CalDiffGroupSettingHelper {
    public static String AddDefaultGroupDims(String groupDims) {
        StringBuilder stringBuilder = new StringBuilder(groupDims);
        for (String defaultDim : CalDiffGroupSettingHelper.getDefaultGroupDims()) {
            stringBuilder.append(',');
            stringBuilder.append(defaultDim);
        }
        return stringBuilder.toString();
    }

    public static Set<String> getDefaultGroupDims() {
        HashSet<String> defaultGroupDimsSet = new HashSet<String>(16);
        defaultGroupDimsSet.add("calorg");
        defaultGroupDimsSet.add("costaccount");
        defaultGroupDimsSet.add("period");
        defaultGroupDimsSet.add("currency");
        defaultGroupDimsSet.add("material");
        defaultGroupDimsSet.add("createtype");
        defaultGroupDimsSet.add("biztype");
        defaultGroupDimsSet.add("isupdatecost");
        defaultGroupDimsSet.add("ischargeoffed");
        defaultGroupDimsSet.add("ischargeoff");
        return defaultGroupDimsSet;
    }

    public static Set<String> getAmountFields() {
        HashSet<String> amountFieldsSet = new HashSet<String>(16);
        amountFieldsSet.add("adjustamt");
        amountFieldsSet.add("diff_g");
        amountFieldsSet.add("diff_h");
        amountFieldsSet.add("diff_k");
        amountFieldsSet.add("diff_p");
        amountFieldsSet.add("diff_q");
        amountFieldsSet.add("diff_r");
        amountFieldsSet.add("diff_m");
        amountFieldsSet.add("diff_s");
        amountFieldsSet.add("diff_t");
        amountFieldsSet.add("diff_c");
        return amountFieldsSet;
    }

    public static Set<String> getAllEnableGroupDims() {
        HashSet<String> groupDimsSet = new HashSet<String>(16);
        groupDimsSet.addAll(CalDiffGroupSettingHelper.getDefaultGroupDims());
        DynamicObjectCollection groupSettings = CalDiffGroupSettingHelper.getAllEnableSetting("groupDims");
        if (groupSettings.isEmpty()) {
            return groupDimsSet;
        }
        for (DynamicObject groupSetting : groupSettings) {
            String[] groupDims;
            for (String groupDim : groupDims = CommonUtils.trimComma(groupSetting.getString("groupdims")).split(",")) {
                if ("".equals(groupDim)) continue;
                groupDimsSet.add(groupDim);
            }
        }
        return groupDimsSet;
    }

    public static DynamicObjectCollection getAllEnableSetting(String selectFields) {
        if (selectFields == null) {
            selectFields = "id,number,name,bizentityobject,bizentityobject.number,biztype,groupdims,orgentry.org";
        }
        return QueryServiceHelper.query((String)"cal_groupdiffbill_setting", (String)selectFields, (QFilter[])new QFilter("enable", "=", (Object)Character.valueOf('1')).toArray());
    }
}

