/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CalFieldMapHelper {
    public Map<String, Map<String, String>> getBillFields(Set<String> billTypes) {
        if (billTypes == null || billTypes.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(16);
        QFilter q = new QFilter("entryentity.billtype", "in", billTypes);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_fieldmapconfig", (String)"calfield,entryentity.billtype,entryentity.billfield", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                String calField = row.getString("calfield");
                String billType = row.getString("entryentity.billtype");
                String billField = row.getString("entryentity.billfield");
                HashMap<String, String> fields = (HashMap<String, String>)resultMap.get(billType);
                if (fields == null) {
                    fields = new HashMap<String, String>(16);
                    resultMap.put(billType, fields);
                }
                fields.put(calField, billField);
            }
        }
        return resultMap;
    }

    @Deprecated
    public Map<String, Map<String, String>> getBizBillFields(Set<String> billTypes) {
        if (billTypes == null || billTypes.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(16);
        QFilter q = new QFilter("entryentity.billtype", "in", billTypes);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_fieldmapconfig", (String)"calfield,entryentity.billtype,entryentity.billfield", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                String calField = row.getString("calfield");
                String billType = row.getString("entryentity.billtype");
                String billField = row.getString("entryentity.billfield");
                HashMap<String, String> fields = (HashMap<String, String>)resultMap.get(billType);
                if (fields == null) {
                    fields = new HashMap<String, String>(16);
                    resultMap.put(billType, fields);
                }
                fields.put(billField, calField);
            }
        }
        return resultMap;
    }

    public Map<String, Map<String, Set<String>>> getBizBillField2CalBillFields(Set<String> billTypes) {
        if (billTypes == null || billTypes.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, Set<String>>> resultMap = new HashMap<String, Map<String, Set<String>>>(16);
        QFilter q = new QFilter("entryentity.billtype", "in", billTypes);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_fieldmapconfig", (String)"calfield,entryentity.billtype,entryentity.billfield", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                String calField = row.getString("calfield");
                String billType = row.getString("entryentity.billtype");
                String billField = row.getString("entryentity.billfield");
                Map fields = resultMap.computeIfAbsent(billType, k -> new HashMap(16));
                Set calFields = fields.computeIfAbsent(billField, k -> new HashSet(4));
                calFields.add(calField);
            }
        }
        return resultMap;
    }
}

