/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.util.DBUtil;

public class CalGroupAccountHelper {
    private static final String IS_HAS_GROUP_ACCT_THREAD_CACHE = "isHasGroupAcct";

    public void addNotGroupAcctFilterSelf(QFilter filter) {
        if (!this.isHasGroupAcct().booleanValue()) {
            return;
        }
        filter.and("accountcosttype", "!=", (Object)"B");
    }

    public void addNotGroupAcctFilter4Bill(QFilter filter) {
        if (!this.isHasGroupAcct().booleanValue()) {
            return;
        }
        this.addNotGroupAcctFilterByAcctField("costaccount", filter);
    }

    public void addNotGroupAcctFilterByAcctField(String costAcctField, QFilter filter) {
        if (!this.isHasGroupAcct().booleanValue()) {
            return;
        }
        filter.and(costAcctField + ".accountcosttype", "!=", (Object)"B");
    }

    public void addNotGroupAcctFilterByAcctFieldIf(String costAcctField, QFilter filter, boolean filterGroupAcct) {
        if (!this.isHasGroupAcct().booleanValue()) {
            return;
        }
        if (filterGroupAcct) {
            filter.and(costAcctField + ".accountcosttype", "!=", (Object)"B");
        }
    }

    public void addNotGroupAcctFilterSelfIf(QFilter filter, boolean filterGroupAcct) {
        if (!this.isHasGroupAcct().booleanValue()) {
            return;
        }
        if (filterGroupAcct) {
            filter.and("accountcosttype", "!=", (Object)"B");
        }
    }

    public void addGroupAcctFilter4Bill(String costAcctField, QFilter filter) {
        filter.and(costAcctField + ".accountcosttype", "=", (Object)"B");
    }

    public String addNotGroupAcctFilter4CostRecordSql(String updateCostRecordSql, Set<Long> bizBillIds) {
        if (!this.isHasGroupAcct().booleanValue()) {
            return updateCostRecordSql;
        }
        Set<Long> notGroupCostAcctIds = this.getNotGroupAcctIds4CostRecord(bizBillIds);
        String notGroupCostAcctIdsStr = DBUtil.getInStringFromSet2(notGroupCostAcctIds);
        updateCostRecordSql = updateCostRecordSql + " and fcostaccountid in " + notGroupCostAcctIdsStr;
        return updateCostRecordSql;
    }

    public Set<Long> getNotGroupAcctIds4CostRecord(Set<Long> bizBillIds) {
        HashSet<Long> groupCostAcctIds = new HashSet<Long>(16);
        groupCostAcctIds.add(-1L);
        if (bizBillIds.isEmpty()) {
            return groupCostAcctIds;
        }
        groupCostAcctIds.clear();
        QFilter bizBillIdF = new QFilter("bizbillid", "in", bizBillIds);
        this.addNotGroupAcctFilter4Bill(bizBillIdF);
        DataSet costAcctIdDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"costaccount", (QFilter[])bizBillIdF.toArray(), null);
        for (Row row : costAcctIdDs) {
            Long costAcctId = row.getLong("costaccount");
            groupCostAcctIds.add(costAcctId);
        }
        return groupCostAcctIds;
    }

    public Boolean isHasGroupAcct() {
        Boolean isHasGroupAcctCache = (Boolean)ThreadCache.get((Object)IS_HAS_GROUP_ACCT_THREAD_CACHE);
        if (isHasGroupAcctCache == null) {
            QFilter filter = new QFilter("accountcosttype", "=", (Object)"B");
            isHasGroupAcctCache = QueryServiceHelper.exists((String)"cal_bd_costaccount", (QFilter[])filter.toArray());
            ThreadCache.put((Object)IS_HAS_GROUP_ACCT_THREAD_CACHE, (Object)isHasGroupAcctCache);
        }
        return isHasGroupAcctCache;
    }
}

