/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import kd.bos.exception.KDBizException;
import org.apache.commons.lang3.StringUtils;

public class CalcKeyHelper {
    public static final String KEY_MATERIAL = "material";
    public static final String KEY_VERSION = "matvers";
    public static final String KEY_AUXPTY = "auxproperty";
    public static final String KEY_PROJECT = "project";
    public static final String KEY_TRACKNUMBER = "tracknumber";
    public static final String KEY_CONFIGUREDCODE = "configuredcode";
    public static final String KEY_LOT = "lot";
    private static final String[] ORDER_KEYARRAY = new String[]{"material", "matvers", "auxproperty", "project", "tracknumber", "configuredcode", "lot"};

    private static boolean isDbDefaultValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value.getClass() == String.class) {
            return StringUtils.isBlank((CharSequence)((String)value));
        }
        if (value.getClass() == BigDecimal.class) {
            return ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0;
        }
        return value.toString().equals("0");
    }

    public static String getCalcKey(Map<String, Object> values) {
        StringBuilder sb = new StringBuilder();
        for (String keyCol : ORDER_KEYARRAY) {
            Object value = values.get(keyCol);
            if (KEY_VERSION.equals(keyCol)) {
                value = 0L;
            }
            if (CalcKeyHelper.isDbDefaultValue(value)) continue;
            sb.append(keyCol).append(':').append(value).append(',');
        }
        if (sb.length() == 0) {
            return null;
        }
        String keycol = CalcKeyHelper.getKeyStr(sb.toString());
        return keycol;
    }

    public static String getKeyStr(String message) {
        return CalcKeyHelper.getSHA256Base64Str(message);
    }

    private static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e1) {
            throw new KDBizException(String.format("CalcKeyHelper:[%s] args:[%s]", e1.getMessage(), message));
        }
    }
}

