/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.enums.CostSrcEnum;
import kd.fi.cal.common.model.CostRecordChildNode;
import kd.fi.cal.common.util.CommonUtils;

public class ChildBillCostUpdateHelper {
    private Map<String, Long[]> cosTypeMaterialMap;
    private Long[] defaultElementIds;
    private boolean isCostRecordDetail;
    private List<Object[]> paramList = new ArrayList<Object[]>();
    private List<Object[]> costDetailParamList = new ArrayList<Object[]>();
    private Set<Long> childEntryIdSet = new HashSet<Long>();

    public ChildBillCostUpdateHelper(Map<String, Long[]> cosTypeMaterialMap, Long[] defaultElementIds, boolean isCostRecordDetail) {
        this.cosTypeMaterialMap = cosTypeMaterialMap;
        this.defaultElementIds = defaultElementIds;
        this.isCostRecordDetail = isCostRecordDetail;
    }

    public void updateChildBillCost(Set<Long> entryIdSet) {
        this.updateChildBillCost(entryIdSet, "");
    }

    public void updateChildBillCost(Set<Long> entryIdSet, String isExpOption) {
        ArrayList<Long> entryIdList = new ArrayList<Long>(entryIdSet);
        List partition = Lists.partition(entryIdList, (int)1000);
        for (List list : partition) {
            List<CostRecordChildNode> nodeList = this.buildTrees(list);
            for (CostRecordChildNode node : nodeList) {
                this.handleChildNode(node, isExpOption);
            }
        }
        if (!this.paramList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.getUpdateSql(CostSrcEnum.EXPBILL.getValue().equals(isExpOption)), this.paramList);
        }
        if (!this.costDetailParamList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)this.getCostRecordDetailSql(), this.costDetailParamList);
        }
        if (!this.childEntryIdSet.isEmpty()) {
            this.caculateDetailUnitActual(this.childEntryIdSet);
        }
    }

    private void handleChildNode(CostRecordChildNode node, String isExpOption) {
        if (node == null || node.getBill() == null) {
            return;
        }
        List<DynamicObject> childBillAList = node.getBillAList();
        List<DynamicObject> childBillBList = node.getBillBList();
        if (childBillAList.isEmpty() && childBillBList.isEmpty()) {
            return;
        }
        DynamicObject fatherBill = node.getBill();
        int amtPrecision = fatherBill.getInt("localcurrency.amtprecision");
        int pricePrecision = 10;
        BigDecimal fatherActualcost = fatherBill.getBigDecimal("entry.actualcost");
        BigDecimal fatherUnitactualcost = fatherBill.getBigDecimal("entry.unitactualcost");
        long costTypeId = fatherBill.getLong("costaccount.costtype");
        long materialId = fatherBill.getLong("entry.material");
        long elementId = this.defaultElementIds[0];
        Long[] elementIds = this.cosTypeMaterialMap.get(costTypeId + "|" + materialId);
        Long writeOffEndPeriod = fatherBill.getLong("writeoffendperiod");
        if (this.isCostRecordDetail && elementIds != null) {
            elementId = elementIds[0];
        }
        if (!childBillAList.isEmpty()) {
            int i = 0;
            BigDecimal totalActualCostA = BigDecimal.ZERO;
            for (DynamicObject childBillA : childBillAList) {
                boolean isLastA = i == childBillAList.size() - 1;
                BigDecimal actualCostA = BigDecimal.ZERO;
                if (childBillA != null) {
                    BigDecimal feeA = childBillA.getBigDecimal("entry.fee");
                    BigDecimal processcostA = childBillA.getBigDecimal("entry.processcost");
                    BigDecimal resourceA = childBillA.getBigDecimal("entry.resource");
                    BigDecimal manufactureCostA = childBillA.getBigDecimal("entry.manufacturecost");
                    BigDecimal baseQtyA = childBillA.getBigDecimal("entry.baseqty");
                    BigDecimal oldActualCostA = childBillA.getBigDecimal("entry.actualcost");
                    BigDecimal materialCostA = BigDecimal.ZERO;
                    BigDecimal unitMaterialCostA = BigDecimal.ZERO;
                    actualCostA = isLastA && writeOffEndPeriod != null && writeOffEndPeriod != 0L ? fatherActualcost.subtract(totalActualCostA) : fatherUnitactualcost.multiply(baseQtyA).setScale(amtPrecision, 4);
                    materialCostA = actualCostA.subtract(feeA).subtract(processcostA).subtract(resourceA).subtract(manufactureCostA);
                    unitMaterialCostA = feeA.compareTo(BigDecimal.ZERO) == 0 && processcostA.compareTo(BigDecimal.ZERO) == 0 && resourceA.compareTo(BigDecimal.ZERO) == 0 && manufactureCostA.compareTo(BigDecimal.ZERO) == 0 ? fatherUnitactualcost : materialCostA.divide(baseQtyA, pricePrecision, 4);
                    if (CostSrcEnum.EXPBILL.getValue().equals(isExpOption)) {
                        this.paramList.add(new Object[]{actualCostA, fatherUnitactualcost, materialCostA, unitMaterialCostA, CostSrcEnum.EXPBILL.getValue(), childBillA.get("entry.id")});
                    } else {
                        this.paramList.add(new Object[]{actualCostA, fatherUnitactualcost, materialCostA, unitMaterialCostA, childBillA.get("entry.id")});
                    }
                    this.costDetailParamList.add(new Object[]{actualCostA.subtract(oldActualCostA), childBillA.get("entry.id"), elementId});
                    this.childEntryIdSet.add(childBillA.getLong("entry.id"));
                    childBillA.set("entry.actualcost", (Object)actualCostA);
                    childBillA.set("entry.unitactualcost", (Object)fatherUnitactualcost);
                    childBillA.set("entry.materialcost", (Object)materialCostA);
                    childBillA.set("entry.unitmaterialcost", (Object)unitMaterialCostA);
                    totalActualCostA = totalActualCostA.add(actualCostA);
                }
                ++i;
            }
        }
        if (!childBillBList.isEmpty()) {
            for (DynamicObject childBillB : childBillBList) {
                if (childBillB == null) continue;
                long writeOffPeriodB = childBillB.getLong("writeoffperiod");
                BigDecimal oldActualCostB = childBillB.getBigDecimal("entry.actualcost");
                BigDecimal totalActualCostA = BigDecimal.ZERO;
                for (DynamicObject childBillA : childBillAList) {
                    long writeOffPeriodA = childBillA.getLong("writeoffperiod");
                    if (writeOffPeriodA > writeOffPeriodB) continue;
                    totalActualCostA = totalActualCostA.add(childBillA.getBigDecimal("entry.actualcost"));
                }
                BigDecimal actualCostB = fatherActualcost.subtract(totalActualCostA);
                BigDecimal baseQtyB = childBillB.getBigDecimal("entry.baseqty");
                BigDecimal feeB = childBillB.getBigDecimal("entry.fee");
                BigDecimal processcostB = childBillB.getBigDecimal("entry.processcost");
                BigDecimal resourceB = childBillB.getBigDecimal("entry.resource");
                BigDecimal manufactureCostB = childBillB.getBigDecimal("entry.manufacturecost");
                BigDecimal materialCostB = actualCostB.subtract(feeB).subtract(processcostB).subtract(resourceB).subtract(manufactureCostB);
                BigDecimal unitMaterialCostB = BigDecimal.ZERO;
                unitMaterialCostB = feeB.compareTo(BigDecimal.ZERO) == 0 && processcostB.compareTo(BigDecimal.ZERO) == 0 && resourceB.compareTo(BigDecimal.ZERO) == 0 && manufactureCostB.compareTo(BigDecimal.ZERO) == 0 ? fatherUnitactualcost : materialCostB.divide(baseQtyB, pricePrecision, 4);
                if (CostSrcEnum.EXPBILL.getValue().equals(isExpOption)) {
                    this.paramList.add(new Object[]{actualCostB, fatherUnitactualcost, materialCostB, unitMaterialCostB, CostSrcEnum.EXPBILL.getValue(), childBillB.get("entry.id")});
                } else {
                    this.paramList.add(new Object[]{actualCostB, fatherUnitactualcost, materialCostB, unitMaterialCostB, childBillB.get("entry.id")});
                }
                this.costDetailParamList.add(new Object[]{actualCostB.subtract(oldActualCostB), childBillB.get("entry.id"), elementId});
                this.childEntryIdSet.add(childBillB.getLong("entry.id"));
                childBillB.set("entry.actualcost", (Object)actualCostB);
                childBillB.set("entry.unitactualcost", (Object)fatherUnitactualcost);
                childBillB.set("entry.materialcost", (Object)materialCostB);
                childBillB.set("entry.unitmaterialcost", (Object)unitMaterialCostB);
            }
        }
    }

    private List<CostRecordChildNode> buildTrees(List<Long> entryIdSet) {
        QFilter q = new QFilter("entry.ancestorentryid", "in", entryIdSet);
        HashMap<Long, ArrayList<DynamicObject>> treeMap = new HashMap<Long, ArrayList<DynamicObject>>();
        ArrayList<CostRecordChildNode> nodeList = new ArrayList<CostRecordChildNode>(16);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"writeoffendperiod,costaccount.costtype,writeoffperiod,writeoffstatus,ischargeoff,ischargeoffed,localcurrency.amtprecision,entry.fatherentryid,entry.ancestorentryid,entry.material,entry.id,entry.fee,entry.resource,entry.actualcost,entry.unitactualcost,entry.manufacturecost,entry.processcost,entry.baseqty,entry.materialcost,entry.unitmaterialcost,entry.costpricesource as costpricesource", (QFilter[])q.toArray());
        for (DynamicObject info : coll) {
            long ancestorentryid = info.getLong("entry.ancestorentryid");
            ArrayList<DynamicObject> billList = (ArrayList<DynamicObject>)treeMap.get(ancestorentryid);
            if (billList != null) {
                billList.add(info);
                continue;
            }
            billList = new ArrayList<DynamicObject>();
            billList.add(info);
            treeMap.put(ancestorentryid, billList);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            CostRecordChildNode rootNode = new CostRecordChildNode();
            long ancestorentryid = (Long)entry.getKey();
            List list = (List)entry.getValue();
            for (DynamicObject bill : list) {
                if (bill.getLong("entry.id") == ancestorentryid) {
                    rootNode.setBill(bill);
                    continue;
                }
                if ("A".equals(bill.getString("writeoffstatus"))) {
                    rootNode.addBillA(bill);
                    continue;
                }
                if (!"B".equals(bill.getString("writeoffstatus"))) continue;
                rootNode.addBillB(bill);
            }
            nodeList.add(rootNode);
        }
        return nodeList;
    }

    private String getCostRecordDetailSql() {
        return " update t_cal_costrecord_detail set factualcost = factualcost + ? where fentryid = ? and fcostsubelementid = ?";
    }

    private String getUpdateSql(boolean isExpOption) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cal_calcostrecordentry set ");
        sql.append(" factualcost = ? ,funitactualcost = ?, ");
        sql.append(" fmaterialcost = ?,funitmaterialcost= ? ");
        if (isExpOption) {
            sql.append(" ,fcostsrc = ?");
        }
        sql.append(" where fentryid = ?");
        return sql.toString();
    }

    private void caculateDetailUnitActual(Set<Long> entryIdSet) {
        DynamicObject[] costDetailArray = BusinessDataServiceHelper.load((String)"cal_costrecord_detail", (String)"id,entryid,costsubelement,actualcost,unitactualcost,costsubelement.id,baseqty,standardcost,unitstandardcost,currency.priceprecision", (QFilter[])new QFilter("entryid", "in", entryIdSet).toArray());
        if (costDetailArray != null && costDetailArray.length > 0) {
            for (DynamicObject costDetail : costDetailArray) {
                BigDecimal actualcost = costDetail.getBigDecimal("actualcost");
                BigDecimal baseqty = costDetail.getBigDecimal("baseqty");
                if (baseqty.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal unitActualcost = actualcost.divide(baseqty, 10, 4);
                costDetail.set("unitactualcost", (Object)unitActualcost);
            }
            SaveServiceHelper.save((DynamicObject[])costDetailArray);
        }
    }
}

