/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class CommonSettingHelper {
    public static final long ID = 683799445774680063L;

    public static DynamicObject[] getExpenseBillType() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection col = setting.getDynamicObjectCollection("expensebilltype");
        DynamicObject[] billtypes = new DynamicObject[col.size()];
        for (int i = 0; i < billtypes.length; ++i) {
            DynamicObject billTypeDyc = ((DynamicObject)col.get(i)).getDynamicObject("fbasedataid");
            if (billTypeDyc == null) continue;
            billtypes[i] = billTypeDyc;
        }
        return billtypes;
    }

    public static Object[] getZeroInOutBizTypeIds() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection col = setting.getDynamicObjectCollection("zeroinoutbiztype");
        Object[] billtypes = new Object[col.size()];
        for (int i = 0; i < billtypes.length; ++i) {
            DynamicObject bizDyc = ((DynamicObject)col.get(i)).getDynamicObject("fbasedataid");
            if (bizDyc == null) continue;
            billtypes[i] = bizDyc.getPkValue();
        }
        return billtypes;
    }

    public static Object[] getExpenseBillTypeIDs() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection col = setting.getDynamicObjectCollection("expensebilltype");
        Object[] billtypes = new Object[col.size()];
        for (int i = 0; i < billtypes.length; ++i) {
            DynamicObject bizDyc = ((DynamicObject)col.get(i)).getDynamicObject("fbasedataid");
            if (bizDyc == null) continue;
            billtypes[i] = bizDyc.getPkValue();
        }
        return billtypes;
    }

    public static String[] getEstimatestandards() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        String standards = setting.getString("esstandards");
        standards = standards.substring(1, standards.length() - 1);
        return standards.split(",");
    }

    public static DynamicObject getEsCurrency() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        return setting.getDynamicObject("escurrency");
    }

    public static String[] getDivideBasis() {
        String divideBasisStr = CommonSettingHelper.getDivideBasisStr();
        return divideBasisStr.split(",");
    }

    public static String getDivideBasisStr() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        String divideBasisStr = setting.getString("dividebasiscols");
        if (divideBasisStr.startsWith(",")) {
            divideBasisStr = divideBasisStr.substring(1, divideBasisStr.length());
        }
        if (divideBasisStr.endsWith(",")) {
            divideBasisStr = divideBasisStr.substring(0, divideBasisStr.length() - 1);
        }
        return divideBasisStr;
    }

    public static String getCalDimensionStr() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        String calDimensionStr = setting.getString("caldimensioncols");
        if (calDimensionStr.startsWith(",")) {
            calDimensionStr = calDimensionStr.substring(1, calDimensionStr.length());
        }
        if (calDimensionStr.endsWith(",")) {
            calDimensionStr = calDimensionStr.substring(0, calDimensionStr.length() - 1);
        }
        return calDimensionStr;
    }

    public static String[] getCalDimension() {
        String calDimensionStr = CommonSettingHelper.getCalDimensionStr();
        return calDimensionStr.split(",");
    }

    public static String[] getGroupCol() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        String calgroupcols = setting.getString("calgroupcols");
        String[] cur = null;
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)calgroupcols)) {
            String[] splits;
            for (String split : splits = calgroupcols.split(",")) {
                if (StringUtils.isEmpty((String)split)) continue;
                list.add(split);
            }
            cur = list.toArray(new String[0]);
        }
        return cur;
    }

    public static DynamicObject getSettingObj() {
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((Object)683799445774680063L, (String)"cal_setting");
        return setting;
    }

    public static Set<String> getBizEntityNumbers(String entryName) {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection biztypes = setting.getDynamicObjectCollection(entryName);
        HashSet<String> numbers = new HashSet<String>();
        for (DynamicObject biztype : biztypes) {
            DynamicObject bizTypeDyc = biztype.getDynamicObject("fbasedataid");
            if (bizTypeDyc == null) continue;
            numbers.add(bizTypeDyc.getString("number"));
        }
        return numbers;
    }

    public static Set<String> getExFieldSet() {
        HashSet<String> exFieldSet = new HashSet<String>();
        QFilter filter = new QFilter("sourcebill.number", "=", (Object)"im_purinbill");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection purRules = QueryServiceHelper.query((String)"cal_calbillrule", (String)"id,fieldmap.calfield,fieldmap.isextendfield", (QFilter[])filter.toArray(), null);
        for (DynamicObject rule : purRules) {
            if (!rule.getBoolean("fieldmap.isextendfield")) continue;
            exFieldSet.add(rule.getString("fieldmap.calfield"));
        }
        return exFieldSet;
    }

    public static void setExFieldValue(Set<String> exFieldSet, MainEntityType destEntiyType, MainEntityType srcEntityType, DynamicObject destInfo, DynamicObject srcInfo) {
        if (exFieldSet != null && !exFieldSet.isEmpty()) {
            for (String exField : exFieldSet) {
                IDataEntityProperty srcProperty = srcEntityType.findProperty(exField);
                IDataEntityProperty destProperty = destEntiyType.findProperty(exField);
                if (srcProperty == null || destProperty == null) continue;
                if (srcProperty instanceof BasedataProp) {
                    destInfo.set(exField, srcInfo.get(exField + "_id"));
                    continue;
                }
                destInfo.set(exField, srcInfo.get(exField));
            }
        }
    }

    public static void setExFieldValue(MainEntityType destEntiyType, MainEntityType srcEntityType, DynamicObject destInfo, DynamicObject srcInfo) {
        Set<String> exFieldSet = CommonSettingHelper.getExFieldSet();
        CommonSettingHelper.setExFieldValue(exFieldSet, destEntiyType, srcEntityType, destInfo, srcInfo);
    }

    public static DynamicObject getCostAdjustOutBillType() {
        return CommonSettingHelper.getBillType("caloutbilltypes", "im_SalOutBill_STD_BT_S");
    }

    public static DynamicObject getCostAdjustInBillType() {
        return CommonSettingHelper.getBillType("calinbilltypes", "im_PurInBill_STD_BT_S");
    }

    private static DynamicObject getBillType(String billTypeName, String defaultBillTypeNum) {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection billTypes = setting.getDynamicObjectCollection(billTypeName);
        DynamicObject[] defaultBillTypes = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"billtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)defaultBillTypeNum)});
        DynamicObject defaultBillType = null;
        if (defaultBillTypes != null && defaultBillTypes.length > 0) {
            defaultBillType = defaultBillTypes[0];
        }
        boolean isContain = false;
        if (billTypes.size() >= 1) {
            for (DynamicObject billtype : billTypes) {
                DynamicObject bizTypeDyc = billtype.getDynamicObject("fbasedataid");
                if (bizTypeDyc == null || defaultBillType == null || !defaultBillType.getString("id").equals(bizTypeDyc.getString("id"))) continue;
                isContain = true;
                break;
            }
            if (isContain) {
                return defaultBillType;
            }
            DynamicObject billTypeDyc = (DynamicObject)billTypes.get(0);
            if (billTypeDyc == null) {
                return null;
            }
            return billTypeDyc.getDynamicObject("fbasedataid");
        }
        return null;
    }

    public static Set<Long> getNotUpdBalBizType() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection bizTypeColl = setting.getDynamicObjectCollection("notupdatebalance");
        HashSet<Long> bizTypeIdSet = new HashSet<Long>(bizTypeColl.size());
        for (DynamicObject bizType : bizTypeColl) {
            DynamicObject bizTypeDyc = bizType.getDynamicObject("fbasedataid");
            if (bizTypeDyc == null) continue;
            bizTypeIdSet.add(bizTypeDyc.getLong("id"));
        }
        return bizTypeIdSet;
    }

    public static Boolean isUseNewPlan() {
        DynamicObject settingObj = CommonSettingHelper.getSettingObj();
        return settingObj.getBoolean("usenewplan");
    }

    public static Set<String> getCheckObject() {
        DynamicObject setting = CommonSettingHelper.getSettingObj();
        DynamicObjectCollection checkobjects = setting.getDynamicObjectCollection("checkobject");
        HashSet<String> objectIdSet = new HashSet<String>(checkobjects.size());
        for (DynamicObject object : checkobjects) {
            DynamicObject checkDyc = object.getDynamicObject("fbasedataid");
            if (checkDyc == null) continue;
            objectIdSet.add(checkDyc.getString("id"));
        }
        return objectIdSet;
    }
}

