/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.AccountType4CostAdjustHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class CostAdjustBillOpHelper {
    Set<Long> needHandlePeriodInfoIds = new HashSet<Long>(16);
    Set<DynamicObject> needHandleCalRangeInfos = new HashSet<DynamicObject>(16);
    Map<Long, Set<DynamicObject>> costAccount2PeriodMap = new HashMap<Long, Set<DynamicObject>>();

    public CostAdjustBillOpHelper(DynamicObject[] costAdjustInfos) {
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        Date minDate = null;
        Date maxDate = null;
        for (DynamicObject info : costAdjustInfos) {
            Long id = info.getLong("id");
            DynamicObject costAccount = info.getDynamicObject("costaccount");
            Date bookDate = info.getDate("bookdate");
            this.needHandlePeriodInfoIds.add(id);
            costAccountIds.add(costAccount.getLong("id"));
            if (minDate == null || minDate.after(bookDate)) {
                minDate = bookDate;
            }
            if (maxDate == null || maxDate.before(bookDate)) {
                maxDate = bookDate;
            }
            this.needHandleCalRangeInfos.add(info);
        }
        this.cacheCostAccount2PeriodMap(minDate, maxDate, costAccountIds);
    }

    public void handleBillPeriod(DynamicObject[] costAdjustInfos) {
        if (this.needHandlePeriodInfoIds.isEmpty()) {
            return;
        }
        for (DynamicObject info : costAdjustInfos) {
            Long id = info.getLong("id");
            if (!this.needHandlePeriodInfoIds.contains(id)) continue;
            DynamicObject costAccount = info.getDynamicObject("costaccount");
            Date bookDate = info.getDate("bookdate");
            Long costAccountId = costAccount.getLong("id");
            info.set("period", (Object)this.getPeriodFromCostaccountBizdate(costAccountId, bookDate, this.costAccount2PeriodMap));
        }
    }

    public void handleBillCalRange(DynamicObject[] costAdjustInfos) {
        if (this.needHandleCalRangeInfos.isEmpty()) {
            return;
        }
        new AccountType4CostAdjustHelper(this.needHandleCalRangeInfos.toArray(new DynamicObject[0])).handleCalRangeAccountType();
    }

    private Long getPeriodFromCostaccountBizdate(Long costAccountId, Date bookDate, Map<Long, Set<DynamicObject>> costAccount2PeriodMap) {
        DynamicObject period;
        Set<DynamicObject> periods = costAccount2PeriodMap.get(costAccountId);
        Long periodId = 0L;
        if (periods == null) {
            periods = new HashSet<DynamicObject>(16);
            costAccount2PeriodMap.put(costAccountId, periods);
            period = PeriodHelper.getPeriodByDate(bookDate, costAccountId);
            periods.add(period);
            periodId = period.getLong("id");
        } else {
            for (DynamicObject period2 : periods) {
                Long begintime = period2.getDate("begindate").getTime();
                Long endtime = period2.getDate("enddate").getTime();
                Long biztime = bookDate.getTime();
                if (begintime.compareTo(biztime) > 0 || endtime.compareTo(biztime) < 0) continue;
                periodId = period2.getLong("id");
            }
        }
        if (periodId == 0L) {
            period = PeriodHelper.getPeriodByDate(bookDate, costAccountId);
            periods.add(period);
            periodId = period.getLong("id");
        }
        return periodId;
    }

    private void cacheCostAccount2PeriodMap(Date minDate, Date maxDate, Set<Long> costAccountIds) {
        if (costAccountIds.isEmpty()) {
            return;
        }
        QFilter caFilter = new QFilter("id", "in", costAccountIds);
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calpolicy.periodtype", (QFilter[])caFilter.toArray(), null);
        HashMap<Long, Long> periodType2costaccountMap = new HashMap<Long, Long>(costAccountIds.size());
        for (DynamicObject costAccount : costAccounts) {
            Long costAccountId = costAccount.getLong("id");
            Long periodType = costAccount.getLong("calpolicy.periodtype");
            periodType2costaccountMap.put(periodType, costAccountId);
        }
        QFilter periodFilter = new QFilter("periodtype", "in", periodType2costaccountMap.keySet());
        periodFilter.and("begindate", "<=", (Object)maxDate);
        periodFilter.and("enddate", ">=", (Object)minDate);
        periodFilter.and("isadjustperiod", "=", (Object)Character.valueOf('0'));
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,periodtype,begindate,enddate", (QFilter[])periodFilter.toArray());
        for (DynamicObject period : periods) {
            Long periodtype = period.getLong("periodtype");
            Long costaccount = (Long)periodType2costaccountMap.get(periodtype);
            Set<DynamicObject> ca2periods = this.costAccount2PeriodMap.get(costaccount);
            if (ca2periods == null) {
                ca2periods = new HashSet<DynamicObject>();
                this.costAccount2PeriodMap.put(costaccount, ca2periods);
            }
            ca2periods.add(period);
        }
    }
}

