/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CostDomainKeyHelper {
    public static final String CAL_DIMENSION_VALUE = "calDimensionValue";
    public static final String CALRANGE = "calrange";
    public static final String COSTACCOUNT = "costaccount";
    public static final String DIVIDE_BASIS_VALUE = "divideBasisValue";
    public static final String MATERIAL = "material";
    private static Log log = LogFactory.getLog(CostDomainKeyHelper.class);
    private List<String> costDomainList = Arrays.asList("calDimensionValue", "calrange", "costaccount", "divideBasisValue", "material");
    private Map<String, Object> map = new HashMap<String, Object>(8);

    public List<String> getCostDomainList() {
        return this.costDomainList;
    }

    public void setCalDimensionValue(String calDimensionValue) {
        this.map.put(CAL_DIMENSION_VALUE, calDimensionValue);
    }

    public void setCalrange(Long calrange) {
        this.map.put(CALRANGE, calrange);
    }

    public void setCostaccount(Long costaccount) {
        this.map.put(COSTACCOUNT, costaccount);
    }

    public void setDivideBasisValue(String divideBasisValue) {
        this.map.put(DIVIDE_BASIS_VALUE, divideBasisValue);
    }

    public void setMaterial(Long material) {
        this.map.put(MATERIAL, material);
    }

    public CostDomainKeyHelper() {
        this.costDomainList.sort(Comparator.naturalOrder());
    }

    public String getCostDomainDimsionKey() {
        StringBuilder dimensionStr = new StringBuilder();
        for (String field : this.costDomainList) {
            Object value = this.map.get(field);
            if (value == null || "".equals(value)) {
                value = "#";
            }
            dimensionStr.append(value);
            dimensionStr.append("_");
        }
        String domainId = CostDomainKeyHelper.getSHA256Base64Str(dimensionStr.toString());
        this.map.clear();
        return domainId;
    }

    private static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException(String.format("getSHA256Base64Str:[%s] args:[%s]", e.getMessage(), message));
        }
    }
}

