/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostPriceSourceTypeEnum;
import kd.fi.cal.common.helper.JSONDataHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.common.util.CommonUtils;

public class CostElementHelper {
    private static Log log = LogFactory.getLog(CostElementHelper.class);
    private static final int BATCH_SIZE = 100000;
    private static final String DEFAULT_MATSUBELEMENT = "default_matsubelement";
    private static final String CAL_BALANCE_ENABLECALBYELEMENTCOSTACCOUNTIDS = "cal_balance_enablecalbyelementcostaccountids";

    public static void calCostRecordMaterialCost(Long[] entryIds, Set<Long> idSet) {
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, idSet)});){
            ctx.set();
            CostElementHelper.calCostRecordMaterialCost(entryIds);
        }
    }

    public static void calCostRecordMaterialCost(Long[] entryIds) {
        String sql = "update t_cal_calcostrecordentry set funitmaterialcost = ?,fmaterialcost = ? where fentryid = ? ";
        int pricePrecision = 10;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_costrecord", (String)"entry.id,entry.baseqty,entry.actualcost,entry.unitactualcost,entry.fee,entry.processcost,entry.manufacturecost,entry.resource,entry.materialcost,entry.unitmaterialcost", (QFilter[])new QFilter("entry.id", "in", (Object)entryIds).toArray(), null);){
            for (Row row : dataSet) {
                long entryId = row.getLong("entry.id");
                BigDecimal oldMaterialCost = row.getBigDecimal("entry.materialcost");
                BigDecimal oldUnitMaterialCost = row.getBigDecimal("entry.unitmaterialcost");
                BigDecimal actualcost = row.getBigDecimal("entry.actualcost");
                BigDecimal unitActualCost = row.getBigDecimal("entry.unitactualcost");
                BigDecimal fee = row.getBigDecimal("entry.fee");
                BigDecimal processcost = row.getBigDecimal("entry.processcost");
                BigDecimal manufacturecost = row.getBigDecimal("entry.manufacturecost");
                BigDecimal resource = row.getBigDecimal("entry.resource");
                BigDecimal materialcost = actualcost.subtract(fee).subtract(processcost).subtract(manufacturecost).subtract(resource);
                BigDecimal unitMaterialcost = BigDecimal.ZERO;
                if (materialcost.compareTo(actualcost) == 0) {
                    unitMaterialcost = unitActualCost;
                } else {
                    BigDecimal baseqty = row.getBigDecimal("entry.baseqty");
                    unitMaterialcost = materialcost.divide(baseqty, pricePrecision, 4);
                }
                if (materialcost.compareTo(oldMaterialCost) == 0 && unitMaterialcost.compareTo(oldUnitMaterialCost) == 0) continue;
                paramList.add(new Object[]{unitMaterialcost, materialcost, entryId});
            }
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
        }
    }

    public static void calCostRecordProcessCost(Long[] entryIds) {
        String sql = "update t_cal_calcostrecordentry set funitprocesscost = ?,fprocesscost = ? where fentryid = ? ";
        int pricePrecision = 10;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_costrecord", (String)"entry.id,entry.baseqty,entry.actualcost,entry.unitactualcost,entry.fee,entry.processcost,entry.manufacturecost,entry.resource,entry.materialcost", (QFilter[])new QFilter("entry.id", "in", (Object)entryIds).toArray(), null);){
            for (Row row : dataSet) {
                long entryId = row.getLong("entry.id");
                BigDecimal oldProcessCost = row.getBigDecimal("entry.processcost");
                BigDecimal actualcost = row.getBigDecimal("entry.actualcost");
                BigDecimal unitActualCost = row.getBigDecimal("entry.unitactualcost");
                BigDecimal fee = row.getBigDecimal("entry.fee");
                BigDecimal materialcost = row.getBigDecimal("entry.materialcost");
                BigDecimal manufacturecost = row.getBigDecimal("entry.manufacturecost");
                BigDecimal resource = row.getBigDecimal("entry.resource");
                BigDecimal processCost = actualcost.subtract(fee).subtract(materialcost).subtract(manufacturecost).subtract(resource);
                if (processCost.compareTo(oldProcessCost) == 0) continue;
                BigDecimal unitProcessCost = BigDecimal.ZERO;
                if (processCost.compareTo(actualcost) == 0) {
                    unitProcessCost = unitActualCost;
                } else {
                    BigDecimal baseqty = row.getBigDecimal("entry.baseqty");
                    unitProcessCost = processCost.divide(baseqty, pricePrecision, 4);
                }
                paramList.add(new Object[]{unitProcessCost, processCost, entryId});
            }
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
        }
    }

    public static void calCostRecordCost(Long[] entryIds, Set<Long> ids) {
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, ids)});){
            ctx.set();
            CostElementHelper.calCostRecordCost(entryIds);
        }
    }

    public static void calCostRecordCost(Long[] entryIds) {
        String sql = "update t_cal_calcostrecordentry set funitactualcost = ?,factualcost = ?,funitstandardcost = ?,fstandardcost = ?  where fentryid = ?";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_costrecord_detail", (String)"entryid,standardcost,actualcost,unitstandardcost,unitactualcost", (QFilter[])new QFilter("entryid", "in", (Object)entryIds).toArray(), null);
             DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_costrecord", (String)"localcurrency.priceprecision,entry.id,entry.baseqty,entry.costpricesource as costpricesource", (QFilter[])new QFilter("entry.id", "in", (Object)entryIds).toArray(), null);
             DataSet groupDataSet = dataSet.groupBy(new String[]{"entryid"}).sum("standardcost").sum("actualcost").sum("unitstandardcost").sum("unitactualcost").finish();){
            HashMap<Long, BigDecimal> standardMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> actualMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> unitStandardMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> unitActualMap = new HashMap<Long, BigDecimal>();
            for (Row row : groupDataSet) {
                standardMap.put(row.getLong("entryid"), row.getBigDecimal("standardcost"));
                actualMap.put(row.getLong("entryid"), row.getBigDecimal("actualcost"));
                unitStandardMap.put(row.getLong("entryid"), row.getBigDecimal("unitstandardcost"));
                unitActualMap.put(row.getLong("entryid"), row.getBigDecimal("unitactualcost"));
            }
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (Row row : costRecordDataSet) {
                long entryId = row.getLong("entry.id");
                BigDecimal standardcost = (BigDecimal)standardMap.get(entryId);
                BigDecimal actualcost = (BigDecimal)actualMap.get(entryId);
                BigDecimal unitStandardCost = (BigDecimal)unitStandardMap.get(entryId);
                BigDecimal unitActualCost = (BigDecimal)unitActualMap.get(entryId);
                paramList.add(new Object[]{unitActualCost, actualcost, unitStandardCost, standardcost, entryId});
            }
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
        }
    }

    public static void calCostRecordAllCost(Long[] entryIds, Set<Long> ids) {
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, ids)});){
            ctx.set();
            CostElementHelper.calCostRecordAllCost(entryIds);
        }
    }

    public static void calCostRecordAllCost(Long[] entryIds) {
        String sql = "update t_cal_calcostrecordentry set funitactualcost = ?,factualcost = ?,funitstandardcost = ?,fstandardcost = ?,funitmaterialcost = ?,fmaterialcost = ?,funitfee = ?,ffee = ?,funitprocesscost = ?,fprocesscost = ? where fentryid = ?";
        String sql_a = "update t_cal_calcostrecordentry set funitmanufacturecost = ?,fmanufacturecost = ?,funitresource = ?,fresource = ? where fentryid = ?";
        String sql1 = "update t_cal_calcostrecordentry set funitactualcost = ?,factualcost = ?,funitstandardcost = ?,fstandardcost = ?,funitmaterialcost = ?,fmaterialcost = ? where fentryid = ?";
        String unitStandardCost2ActualCostSql = "update t_cal_calcostrecordentry set funitactualcost = funitstandardcost where factualcost <> 0 and factualcost = fstandardcost and fid in ";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_costrecord_detail", (String)"entryid,standardcost,actualcost,unitstandardcost,unitactualcost,costsubelement.type", (QFilter[])new QFilter("entryid", "in", (Object)entryIds).toArray(), null);
             DataSet groupDataSet = dataSet.copy().groupBy(new String[]{"entryid"}).sum("standardcost").sum("actualcost").sum("unitstandardcost").sum("unitactualcost").finish();
             DataSet groupElementDataSet = dataSet.groupBy(new String[]{"entryid", "costsubelement.type"}).sum("standardcost").sum("actualcost").sum("unitstandardcost").sum("unitactualcost").finish();
             DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_costrecord", (String)"id,localcurrency.priceprecision,entry.id,entry.baseqty", (QFilter[])new QFilter("entry.id", "in", (Object)entryIds).toArray(), null);){
            HashMap<Long, BigDecimal> standardMap = new HashMap<Long, BigDecimal>();
            HashMap<Object, BigDecimal> actualMap = new HashMap<Object, BigDecimal>();
            HashMap<Long, BigDecimal> unitStandardMap = new HashMap<Long, BigDecimal>();
            HashMap<Object, BigDecimal> unitActualMap = new HashMap<Object, BigDecimal>();
            HashSet<String> billids = new HashSet<String>(16);
            for (Row row : groupDataSet) {
                standardMap.put(row.getLong("entryid"), row.getBigDecimal("standardcost"));
                unitStandardMap.put(row.getLong("entryid"), row.getBigDecimal("unitstandardcost"));
                actualMap.put(row.getLong("entryid"), row.getBigDecimal("actualcost"));
                unitActualMap.put(row.getLong("entryid"), row.getBigDecimal("unitactualcost"));
            }
            for (Row row : groupElementDataSet) {
                actualMap.put(row.getLong("entryid") + "|" + row.getString("costsubelement.type"), row.getBigDecimal("actualcost"));
                unitActualMap.put(row.getLong("entryid") + "|" + row.getString("costsubelement.type"), row.getBigDecimal("unitactualcost"));
            }
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            ArrayList<Object[]> paramList_a = new ArrayList<Object[]>();
            ArrayList<Object[]> paramList1 = new ArrayList<Object[]>();
            for (Row row : costRecordDataSet) {
                String billid = row.getString("id");
                billids.add(billid);
                long entryId = row.getLong("entry.id");
                BigDecimal standardCost = (BigDecimal)standardMap.get(entryId);
                BigDecimal actualCost = (BigDecimal)actualMap.get(entryId);
                BigDecimal materialCost = (BigDecimal)actualMap.get(entryId + "|001");
                BigDecimal unitStandardCost = (BigDecimal)unitStandardMap.get(entryId);
                BigDecimal unitActualCost = (BigDecimal)unitActualMap.get(entryId);
                BigDecimal unitMaterialCost = (BigDecimal)unitActualMap.get(entryId + "|001");
                if (actualMap.containsKey(entryId + "|002")) {
                    BigDecimal fee = (BigDecimal)actualMap.get(entryId + "|002");
                    BigDecimal manufactureCost = (BigDecimal)actualMap.get(entryId + "|003");
                    BigDecimal resource = (BigDecimal)actualMap.get(entryId + "|004");
                    BigDecimal processCost = (BigDecimal)actualMap.get(entryId + "|005");
                    BigDecimal unitFee = (BigDecimal)unitActualMap.get(entryId + "|002");
                    BigDecimal unitManufactureCost = (BigDecimal)unitActualMap.get(entryId + "|003");
                    BigDecimal unitResource = (BigDecimal)unitActualMap.get(entryId + "|004");
                    BigDecimal unitProcessCost = (BigDecimal)unitActualMap.get(entryId + "|005");
                    paramList.add(new Object[]{unitActualCost, actualCost, unitStandardCost, standardCost, unitMaterialCost, materialCost, unitFee, fee, unitProcessCost, processCost, entryId});
                    paramList_a.add(new Object[]{unitManufactureCost, manufactureCost, unitResource, resource, entryId});
                    continue;
                }
                paramList1.add(new Object[]{unitActualCost, actualCost, unitStandardCost, standardCost, unitMaterialCost, materialCost, entryId});
            }
            if (!paramList.isEmpty()) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql_a, paramList_a);
            }
            if (!paramList1.isEmpty()) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql1, paramList1);
            }
            if (!billids.isEmpty()) {
                DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)(unitStandardCost2ActualCostSql + "(" + String.join((CharSequence)",", billids) + ")"));
            }
        }
    }

    public static void calCostRecordAllCost(DynamicObject[] costRecDycs, Map<Long, Boolean> calByCostElementMap, Map<Long, String> subElesTypeMap) {
        int pricePrecision = 10;
        for (DynamicObject cosRecDyc : costRecDycs) {
            long costAccountId = cosRecDyc.getLong("costaccount_id");
            boolean calByCostElement = calByCostElementMap.get(costAccountId);
            for (DynamicObject entryDyc : cosRecDyc.getDynamicObjectCollection("entry")) {
                BigDecimal stdCost = BigDecimal.ZERO;
                BigDecimal actCost = BigDecimal.ZERO;
                BigDecimal matCost = BigDecimal.ZERO;
                BigDecimal fee = BigDecimal.ZERO;
                BigDecimal manufactureCost = BigDecimal.ZERO;
                BigDecimal resource = BigDecimal.ZERO;
                BigDecimal processCost = BigDecimal.ZERO;
                BigDecimal unitStdCostAll = BigDecimal.ZERO;
                BigDecimal unitActCostAll = BigDecimal.ZERO;
                BigDecimal unitMatCostAll = BigDecimal.ZERO;
                BigDecimal unitFeeAll = BigDecimal.ZERO;
                BigDecimal unitManufactureCostAll = BigDecimal.ZERO;
                BigDecimal unitResourceAll = BigDecimal.ZERO;
                BigDecimal unitProcessCostAll = BigDecimal.ZERO;
                BigDecimal baseQty = entryDyc.getBigDecimal("baseqty");
                for (DynamicObject subEntryDyc : entryDyc.getDynamicObjectCollection("subentrycostelement")) {
                    long subEle = subEntryDyc.getLong("costsubelement_id");
                    String subType = subElesTypeMap.get(subEle);
                    BigDecimal subStdCost = subEntryDyc.getBigDecimal("sub_standardcost");
                    BigDecimal subActCost = subEntryDyc.getBigDecimal("sub_actualcost");
                    BigDecimal unitSubStdCost = subEntryDyc.getBigDecimal("sub_unitstandardcost");
                    BigDecimal unitSubActCost = subEntryDyc.getBigDecimal("sub_unitactualcost");
                    if ("001".equals(subType)) {
                        matCost = matCost.add(subActCost);
                        unitMatCostAll = unitMatCostAll.add(unitSubActCost);
                    } else if ("002".equals(subType)) {
                        fee = fee.add(subActCost);
                        unitFeeAll = unitFeeAll.add(unitSubActCost);
                    } else if ("003".equals(subType)) {
                        manufactureCost = manufactureCost.add(subActCost);
                        unitManufactureCostAll = unitManufactureCostAll.add(unitSubActCost);
                    } else if ("004".equals(subType)) {
                        resource = resource.add(subActCost);
                        unitResourceAll = unitResourceAll.add(unitSubActCost);
                    } else if ("005".equals(subType)) {
                        processCost = processCost.add(subActCost);
                        unitProcessCostAll = unitProcessCostAll.add(unitSubActCost);
                    }
                    stdCost = stdCost.add(subStdCost);
                    actCost = actCost.add(subActCost);
                    unitStdCostAll = unitStdCostAll.add(unitSubStdCost);
                    unitActCostAll = unitActCostAll.add(unitSubActCost);
                }
                if (calByCostElement) {
                    entryDyc.set("fee", (Object)fee);
                    entryDyc.set("manufacturecost", (Object)manufactureCost);
                    entryDyc.set("resource", (Object)resource);
                    entryDyc.set("processcost", (Object)processCost);
                    entryDyc.set("unitfee", (Object)unitFeeAll);
                    entryDyc.set("unitmanufacturecost", (Object)unitManufactureCostAll);
                    entryDyc.set("unitresource", (Object)unitResourceAll);
                    entryDyc.set("unitprocesscost", (Object)unitProcessCostAll);
                } else {
                    fee = entryDyc.getBigDecimal("fee");
                    manufactureCost = entryDyc.getBigDecimal("manufacturecost");
                    resource = entryDyc.getBigDecimal("resource");
                    processCost = entryDyc.getBigDecimal("processcost");
                }
                BigDecimal oldMatCost = matCost;
                BigDecimal oldUnitMatCost = unitMatCostAll;
                entryDyc.set("actualcost", (Object)actCost);
                entryDyc.set("materialcost", (Object)matCost);
                entryDyc.set("standardcost", (Object)stdCost);
                entryDyc.set("unitactualcost", (Object)unitActCostAll);
                BigDecimal oldUnitMat = unitMatCostAll;
                if (matCost.compareTo(actCost) == 0) {
                    oldUnitMat = unitActCostAll;
                }
                entryDyc.set("unitmaterialcost", (Object)oldUnitMat);
                matCost = actCost.subtract(fee).subtract(processCost).subtract(manufactureCost).subtract(resource);
                BigDecimal unitMat = matCost.divide(baseQty, pricePrecision, 4);
                if (matCost.compareTo(actCost) == 0) {
                    unitMat = unitActCostAll;
                }
                if (matCost.compareTo(oldMatCost) != 0 || unitMat.compareTo(oldUnitMatCost) != 0) {
                    entryDyc.set("unitmaterialcost", (Object)unitMat);
                    entryDyc.set("materialcost", (Object)matCost);
                }
                entryDyc.set("unitstandardcost", (Object)unitStdCostAll);
                BigDecimal unitStdCost = entryDyc.getBigDecimal("unitstandardcost");
                if (actCost.compareTo(stdCost) != 0 || unitStdCost.compareTo(BigDecimal.ZERO) == 0) continue;
                entryDyc.set("unitactualcost", (Object)unitStdCost);
            }
        }
    }

    public static void calCostAdjustCost(Long[] entryIds) {
        String sql = "update t_cal_costadjustbillentry set fadjustamt = ? where fentryid = ?";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_costadjust_detail", (String)"entryid,adjustamt", (QFilter[])new QFilter("entryid", "in", (Object)entryIds).toArray(), null);
             DataSet groupDataSet = dataSet.groupBy(new String[]{"entryid"}).sum("adjustamt").finish();){
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (Row row : groupDataSet) {
                long entryId = row.getLong("entryid");
                BigDecimal adjustAmt = row.getBigDecimal("adjustamt");
                paramList.add(new Object[]{adjustAmt, entryId});
            }
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
        }
    }

    public static Map<String, Long[]> getCostElementsByMaterial(Long[] costTypeIds, Long[] materialIds) {
        if (costTypeIds == null || costTypeIds.length == 0) {
            costTypeIds = new Long[]{0L};
        }
        HashMap<String, Long[]> map = new HashMap<String, Long[]>();
        Long[] elements = CostElementHelper.getDefaultMaterialElements();
        Long[] longArray = materialIds;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long materialId = longArray[i];
            Long[] longArray2 = costTypeIds;
            int n2 = longArray2.length;
            for (int j = 0; j < n2; ++j) {
                long costTypeId = longArray2[j];
                map.put(costTypeId + "|" + materialId, elements);
            }
        }
        QFilter q = new QFilter("costtype", "in", (Object)costTypeIds);
        q.and("material", "in", (Object)materialIds);
        DataSet dataSet = null;
        DataSet detailDataSet = null;
        DataSet joinDataSet = null;
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_subelement_material", (String)"id,subelement,costtype,material", (QFilter[])q.toArray(), null);
            detailDataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_elementdetail", (String)"id,element,subelement", null, null);
            joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("subelement", "subelement").select(new String[]{"costtype", "subelement", "material"}, new String[]{"element"}).finish();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return map;
        }
        for (Row row : joinDataSet) {
            long costTypeId = row.getLong("costtype");
            long materialId = row.getLong("material");
            long costElement = row.getLong("element");
            long costSubElement = row.getLong("subelement");
            if (costElement == 0L) {
                costElement = elements[1];
            }
            if (costSubElement == 0L) {
                costSubElement = elements[0];
            }
            map.put(costTypeId + "|" + materialId, new Long[]{costSubElement, costElement});
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Long[]> getCostElementsByMaterial(long calOrgId, Long[] costTypeIds, Long[] materialIds) {
        void var8_9;
        if (costTypeIds == null || costTypeIds.length == 0) {
            costTypeIds = new Long[]{0L};
        }
        HashMap<String, Long[]> map = new HashMap<String, Long[]>(16);
        Long[] elements = CostElementHelper.getDefaultMaterialElements();
        Long[] longArray = materialIds;
        int n = longArray.length;
        boolean i = false;
        while (var8_9 < n) {
            long materialId = longArray[var8_9];
            Long[] longArray2 = costTypeIds;
            int n2 = longArray2.length;
            for (int j = 0; j < n2; ++j) {
                long costTypeId = longArray2[j];
                map.put(costTypeId + "|" + materialId, elements);
            }
            ++var8_9;
        }
        Map matEleMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getSubElementByOrg", (Object[])new Object[]{calOrgId, new HashSet<Long>(Arrays.asList(materialIds)), TimeServiceHelper.now(), true});
        for (Long costTypeId : costTypeIds) {
            for (Map.Entry entry : matEleMap.entrySet()) {
                Long materialId = (Long)entry.getKey();
                Long costElement = ((Long[])entry.getValue())[0];
                Long costSubElement = ((Long[])entry.getValue())[1];
                map.put(costTypeId + "|" + materialId, new Long[]{costSubElement, costElement});
            }
        }
        for (Map.Entry entry : matEleMap.entrySet()) {
            Long materialId = (Long)entry.getKey();
            Long costElement = ((Long[])entry.getValue())[0];
            Long costSubElement = ((Long[])entry.getValue())[1];
            map.put("0|" + materialId, new Long[]{costSubElement, costElement});
        }
        return map;
    }

    public static Long[] getOneCostEleByMaterial(long costTypeId, long materialId) {
        Long[] elements = CostElementHelper.getDefaultMaterialElements();
        QFilter q = new QFilter("costtype", "=", (Object)costTypeId);
        q.and("material", "=", (Object)materialId);
        DataSet dataSet = null;
        DataSet detailDataSet = null;
        DataSet joinDataSet = null;
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_subelement_material", (String)"id,subelement", (QFilter[])q.toArray(), null);
            detailDataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_elementdetail", (String)"id,element,subelement", null, null);
            joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("subelement", "subelement").select(new String[]{"subelement"}, new String[]{"element"}).finish();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return elements;
        }
        for (Row row : joinDataSet) {
            long costElement = row.getLong("element");
            long costSubElement = row.getLong("subelement");
            if (costElement == 0L) {
                costElement = elements[1];
            }
            if (costSubElement == 0L) {
                costSubElement = elements[0];
            }
            elements = new Long[]{costSubElement, costElement};
        }
        return elements;
    }

    public static Long[] getOneCostEleByMaterial(long calOrgId, long costTypeId, long materialId) {
        Long[] elements = CostElementHelper.getDefaultMaterialElements();
        HashSet<Long> materialids = new HashSet<Long>(1);
        materialids.add(materialId);
        Map matEleMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getSubElementByOrg", (Object[])new Object[]{calOrgId, materialids, TimeServiceHelper.now(), true});
        for (Map.Entry e : matEleMap.entrySet()) {
            Long costElement = ((Long[])e.getValue())[0];
            Long costSubElement = ((Long[])e.getValue())[1];
            elements = new Long[]{costSubElement, costElement};
        }
        return elements;
    }

    public static Map<String, Long[]> getCostElementsByMaterial(DataSet costTypeMaterialSet) {
        HashMap<String, Long[]> map = new HashMap<String, Long[]>(16);
        HashSet<Long> costTypeSet = new HashSet<Long>(16);
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        long calOrgId = 0L;
        for (Row row : costTypeMaterialSet) {
            costTypeSet.add(row.getLong("costtype"));
            materialIdSet.add(row.getLong("material"));
            calOrgId = row.getLong("calorg");
        }
        Map matEleMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getSubElementByOrg", (Object[])new Object[]{calOrgId, materialIdSet, TimeServiceHelper.now(), true});
        for (Long l : costTypeSet) {
            for (Map.Entry e : matEleMap.entrySet()) {
                Long materialId = (Long)e.getKey();
                Long costElement = ((Long[])e.getValue())[0];
                Long costSubElement = ((Long[])e.getValue())[1];
                map.put(l + "|" + materialId, new Long[]{costSubElement, costElement});
            }
        }
        for (Map.Entry entry : matEleMap.entrySet()) {
            Long materialId = (Long)entry.getKey();
            Long costElement = ((Long[])entry.getValue())[0];
            Long costSubElement = ((Long[])entry.getValue())[1];
            map.put("0|" + materialId, new Long[]{costSubElement, costElement});
        }
        return map;
    }

    public static Long getDefalutMaterialId() {
        return CostElementHelper.getDefaultMaterialElements()[0];
    }

    public static void addCostRecElements(DynamicObject[] infos) {
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        HashMap<Long, Long> accountCostTypeMap = new HashMap<Long, Long>(16);
        String entryName = "entry";
        for (DynamicObject info : infos) {
            costAccountIds.add(info.getLong("costaccount_id"));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_bd_costaccount", (String)"id,costtype", (QFilter[])new QFilter("id", "in", costAccountIds).toArray(), null);){
            for (Row row : dataSet) {
                accountCostTypeMap.put(row.getLong("id"), row.getLong("costtype"));
            }
        }
        Map<String, Long[]> materialCostElementMap = CostElementHelper.getMaterialCostElement(infos);
        Map<Long, List<Long[]>> entryCostSubElementMap = CostElementHelper.cacheMaterialCostElements(infos, materialCostElementMap, accountCostTypeMap);
        for (DynamicObject info : infos) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection(entryName);
            for (DynamicObject entry : entrys) {
                entry.getDynamicObjectCollection("subentrycostelement").clear();
                long localCurrencyId = info.getLong("localcurrency_id");
                long materialId = entry.getLong("material_id");
                long baseUnitId = entry.getLong("baseunit_id");
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                long entryId = entry.getLong("id");
                List<Long[]> costElementSet = entryCostSubElementMap.get(entryId);
                int seq = 1;
                for (Long[] costElements : costElementSet) {
                    long costSubElement = costElements[0];
                    long costElement = costElements[1];
                    DynamicObject detail = entry.getDynamicObjectCollection("subentrycostelement").addNew();
                    detail.set("sub_material_id", (Object)materialId);
                    detail.set("sub_baseunit_id", (Object)baseUnitId);
                    detail.set("sub_currency_id", (Object)localCurrencyId);
                    detail.set("sub_baseqty", (Object)baseQty);
                    detail.set("costsubelement_id", (Object)costSubElement);
                    detail.set("costelement_id", (Object)costElement);
                    detail.set("seq", (Object)seq);
                    ++seq;
                }
            }
        }
    }

    public static void insertCostElements(DynamicObject[] infos) {
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        HashMap<Long, Long> accountCostTypeMap = new HashMap<Long, Long>();
        String entityName = infos[0].getDataEntityType().getName();
        String entryName = "entry";
        String tableName = "t_cal_calcostrecord";
        if ("cal_costadjustbill".equals(entityName) || "cal_costadjust_subentity".equals(entityName)) {
            entryName = "entryentity";
            tableName = "t_cal_costadjustbill";
        }
        for (DynamicObject info : infos) {
            costAccountIds.add(info.getLong("costaccount_id"));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_bd_costaccount", (String)"id,costtype", (QFilter[])new QFilter("id", "in", costAccountIds).toArray(), null);){
            for (Row row : dataSet) {
                accountCostTypeMap.put(row.getLong("id"), row.getLong("costtype"));
            }
        }
        Map<String, Long[]> materialCostElementMap = CostElementHelper.getMaterialCostElement(infos);
        HashSet<DynamicObject> detailSet = null;
        ArrayList<HashSet<DynamicObject>> detailList = new ArrayList<HashSet<DynamicObject>>(16);
        long index = 0L;
        Map<Long, List<Long[]>> entryCostSubElementMap = CostElementHelper.cacheMaterialCostElements(infos, materialCostElementMap, accountCostTypeMap);
        HashSet<Long> infoIds = new HashSet<Long>(16);
        for (DynamicObject info : infos) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection(entryName);
            infoIds.add(info.getLong("id"));
            for (DynamicObject entry : entrys) {
                long materialId;
                long localCurrencyId;
                if ("cal_costadjustbill".equals(entityName) || "cal_costadjust_subentity".equals(entityName)) {
                    localCurrencyId = info.getLong("currency_id");
                    materialId = entry.getLong("material_id");
                    long entryId = entry.getLong("id");
                    List<Long[]> costElementSet = entryCostSubElementMap.get(entryId);
                    int seq = 1;
                    for (Long[] costElements : costElementSet) {
                        long costSubElement = costElements[0];
                        long costElement = costElements[1];
                        DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjust_detail");
                        detail.set("entryid", (Object)entryId);
                        detail.set("material", (Object)materialId);
                        detail.set("currency", (Object)localCurrencyId);
                        detail.set("costsubelement", (Object)costSubElement);
                        detail.set("costelement", (Object)costElement);
                        detail.set("seqnum", (Object)seq);
                        if (index % 100000L == 0L) {
                            detailSet = new HashSet<DynamicObject>();
                            detailList.add(detailSet);
                        }
                        if (detailSet != null) {
                            detailSet.add(detail);
                        }
                        ++index;
                        ++seq;
                    }
                    continue;
                }
                if (!"cal_costrecord".equals(entityName)) continue;
                localCurrencyId = info.getLong("localcurrency_id");
                materialId = entry.getLong("material_id");
                long baseUnitId = entry.getLong("baseunit_id");
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                long entryId = entry.getLong("id");
                List<Long[]> costElementSet = entryCostSubElementMap.get(entryId);
                int seq = 1;
                for (Long[] costElements : costElementSet) {
                    long costSubElement = costElements[0];
                    long costElement = costElements[1];
                    DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"cal_costrecord_detail");
                    detail.set("entryid", (Object)entryId);
                    detail.set("material", (Object)materialId);
                    detail.set("baseunit", (Object)baseUnitId);
                    detail.set("currency", (Object)localCurrencyId);
                    detail.set("baseqty", (Object)baseQty);
                    detail.set("costsubelement", (Object)costSubElement);
                    detail.set("costelement", (Object)costElement);
                    detail.set("seqnum", (Object)seq);
                    if (index % 100000L == 0L) {
                        detailSet = new HashSet();
                        detailList.add(detailSet);
                    }
                    if (detailSet != null) {
                        detailSet.add(detail);
                    }
                    ++index;
                    ++seq;
                }
            }
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)tableName, (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, infoIds)});){
            ctx.set();
            for (int arrayIndex = 0; arrayIndex < detailList.size(); ++arrayIndex) {
                SaveServiceHelper.save((DynamicObject[])((Set)detailList.get(arrayIndex)).toArray(new DynamicObject[0]));
            }
        }
    }

    public static void insertCostElements4Initcal(DynamicObject[] infos) {
        DynamicObject[] initCalBills;
        String entryName = "entryentity";
        String subEntryName = "subentryentity";
        HashSet<Long> billIds = new HashSet<Long>(infos.length);
        HashMap<Long, Boolean> calByEleMap = new HashMap<Long, Boolean>(16);
        for (DynamicObject info : infos) {
            billIds.add(info.getLong("id"));
            long costAccId = info.getLong("costaccount_id");
            boolean calByCostElement = ParamsHelper.getCostElementByCostAccount(costAccId);
            calByEleMap.put(costAccId, calByCostElement);
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        Map allEntities = dataEntityType.getAllEntities();
        EntityType entityType = (EntityType)allEntities.get(subEntryName);
        Map fields = entityType.getFields();
        StringBuilder subEntryFieldStr = new StringBuilder();
        for (String field : fields.keySet()) {
            subEntryFieldStr.append(subEntryName).append('.').append(field).append(',');
        }
        Long[] materialDefaultElements = CostElementHelper.getDefaultMaterialElements();
        for (DynamicObject info : initCalBills = BusinessDataServiceHelper.load((String)"cal_initbill", (String)subEntryFieldStr.append(CostElementHelper.getEntryFields(entryName)).append(",accounttype,costaccount").toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)})) {
            DynamicObject costAcc = info.getDynamicObject("costaccount");
            if (((Boolean)calByEleMap.get(costAcc.getLong("id"))).booleanValue() || costAcc.getBoolean("enablestandardcost")) continue;
            DynamicObjectCollection entrys = info.getDynamicObjectCollection(entryName);
            for (DynamicObject entry : entrys) {
                if (AccountTypeEnum.STANDARDCOST.getValue().equals(entry.getString("accounttype"))) continue;
                DynamicObjectCollection subEntryEntityColl = entry.getDynamicObjectCollection(subEntryName);
                DynamicObject subEntryEntity = subEntryEntityColl.size() == 0 ? subEntryEntityColl.addNew() : (DynamicObject)subEntryEntityColl.get(0);
                subEntryEntity.set("costsubelement", (Object)materialDefaultElements[0]);
                subEntryEntity.set("costelement", (Object)materialDefaultElements[1]);
                subEntryEntity.set("sub_material", (Object)entry.getLong("material.id"));
                subEntryEntity.set("sub_baseunit", (Object)entry.getLong("baseunit.id"));
                subEntryEntity.set("sub_baseqty", (Object)CostElementHelper.dealBigDecimal(entry.getBigDecimal("baseqty")));
                subEntryEntity.set("sub_price", (Object)CostElementHelper.dealBigDecimal(entry.getBigDecimal("price")));
                subEntryEntity.set("sub_amount", (Object)CostElementHelper.dealBigDecimal(entry.getBigDecimal("amount")));
                subEntryEntity.set("sub_costdiff", (Object)CostElementHelper.dealBigDecimal(entry.getBigDecimal("costdiff")));
                subEntryEntity.set("sub_yearinqty", (Object)CostElementHelper.dealBigDecimal(entry.getBigDecimal("yearinqty")));
                subEntryEntity.set("sub_yearincost", (Object)CostElementHelper.dealBigDecimal(entry.getBigDecimal("yearincost")));
                subEntryEntity.set("sub_yearincostdiff", (Object)CostElementHelper.dealBigDecimal(entry.getBigDecimal("yearincostdiff")));
                subEntryEntity.set("sub_yearissueqty", (Object)CostElementHelper.dealBigDecimal(entry.getBigDecimal("yearissueqty")));
                subEntryEntity.set("sub_yearissuecost", (Object)CostElementHelper.dealBigDecimal(entry.getBigDecimal("yearissuecost")));
                subEntryEntity.set("sub_yearissuecostdiff", (Object)CostElementHelper.dealBigDecimal(entry.getBigDecimal("yearissuecostdiff")));
            }
        }
        SaveServiceHelper.save((DynamicObject[])initCalBills);
    }

    private static String getEntryFields(String entryName) {
        String selectEntryFields = "material,baseunit,baseqty,price,amount,costdiff,yearinqty,yearincost,yearincostdiff,yearissueqty,yearissuecost,yearissuecostdiff";
        StringBuilder sb = new StringBuilder();
        for (String field : selectEntryFields.split(",")) {
            sb.append(entryName).append('.').append(field).append(',');
        }
        String entryFieldsStr = sb.toString();
        return entryFieldsStr.substring(0, entryFieldsStr.length() - 1);
    }

    private static BigDecimal dealBigDecimal(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    public static Map<Long, List<Long[]>> cacheMaterialCostElements(DynamicObject[] infos, Map<String, Long[]> materialCostElementMap, Map<Long, Long> accountCostTypeMap) {
        HashMap<Long, List<Long[]>> entryCostSubElementMap = new HashMap<Long, List<Long[]>>();
        ArrayList<Long[]> costAllSubElements = new ArrayList<Long[]>();
        Long[] materialDefaultElements = CostElementHelper.getDefaultMaterialElements();
        String entityName = infos[0].getDataEntityType().getName();
        String entryName = "entry";
        if ("cal_costadjustbill".equals(entityName) || "cal_costadjust_subentity".equals(entityName) || "cal_initbill".equals(entityName) || "cal_stdcostdiffbill".equals(entityName)) {
            entryName = "entryentity";
        }
        HashSet<String> dupSet = new HashSet<String>();
        QFilter q = new QFilter("syncflag", "=", (Object)"1");
        DynamicObject[] dynamicObjectArray = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_subelement", (String)"id", (QFilter[])q.toArray(), null);
             DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_elementdetail", (String)"id,element,subelement", null, null);
             DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("id", "subelement").select(new String[]{"id as subelement"}, new String[]{"element"}).finish();){
            for (Row row : joinDataSet) {
                if (dupSet.contains(row.getLong("subelement") + "|" + row.getLong("element"))) continue;
                costAllSubElements.add(new Long[]{row.getLong("subelement"), row.getLong("element")});
                dupSet.add(row.getLong("subelement") + "|" + row.getLong("element"));
            }
        }
        catch (Throwable object) {
            dynamicObjectArray = object;
            throw object;
        }
        HashMap<Long, Boolean> paramMap = new HashMap<Long, Boolean>();
        for (DynamicObject info : infos) {
            long costAccountId = info.getLong("costaccount_id");
            boolean calByCostElement = false;
            if (paramMap.get(costAccountId) != null) {
                calByCostElement = (Boolean)paramMap.get(costAccountId);
            } else {
                calByCostElement = ParamsHelper.getCostElementByCostAccount(costAccountId);
                paramMap.put(costAccountId, calByCostElement);
            }
            DynamicObjectCollection entrys = info.getDynamicObjectCollection(entryName);
            for (DynamicObject entry : entrys) {
                if (calByCostElement) {
                    entryCostSubElementMap.put(entry.getLong("id"), costAllSubElements);
                    continue;
                }
                ArrayList<Long[]> costSubElements = new ArrayList<Long[]>();
                costSubElements.add(materialDefaultElements);
                entryCostSubElementMap.put(entry.getLong("id"), costSubElements);
            }
        }
        return entryCostSubElementMap;
    }

    public static Set<Long> getDisableSubElement() {
        HashSet<Long> disableSubElementSet = new HashSet<Long>(16);
        QFilter q = new QFilter("syncflag", "=", (Object)"1");
        q.and("enable", "=", (Object)Boolean.FALSE);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_subelement", (String)"id", (QFilter[])q.toArray(), null);
        for (Row row : dataSet) {
            disableSubElementSet.add(row.getLong("id"));
        }
        return disableSubElementSet;
    }

    public static Set<Long> getEnableSubElement() {
        HashSet<Long> subElementSet = new HashSet<Long>(16);
        QFilter q = new QFilter("syncflag", "=", (Object)"1");
        q.and("enable", "=", (Object)Boolean.TRUE);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_subelement", (String)"id", (QFilter[])q.toArray(), null);
        for (Row row : dataSet) {
            subElementSet.add(row.getLong("id"));
        }
        return subElementSet;
    }

    public static List<Long[]> getAllCostEle4InitBill() {
        ArrayList<Long[]> costAllSubElements = new ArrayList<Long[]>();
        HashSet<String> dupSet = new HashSet<String>();
        QFilter q = new QFilter("syncflag", "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_subelement", (String)"id", (QFilter[])q.toArray(), null);
             DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_elementdetail", (String)"id,element,element.number as elementNumber,subelement", null, null);
             DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("id", "subelement").select(new String[]{"id as subelement"}, new String[]{"element", "elementNumber"}).finish();){
            DataSet orderDataSet = joinDataSet.orderBy(new String[]{"elementNumber"});
            for (Row row : orderDataSet) {
                if (dupSet.contains(row.getLong("subelement") + "|" + row.getLong("element"))) continue;
                costAllSubElements.add(new Long[]{row.getLong("subelement"), row.getLong("element")});
                dupSet.add(row.getLong("subelement") + "|" + row.getLong("element"));
            }
        }
        return costAllSubElements;
    }

    public static Set<String> getAllCostEleStr() {
        HashSet<String> eleStrSet = new HashSet<String>(8);
        QFilter q = new QFilter("syncflag", "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_subelement", (String)"id", (QFilter[])q.toArray(), null);
             DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cad_elementdetail", (String)"id,element,subelement", null, null);
             DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("id", "subelement").select(new String[]{"id as subelement"}, new String[]{"element"}).finish();){
            for (Row row : joinDataSet) {
                eleStrSet.add(row.getLong("element") + "|" + row.getLong("subelement"));
            }
        }
        return eleStrSet;
    }

    public static Map<String, Long[]> getMaterialCostElement(DynamicObject[] infos) {
        HashSet<Long> materialIds = new HashSet<Long>();
        HashSet<Long> costTypes = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashMap<String, Long[]> materialCostElementMap = new HashMap<String, Long[]>();
        String entityName = infos[0].getDataEntityType().getName();
        String entryName = "entry";
        if ("cal_costadjustbill".equals(entityName) || "cal_costadjust_subentity".equals(entityName) || "cal_initbill".equals(entityName) || "cal_stdcostdiffbill".equals(entityName)) {
            entryName = "entryentity";
        }
        long calOrgId = 0L;
        for (DynamicObject info : infos) {
            calOrgId = info.getLong("calorg_id");
            orgIds.add(info.getLong("calorg_id"));
            if ("cal_costrecord".equals(entityName) || "cal_costrecord_subentity".equals(entityName)) {
                orgIds.add(info.getLong("storageorgunit_id"));
            }
            DynamicObjectCollection entrys = info.getDynamicObjectCollection(entryName);
            for (DynamicObject entry : entrys) {
                long materialId = entry.getLong("material_id");
                materialIds.add(materialId);
                if (!"cal_costadjustbill".equals(entityName) && !"cal_costadjust_subentity".equals(entityName) && !"cal_initbill".equals(entityName) && !"cal_stdcostdiffbill".equals(entityName)) continue;
                orgIds.add(entry.getLong("storageorgunit.id"));
            }
        }
        Map<String, Set<DynamicObject>> costTypeOrgs = ParamsHelper.getCostTypeByOrg(orgIds);
        for (Map.Entry<String, Set<DynamicObject>> costTypeOrgSet : costTypeOrgs.entrySet()) {
            for (DynamicObject costTypeOrg : costTypeOrgSet.getValue()) {
                costTypes.add(costTypeOrg.getLong("costtype.id"));
            }
        }
        materialCostElementMap.putAll(CostElementHelper.getCostElementsByMaterial(calOrgId, costTypes.toArray(new Long[0]), materialIds.toArray(new Long[0])));
        return materialCostElementMap;
    }

    public static Map<String, Long[]> buildExitemElement(Set<Long> exitemSet, Set<Long> costTypeSet) {
        HashMap<String, Long[]> exitemElementMap = new HashMap<String, Long[]>();
        HashSet<Long> elementSet = new HashSet<Long>();
        long defaultId = CostElementHelper.getDefaultElement();
        DynamicObject elementInfo = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element.id,subelement.id", (QFilter[])new QFilter("subelement", "=", (Object)defaultId).toArray());
        long defaultElementId = elementInfo.getLong("element.id");
        HashMap<Long, Long> exitemDetailMap = new HashMap<Long, Long>();
        exitemDetailMap.put(defaultId, defaultElementId);
        Long[] defaultElements = new Long[]{defaultId, defaultElementId};
        for (long expensEitemId : exitemSet) {
            for (long costTypeId : costTypeSet) {
                exitemElementMap.put(costTypeId + "|" + expensEitemId, defaultElements);
            }
        }
        try {
            DynamicObjectCollection exitemElementList = QueryServiceHelper.query((String)"cad_subelemententry", (String)"costtype.id,subelement.id,expenseitem.id", (QFilter[])new QFilter("expenseitem", "in", exitemSet).and("costtype", "in", costTypeSet).toArray());
            for (DynamicObject exitemElement : exitemElementList) {
                elementSet.add(exitemElement.getLong("subelement.id"));
            }
            elementSet.add(defaultId);
            DynamicObjectCollection exitemDetailList = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element.id,subelement.id", (QFilter[])new QFilter("subelement", "in", elementSet).toArray());
            for (DynamicObject exitemDetail : exitemDetailList) {
                exitemDetailMap.put(exitemDetail.getLong("subelement.id"), exitemDetail.getLong("element.id"));
            }
            for (DynamicObject dynamic : exitemElementList) {
                long subelementId = dynamic.getLong("subelement.id");
                long costTypeId = dynamic.getLong("costtype.id");
                long expensEitemId = dynamic.getLong("expenseitem.id");
                if (subelementId == 0L) {
                    subelementId = defaultId;
                }
                exitemElementMap.put(costTypeId + "|" + expensEitemId, new Long[]{subelementId, (Long)exitemDetailMap.get(subelementId)});
                exitemElementMap.put("0|" + expensEitemId, new Long[]{defaultId, (Long)exitemDetailMap.get(defaultId)});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return exitemElementMap;
    }

    public static Long getDefaultElement() {
        long defaultId = 0L;
        DynamicObjectCollection subElements = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter("type", "=", (Object)"002").and("defaultvalue", "=", (Object)Character.valueOf('1')).and("syncflag", "=", (Object)"1").toArray());
        defaultId = subElements.isEmpty() ? 773175492709890048L : ((DynamicObject)subElements.get(0)).getLong("id");
        return defaultId;
    }

    public static Long[] getDefaultMaterialElements() {
        return new Long[]{773175233367685120L, 773126985240072192L};
    }

    public static Long[] getOutSourceProcessElements() {
        return new Long[]{773176488857077760L, 773173574319126528L};
    }

    public static Long getCostElementBySub(Long costSubElementId) {
        return BusinessDataServiceHelper.loadSingle((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter("subelement", "=", (Object)costSubElementId).toArray()).getDynamicObject("element").getLong("ID");
    }

    public static void insertDiffbillCostElements(DynamicObject[] infos, Map<Long, Set<CostAdjustDetailParams>> costEntryIdDetailParamMap) {
        String entryName = "entryentity";
        HashSet<Long> infoIds = new HashSet<Long>(16);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (DynamicObject info : infos) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection(entryName);
            infoIds.add(info.getLong("id"));
            for (DynamicObject entry : entrys) {
                long entryId = entry.getLong("id");
                Set<CostAdjustDetailParams> costAdjustDetailParams = costEntryIdDetailParamMap.get(entryId);
                BigDecimal diff_g = BigDecimal.ZERO;
                BigDecimal diff_h = BigDecimal.ZERO;
                BigDecimal diff_k = BigDecimal.ZERO;
                BigDecimal diff_p = BigDecimal.ZERO;
                BigDecimal diff_q = BigDecimal.ZERO;
                BigDecimal diff_r = BigDecimal.ZERO;
                BigDecimal diff_m = BigDecimal.ZERO;
                BigDecimal diff_s = BigDecimal.ZERO;
                BigDecimal diff_t = BigDecimal.ZERO;
                BigDecimal diff_c = BigDecimal.ZERO;
                BigDecimal diff_x = BigDecimal.ZERO;
                BigDecimal diff_w = BigDecimal.ZERO;
                BigDecimal diff_y = BigDecimal.ZERO;
                String oldValueStr = null;
                int seq = 1;
                if (costAdjustDetailParams != null && !costAdjustDetailParams.isEmpty()) {
                    for (CostAdjustDetailParams param : costAdjustDetailParams) {
                        oldValueStr = JSONDataHelper.JsonFieldData(oldValueStr, param, seq++);
                    }
                    for (CostAdjustDetailParams param : costAdjustDetailParams) {
                        Object costElementId = param.getCostElementId();
                        Object costSubElementId = param.getCostSubElementId();
                        if (null == costElementId || null == costSubElementId || Long.parseLong(String.valueOf(costElementId)) == 0L || Long.parseLong(String.valueOf(costSubElementId)) == 0L) continue;
                        if (param.getDdiff_g() != null) {
                            diff_g = diff_g.add(param.getDdiff_g());
                        }
                        if (param.getDdiff_h() != null) {
                            diff_h = diff_h.add(param.getDdiff_h());
                        }
                        if (param.getDdiff_k() != null) {
                            diff_k = diff_k.add(param.getDdiff_k());
                        }
                        if (param.getDdiff_p() != null) {
                            diff_p = diff_p.add(param.getDdiff_p());
                        }
                        if (param.getDdiff_q() != null) {
                            diff_q = diff_q.add(param.getDdiff_q());
                        }
                        if (param.getDdiff_r() != null) {
                            diff_r = diff_r.add(param.getDdiff_r());
                        }
                        if (param.getDdiff_m() != null) {
                            diff_m = diff_m.add(param.getDdiff_m());
                        }
                        if (param.getDdiff_s() != null) {
                            diff_s = diff_s.add(param.getDdiff_s());
                        }
                        if (param.getDdiff_t() != null) {
                            diff_t = diff_t.add(param.getDdiff_t());
                        }
                        if (param.getDdiff_c() != null) {
                            diff_c = diff_c.add(param.getDdiff_c());
                        }
                        if (param.getDdiff_x() != null) {
                            diff_x = diff_x.add(param.getDdiff_x());
                        }
                        if (param.getDdiff_w() != null) {
                            diff_w = diff_w.add(param.getDdiff_w());
                        }
                        if (param.getDdiff_y() == null) continue;
                        diff_y = diff_y.add(param.getDdiff_y());
                    }
                }
                BigDecimal totalAdjustamt = BigDecimal.ZERO;
                totalAdjustamt = diff_g.add(diff_h).add(diff_k).add(diff_p).add(diff_q).add(diff_r).add(diff_m).add(diff_s).add(diff_t).add(diff_c).add(diff_x).add(diff_w).add(diff_y);
                paramList.add(new Object[]{oldValueStr, totalAdjustamt, diff_g, diff_h, diff_k, diff_p, diff_q, diff_r, diff_m, diff_s, diff_t, diff_c, diff_x, diff_w, diff_y, entryId});
            }
        }
        String sql = "update t_cal_stdcostdiffentry set fsubentryentity = ?,fadjustamt = ?,fdiff_g = ?,fdiff_h = ?,fdiff_k = ?,fdiff_p = ?,fdiff_q = ?,fdiff_r = ?,fdiff_m = ?,fdiff_s = ?,fdiff_t = ?,fdiff_c = ?,fdiff_x = ?,fdiff_w = ?,fdiff_y = ? where fentryid = ?";
        if (paramList != null && paramList.size() != 0) {
            try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_stdcostdiff", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, infoIds)});){
                ctx.set();
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
            }
        }
    }

    public static void calCostpricesourceRecordCost(Long[] entryIds, String type) {
        String sql = "update t_cal_calcostrecordentry set funitactualcost = ?,factualcost = ?,funitstandardcost = ?,fstandardcost = ?,fcostpricesource = ?,fdesignatedcost = ? where fentryid = ?";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_costrecord_detail", (String)"entryid,standardcost,actualcost,unitstandardcost,unitactualcost", (QFilter[])new QFilter("entryid", "in", (Object)entryIds).toArray(), null);
             DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_costrecord", (String)"localcurrency.priceprecision,entry.id,entry.baseqty,entry.costpricesource as costpricesource,entry.ispresent as ispresent,entry.designatedcost as designatedcost", (QFilter[])new QFilter("entry.id", "in", (Object)entryIds).toArray(), null);
             DataSet groupDataSet = dataSet.groupBy(new String[]{"entryid"}).sum("standardcost").sum("actualcost").sum("unitstandardcost").sum("unitactualcost").finish();){
            HashMap<Long, BigDecimal> standardMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> actualMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> unitStandardMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> unitActualMap = new HashMap<Long, BigDecimal>();
            for (Row row : groupDataSet) {
                standardMap.put(row.getLong("entryid"), row.getBigDecimal("standardcost"));
                actualMap.put(row.getLong("entryid"), row.getBigDecimal("actualcost"));
                unitStandardMap.put(row.getLong("entryid"), row.getBigDecimal("unitstandardcost"));
                unitActualMap.put(row.getLong("entryid"), row.getBigDecimal("unitactualcost"));
            }
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (Row row : costRecordDataSet) {
                long entryId = row.getLong("entry.id");
                BigDecimal standardcost = (BigDecimal)standardMap.get(entryId);
                BigDecimal actualcost = (BigDecimal)actualMap.get(entryId);
                BigDecimal unitStandardCost = (BigDecimal)unitStandardMap.get(entryId);
                BigDecimal unitActualCost = (BigDecimal)unitActualMap.get(entryId);
                String costpricesource = null;
                String designated = "0";
                costpricesource = row.getString("costpricesource");
                boolean ispresent = row.getBoolean("ispresent");
                boolean designatedcost = row.getBoolean("designatedcost");
                if (designatedcost) {
                    designated = "1";
                }
                if ("PurWriteOff".equals(type)) {
                    if (!ispresent) {
                        costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue(costpricesource, CostPriceSourceTypeEnum.PAY_ABLE_SPECIFICATION.getValue());
                        designated = CostPriceSourceTypeEnum.PAY_ABLE_SPECIFICATION.getDesignated();
                    }
                } else if ("UnCostEstimate".equals(type)) {
                    costpricesource = CostPriceSourceTypeEnum.getDeleteCostPriceSourceValue(costpricesource, CostPriceSourceTypeEnum.FEE_TEMP_SPECIFICATION.getValue());
                    designated = CostPriceSourceTypeEnum.getDesignatedByCostPriceSource(costpricesource);
                } else if ("FeeBackShare".equals(type)) {
                    costpricesource = CostPriceSourceTypeEnum.getDeleteCostPriceSourceValue(costpricesource, CostPriceSourceTypeEnum.FEE_SHARE_SPECIFICATION.getValue());
                    designated = CostPriceSourceTypeEnum.getDesignatedByCostPriceSource(costpricesource);
                } else if ("ExpenseItemFeeShare".equals(type)) {
                    costpricesource = CostPriceSourceTypeEnum.getCostPriceSourceValue(costpricesource, CostPriceSourceTypeEnum.FEE_SHARE_SPECIFICATION.getValue());
                    designated = CostPriceSourceTypeEnum.FEE_SHARE_SPECIFICATION.getDesignated();
                }
                paramList.add(new Object[]{unitActualCost, actualcost, unitStandardCost, standardcost, costpricesource, designated, entryId});
            }
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, paramList);
        }
    }

    public static Long getDefaultMatSubElementId() {
        Long matSubElementid = (Long)ThreadCache.get((Object)DEFAULT_MATSUBELEMENT);
        if (matSubElementid == null) {
            DynamicObject subElement = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id", (QFilter[])new QFilter("type", "=", (Object)"001").and("defaultvalue", "=", (Object)Character.valueOf('1')).and("syncflag", "=", (Object)"1").toArray());
            matSubElementid = subElement != null ? Long.valueOf(subElement.getLong("id")) : Long.valueOf(773175233367685120L);
            ThreadCache.put((Object)DEFAULT_MATSUBELEMENT, (Object)matSubElementid);
        }
        return matSubElementid;
    }

    public static Set<Long> getEnableCalByEleCostAcctIds() {
        HashSet<Long> enableCalByEleCostAccountIds = (HashSet<Long>)ThreadCache.get((Object)CAL_BALANCE_ENABLECALBYELEMENTCOSTACCOUNTIDS);
        if (enableCalByEleCostAccountIds == null) {
            enableCalByEleCostAccountIds = new HashSet<Long>(4);
            QFilter filter = new QFilter("calpolicy.calbycostelement", "=", (Object)true);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostElementHelper.class.getName(), (String)"cal_bd_costaccount", (String)"id", (QFilter[])filter.toArray(), null);){
                for (Row row : dataSet) {
                    enableCalByEleCostAccountIds.add(row.getLong("id"));
                }
            }
            ThreadCache.put((Object)CAL_BALANCE_ENABLECALBYELEMENTCOSTACCOUNTIDS, enableCalByEleCostAccountIds);
        }
        return enableCalByEleCostAccountIds;
    }
}

