/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostTypeHelper;

public class CostEstCostDetailHelper {
    private static final String[] costTypeFields = new String[]{"auditdate", "costaccount", "calorg", "storageorgunit", "accounttype"};

    public static Map<String, Object> getElementMap(List<Object> exitemAndEntryIdList) {
        Map<Object, Object> exitemElementMap = new HashMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        exitemElementMap = CostElementHelper.buildExitemElement((Set)exitemAndEntryIdList.get(0), (Set)exitemAndEntryIdList.get(2));
        returnMap.put("exitemElementMap", exitemElementMap);
        returnMap.put("defaultId", CostElementHelper.getDefaultElement());
        returnMap.put("defaultMateriaId", CostElementHelper.getDefalutMaterialId());
        return returnMap;
    }

    public static List<Object> getExitemMaterialIdEntryId(DynamicObject[] costrecordarr) {
        ArrayList<Object> exitemAndEntryIdList = new ArrayList<Object>();
        HashSet<Long> exitemSet = new HashSet<Long>(16);
        HashSet<Long> entryIdSet = new HashSet<Long>(16);
        HashSet<Long> costTypeIdSet = new HashSet<Long>(16);
        for (DynamicObject costRecord : costrecordarr) {
            DynamicObjectCollection costRecordEntry = costRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : costRecordEntry) {
                Long entryId = entry.getLong("id");
                entryIdSet.add(entryId);
                DynamicObjectCollection subresultentity = entry.getDynamicObjectCollection("subentryentityest");
                for (DynamicObject subEntry : subresultentity) {
                    exitemSet.add(subEntry.getDynamicObject("sharedetailexitem").getLong("id"));
                }
            }
        }
        Map<Long, Long> billCostTypeMap = CostTypeHelper.getCostTypeByBill(costrecordarr, costTypeFields);
        for (Map.Entry<Long, Long> billCostTypeInfo : billCostTypeMap.entrySet()) {
            costTypeIdSet.add(billCostTypeInfo.getValue());
        }
        exitemAndEntryIdList.add(exitemSet);
        exitemAndEntryIdList.add(entryIdSet);
        exitemAndEntryIdList.add(costTypeIdSet);
        exitemAndEntryIdList.add(billCostTypeMap);
        return exitemAndEntryIdList;
    }

    public static Map<Long, Boolean> getCostElementByCostAccounts(DynamicObject[] costrecordarr) {
        HashSet<Long> costAccountIds = new HashSet<Long>(16);
        HashMap<Long, Long> entryCostAccountMap = new HashMap<Long, Long>();
        for (DynamicObject costRecord : costrecordarr) {
            long costAccountId = costRecord.getLong("costaccount.id");
            costAccountIds.add(costAccountId);
            DynamicObjectCollection costRecordEntry = costRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : costRecordEntry) {
                Long entryId = entry.getLong("id");
                entryCostAccountMap.put(entryId, costAccountId);
            }
        }
        HashMap<Long, Boolean> costAccountToElementMap = new HashMap<Long, Boolean>(costAccountIds.size());
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calpolicy.calbycostelement", (QFilter[])new QFilter("id", "in", costAccountIds).toArray());
        for (DynamicObject costAccount : costAccounts) {
            Long costAccountId = costAccount.getLong("id");
            Boolean calByCostElement = costAccount.getBoolean("calpolicy.calbycostelement");
            costAccountToElementMap.put(costAccountId, calByCostElement);
        }
        HashMap<Long, Boolean> entryCostElementMap = new HashMap<Long, Boolean>(costAccountIds.size());
        for (Map.Entry entry : entryCostAccountMap.entrySet()) {
            Long entryId = (Long)entry.getKey();
            Long costAccountId = (Long)entry.getValue();
            Boolean calByCostElement = (Boolean)costAccountToElementMap.get(costAccountId);
            entryCostElementMap.put(entryId, calByCostElement);
        }
        return entryCostElementMap;
    }

    public static void buildCostRecordDetailExitem(Long costTypeId, Long entryId, DynamicObjectCollection subresultentity, Map<String, Long[]> exitemElementMap, List<Object[]> costRecordDetailList, List<Object[]> costRecordDetailUnitCostList, boolean addUpdate, Long defaultId, Set<Long> exitems, boolean hasTax) {
        for (DynamicObject subEntry : subresultentity) {
            long detailId = subEntry.getLong("id");
            long exitemId = 0L;
            BigDecimal shareDetailAmt = BigDecimal.ZERO;
            if (addUpdate) {
                exitemId = subEntry.getLong("sharedetailexitem.id");
                shareDetailAmt = hasTax ? subEntry.getBigDecimal("sharedetailtaxamt") : subEntry.getBigDecimal("sharedetailamt");
            } else {
                DynamicObject detailS = QueryServiceHelper.queryOne((String)"cal_costestimatebill", (String)"resultentity.subresultentity.sharedetailexitem,resultentity.subresultentity.sharedetailamt,resultentity.subresultentity.sharedetailtaxamt", (QFilter[])new QFilter("resultentity.subresultentity.id", "=", (Object)detailId).toArray());
                exitemId = detailS.getLong("resultentity.subresultentity.sharedetailexitem");
                shareDetailAmt = hasTax ? detailS.getBigDecimal("resultentity.subresultentity.sharedetailtaxamt") : detailS.getBigDecimal("resultentity.subresultentity.sharedetailamt");
            }
            if (exitems != null && exitems.contains(exitemId)) continue;
            long elementId = 0L;
            Long[] elementIds = exitemElementMap.get(costTypeId + "|" + exitemId);
            elementId = elementIds == null ? defaultId.longValue() : elementIds[0].longValue();
            BigDecimal actualCost = shareDetailAmt;
            costRecordDetailList.add(new Object[]{actualCost, entryId, elementId});
            costRecordDetailUnitCostList.add(new Object[]{entryId, elementId});
        }
    }

    public static void buildCostRecordDetailMaterial(Long entryId, DynamicObjectCollection subresultentity, List<Object[]> costRecordDetailList, List<Object[]> costRecordDetailUnitCostList, boolean addUpdate, Long defaultMateriaId, Set<Long> exitems, boolean hasTax) {
        for (DynamicObject subEntry : subresultentity) {
            long detailId = subEntry.getLong("id");
            long exitemId = 0L;
            BigDecimal shareDetailAmt = BigDecimal.ZERO;
            if (addUpdate) {
                exitemId = subEntry.getLong("sharedetailexitem.id");
                shareDetailAmt = hasTax ? subEntry.getBigDecimal("sharedetailtaxamt") : subEntry.getBigDecimal("sharedetailamt");
            } else {
                DynamicObject detailS = QueryServiceHelper.queryOne((String)"cal_costestimatebill", (String)"resultentity.subresultentity.sharedetailexitem,resultentity.subresultentity.sharedetailamt,resultentity.subresultentity.sharedetailtaxamt", (QFilter[])new QFilter("resultentity.subresultentity.id", "=", (Object)detailId).toArray());
                exitemId = detailS.getLong("resultentity.subresultentity.sharedetailexitem");
                shareDetailAmt = hasTax ? detailS.getBigDecimal("resultentity.subresultentity.sharedetailtaxamt") : detailS.getBigDecimal("resultentity.subresultentity.sharedetailamt");
            }
            if (exitems != null && exitems.contains(exitemId)) continue;
            BigDecimal actualCost = shareDetailAmt;
            costRecordDetailList.add(new Object[]{actualCost, entryId, defaultMateriaId});
            costRecordDetailUnitCostList.add(new Object[]{entryId, defaultMateriaId});
        }
    }

    public static String getUpdateCostRecordDetailActualCostSql() {
        return " update t_cal_costrecord_detail set factualcost = factualcost + ? where fentryid = ? and fcostsubelementid = ?";
    }

    public static String getUpdateCostRecordDetailUnitActualCostSql() {
        return " update t_cal_costrecord_detail set funitactualcost=factualcost/fbaseqty where fentryid = ? and fcostsubelementid = ?";
    }

    public static String getSubCostRecordDetailSql() {
        return " update t_cal_costrecord_detail set factualcost = factualcost - ?   where fentryid = ? and fcostsubelementid = ?";
    }

    public static void getExitem(DynamicObjectCollection resultEntitys, List<Object> exitemAndEntryIdList) {
        HashSet<Long> exitemSet = new HashSet<Long>();
        for (DynamicObject resultEntity : resultEntitys) {
            DynamicObjectCollection subresultentity = resultEntity.getDynamicObjectCollection("subresultentity");
            HashSet<Long> detailIds = new HashSet<Long>();
            for (DynamicObject entity : subresultentity) {
                entity.getLong("id");
                detailIds.add(entity.getLong("id"));
            }
            DynamicObjectCollection detailS = QueryServiceHelper.query((String)"cal_costestimatebill", (String)"resultentity.subresultentity.sharedetailexitem", (QFilter[])new QFilter("resultentity.subresultentity.id", "in", detailIds).toArray());
            for (DynamicObject detail : detailS) {
                exitemSet.add(detail.getLong("resultentity.subresultentity.sharedetailexitem"));
            }
        }
        exitemAndEntryIdList.set(0, exitemSet);
    }

    public static void caculateDetailUnitActual(Set<Long> entryIdSet) {
        DynamicObject[] costDetailArray;
        for (DynamicObject costDetail : costDetailArray = BusinessDataServiceHelper.load((String)"cal_costrecord_detail", (String)"id,entryid,costsubelement,actualcost,unitactualcost,costsubelement.id,baseqty,standardcost,unitstandardcost,currency.priceprecision", (QFilter[])new QFilter("entryid", "in", entryIdSet).toArray())) {
            BigDecimal actualcost = costDetail.getBigDecimal("actualcost");
            BigDecimal baseqty = costDetail.getBigDecimal("baseqty");
            if (baseqty.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal unitActualcost = actualcost.divide(baseqty, 10, 4);
            costDetail.set("unitactualcost", (Object)unitActualcost);
        }
        SaveServiceHelper.save((DynamicObject[])costDetailArray);
    }
}

