/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.WriteLogHelper;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.DateUtils;

public class CostTypeHelper {
    private static final Log logger = LogFactory.getLog(CostTypeHelper.class);

    public static Set<Long> getCostTypeByOrg(DynamicObject[] bills, String[] fields, Map<Long, SynBillErrInfo> errMap) {
        HashSet<Long> costTypeIdSet = new HashSet<Long>(16);
        if (bills == null || bills.length < 1) {
            return costTypeIdSet;
        }
        Set<Long> orgSet = CostTypeHelper.getBillOrgs(bills, fields);
        Map<String, Set<DynamicObject>> orgCostTypeMap = ParamsHelper.getCostTypeByOrg(orgSet);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)bills[0].getDataEntityType().getName());
        IDataEntityProperty property = entityType.findProperty(fields[3]);
        if (property == null) {
            return costTypeIdSet;
        }
        IDataEntityType parentProp = property.getParent();
        boolean isEntryProp = parentProp instanceof EntryType;
        String errorMsg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7684\u6210\u672c\u8d26\u7c3f\u201c%1$s\uff08%2$s\uff09\u201d\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u201c\u5b58\u8d27\u6838\u7b97>\u57fa\u7840\u914d\u7f6e>\u6838\u7b97\u914d\u7f6e>\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u8868\u201d\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"CostTypeHelper_1", (String)"fi-cal-common", (Object[])new Object[0]);
        for (DynamicObject bill : bills) {
            Set<DynamicObject> calOrgCostTypeSet;
            String costAccountType;
            String entityName = bills[0].getDataEntityType().getName();
            Date bizDate = bill.getDate(fields[0]) == null ? new Date() : bill.getDate(fields[0]);
            DynamicObject costAccount = bill.getDynamicObject(fields[1]);
            String costAccountId = costAccount == null ? bill.getString(fields[1] + "_id") : costAccount.getString("id");
            String calOrgKey = "";
            if ("cal_initbill".equals(entityName)) {
                Long calorgid = bill.getLong(fields[2] + "_id") == 0L ? bill.getLong(fields[2]) : bill.getLong(fields[2] + "_id");
                calOrgKey = bill.getLong(fields[1] + "_id") + "@" + calorgid;
            } else {
                DynamicObject calOrg = bill.getDynamicObject(fields[2]);
                String calOrgId = calOrg == null ? bill.getString(fields[2] + "_id") : calOrg.getString("id");
                calOrgKey = costAccountId + "@" + (String)calOrgId;
            }
            if (isEntryProp) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(parentProp.getName());
                for (DynamicObject entry : entrys) {
                    Set<DynamicObject> calOrgCostTypeSet2;
                    DynamicObject storageOrg = entry.getDynamicObject(fields[3]);
                    String storageOrgId = storageOrg == null ? entry.getString(fields[3] + "_id") : storageOrg.getString("id");
                    String storageOrgKey = "";
                    if ("cal_initbill".equals(entityName)) {
                        Long storageId = entry.getLong(fields[3] + "_id") == 0L ? entry.getLong(fields[3]) : entry.getLong(fields[3] + "_id");
                        storageOrgKey = bill.getString(fields[1] + "_id") + "@" + storageId;
                    } else {
                        storageOrgKey = costAccountId + "@" + (String)storageOrgId;
                    }
                    costAccountType = entry.getString(fields[4]);
                    if (!"D".equals(costAccountType)) continue;
                    DynamicObject costTypeInfo = null;
                    Set<DynamicObject> set = orgCostTypeMap.get(storageOrgKey);
                    if (set != null && !set.isEmpty()) {
                        for (DynamicObject dynamicObject : set) {
                            if (!dynamicObject.getDate("effectdate").before(bizDate) || !dynamicObject.getDate("invaliddate").after(bizDate)) continue;
                            costTypeInfo = dynamicObject;
                            break;
                        }
                    }
                    if (costTypeInfo == null && (calOrgCostTypeSet2 = orgCostTypeMap.get(calOrgKey)) != null && !calOrgCostTypeSet2.isEmpty()) {
                        for (DynamicObject calOrgCostType : calOrgCostTypeSet2) {
                            if (!calOrgCostType.getDate("effectdate").before(bizDate) || !calOrgCostType.getDate("invaliddate").after(bizDate)) continue;
                            costTypeInfo = calOrgCostType;
                            break;
                        }
                    }
                    if (costTypeInfo == null) {
                        if (errMap == null) continue;
                        QFilter q = new QFilter("id", "=", (Object)Long.valueOf(costAccountId));
                        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"name,number", (QFilter[])q.toArray());
                        errMap.put(bill.getLong("bizbillid"), new SynBillErrInfo("3", String.format(errorMsg, dynamicObject.getString("number"), dynamicObject.getString("name"))));
                        continue;
                    }
                    costTypeIdSet.add(costTypeInfo.getLong("costtype.id"));
                }
                continue;
            }
            DynamicObject storageOrg = bill.getDynamicObject(fields[3]);
            String storageOrgId = storageOrg == null ? bill.getString(fields[3] + "_id") : storageOrg.getString("id");
            property = entityType.findProperty(fields[4]);
            if (property == null) {
                return costTypeIdSet;
            }
            parentProp = property.getParent();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(parentProp.getName());
            boolean isHasStdAccountType = false;
            for (DynamicObject entry : entrys) {
                costAccountType = entry.getString(fields[4]);
                if (!"D".equals(costAccountType)) continue;
                isHasStdAccountType = true;
            }
            if (!isHasStdAccountType) continue;
            String storageOrgKey = costAccountId + "@" + storageOrgId;
            DynamicObject costTypeInfo = null;
            Set<DynamicObject> storageOrgCostTypeSet = orgCostTypeMap.get(storageOrgKey);
            if (storageOrgCostTypeSet != null && !storageOrgCostTypeSet.isEmpty()) {
                for (DynamicObject dynamicObject : storageOrgCostTypeSet) {
                    if (!dynamicObject.getDate("effectdate").before(bizDate) || !dynamicObject.getDate("invaliddate").after(bizDate)) continue;
                    costTypeInfo = dynamicObject;
                    break;
                }
            }
            if (costTypeInfo == null && (calOrgCostTypeSet = orgCostTypeMap.get(calOrgKey)) != null && !calOrgCostTypeSet.isEmpty()) {
                for (DynamicObject calOrgCostType : calOrgCostTypeSet) {
                    if (!calOrgCostType.getDate("effectdate").before(bizDate) || !calOrgCostType.getDate("invaliddate").after(bizDate)) continue;
                    costTypeInfo = calOrgCostType;
                    break;
                }
            }
            if (costTypeInfo == null) {
                if (errMap == null) continue;
                QFilter q = new QFilter("id", "=", (Object)Long.valueOf(costAccountId));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"name,number", (QFilter[])q.toArray());
                errMap.put(bill.getLong("bizbillid"), new SynBillErrInfo("3", String.format(errorMsg, dynamicObject.getString("number"), dynamicObject.getString("name"))));
                continue;
            }
            costTypeIdSet.add(costTypeInfo.getLong("costtype.id"));
        }
        return costTypeIdSet;
    }

    public static Map<Long, Long> getCostTypeByBill(DynamicObject[] bills, String[] fields) {
        HashMap<Long, Long> costTypeIdMap = new HashMap<Long, Long>(16);
        if (bills == null || bills.length < 1) {
            return costTypeIdMap;
        }
        for (DynamicObject bill : bills) {
            costTypeIdMap.put(bill.getLong("id"), 0L);
        }
        Set<Long> orgSet = CostTypeHelper.getBillOrgs(bills, fields);
        String entityName = bills[0].getDataEntityType().getName();
        Map<String, Set<DynamicObject>> orgCostTypeMap = ParamsHelper.getCostTypeByOrg(orgSet);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        IDataEntityProperty property = entityType.findProperty(fields[3]);
        if (property == null) {
            return costTypeIdMap;
        }
        IDataEntityType parentProp = property.getParent();
        boolean isEntryProp = parentProp instanceof EntryType;
        for (DynamicObject bill : bills) {
            Set<DynamicObject> set;
            Date bizDate = bill.getDate(fields[0]) == null ? new Date() : bill.getDate(fields[0]);
            String calOrgKey = "";
            if ("cal_initbill".equals(entityName)) {
                Long calorgid = bill.getLong(fields[2] + "_id") == 0L ? bill.getLong(fields[2]) : bill.getLong(fields[2] + "_id");
                calOrgKey = bill.getString(fields[1] + "_id") + "@" + calorgid;
            } else {
                DynamicObject costAccount = bill.getDynamicObject(fields[1]);
                String costAccountId = costAccount == null ? bill.getString(fields[1] + "_id") : costAccount.getString("id");
                DynamicObject calOrg = bill.getDynamicObject(fields[2]);
                String calOrgId = calOrg == null ? bill.getString(fields[2] + "_id") : calOrg.getString("id");
                calOrgKey = (String)costAccountId + "@" + calOrgId;
            }
            if (isEntryProp) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(parentProp.getName());
                for (DynamicObject entry : entrys) {
                    Set<DynamicObject> calOrgCostTypeSet2;
                    String storageOrgKey = "";
                    if ("cal_initbill".equals(entityName)) {
                        Long storageId = entry.getLong(fields[3] + "_id") == 0L ? entry.getLong(fields[3]) : entry.getLong(fields[3] + "_id");
                        storageOrgKey = bill.getString(fields[1] + "_id") + "@" + storageId;
                    } else {
                        DynamicObject costAccount = bill.getDynamicObject(fields[1]);
                        String costAccountId = costAccount == null ? bill.getString(fields[1] + "_id") : costAccount.getString("id");
                        DynamicObject storageOrg = entry.getDynamicObject(fields[3]);
                        String string = storageOrg == null ? bill.getString(fields[3] + "_id") : storageOrg.getString("id");
                        storageOrgKey = costAccountId + "@" + string;
                    }
                    DynamicObject costTypeInfo = null;
                    Set<DynamicObject> storageOrgCostTypeSet = orgCostTypeMap.get(storageOrgKey);
                    if (storageOrgCostTypeSet != null && !storageOrgCostTypeSet.isEmpty()) {
                        for (DynamicObject dynamicObject : storageOrgCostTypeSet) {
                            if (!dynamicObject.getDate("effectdate").before(bizDate) || !dynamicObject.getDate("invaliddate").after(bizDate)) continue;
                            costTypeInfo = dynamicObject;
                            break;
                        }
                    }
                    if (costTypeInfo == null && (calOrgCostTypeSet2 = orgCostTypeMap.get(calOrgKey)) != null && !calOrgCostTypeSet2.isEmpty()) {
                        for (DynamicObject calOrgCostType : calOrgCostTypeSet2) {
                            if (!calOrgCostType.getDate("effectdate").before(bizDate) || !calOrgCostType.getDate("invaliddate").after(bizDate)) continue;
                            costTypeInfo = calOrgCostType;
                            break;
                        }
                    }
                    if (costTypeInfo == null) continue;
                    costTypeIdMap.put(bill.getLong("id"), costTypeInfo.getLong("costtype.id"));
                }
                continue;
            }
            DynamicObject storageOrg = bill.getDynamicObject(fields[3]);
            String storageOrgId = storageOrg == null ? bill.getString(fields[3] + "_id") : storageOrg.getString("id");
            DynamicObject costAccount = bill.getDynamicObject(fields[1]);
            String costAccountId = costAccount == null ? bill.getString(fields[1] + "_id") : costAccount.getString("id");
            String storageOrgKey = costAccountId + "@" + storageOrgId;
            DynamicObject costTypeInfo = null;
            Set<DynamicObject> storageOrgCostTypeSet = orgCostTypeMap.get(storageOrgKey);
            if (storageOrgCostTypeSet != null && !storageOrgCostTypeSet.isEmpty()) {
                for (DynamicObject storageOrgCostType3 : storageOrgCostTypeSet) {
                    if (!storageOrgCostType3.getDate("effectdate").before(bizDate) || !storageOrgCostType3.getDate("invaliddate").after(bizDate)) continue;
                    costTypeInfo = storageOrgCostType3;
                    break;
                }
            }
            if (costTypeInfo == null && (set = orgCostTypeMap.get(calOrgKey)) != null && !set.isEmpty()) {
                for (DynamicObject calOrgCostType : set) {
                    if (!calOrgCostType.getDate("effectdate").before(bizDate) || !calOrgCostType.getDate("invaliddate").after(bizDate)) continue;
                    costTypeInfo = calOrgCostType;
                    break;
                }
            }
            if (costTypeInfo == null) continue;
            costTypeIdMap.put(bill.getLong("id"), costTypeInfo.getLong("costtype.id"));
        }
        return costTypeIdMap;
    }

    private static Set<Long> getBillOrgs(DynamicObject[] bills, String[] fields) {
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        if (bills == null || bills.length < 1) {
            return orgIdSet;
        }
        String entityName = bills[0].getDataEntityType().getName();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        IDataEntityProperty property = entityType.findProperty(fields[3]);
        if (property == null) {
            return orgIdSet;
        }
        IDataEntityType parentProp = property.getParent();
        boolean isEntryProp = parentProp instanceof EntryType;
        for (DynamicObject bill : bills) {
            if ("cal_initbill".equals(entityName) && !(bill.get(fields[2]) instanceof DynamicObject)) {
                orgIdSet.add(bill.getLong(fields[2]));
            } else {
                DynamicObject calOrg = bill.getDynamicObject(fields[2]);
                if (calOrg == null) {
                    orgIdSet.add(bill.getLong(fields[2] + "_id"));
                } else {
                    orgIdSet.add(calOrg.getLong("id"));
                }
            }
            if (isEntryProp) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(parentProp.getName());
                for (DynamicObject entry : entrys) {
                    DynamicObject storageOrg = entry.getDynamicObject(fields[3]);
                    if (storageOrg == null) {
                        orgIdSet.add(entry.getLong(fields[3] + "_id"));
                        continue;
                    }
                    orgIdSet.add(storageOrg.getLong("id"));
                }
                continue;
            }
            DynamicObject storageOrg = bill.getDynamicObject(fields[3]);
            if (storageOrg == null) {
                orgIdSet.add(bill.getLong(fields[3] + "_id"));
                continue;
            }
            orgIdSet.add(storageOrg.getLong("id"));
        }
        return orgIdSet;
    }

    public static Map<Long, DynamicObject> getCostTypeInfos(Set<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] costTypeInfos = BusinessDataServiceHelper.load((String)"cad_costtype", (String)"id,name,number", (QFilter[])filter.toArray());
        HashMap<Long, DynamicObject> costTypeInfoMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject costTypeInfo : costTypeInfos) {
            costTypeInfoMap.put(costTypeInfo.getLong("id"), costTypeInfo);
        }
        return costTypeInfoMap;
    }

    public static Map<Long, Long> getCostTypeByBillAndBookDate(DynamicObject[] bills, String[] fields, int type) {
        HashMap<Long, Long> costTypeIdMap = new HashMap<Long, Long>(16);
        if (bills == null || bills.length < 1) {
            return costTypeIdMap;
        }
        for (DynamicObject bill : bills) {
            costTypeIdMap.put(bill.getLong("id"), 0L);
        }
        Set<Long> orgSet = CostTypeHelper.getBillOrgs(bills, fields);
        String entityName = bills[0].getDataEntityType().getName();
        Map<String, Set<DynamicObject>> orgCostTypeMap = ParamsHelper.getCostTypeByOrg(orgSet);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        IDataEntityProperty property = entityType.findProperty(fields[3]);
        if (property == null) {
            return costTypeIdMap;
        }
        IDataEntityType parentProp = property.getParent();
        boolean isEntryProp = parentProp instanceof EntryType;
        for (DynamicObject bill : bills) {
            Set<DynamicObject> set;
            Date bizDate = bill.getDate(fields[0]) == null ? new Date() : bill.getDate(fields[0]);
            Date bookDate = bill.getDate(fields[4]) == null ? new Date() : bill.getDate(fields[4]);
            bizDate = type == 0 ? CostTypeHelper.getStandardCostDate(bizDate, bookDate) : DateUtils.getDayEndTime(bookDate);
            String calOrgKey = "";
            if ("cal_initbill".equals(entityName)) {
                Long calorgid = bill.getLong(fields[2] + "_id") == 0L ? bill.getLong(fields[2]) : bill.getLong(fields[2] + "_id");
                calOrgKey = bill.getString(fields[1] + "_id") + "@" + calorgid;
            } else {
                DynamicObject costAccount = bill.getDynamicObject(fields[1]);
                String costAccountId = costAccount == null ? bill.getString(fields[1] + "_id") : costAccount.getString("id");
                DynamicObject calOrg = bill.getDynamicObject(fields[2]);
                String calOrgId = calOrg == null ? bill.getString(fields[2] + "_id") : calOrg.getString("id");
                calOrgKey = (String)costAccountId + "@" + calOrgId;
            }
            if (isEntryProp) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(parentProp.getName());
                for (DynamicObject entry : entrys) {
                    Set<DynamicObject> calOrgCostTypeSet2;
                    String storageOrgKey = "";
                    if ("cal_initbill".equals(entityName)) {
                        Long storageId = entry.getLong(fields[3] + "_id") == 0L ? entry.getLong(fields[3]) : entry.getLong(fields[3] + "_id");
                        storageOrgKey = bill.getString(fields[1] + "_id") + "@" + storageId;
                    } else {
                        DynamicObject costAccount = bill.getDynamicObject(fields[1]);
                        String costAccountId = costAccount == null ? bill.getString(fields[1] + "_id") : costAccount.getString("id");
                        DynamicObject storageOrg = entry.getDynamicObject(fields[3]);
                        String string = storageOrg == null ? bill.getString(fields[3] + "_id") : storageOrg.getString("id");
                        storageOrgKey = costAccountId + "@" + string;
                    }
                    DynamicObject costTypeInfo = null;
                    Set<DynamicObject> storageOrgCostTypeSet = orgCostTypeMap.get(storageOrgKey);
                    if (storageOrgCostTypeSet != null && !storageOrgCostTypeSet.isEmpty()) {
                        for (DynamicObject dynamicObject : storageOrgCostTypeSet) {
                            if (!dynamicObject.getDate("effectdate").before(bizDate) || !dynamicObject.getDate("invaliddate").after(bizDate)) continue;
                            costTypeInfo = dynamicObject;
                            break;
                        }
                    }
                    if (costTypeInfo == null && (calOrgCostTypeSet2 = orgCostTypeMap.get(calOrgKey)) != null && !calOrgCostTypeSet2.isEmpty()) {
                        for (DynamicObject calOrgCostType : calOrgCostTypeSet2) {
                            if (!calOrgCostType.getDate("effectdate").before(bizDate) || !calOrgCostType.getDate("invaliddate").after(bizDate)) continue;
                            costTypeInfo = calOrgCostType;
                            break;
                        }
                    }
                    if (costTypeInfo == null) continue;
                    costTypeIdMap.put(bill.getLong("id"), costTypeInfo.getLong("costtype.id"));
                }
                continue;
            }
            DynamicObject storageOrg = bill.getDynamicObject(fields[3]);
            String storageOrgId = storageOrg == null ? bill.getString(fields[3] + "_id") : storageOrg.getString("id");
            DynamicObject costAccount = bill.getDynamicObject(fields[1]);
            String costAccountId = costAccount == null ? bill.getString(fields[1] + "_id") : costAccount.getString("id");
            String storageOrgKey = costAccountId + "@" + storageOrgId;
            DynamicObject costTypeInfo = null;
            Set<DynamicObject> storageOrgCostTypeSet = orgCostTypeMap.get(storageOrgKey);
            if (storageOrgCostTypeSet != null && !storageOrgCostTypeSet.isEmpty()) {
                for (DynamicObject storageOrgCostType3 : storageOrgCostTypeSet) {
                    if (!storageOrgCostType3.getDate("effectdate").before(bizDate) || !storageOrgCostType3.getDate("invaliddate").after(bizDate)) continue;
                    costTypeInfo = storageOrgCostType3;
                    break;
                }
            }
            if (costTypeInfo == null && (set = orgCostTypeMap.get(calOrgKey)) != null && !set.isEmpty()) {
                for (DynamicObject calOrgCostType : set) {
                    if (!calOrgCostType.getDate("effectdate").before(bizDate) || !calOrgCostType.getDate("invaliddate").after(bizDate)) continue;
                    costTypeInfo = calOrgCostType;
                    break;
                }
            }
            if (costTypeInfo == null) continue;
            costTypeIdMap.put(bill.getLong("id"), costTypeInfo.getLong("costtype.id"));
        }
        return costTypeIdMap;
    }

    public static Set<Long> getCostTypeByOrgAndBookDate(DynamicObject[] bills, String[] fields, Map<Long, SynBillErrInfo> errMap, int type) {
        HashSet<Long> costTypeIdSet = new HashSet<Long>(16);
        if (bills == null || bills.length < 1) {
            return costTypeIdSet;
        }
        Set<Long> orgSet = CostTypeHelper.getBillOrgs(bills, fields);
        Map<String, Set<DynamicObject>> orgCostTypeMap = ParamsHelper.getCostTypeByOrg(orgSet);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)bills[0].getDataEntityType().getName());
        IDataEntityProperty property = entityType.findProperty(fields[3]);
        if (property == null) {
            return costTypeIdSet;
        }
        IDataEntityType parentProp = property.getParent();
        boolean isEntryProp = parentProp instanceof EntryType;
        String errorMsg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7684\u6210\u672c\u8d26\u7c3f\u201c%1$s\uff08%2$s\uff09\u201d\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u201c\u5b58\u8d27\u6838\u7b97>\u57fa\u7840\u914d\u7f6e>\u6838\u7b97\u914d\u7f6e>\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u8868\u201d\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"CostTypeHelper_1", (String)"fi-cal-common", (Object[])new Object[0]);
        for (DynamicObject bill : bills) {
            Set<DynamicObject> calOrgCostTypeSet;
            String costAccountType;
            Boolean isgetstdcost = (Boolean)ParamsHelper.getAppParam(bill.getLong("calorg_id"), "isgetstdcost");
            String entityName = bills[0].getDataEntityType().getName();
            Date bizDate = bill.getDate(fields[0]) == null ? new Date() : bill.getDate(fields[0]);
            Date bookDate = bill.getDate(fields[5]) == null ? new Date() : bill.getDate(fields[5]);
            bizDate = type == 0 ? CostTypeHelper.getStandardCostDate(bizDate, bookDate) : DateUtils.getDayEndTime(bookDate);
            DynamicObject costAccount = bill.getDynamicObject(fields[1]);
            String costAccountId = costAccount == null ? bill.getString(fields[1] + "_id") : costAccount.getString("id");
            String calOrgKey = "";
            if ("cal_initbill".equals(entityName)) {
                Long calorgid = bill.getLong(fields[2] + "_id") == 0L ? bill.getLong(fields[2]) : bill.getLong(fields[2] + "_id");
                calOrgKey = bill.getLong(fields[1] + "_id") + "@" + calorgid;
            } else {
                DynamicObject calOrg = bill.getDynamicObject(fields[2]);
                String calOrgId = calOrg == null ? bill.getString(fields[2] + "_id") : calOrg.getString("id");
                calOrgKey = costAccountId + "@" + (String)calOrgId;
            }
            if (isEntryProp) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(parentProp.getName());
                for (DynamicObject entry : entrys) {
                    Set<DynamicObject> calOrgCostTypeSet2;
                    DynamicObject storageOrg = entry.getDynamicObject(fields[3]);
                    String storageOrgId = storageOrg == null ? entry.getString(fields[3] + "_id") : storageOrg.getString("id");
                    String storageOrgKey = "";
                    if ("cal_initbill".equals(entityName)) {
                        Long storageId = entry.getLong(fields[3] + "_id") == 0L ? entry.getLong(fields[3]) : entry.getLong(fields[3] + "_id");
                        storageOrgKey = bill.getString(fields[1] + "_id") + "@" + storageId;
                    } else {
                        storageOrgKey = costAccountId + "@" + (String)storageOrgId;
                    }
                    costAccountType = entry.getString(fields[4]);
                    if (!"D".equals(costAccountType) && !isgetstdcost.booleanValue()) continue;
                    DynamicObject costTypeInfo = null;
                    Set<DynamicObject> set = orgCostTypeMap.get(storageOrgKey);
                    if (set != null && !set.isEmpty()) {
                        for (DynamicObject dynamicObject : set) {
                            if (!dynamicObject.getDate("effectdate").before(bizDate) || !dynamicObject.getDate("invaliddate").after(bizDate)) continue;
                            costTypeInfo = dynamicObject;
                            break;
                        }
                    }
                    if (costTypeInfo == null && (calOrgCostTypeSet2 = orgCostTypeMap.get(calOrgKey)) != null && !calOrgCostTypeSet2.isEmpty()) {
                        for (DynamicObject calOrgCostType : calOrgCostTypeSet2) {
                            if (!calOrgCostType.getDate("effectdate").before(bizDate) || !calOrgCostType.getDate("invaliddate").after(bizDate)) continue;
                            costTypeInfo = calOrgCostType;
                            break;
                        }
                    }
                    if (costTypeInfo == null) {
                        if (errMap == null) continue;
                        QFilter q = new QFilter("id", "=", (Object)Long.valueOf(costAccountId));
                        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"name,number", (QFilter[])q.toArray());
                        errMap.put(bill.getLong("bizbillid"), new SynBillErrInfo("3", String.format(errorMsg, dynamicObject.getString("number"), dynamicObject.getString("name"))));
                        continue;
                    }
                    costTypeIdSet.add(costTypeInfo.getLong("costtype.id"));
                }
                continue;
            }
            DynamicObject storageOrg = bill.getDynamicObject(fields[3]);
            String storageOrgId = storageOrg == null ? bill.getString(fields[3] + "_id") : storageOrg.getString("id");
            property = entityType.findProperty(fields[4]);
            if (property == null) {
                return costTypeIdSet;
            }
            parentProp = property.getParent();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(parentProp.getName());
            boolean isHasStdAccountType = false;
            for (DynamicObject entry : entrys) {
                costAccountType = entry.getString(fields[4]);
                if (!"D".equals(costAccountType) && !isgetstdcost.booleanValue()) continue;
                isHasStdAccountType = true;
            }
            if (!isHasStdAccountType) continue;
            String storageOrgKey = costAccountId + "@" + storageOrgId;
            DynamicObject costTypeInfo = null;
            Set<DynamicObject> storageOrgCostTypeSet = orgCostTypeMap.get(storageOrgKey);
            if (storageOrgCostTypeSet != null && !storageOrgCostTypeSet.isEmpty()) {
                for (DynamicObject dynamicObject : storageOrgCostTypeSet) {
                    if (!dynamicObject.getDate("effectdate").before(bizDate) || !dynamicObject.getDate("invaliddate").after(bizDate)) continue;
                    costTypeInfo = dynamicObject;
                    break;
                }
            }
            if (costTypeInfo == null && (calOrgCostTypeSet = orgCostTypeMap.get(calOrgKey)) != null && !calOrgCostTypeSet.isEmpty()) {
                for (DynamicObject calOrgCostType : calOrgCostTypeSet) {
                    if (!calOrgCostType.getDate("effectdate").before(bizDate) || !calOrgCostType.getDate("invaliddate").after(bizDate)) continue;
                    costTypeInfo = calOrgCostType;
                    break;
                }
            }
            if (costTypeInfo == null) {
                if (errMap == null) continue;
                QFilter q = new QFilter("id", "=", (Object)Long.valueOf(costAccountId));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"name,number", (QFilter[])q.toArray());
                errMap.put(bill.getLong("bizbillid"), new SynBillErrInfo("3", String.format(errorMsg, dynamicObject.getString("number"), dynamicObject.getString("name"))));
                continue;
            }
            costTypeIdSet.add(costTypeInfo.getLong("costtype.id"));
        }
        return costTypeIdSet;
    }

    public static Date getStandardCostDate(Date auditdate, Date bookdate) {
        WriteLogHelper.writeInfoLog(logger, "CostTypeHelper-getStandardCostDate auditdate\uff1a" + auditdate, new Object[0]);
        WriteLogHelper.writeInfoLog(logger, "CostTypeHelper-getStandardCostDate bookdate1\uff1a" + bookdate, new Object[0]);
        if (null == auditdate || null == bookdate) {
            return auditdate;
        }
        if (DateUtils.isTheSameDay(auditdate, bookdate)) {
            bookdate = DateUtils.getDayStartTime(bookdate);
            int hour = DateUtils.getIntByDate(auditdate, 11);
            int minute = DateUtils.getIntByDate(auditdate, 12);
            int second = DateUtils.getIntByDate(auditdate, 13);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(bookdate);
            calendar.set(11, hour);
            calendar.set(12, minute);
            calendar.set(13, second);
            bookdate = calendar.getTime();
        } else {
            bookdate = DateUtils.getDayEndTime(bookdate);
        }
        WriteLogHelper.writeInfoLog(logger, "CostTypeHelper-getStandardCostDate bookdate2\uff1a" + bookdate, new Object[0]);
        return bookdate;
    }
}

