/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.CalStdcostdiffbillHelper;
import kd.fi.cal.common.helper.MaterialNoUpdateFieldHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;

public class CostUpdateApplyBillAuditHelper {
    private List<CostAdjustDetailParams> detailParamsList = new ArrayList<CostAdjustDetailParams>();

    public void exeAudit(DynamicObject[] bills) {
        DynamicObject[] costAdjustBills = this.createCostAdjustBills(bills);
        DynamicObject[] costDiffBills = this.createCostdiffbills(bills);
        this.auditCostAdjustBills(costAdjustBills);
        this.auditCostDiffbills(costDiffBills);
    }

    private void auditCostAdjustBills(DynamicObject[] costAdjustBills) {
        DynamicObject[] infos = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])costAdjustBills);
        costAdjustBills = this.getLoadDynamicObject(infos, false);
        OperateOption op = OperateOption.create();
        String params = SerializationUtils.toJsonString(this.detailParamsList);
        op.setVariableValue("CostAdjustDetailParms", params);
        op.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_costadjust_subentity", (DynamicObject[])costAdjustBills, (OperateOption)op);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess() || !errors.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder();
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                errorMsg.append(operror.getMessage());
            }
            String content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u751f\u6210\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff1a%1$s", (String)"CostUpdateApplyBillAuditHelper_1", (String)"fi-cal-common", (Object[])new Object[0]), errorMsg + result.getMessage());
            throw new KDBizException(content);
        }
    }

    private void auditCostDiffbills(DynamicObject[] costAdjustBills) {
        DynamicObject[] infos = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])costAdjustBills);
        costAdjustBills = this.getLoadDynamicObject(infos, true);
        OperateOption op = OperateOption.create();
        String params = SerializationUtils.toJsonString(this.detailParamsList);
        op.setVariableValue("CostAdjustDetailParms", params);
        op.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (DynamicObject[])costAdjustBills, (OperateOption)op);
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess() || !errors.isEmpty()) {
            StringBuilder errorMsg = new StringBuilder();
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                errorMsg.append(operror.getMessage());
            }
            String content = String.format(ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u751f\u6210\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u5ba1\u6838\u5931\u8d25\uff1a%1$s", (String)"CostUpdateApplyBillAuditHelper_2", (String)"fi-cal-common", (Object[])new Object[0]), errorMsg + result.getMessage());
            throw new KDBizException(content);
        }
    }

    private DynamicObject[] getLoadDynamicObject(DynamicObject[] infos, boolean isdiffBill) {
        HashSet<Object> infoIds = new HashSet<Object>(32);
        for (DynamicObject object : infos) {
            infoIds.add(object.getPkValue());
        }
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjust_subentity");
        if (isdiffBill) {
            costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
        }
        return BusinessDataServiceHelper.load((Object[])infoIds.toArray(), (DynamicObjectType)costAdjustEntityType);
    }

    private DynamicObject[] createCostAdjustBills(DynamicObject[] bills) {
        HashSet<DynamicObject> costAdjustbills = new HashSet<DynamicObject>(bills.length);
        Set<String> dimField = CalBalanceModelHelper.getDimField();
        dimField.add("baseunit");
        String[] dimFieldArray = dimField.toArray(new String[dimField.size()]);
        HashMap<String, DynamicObject> entryRows = new HashMap<String, DynamicObject>(16);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        for (DynamicObject applyInfo : bills) {
            String srcSys = applyInfo.getString("srcsys");
            String applyBillNo = applyInfo.getString("billno");
            String createType = "";
            String diffType = "";
            if (!"A".equals(srcSys)) continue;
            createType = "A";
            diffType = "B";
            DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_costadjustbill");
            costAdjustBill.set("bizdate", applyInfo.get("bizdate"));
            costAdjustBill.set("bookdate", applyInfo.get("bookdate"));
            costAdjustBill.set("calorg", (Object)applyInfo.getString("calorg.id"));
            costAdjustBill.set("costaccount", applyInfo.get("costaccount"));
            costAdjustBill.set("biztype", (Object)Character.valueOf('A'));
            costAdjustBill.set("currency", (Object)applyInfo.getString("currency.id"));
            costAdjustBill.set("billstatus", (Object)Character.valueOf('B'));
            costAdjustBill.set("createtype", (Object)createType);
            costAdjustBill.set("difftype", (Object)diffType);
            costAdjustBill.set("remark", applyInfo.get("remark"));
            costAdjustBill.set("creator", (Object)applyInfo.getString("creator.id"));
            costAdjustBill.set("createtime", applyInfo.get("createtime"));
            costAdjustBill.set("modifier", (Object)applyInfo.getString("modifier.id"));
            costAdjustBill.set("modifytime", applyInfo.get("modifytime"));
            costAdjustBill.set("auditor", (Object)applyInfo.getString("auditor.id"));
            costAdjustBill.set("auditor", applyInfo.get("auditdate"));
            costAdjustBill.set("srcsys", (Object)applyInfo.getString("srcsys"));
            String billno = BillNoHelper.getBillNo("cal_costadjust_subentity", costAdjustBill, applyInfo.getString("calorg.id"));
            costAdjustBill.set("billno", (Object)billno);
            String applybillid = applyInfo.getPkValue().toString();
            DynamicObjectCollection entry = costAdjustBill.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection applyEntrys = applyInfo.getDynamicObjectCollection("entryentity");
            long[] entryIds = DBServiceHelper.genLongIds((String)"t_cal_costadjustentry", (int)applyEntrys.size());
            int i = 0;
            HashSet<String> entryKeys = new HashSet<String>(32);
            for (DynamicObject applyEntry : applyEntrys) {
                paramMap.clear();
                StringBuilder keyStr = new StringBuilder();
                for (String dim : dimFieldArray) {
                    Object value = applyEntry.get(dim);
                    if (value instanceof BasedataProp) {
                        DynamicObject dynamicObject = (DynamicObject)value;
                        Object id = dynamicObject.getPkValue();
                        paramMap.put(dim, id);
                        keyStr.append(id).append('_');
                        continue;
                    }
                    if (value != null) {
                        paramMap.put(dim, value);
                        keyStr.append(value).append('_');
                        continue;
                    }
                    keyStr.append('_');
                }
                BigDecimal costDiff = applyEntry.getBigDecimal("costdiff");
                if ("M".equals(diffType) && "C1".equals(createType)) {
                    costDiff = BigDecimal.ZERO.subtract(costDiff);
                }
                Object costelement = applyEntry.get("costelement.id");
                Object costsubelement = applyEntry.get("costsubelement.id");
                int seq = applyEntry.getInt("seq");
                String key = keyStr.toString();
                if (entryKeys.contains(key)) {
                    DynamicObject entryRow = (DynamicObject)entryRows.get(key);
                    BigDecimal adjustamt = entryRow.getBigDecimal("adjustamt");
                    entryRow.set("adjustamt", (Object)adjustamt.add(costDiff));
                    Object id = entryRow.get("id");
                    CostAdjustDetailParams costAdjustDetailParams = new CostAdjustDetailParams(id, costelement, costsubelement, costDiff);
                    this.detailParamsList.add(costAdjustDetailParams);
                } else {
                    DynamicObject entryInfo = entry.addNew();
                    entryKeys.add(key);
                    long id = entryIds[i++];
                    entryInfo.set("id", (Object)id);
                    entryInfo.set("seq", (Object)i);
                    for (String dim : dimFieldArray) {
                        entryInfo.set(dim, paramMap.get(dim));
                    }
                    entryInfo.set("adjustamt", (Object)costDiff);
                    entryInfo.set("invbizentityobject", (Object)"cal_costupdateapplybill");
                    entryInfo.set("invbillnum", (Object)applyBillNo);
                    entryInfo.set("invbillid", (Object)applybillid);
                    entryInfo.set("inventryseq", (Object)seq);
                    entryRows.put(key, entryInfo);
                    CostAdjustDetailParams costAdjustDetailParams = new CostAdjustDetailParams(id, costelement, costsubelement, costDiff);
                    this.detailParamsList.add(costAdjustDetailParams);
                }
                costAdjustbills.add(costAdjustBill);
            }
        }
        return costAdjustbills.toArray(new DynamicObject[0]);
    }

    private DynamicObject[] createCostdiffbills(DynamicObject[] bills) {
        HashSet<DynamicObject> costAdjustbills = new HashSet<DynamicObject>(bills.length);
        Set<String> dimField = CalBalanceModelHelper.getDimField();
        dimField.add("baseunit");
        String[] dimFieldArray = dimField.toArray(new String[dimField.size()]);
        HashMap<String, DynamicObject> entryRows = new HashMap<String, DynamicObject>(16);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        MaterialNoUpdateFieldHelper materialNoUpdateFieldHelper = new MaterialNoUpdateFieldHelper();
        Map<String, Long> unionKeyAndStorageInvId = materialNoUpdateFieldHelper.getStorageOrgMaterialAndInvInfoMap(bills);
        Map<Object, String> storageInvIdAndNoUpdateStr = materialNoUpdateFieldHelper.getSDBNoUpdateInfoMap(unionKeyAndStorageInvId, "cal_costadjust_subentity", "entryentity");
        for (DynamicObject applyInfo : bills) {
            String srcSys = applyInfo.getString("srcsys");
            String applyBillNo = applyInfo.getString("billno");
            String createType = "";
            String diffType = "";
            if (!"B".equals(srcSys)) continue;
            createType = "C1";
            diffType = "M";
            DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
            costAdjustBill.set("bizdate", applyInfo.get("bizdate"));
            costAdjustBill.set("bookdate", applyInfo.get("bookdate"));
            costAdjustBill.set("calorg", (Object)applyInfo.getString("calorg.id"));
            costAdjustBill.set("costaccount", applyInfo.get("costaccount"));
            costAdjustBill.set("biztype", (Object)Character.valueOf('A'));
            costAdjustBill.set("currency", (Object)applyInfo.getString("currency.id"));
            costAdjustBill.set("billstatus", (Object)Character.valueOf('B'));
            costAdjustBill.set("createtype", (Object)createType);
            costAdjustBill.set("remark", applyInfo.get("remark"));
            costAdjustBill.set("creator", (Object)applyInfo.getString("creator.id"));
            costAdjustBill.set("createtime", applyInfo.get("createtime"));
            costAdjustBill.set("modifier", (Object)applyInfo.getString("modifier.id"));
            costAdjustBill.set("modifytime", applyInfo.get("modifytime"));
            costAdjustBill.set("auditor", (Object)applyInfo.getString("auditor.id"));
            costAdjustBill.set("auditor", applyInfo.get("auditdate"));
            String billno = BillNoHelper.getBillNo("cal_stdcostdiffbill", costAdjustBill, applyInfo.getString("calorg.id"));
            costAdjustBill.set("billno", (Object)billno);
            costAdjustBill.set("srcsys", (Object)applyInfo.getString("srcsys"));
            String applybillid = applyInfo.getPkValue().toString();
            DynamicObjectCollection entry = costAdjustBill.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection applyEntrys = applyInfo.getDynamicObjectCollection("entryentity");
            long[] entryIds = DBServiceHelper.genLongIds((String)"t_cal_stdcostdiffentry", (int)applyEntrys.size());
            int i = 0;
            HashSet<String> entryKeys = new HashSet<String>(32);
            for (DynamicObject applyEntry : applyEntrys) {
                paramMap.clear();
                StringBuilder keyStr = new StringBuilder();
                for (String dim : dimFieldArray) {
                    Object value = applyEntry.get(dim);
                    if (value instanceof BasedataProp) {
                        DynamicObject dynamicObject = (DynamicObject)value;
                        Object id = dynamicObject.getPkValue();
                        paramMap.put(dim, id);
                        keyStr.append(id).append('_');
                        continue;
                    }
                    if (value != null) {
                        paramMap.put(dim, value);
                        keyStr.append(value).append('_');
                        continue;
                    }
                    keyStr.append('_');
                }
                BigDecimal costDiff = applyEntry.getBigDecimal("costdiff");
                if ("M".equals(diffType) && "C1".equals(createType)) {
                    costDiff = BigDecimal.ZERO.subtract(costDiff);
                }
                Object costelement = applyEntry.get("costelement.id");
                Object costsubelement = applyEntry.get("costsubelement.id");
                int seq = applyEntry.getInt("seq");
                String key = keyStr.toString();
                if (entryKeys.contains(key)) {
                    DynamicObject entryRow = (DynamicObject)entryRows.get(key);
                    BigDecimal adjustamt = entryRow.getBigDecimal("adjustamt");
                    entryRow.set("adjustamt", (Object)adjustamt.add(costDiff));
                    Object id = entryRow.get("id");
                    String[] parms = new CostAdjustDetailParams();
                    parms.setEntryid(id);
                    parms.setCostElementId(costelement);
                    parms.setCostSubElementId(costsubelement);
                    parms.setAdjustAmt(costDiff);
                    CalStdcostdiffbillHelper.setParamSubDdiffAmt("M", costDiff, (CostAdjustDetailParams)parms);
                    this.detailParamsList.add((CostAdjustDetailParams)parms);
                } else {
                    DynamicObject entryInfo = entry.addNew();
                    entryKeys.add(key);
                    long id = entryIds[i++];
                    entryInfo.set("id", (Object)id);
                    entryInfo.set("seq", (Object)i);
                    for (String dim : dimFieldArray) {
                        entryInfo.set(dim, paramMap.get(dim));
                    }
                    entryInfo.set("adjustamt", (Object)costDiff);
                    entryInfo.set("invbizentityobject", (Object)"cal_costupdateapplybill");
                    entryInfo.set("invbillnum", (Object)applyBillNo);
                    entryInfo.set("invbillid", (Object)applybillid);
                    entryInfo.set("inventryseq", (Object)seq);
                    long material = applyEntry.getDynamicObject("material").getLong("id");
                    long storageorgunit = applyEntry.getDynamicObject("storageorgunit").getLong("id");
                    String curUnionKey = storageorgunit + "#" + material;
                    Long storageInvId = unionKeyAndStorageInvId.get(curUnionKey);
                    String noupdatecalfields = storageInvIdAndNoUpdateStr.get(storageInvId);
                    entryInfo.set("noupdatecalfields", (Object)noupdatecalfields);
                    entryRows.put(key, entryInfo);
                    CostAdjustDetailParams parms = new CostAdjustDetailParams();
                    parms.setEntryid(id);
                    parms.setCostElementId(costelement);
                    parms.setCostSubElementId(costsubelement);
                    parms.setAdjustAmt(costDiff);
                    CalStdcostdiffbillHelper.setParamSubDdiffAmt("M", costDiff, parms);
                    this.detailParamsList.add(parms);
                }
                costAdjustbills.add(costAdjustBill);
            }
        }
        return costAdjustbills.toArray(new DynamicObject[0]);
    }
}

