/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.PeriodVoucherValidHelper;
import kd.fi.cal.common.helper.WriteLogHelper;

public class DeleteVoucherValidHelper {
    private static final Log logger = LogFactory.getLog(DeleteVoucherValidHelper.class);
    private Set<Long> costAccountIdSet;
    private Map<Long, DynamicObjectCollection> voucherRecordColMap;

    public DeleteVoucherValidHelper() {
    }

    public DeleteVoucherValidHelper(Set<Long> costAccountIdSet, Set<Long> voucherIdSet) {
        this.costAccountIdSet = costAccountIdSet;
        this.voucherRecordColMap = this.getCostRecordCollByVoucherIdSet(voucherIdSet);
    }

    public static String costRecordSelect() {
        return "id,costaccount,vouchertype,isfivoucher,istempvoucher,isdischargevoucher,iscostcarryover,fivouchernum,tempvouchernum,dischargevouchernum,carryovervouchernum,fivoucherid,tempvoucherid,dischargevoucherid,carryovervoucherid,billnumber,dischargetype,billno,feevoucherid,isfeevoucher,feevouchernum,bizdate,bookdate,writeoffdate,writeofftype,writeoffstatus,writeoffperiod,bizentityobject,isinitbill,issplitcreate,calbilltype,bizbillid";
    }

    private Map<Long, DynamicObjectCollection> getCostRecordCollByVoucherIdSet(Set<Long> voucherIdSet) {
        if (voucherIdSet == null || voucherIdSet.size() == 0) {
            return new HashMap<Long, DynamicObjectCollection>();
        }
        QFilter q = new QFilter("voucherid", "in", voucherIdSet);
        HashSet<Long> costRecordIdSet = new HashSet<Long>();
        HashMap costRecordMap = new HashMap();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_voucher", (String)"voucherid,costrecordid,vouchertype", (QFilter[])new QFilter[]{q}, null);){
            for (Row row : dataSet) {
                long voucherid = row.getLong("voucherid");
                HashSet<Long> recordIdSet = (Set)costRecordMap.get(voucherid);
                if (costRecordMap.get(voucherid) == null) {
                    recordIdSet = new HashSet<Long>(512);
                }
                Long recordId = row.getLong("costrecordid");
                recordIdSet.add(recordId);
                costRecordMap.put(voucherid, recordIdSet);
                costRecordIdSet.add(recordId);
            }
        }
        DynamicObjectCollection recordCol = QueryServiceHelper.query((String)"cal_costrecord", (String)DeleteVoucherValidHelper.costRecordSelect(), (QFilter[])new QFilter[]{new QFilter("id", "in", costRecordIdSet)});
        HashMap<Long, DynamicObject> recordDynamicObj = new HashMap<Long, DynamicObject>();
        for (DynamicObject record : recordCol) {
            recordDynamicObj.put(record.getLong("id"), record);
        }
        HashMap<Long, DynamicObjectCollection> voucherRecordMap = new HashMap<Long, DynamicObjectCollection>(64);
        for (Map.Entry entry : costRecordMap.entrySet()) {
            DynamicObjectCollection recordCols = new DynamicObjectCollection();
            Set recordIds = (Set)entry.getValue();
            for (Long recordId : recordIds) {
                recordCols.add(recordDynamicObj.get(recordId));
            }
            voucherRecordMap.put((Long)entry.getKey(), recordCols);
        }
        return voucherRecordMap;
    }

    public String doValidate(DynamicObjectCollection costRecords, long voucherId, boolean isCalDelete, PeriodVoucherValidHelper helper) {
        DynamicObject voucher = null;
        try {
            voucher = BusinessDataServiceHelper.loadSingle((Object)voucherId, (String)"gl_voucher", (String)"id");
        }
        catch (Exception e) {
            WriteLogHelper.writeErrorLog(logger, e);
        }
        if (voucher == null) {
            return ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5c1a\u672a\u751f\u6210\u6b63\u5f0f\u51ed\u8bc1\u6216\u51ed\u8bc1\u5df2\u5220\u9664\u3002", (String)"DeleteVoucherValidHelper_11", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        if (isCalDelete) {
            QFilter q = new QFilter("voucherid", "=", (Object)voucherId);
            q.and("vouchersource", "=", (Object)"C");
            if (QueryServiceHelper.exists((String)"cal_voucher", (QFilter[])new QFilter[]{q})) {
                return ResManager.loadKDString((String)"\u7531\u5e94\u4ed8\u53cd\u5199\u751f\u6210\u7684\u6b63\u5f0f\u51ed\u8bc1\u4e0d\u5141\u8bb8\u624b\u5de5\u5220\u9664\u3002", (String)"DeleteVoucherValidHelper_0", (String)"fi-cal-common", (Object[])new Object[0]);
            }
        }
        if (costRecords == null) {
            return ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u672a\u751f\u6210\u6b63\u5f0f\u51ed\u8bc1\u3002", (String)"DeleteVoucherValidHelper_5", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        for (DynamicObject costRecord : costRecords) {
            String error = helper.doValidate(costRecord, true);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    public String doTempValidate(DynamicObjectCollection costRecords, long voucherId, PeriodVoucherValidHelper helper, Map<Long, DynamicObject> vocherPeriodMap) {
        if (costRecords == null) {
            return ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u672a\u751f\u6210\u6682\u4f30\u51ed\u8bc1\u3002", (String)"DeleteVoucherValidHelper_6", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        DynamicObject voucher = null;
        if (vocherPeriodMap == null) {
            try {
                voucher = BusinessDataServiceHelper.loadSingle((Object)voucherId, (String)"gl_voucher", (String)"period.begindate,period.enddate,period.periodyear,period.periodnumber");
            }
            catch (Exception e) {
                WriteLogHelper.writeErrorLog(logger, e);
            }
            if (voucher == null) {
                return ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5c1a\u672a\u751f\u6210\u6682\u4f30\u51ed\u8bc1\u6216\u51ed\u8bc1\u5df2\u5220\u9664\u3002", (String)"DeleteVoucherValidHelper_10", (String)"fi-cal-common", (Object[])new Object[0]);
            }
        }
        HashMap<String, ArrayList<String>> billMap = new HashMap<String, ArrayList<String>>(costRecords.size());
        HashSet<Long> costAccounts = new HashSet<Long>(costRecords.size());
        HashSet<Long> bizBillIds = new HashSet<Long>(costRecords.size());
        for (DynamicObject costRecord : costRecords) {
            costAccounts.add(costRecord.getLong("costaccount"));
            bizBillIds.add(costRecord.getLong("bizbillid"));
        }
        QFilter q = new QFilter("costaccount", "in", costAccounts);
        q.and("bizbillid", "in", bizBillIds);
        q.and("isdischargevoucher", "=", (Object)Character.valueOf('1'));
        q.and("issplitcreate", "=", (Object)Character.valueOf('1'));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,costaccount,bizbillid,billno", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                String key = row.getLong("costaccount") + "_" + row.getLong("bizbillid");
                ArrayList<String> billNoList = (ArrayList<String>)billMap.get(key);
                if (billNoList == null) {
                    billNoList = new ArrayList<String>(16);
                    billMap.put(key, billNoList);
                }
                billNoList.add(row.getString("billno"));
            }
        }
        for (DynamicObject costRecord : costRecords) {
            String error;
            String dischargeType = costRecord.getString("dischargetype");
            if (DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargeType)) {
                if (this.compareVoucherPeriod(costRecord, voucherId, voucher, helper.getAllCurPeriod(), vocherPeriodMap)) {
                    return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u6708\u521d\u4e00\u6b21\u51b2\u56de\u201d\uff0c\u6682\u4f30\u51ed\u8bc1\u7684\u671f\u95f4\u5c0f\u4e8e\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"DeleteVoucherValidHelper_1", (String)"fi-cal-common", (Object[])new Object[0]);
                }
            } else if (DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType)) {
                if (this.compareVoucherPeriod(costRecord, voucherId, voucher, helper.getAllCurPeriod(), vocherPeriodMap)) {
                    return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u5355\u5230\u51b2\u56de\u201d\uff0c\u6682\u4f30\u51ed\u8bc1\u7684\u671f\u95f4\u5c0f\u4e8e\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"DeleteVoucherValidHelper_2", (String)"fi-cal-common", (Object[])new Object[0]);
                }
                String key = costRecord.getLong("costaccount") + "_" + costRecord.getLong("bizbillid");
                List billNoList = (List)billMap.get(key);
                if (billNoList != null && !billNoList.isEmpty()) {
                    StringBuilder billNos = new StringBuilder();
                    for (String billno : billNoList) {
                        billNos.append(billno).append(",");
                    }
                    String content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\u5df2\u751f\u6210\u51b2\u56de\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u6682\u4f30\u51ed\u8bc1\u3002", (String)"DataCheckConstant_10", (String)"fi-cal-common", (Object[])new Object[0]), billNos.substring(0, billNos.length() - 1));
                    return content;
                }
            }
            if ((error = helper.doTempValidate(costRecord)) == null) continue;
            return error;
        }
        return null;
    }

    public String doDischargeValidate(DynamicObjectCollection costRecords, long voucherId, PeriodVoucherValidHelper helper) {
        DynamicObject voucher = null;
        try {
            voucher = BusinessDataServiceHelper.loadSingle((Object)voucherId, (String)"gl_voucher", (String)"id");
        }
        catch (Exception e) {
            WriteLogHelper.writeErrorLog(logger, e);
        }
        if (voucher == null) {
            return ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5c1a\u672a\u751f\u6210\u51b2\u56de\u51ed\u8bc1\u6216\u51ed\u8bc1\u5df2\u5220\u9664\u3002", (String)"DeleteVoucherValidHelper_12", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        if (costRecords == null) {
            return ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u672a\u751f\u6210\u51b2\u56de\u51ed\u8bc1\u3002", (String)"DeleteVoucherValidHelper_7", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        for (DynamicObject costRecord : costRecords) {
            String dischargeType = costRecord.getString("dischargetype");
            boolean isInitBill = costRecord.getBoolean("isinitbill");
            boolean isSplitCreate = costRecord.getBoolean("issplitcreate");
            if (!(DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType) || DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargeType) && isInitBill && !isSplitCreate)) {
                return ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u624b\u5de5\u5220\u9664\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\u7684\u51b2\u56de\u51ed\u8bc1\u3002", (String)"DeleteVoucherValidHelper_4", (String)"fi-cal-common", (Object[])new Object[0]);
            }
            String error = helper.doDischargeValidate(costRecord);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    public String doCarryOverValidate(DynamicObjectCollection costRecords, long voucherId, PeriodVoucherValidHelper voucherHelper) {
        DynamicObject voucher = null;
        try {
            voucher = BusinessDataServiceHelper.loadSingle((Object)voucherId, (String)"gl_voucher", (String)"id");
        }
        catch (Exception e) {
            WriteLogHelper.writeErrorLog(logger, e);
        }
        if (voucher == null) {
            return ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5c1a\u672a\u751f\u6210\u7ed3\u8f6c\u51ed\u8bc1\u6216\u51ed\u8bc1\u5df2\u5220\u9664\u3002", (String)"DeleteVoucherValidHelper_13", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        if (costRecords == null) {
            return ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u672a\u751f\u6210\u7ed3\u8f6c\u51ed\u8bc1\u3002", (String)"DeleteVoucherValidHelper_8", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        PeriodVoucherValidHelper helper = new PeriodVoucherValidHelper(this.costAccountIdSet);
        for (DynamicObject costRecord : costRecords) {
            String error = helper.doSaleCarryOverValidate(costRecord, true);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    public String doFeeValidate(DynamicObjectCollection costRecords, long voucherId, PeriodVoucherValidHelper helper) {
        DynamicObject voucher = null;
        try {
            voucher = BusinessDataServiceHelper.loadSingle((Object)voucherId, (String)"gl_voucher", (String)"id");
        }
        catch (Exception e) {
            WriteLogHelper.writeErrorLog(logger, e);
        }
        if (voucher == null) {
            return ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u5c1a\u672a\u751f\u6210\u8d39\u7528\u51ed\u8bc1\u6216\u51ed\u8bc1\u5df2\u5220\u9664\u3002", (String)"DeleteVoucherValidHelper_14", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        if (costRecords == null) {
            return ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u672a\u751f\u6210\u8d39\u7528\u51ed\u8bc1\u3002", (String)"DeleteVoucherValidHelper_9", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        for (DynamicObject costRecord : costRecords) {
            String error = helper.doFeeValidate(costRecord, true);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private boolean compareVoucherPeriod(DynamicObject costRecord, long voucherId, DynamicObject voucher, Map<Long, DynamicObject> allCurPeriod, Map<Long, DynamicObject> vocherPeriodMap) {
        Long costAccount = costRecord.getLong("costAccount");
        DynamicObject vocherPeriod = null;
        vocherPeriod = null == vocherPeriodMap ? voucher.getDynamicObject("period") : vocherPeriodMap.get(voucherId);
        DynamicObject curPeriod = allCurPeriod.get(costAccount);
        return PeriodHelper.compare2period(vocherPeriod, curPeriod) == -1;
    }

    public Map<Long, DynamicObjectCollection> getVoucherRecordColMap() {
        return this.voucherRecordColMap;
    }

    public void setVoucherRecordColMap(Map<Long, DynamicObjectCollection> voucherRecordColMap) {
        this.voucherRecordColMap = voucherRecordColMap;
    }
}

