/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.fi.cal.common.metadata.DecimalElement;
import kd.fi.cal.common.metadata.Element;
import kd.fi.cal.common.metadata.EntryElement;

public class DynamicFieldCreateHelper {
    public static void dynAddElementCostFields(DynamicObjectCollection costSubElements, IFormView view, String entity, DynamicObject currency) {
        ArrayList<Element> elementList = new ArrayList<Element>(16);
        for (DynamicObject costSubElement : costSubElements) {
            DynamicObject item = costSubElement.getDynamicObject("fbasedataid");
            String number = item.getString("number").toLowerCase();
            String name = item.getString("name");
            String unitDisplayName = String.format(ResManager.loadKDString((String)"%s\u5b50\u8981\u7d20\u5355\u4f4d\u5b9e\u9645\u6210\u672c", (String)"DynamicFieldCreateHelper_0", (String)"fi-cal-common", (Object[])new Object[0]), name);
            DecimalElement unitCostElement = new DecimalElement(number + "_unitcost", unitDisplayName, currency.getInt("priceprecision"));
            elementList.add(unitCostElement);
            String costDisplayName = String.format(ResManager.loadKDString((String)"%s\u5b50\u8981\u7d20\u5b9e\u9645\u6210\u672c", (String)"DynamicFieldCreateHelper_1", (String)"fi-cal-common", (Object[])new Object[0]), name);
            DecimalElement costElement = new DecimalElement(number + "_cost", costDisplayName, currency.getInt("amtprecision"));
            elementList.add(costElement);
        }
        IPageCache pageCache = view.getPageCache();
        DynamicFieldCreateHelper.cacheEntryElement(elementList, pageCache, entity);
        DynamicFieldCreateHelper.getEntryElement(pageCache, entity).build(view);
        view.getModel().setDataChanged(false);
    }

    public static EntryElement getEntryElement(IPageCache pageCache, String entity) {
        String elements = pageCache.get("entry_element");
        if (elements == null) {
            ArrayList<Element> elementList = new ArrayList<Element>(16);
            return DynamicFieldCreateHelper.cacheEntryElement(elementList, pageCache, entity);
        }
        EntryElement entryElement = (EntryElement)ThreadCache.get((Object)"entryElement");
        if (entryElement == null) {
            entryElement = (EntryElement)SerializationUtils.deSerializeFromBase64((String)elements);
            ThreadCache.put((Object)"entryElement", (Object)entryElement);
        }
        return entryElement;
    }

    public static EntryElement cacheEntryElement(List<Element> elementList, IPageCache pageCache, String entity) {
        EntryElement entryElement = new EntryElement("entryentity", entity);
        entryElement.setItems(elementList);
        String s = SerializationUtils.serializeToBase64((Object)entryElement);
        pageCache.put("entry_element", s);
        ThreadCache.put((Object)"entryElement", (Object)entryElement);
        return entryElement;
    }
}

