/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ExchangeRateHelper {
    private static final Log logger = LogFactory.getLog(ExchangeRateHelper.class);
    private DynamicObject currency;
    private DynamicObject localcurrency;
    private DynamicObject costAccount;
    private Date bizDate;
    private long exratetableID = 0L;
    private long currencyID = 0L;
    private long localCurrencyID = 0L;
    private long costAccountID = 0L;
    private Map<String, String> convertModeMap = new HashMap<String, String>();

    public ExchangeRateHelper(DynamicObject currency, DynamicObject localcurrency, DynamicObject costAccount, Date bizDate) {
        this.currency = currency;
        this.localcurrency = localcurrency;
        this.costAccount = costAccount;
        this.bizDate = bizDate;
    }

    public ExchangeRateHelper(DynamicObject currency, DynamicObject localcurrency, DynamicObject costAccount, Date bizDate, long exratetableID) {
        this.currency = currency;
        this.localcurrency = localcurrency;
        this.costAccount = costAccount;
        this.bizDate = bizDate;
        this.exratetableID = exratetableID;
    }

    public ExchangeRateHelper(long currency, long localcurrency, long costAccount, Date bizDate) {
        this.currencyID = currency;
        this.localCurrencyID = localcurrency;
        this.costAccountID = costAccount;
        this.bizDate = bizDate;
    }

    public ExchangeRateHelper(long currency, long localcurrency, long costAccount, Date bizDate, long exratetableID) {
        this.currencyID = currency;
        this.localCurrencyID = localcurrency;
        this.costAccountID = costAccount;
        this.bizDate = bizDate;
        this.exratetableID = exratetableID;
    }

    private void init() {
        if (this.costAccountID == 0L) {
            this.costAccountID = this.costAccount.getLong("id");
        }
        QFilter filter = new QFilter("id", "=", (Object)this.costAccountID);
        this.costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,number,name,calpolicy,calpolicy.exratetable,calpolicy.convertmode", (QFilter[])new QFilter[]{filter});
        if (this.currencyID == 0L) {
            this.currencyID = this.currency.getLong("id");
        }
        if (this.localCurrencyID == 0L) {
            this.localCurrencyID = this.localcurrency.getLong("id");
        }
        if (this.exratetableID == 0L) {
            this.exratetableID = this.costAccount.getLong("calpolicy.exratetable");
        }
    }

    public BigDecimal getExchangeRate() {
        this.init();
        boolean isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)this.currencyID, (Long)this.localCurrencyID, (Date)this.bizDate);
        this.convertModeMap.put("exchangeRate", isIndirect ? "2" : "1");
        if (this.currencyID == this.localCurrencyID) {
            return BigDecimal.ONE;
        }
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)this.currencyID, (Long)this.localCurrencyID, (Long)this.exratetableID, (Date)this.bizDate, (boolean)isIndirect);
        return exchangeRate;
    }

    public Map<String, BigDecimal> getExchangeRate4TargetUSD() {
        this.init();
        boolean isIndirect4TargetUSD = BaseDataServiceHelper.getRateConversionConfig((Long)this.currencyID, (Long)6L, (Date)this.bizDate);
        BigDecimal exchangeRate4TargetUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)this.currencyID, (Long)6L, (Long)this.exratetableID, (Date)this.bizDate, (boolean)isIndirect4TargetUSD);
        boolean isIndirect4sourceUSD = BaseDataServiceHelper.getRateConversionConfig((Long)6L, (Long)this.localCurrencyID, (Date)this.bizDate);
        BigDecimal exchangeRate4sourceUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)6L, (Long)this.localCurrencyID, (Long)this.exratetableID, (Date)this.bizDate, (boolean)isIndirect4sourceUSD);
        this.convertModeMap.put("exchangeRate4TargetUSD", isIndirect4TargetUSD ? "2" : "1");
        this.convertModeMap.put("exchangeRate4sourceUSD", isIndirect4sourceUSD ? "2" : "1");
        if (exchangeRate4TargetUSD == null) {
            String content = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5e01\u79cd\u201c%1$s\u201d\u4e0e\u672c\u4f4d\u5e01\u201c%2$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u5e76\u4e14\u4ea4\u6613\u5e01\u79cd\u201c%3$s\u201d\u4e0e\u201c\u7f8e\u5143\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u3002", (String)"ExchangeRateHelper_6", (String)"fi-cal-common", (Object[])new Object[0]), this.currency.getString("name"), this.localcurrency.getString("name"), this.currency.getString("name"));
            throw new KDBizException(content);
        }
        if (exchangeRate4sourceUSD == null) {
            String content = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5e01\u79cd\u201c%1$s\u201d\u4e0e\u672c\u4f4d\u5e01\u201c%2$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u5e76\u4e14\u201c\u7f8e\u5143\u201d\u4e0e\u672c\u4f4d\u5e01\u201c%3$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u3002", (String)"ExchangeRateHelper_7", (String)"fi-cal-common", (Object[])new Object[0]), this.currency.getString("name"), this.localcurrency.getString("name"), this.localcurrency.getString("name"));
            throw new KDBizException(content);
        }
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        retMap.put("exchangeRate4TargetUSD", exchangeRate4TargetUSD);
        retMap.put("exchangeRate4sourceUSD", exchangeRate4sourceUSD);
        return retMap;
    }

    public BigDecimal getTargetAmount(BigDecimal exchangeRate, BigDecimal sourceAmount, int amtPrecision, String convertMode) {
        BigDecimal targetAmount = BigDecimal.ZERO;
        if (sourceAmount == null || sourceAmount.compareTo(BigDecimal.ZERO) == 0) {
            return targetAmount;
        }
        if (exchangeRate != null) {
            targetAmount = "1".equals(convertMode) ? sourceAmount.multiply(exchangeRate).setScale(amtPrecision, 4) : sourceAmount.divide(exchangeRate, amtPrecision, 4);
        }
        return targetAmount;
    }

    public Map<String, String> getConvertModeMap() {
        return this.convertModeMap;
    }
}

