/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.common.helper.CostElementHelper;

public class ExpenseItemSubElementHelper {
    private Map<String, Long> cacheMap = new HashMap<String, Long>();
    private Map<Long, DynamicObject> elementMap = new HashMap<Long, DynamicObject>();

    public Long getSubElement(Long costTypeId, Long materialId, boolean calbycostelement, Long expenseItemId) {
        if (!calbycostelement) {
            return 773175233367685120L;
        }
        String key = costTypeId + "|" + materialId + "|" + expenseItemId;
        Long subElement = this.cacheMap.get(key);
        if (subElement != null) {
            return subElement;
        }
        subElement = this.getExpenseItemSubElement(costTypeId, expenseItemId);
        this.cacheMap.put(key, subElement);
        return subElement;
    }

    public DynamicObject getElementBySubId(Long subElementId) {
        if (this.elementMap.isEmpty()) {
            DynamicObject[] relationCol;
            for (DynamicObject relation : relationCol = BusinessDataServiceHelper.load((String)"cad_elementdetail", (String)"element,subelement", null)) {
                Long subelementId = relation.getDynamicObject("subelement") == null ? 0L : relation.getDynamicObject("subelement").getLong("id");
                this.elementMap.put(subelementId, relation.getDynamicObject("element"));
            }
        }
        return this.elementMap.get(subElementId);
    }

    private Long getExpenseItemSubElement(Long costTypeId, Long expenseItemId) {
        if (costTypeId == null) {
            return CostElementHelper.getDefaultElement();
        }
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and("expenseitem", "=", (Object)expenseItemId);
        DynamicObject relation = BusinessDataServiceHelper.loadSingle((String)"cad_subelemententry", (String)"id,subelement", (QFilter[])filter.toArray());
        if (relation == null) {
            return CostElementHelper.getDefaultElement();
        }
        return relation.getDynamicObject("subelement").getLong("id");
    }
}

