/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.util.ExcelHelper;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.bos.web.actions.export.ExportWriterFormat;
import kd.fi.cal.common.helper.WriteLogHelper;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

@Deprecated
public class ExportWriter {
    private static final Log logger = LogFactory.getLog(ExportWriter.class);
    private static final String RESULT = "result";
    private static final String EXTEND = "extend";
    private static final String BOS_WEBACTIONS = "bos-webactions";
    private static Log log = LogFactory.getLog(ExportWriter.class);
    private static final String[] sources = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String COLWIDTH_KEY = "ColWidth";
    private static final String INPUTVALUES = "InputValues";

    @Deprecated
    public static void writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, ExportWriterFormat format) {
        ExportWriter.writeHeader(wb, sheet, new ExportSheetStyle(wb), format);
    }

    @Deprecated
    public static void writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, ExportWriterFormat format) {
        ExportWriter.writeHeader(wb, sheet, styles, Collections.singletonList(format));
    }

    public static void writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, List<ExportWriterFormat> formats) {
        SXSSFSheet dropdownSheet = wb.createSheet("dropdown_items_sheet");
        SXSSFSheet dropdownBaseDataValuesSheet = wb.createSheet("basedata_items_sheet");
        dropdownSheet.setRandomAccessWindowSize(-1);
        dropdownBaseDataValuesSheet.setRandomAccessWindowSize(-1);
        int offset = 0;
        for (ExportWriterFormat format : formats) {
            offset = ExportWriter.writeHeader(wb, sheet, dropdownSheet, dropdownBaseDataValuesSheet, styles, format, offset);
        }
        wb.setSheetHidden(wb.getSheetIndex("dropdown_items_sheet"), true);
        wb.setSheetHidden(wb.getSheetIndex("basedata_items_sheet"), true);
    }

    private static int writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, SXSSFSheet dropdownSheet, SXSSFSheet basedataSheet, ExportSheetStyle styles, ExportWriterFormat format, int preOffset) {
        SXSSFRow entityRow = ExportWriter.getRow(sheet, 0);
        SXSSFRow commentRow = ExportWriter.getRow(sheet, 1);
        SXSSFRow nameRow = ExportWriter.getRow(sheet, 2);
        SXSSFRow titleRow = ExportWriter.getRow(sheet, 3);
        if (format.getHideFieldRow().booleanValue()) {
            entityRow.setHidden(Boolean.valueOf(true));
            commentRow.setHidden(Boolean.valueOf(true));
            nameRow.setHidden(Boolean.valueOf(true));
        }
        if (styles.getEntityRow() == null || styles.getNameRow() == null) {
            styles.reference(entityRow, nameRow);
        }
        ExportWriter.createCell(wb, entityRow, format.col + preOffset, format.displayName != null && format.displayName.startsWith("*") ? styles.getTextHighLightStyle() : styles.getTextStyle()).setCellValue(format.displayName + " # " + format.name);
        int offset = preOffset;
        String caption = "";
        for (int i = 0; i < format.fields.size(); ++i) {
            String fieldName = (String)format.fields.get(i);
            Map property = (Map)format.properties.get(fieldName);
            boolean mustInput = false;
            Object inputType = null;
            if (property != null) {
                String propName;
                mustInput = Boolean.TRUE.equals(property.get("MustInput"));
                inputType = property.get("InputType");
                if ("id".equals(inputType)) {
                    fieldName = fieldName.replace('.', '_');
                    sheet.setDefaultColumnStyle(format.col + offset, styles.getTextStyle());
                } else if (inputType instanceof JSONArray) {
                    ArrayList<String> items = new ArrayList<String>();
                    ((JSONArray)inputType).forEach(obj -> items.add(obj.toString().split(" # ", -1)[0]));
                    if (!items.isEmpty() && !"MulComboProp".equals(property.get("PropType"))) {
                        ExportWriter.createDropDownSheet(sheet, dropdownSheet, format, offset, items, "dropdown_items_sheet!$%s$%d:$%s$%d");
                    }
                } else if ("date".equals(inputType)) {
                    sheet.setDefaultColumnStyle(format.col + offset, styles.getDateStyle());
                } else if ("datetime".equals(inputType)) {
                    sheet.setDefaultColumnStyle(format.col + offset, styles.getDatetimeStyle());
                } else if ("decimal".equals(inputType)) {
                    sheet.setDefaultColumnStyle(format.col + offset, styles.getDecimalStyle(wb, (Map)property.get("DecimalFormat")));
                } else {
                    if (ExportWriter.multipleColumnsField(inputType).booleanValue()) {
                        List splitCols = (List)format.flexColumn.get(fieldName);
                        List<String> propList = ExportWriter.getPropList(splitCols);
                        List splitColDisplayNames = (List)format.flexColumnDisplay.get(fieldName);
                        List splitColDesc = (List)format.flexColumnDesc.get(fieldName);
                        if (splitCols == null) continue;
                        for (int j = 0; j < splitCols.size(); ++j) {
                            boolean isImportPropValid;
                            Object colWidth;
                            String displayName = ExportWriter.dealDisplayName(j, format.getExchangeNameAndMark(), property, splitCols, splitColDisplayNames);
                            caption = (j == 0 && mustInput ? "*" : "") + displayName;
                            sheet.setDefaultColumnStyle(format.col + offset, styles.getTextStyle());
                            ExportWriter.createCell(wb, nameRow, format.col + offset, styles.getTextStyle()).setCellValue((String)splitCols.get(j));
                            SXSSFCell cell = ExportWriter.createCell(wb, titleRow, format.col + offset, j == 0 && mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle());
                            cell.setCellValue(caption);
                            if (j < splitColDesc.size()) {
                                ExportWriter.bindCellTip(sheet, cell, format.col + offset, 3, (String)splitColDesc.get(j));
                            }
                            int designatedColWidth = (colWidth = property.get(COLWIDTH_KEY)) instanceof Integer ? (Integer)colWidth : 0;
                            sheet.setColumnWidth(format.col + offset, ExportWriter.calcColumnWidth(caption, designatedColWidth));
                            ExportWriter.writeComment(wb, commentRow, format, styles, property, (String)splitCols.get(j), propList, offset);
                            Object inputValues = property.get(INPUTVALUES);
                            Object ImportProp = property.get("ImportProp");
                            boolean hasInputValues = inputValues instanceof List && !((List)inputValues).isEmpty();
                            boolean bl = isImportPropValid = ImportProp instanceof List && !((List)ImportProp).isEmpty();
                            if (hasInputValues && isImportPropValid) {
                                List inputValuesList = (List)inputValues;
                                List importPropList = (List)ImportProp;
                                if (((String)splitCols.get(j)).contains((CharSequence)importPropList.get(0))) {
                                    ExportWriter.createDropDownSheet(sheet, basedataSheet, format, offset, inputValuesList, "basedata_items_sheet!$%s$%d:$%s$%d");
                                }
                            }
                            ++offset;
                        }
                        continue;
                    }
                    sheet.setDefaultColumnStyle(format.col + offset, styles.getTextStyle());
                }
                String displayName = (String)property.get("DisplayName");
                String string = propName = property.get("propName") instanceof String ? (String)property.get("propName") : "";
                if (format.getExchangeNameAndMark().booleanValue() && StringUtils.isNotBlank(property.get("EntityDescription"))) {
                    String descValue = (String)property.get("EntityDescription");
                    displayName = ExportWriter.getRealDescByInputType(descValue, property, null, propName);
                }
                caption = (mustInput ? "*" : "") + displayName;
                ExportWriter.writeComment(wb, commentRow, format, styles, property, propName, null, offset);
            }
            ExportWriter.createCell(wb, nameRow, format.col + offset, styles.getTextStyle()).setCellValue(fieldName);
            SXSSFCell cell = ExportWriter.createCell(wb, titleRow, format.col + offset, mustInput ? styles.getTitleMustInputStyle() : styles.getTitleStyle());
            cell.setCellValue(caption);
            if (format.col + offset != 0) {
                Object colWidth = property.get(COLWIDTH_KEY);
                int designatedColWidth = colWidth instanceof Integer ? (Integer)colWidth : 0;
                sheet.setColumnWidth(format.col + offset, ExportWriter.calcColumnWidth(caption, designatedColWidth));
            }
            if (property != null && property.containsKey("InputDesc")) {
                String tip = property.getOrDefault("InputDesc", "");
                ExportWriter.bindCellTip(sheet, cell, format.col + offset, 3, tip);
            }
            ++offset;
        }
        for (ExportWriterFormat wr : format.next) {
            offset += ExportWriter.writeHeader(wb, sheet, dropdownSheet, basedataSheet, styles, wr, preOffset);
        }
        return offset;
    }

    private static void createDropDownSheet(SXSSFSheet sheet, SXSSFSheet dropSheet, ExportWriterFormat format, int offset, List<String> inputValuesList, String formatString) {
        int currCol = format.col + offset;
        for (int k = 0; k < inputValuesList.size(); ++k) {
            ExportWriter.getRow(dropSheet, k).createCell(currCol).setCellValue(inputValuesList.get(k));
        }
        String currColLabel = ExportWriter.getColumnLabel(currCol + 1);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(4, 10000, currCol, currCol);
        String strFormula = String.format(formatString, currColLabel, 1, currColLabel, inputValuesList.size());
        DataValidationConstraint constraint = helper.createFormulaListConstraint(strFormula);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    public static String dealDisplayName(int j, Boolean exchangeNameAndMark, Map<String, Object> property, List<String> splitCols, List<String> splitColDisplayNames) {
        boolean isFlexOrLargetext;
        boolean containSpecilKey;
        String inputType = (String)property.get("InputType");
        String displayName = splitColDisplayNames.get(j);
        String description = (String)property.get("EntityDescription");
        String columnNumber = splitCols.get(j);
        List<String> propList = ExportWriter.getPropList(splitCols);
        String curLangKey = Lang.get().toString();
        Map<String, Map<String, String>> langPropDesMapping = ExportWriter.getLangPropDesMapping(description, propList);
        Map<String, String> propDesMapping = langPropDesMapping.get(curLangKey);
        if (propDesMapping == null) {
            return displayName;
        }
        boolean bl = containSpecilKey = propDesMapping.size() > 0;
        if (columnNumber.contains(".")) {
            columnNumber = columnNumber.substring(columnNumber.indexOf(".") + 1);
        }
        String curLangDes = propDesMapping.get(columnNumber);
        boolean bl2 = isFlexOrLargetext = "flex".equals(inputType) || "largetext".equals(inputType);
        if (isFlexOrLargetext) {
            Optional<String> firstValue = propDesMapping.values().stream().findFirst();
            curLangDes = firstValue.orElse(curLangDes);
        }
        if (exchangeNameAndMark.booleanValue() && StringUtils.isNotBlank((CharSequence)curLangDes)) {
            property.put("splitColumnName", displayName);
            String suffix = !containSpecilKey && displayName.contains(".") ? displayName.substring(displayName.indexOf(".")) : "";
            displayName = curLangDes + suffix;
        }
        return displayName;
    }

    public static List<String> getPropList(List<String> splitCols) {
        ArrayList<String> propList = new ArrayList<String>(splitCols.size());
        for (String splitCol : splitCols) {
            if (splitCol.contains(".")) {
                splitCol = splitCol.substring(splitCol.indexOf(".") + 1);
            }
            propList.add(splitCol);
        }
        return propList;
    }

    private static List<String> getEnabledLangList() {
        List enabledLang = InteServiceHelper.getMultiLangEnabledLang();
        ArrayList<String> langList = new ArrayList<String>(enabledLang.size());
        for (EnabledLang lang : enabledLang) {
            langList.add(lang.getNumber());
        }
        return langList;
    }

    private static void createCellAndWriteComment() {
    }

    public static Map<String, Map<String, String>> getLangPropDesMapping(String des, List<String> keyList) {
        Map<String, Map<String, String>> langPropDesMapping = null;
        boolean newFormatJsonString = false;
        try {
            langPropDesMapping = (Map<String, Map<String, String>>)SerializationUtils.fromJsonString((String)des, Map.class);
            newFormatJsonString = true;
        }
        catch (Exception formatException) {
            log.info("format des to langPropDesMapping fail , source des is " + des);
            WriteLogHelper.writeErrorLog(logger, "CalculateOutRptFilterListPlugin-setDivFields", formatException);
        }
        if (newFormatJsonString) {
            return langPropDesMapping;
        }
        langPropDesMapping = ExportWriter.getLangPropDesMappingFormOldFormat(des, keyList);
        return langPropDesMapping;
    }

    private static Map<String, Map<String, String>> getLangPropDesMappingFormOldFormat(String des, List<String> keyList) {
        List<String> enabledLangList = ExportWriter.getEnabledLangList();
        LinkedHashMap<String, Map<String, String>> langPropDesMapping = new LinkedHashMap<String, Map<String, String>>(enabledLangList.size());
        for (String langNumber : enabledLangList) {
            Map<String, String> propDesMapping = ExportWriter.getKeyDesMapping(des, keyList);
            langPropDesMapping.put(langNumber, propDesMapping);
        }
        return langPropDesMapping;
    }

    private static Map<String, String> getKeyDesMapping(String des, List<String> keyList) {
        if (des == null) {
            des = "";
        }
        LinkedHashMap<String, String> keyDesMapping = new LinkedHashMap<String, String>(keyList.size());
        HashMap<String, Integer> keyIndexMapping = new HashMap<String, Integer>(keyList.size());
        for (String key : keyList) {
            String langKey = "#" + key;
            if (!des.contains(langKey)) continue;
            keyIndexMapping.put(langKey, des.indexOf(langKey));
        }
        if (keyIndexMapping.size() == 0 || des.equals("")) {
            for (String key : keyList) {
                keyDesMapping.put(key, des);
            }
            return keyDesMapping;
        }
        List<Map.Entry<String, Integer>> langKeyIndexMappingList = ExportWriter.sortMap(keyIndexMapping);
        for (int i = 0; i < langKeyIndexMappingList.size(); ++i) {
            Map.Entry<String, Integer> curEntry = langKeyIndexMappingList.get(i);
            String curLangNumberKey = curEntry.getKey();
            if (i == langKeyIndexMappingList.size() - 1) {
                String curLangDes = des.substring(curEntry.getValue() + curLangNumberKey.length());
                keyDesMapping.put(curEntry.getKey().substring(1), curLangDes);
                break;
            }
            Map.Entry<String, Integer> nextEntry = langKeyIndexMappingList.get(i + 1);
            String curLangDes = des.substring(curEntry.getValue() + curLangNumberKey.length(), nextEntry.getValue());
            keyDesMapping.put(curEntry.getKey().substring(1), curLangDes);
        }
        return keyDesMapping;
    }

    private static List<Map.Entry<String, Integer>> sortMap(Map<String, Integer> langKeyIndexMapping) {
        ArrayList<Map.Entry<String, Integer>> entryList = new ArrayList<Map.Entry<String, Integer>>(langKeyIndexMapping.entrySet());
        Collections.sort(entryList, Comparator.comparingInt(Map.Entry::getValue));
        return entryList;
    }

    private static void bindCellTip(SXSSFSheet sheet, SXSSFCell cell, int colSeq, int rowSeq, String tip) {
        if (StringUtils.isBlank((CharSequence)tip)) {
            return;
        }
        SXSSFDrawing p = sheet.createDrawingPatriarch();
        Comment comment = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)colSeq), rowSeq, (short)colSeq + 2, rowSeq + 3));
        comment.setString((RichTextString)new XSSFRichTextString(tip));
        cell.setCellComment(comment);
    }

    private static void writeComment(SXSSFWorkbook wb, SXSSFRow commentRow, ExportWriterFormat format, ExportSheetStyle styles, Map<String, Object> property, String columnNumber, List<String> propList, int offset) {
        String entityDesc = (String)property.get("EntityDescription");
        entityDesc = ExportWriter.getRealDescByInputType(entityDesc, property, propList, columnNumber);
        if (format.getExchangeNameAndMark().booleanValue() && StringUtils.isNotBlank((CharSequence)entityDesc)) {
            String string = entityDesc = StringUtils.isNotBlank((Object)property.get("splitColumnName")) ? (String)property.get("splitColumnName") : (String)property.get("DisplayName");
        }
        if (format.col + offset == 0) {
            StringBuilder tips = ExportWriter.buildTips(format, commentRow, entityDesc, property);
            CellStyle textHighLightStyle = styles.getTextHighLightStyle();
            textHighLightStyle.setVerticalAlignment(VerticalAlignment.TOP);
            textHighLightStyle.setWrapText(true);
            ExportWriter.createCell(wb, commentRow, 0, textHighLightStyle).setCellValue(tips.toString());
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            ExportWriter.createCell(wb, commentRow, format.col + offset, styles.getTextStyle()).setCellValue(entityDesc);
        }
    }

    public static String getRealDescByInputType(String entityDesc, Map<String, Object> property, List<String> propList, String columnNumber) {
        boolean isFlexOrLargetext;
        Map<String, Map<String, String>> langPropDesMapping;
        Map<String, String> propDesMapping;
        if (columnNumber.contains(".")) {
            columnNumber = columnNumber.substring(columnNumber.indexOf(".") + 1);
        }
        Object inputType = property.get("InputType");
        String curLangKey = Lang.get().toString();
        if (propList == null || propList.isEmpty()) {
            propList = new ArrayList<String>(1);
            propList.add(columnNumber);
        }
        if ((propDesMapping = (langPropDesMapping = ExportWriter.getLangPropDesMapping(entityDesc, propList)).get(curLangKey)) == null) {
            return "";
        }
        entityDesc = propDesMapping.get(columnNumber);
        boolean bl = isFlexOrLargetext = "flex".equals(inputType) || "largetext".equals(inputType);
        if (isFlexOrLargetext) {
            Optional<String> firstValue = propDesMapping.values().stream().findFirst();
            entityDesc = firstValue.orElse(entityDesc);
        }
        return entityDesc;
    }

    private static StringBuilder buildTips(ExportWriterFormat format, SXSSFRow commentRow, String entityDesc, Map<String, Object> property) {
        StringBuilder strb = new StringBuilder();
        ArrayList<String> tips = new ArrayList<String>(8);
        tips.add(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"ExportWriter_0", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        tips.add(ResManager.loadKDString((String)"2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"ExportWriter_5", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        if (format.getEnableSetNull().booleanValue()) {
            tips.add(ResManager.loadKDString((String)"#SetNULL\uff08\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5\uff09", (String)"ListDataExporter_9", (String)"bos-export", (Object[])new Object[0]));
        }
        if (format.getSplitSubEntries().booleanValue()) {
            tips.add("#SplitSubEntries");
        }
        if (format.getForUpdateMultiLangFields().booleanValue()) {
            tips.add("#ForUpdateMultiLangFields");
        }
        if (StringUtils.isNotBlank((CharSequence)entityDesc)) {
            tips.add("-----------");
            tips.add(entityDesc);
        }
        int radit = ExportWriter.addTips(strb, tips);
        Optional maxLengthStr = tips.stream().max((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return 1;
            }
            return -1;
        });
        commentRow.setHeightInPoints((float)radit * commentRow.getSheet().getDefaultRowHeightInPoints());
        Object colWidth = property.get(COLWIDTH_KEY);
        int designatedColWidth = colWidth instanceof Integer ? (Integer)colWidth : 0;
        commentRow.getSheet().setColumnWidth(0, ExportWriter.calcColumnWidth(maxLengthStr.orElse(""), designatedColWidth));
        return strb;
    }

    private static int addTips(StringBuilder strb, List<String> tips) {
        for (String tip : tips) {
            strb.append(tip).append("\r\n");
        }
        strb.delete(strb.length() - "\r\n".length(), strb.length());
        return tips.size();
    }

    private static String getColumnLabel(int columnNo) {
        if (columnNo < 1) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append('Z');
            remainder = 26;
        } else {
            sb.append(sources[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(sources[remainder]);
        }
        return sb.reverse().toString();
    }

    private static int calcColumnWidth(String caption, int designatedColWidth) {
        if (designatedColWidth > 0) {
            return designatedColWidth * 32;
        }
        int colWidth = 0;
        try {
            colWidth = 256 * (caption.getBytes("GBK").length + 8);
        }
        catch (UnsupportedEncodingException e) {
            colWidth = 256 * (caption.getBytes(StandardCharsets.UTF_8).length + 8);
            WriteLogHelper.writeErrorLog(logger, "ExportWriter-calcColumnWidth", e);
        }
        return Math.min(colWidth, 51200);
    }

    @Deprecated
    public static int writeData(SXSSFWorkbook wb, SXSSFSheet sheet, JSONObject data, int rowIndex, ExportWriterFormat format, boolean existAttachments, String attachment) {
        return ExportWriter.writeData(wb, sheet, new ExportSheetStyle(wb), data, rowIndex, format, existAttachments, attachment, false);
    }

    @Deprecated
    public static int writeData(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, JSONObject data, int rowIndex, ExportWriterFormat format, boolean existAttachments, String attachment, boolean fillParent) {
        SXSSFRow entityRow = styles.getEntityRow();
        SXSSFRow nameRow = styles.getNameRow();
        if (rowIndex < 4) {
            rowIndex = 4;
        }
        SXSSFRow row = ExportWriter.getRow(sheet, rowIndex);
        int flexRowCount = 0;
        int flexColCount = 0;
        String lastFieldName = null;
        int startCol = format.col;
        int last = ExportWriter.getLastCellNum(sheet, entityRow, startCol + 1, nameRow.getLastCellNum());
        while (startCol < last && nameRow.getCell(startCol) != null) {
            String dataKey;
            String fullName;
            String fieldName = fullName = nameRow.getCell(startCol).getStringCellValue();
            if (StringUtils.isNotBlank((CharSequence)fullName) && (fieldName = fullName.split("\\.")[0]).endsWith("_id")) {
                fieldName = fieldName.substring(0, fieldName.length() - 3) + ".id";
            }
            if (fieldName.equals(lastFieldName)) {
                ++flexColCount;
            } else {
                lastFieldName = fieldName;
                flexColCount = 0;
            }
            Map property = (Map)format.properties.get(fieldName);
            Object dataKeyObj = property.get("DataKey");
            Object inputType = property.get("InputType");
            Object dataObj = "id".equals(inputType) ? data.get((Object)"id") : data.get((Object)fieldName);
            String val = "";
            if (dataObj == null) {
                val = "";
            } else if (dataObj instanceof Boolean) {
                val = Boolean.TRUE.equals(dataObj) ? ResManager.loadKDString((String)"\u662f", (String)"ExportWriter_1", (String)BOS_WEBACTIONS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ExportWriter_2", (String)BOS_WEBACTIONS, (Object[])new Object[0]);
            } else if (dataObj instanceof BigDecimal) {
                val = ((BigDecimal)dataObj).toPlainString();
            } else if (StringUtils.isBlank(dataKeyObj)) {
                val = dataObj.toString();
                if (inputType instanceof JSONArray) {
                    JSONArray inputArrType = (JSONArray)inputType;
                    ArrayList<String> valDesc = new ArrayList<String>();
                    List<String> valSplit = Arrays.asList(val.split(","));
                    String propType = (String)property.get("PropType");
                    for (int i = 0; i < inputArrType.size(); ++i) {
                        Object item = inputArrType.getString(i).split(" # ", -1);
                        if (((String[])item).length <= 1 || !("MulComboProp".equals(propType) ? valSplit.contains(item[1]) : item[1].equals(val))) continue;
                        valDesc.add(item[0]);
                    }
                    if (!valDesc.isEmpty()) {
                        val = String.join((CharSequence)",", valDesc);
                    }
                }
            } else if (dataObj instanceof Map) {
                dataKey = "";
                if (dataKeyObj instanceof String) {
                    dataKey = (String)dataKeyObj;
                } else if (dataKeyObj instanceof JSONArray && ((JSONArray)dataKeyObj).size() > 0) {
                    dataKey = (String)((JSONArray)dataKeyObj).get(flexColCount);
                }
                if (dataKey.indexOf(".") >= 0) {
                    String[] dkeys = dataKey.split("\\.");
                    Object tempVal = ((Map)dataObj).get(dkeys[0]);
                    for (int i = 1; i < dkeys.length && tempVal instanceof Map; ++i) {
                        tempVal = ((Map)tempVal).get(dkeys[i]);
                    }
                    val = (String)tempVal;
                } else {
                    Object dataVal = ((Map)dataObj).get(dataKey);
                    if ("flex".equals(inputType)) {
                        HashMap flexData = (HashMap)dataObj;
                        int flexStartCol = startCol;
                        for (Map.Entry entry : flexData.entrySet()) {
                            ExportWriter.createCell(wb, row, flexStartCol, styles.getTextStyle()).setCellValue((String)entry.getKey());
                            ++flexStartCol;
                            Object flexValue = entry.getValue();
                            if (flexValue instanceof Map) {
                                Map flexMap = (Map)flexValue;
                                ExportWriter.createCell(wb, row, flexStartCol, styles.getTextStyle()).setCellValue(flexMap.get("number") == null ? "" : flexMap.get("number").toString());
                                ExportWriter.createCell(wb, row, ++flexStartCol, styles.getTextStyle()).setCellValue(flexMap.get("name") == null ? "" : flexMap.get("name").toString());
                                ++flexStartCol;
                                continue;
                            }
                            ExportWriter.createCell(wb, row, ++flexStartCol, styles.getTextStyle()).setCellValue((String)entry.getKey());
                            ++flexStartCol;
                        }
                        startCol += ((List)format.flexColumnDesc.get(lastFieldName)).size();
                        continue;
                    }
                    if ("multilang".equals(inputType)) {
                        dataVal = ((Map)dataObj).get(fullName.split("\\.")[1]);
                    }
                    val = dataVal == null ? "" : "" + dataVal;
                }
            } else if (dataObj instanceof List && dataObj != null && !((List)dataObj).isEmpty()) {
                dataKey = "";
                if (dataKeyObj instanceof String) {
                    dataKey = (String)dataKeyObj;
                } else if (dataKeyObj instanceof JSONArray && ((JSONArray)dataKeyObj).size() > 1) {
                    dataKey = fullName.endsWith(".name") ? ((JSONArray)dataKeyObj).getString(1) : ((JSONArray)dataKeyObj).getString(0);
                }
                List listData = (List)dataObj;
                String[] subKeys = dataKey.split("\\.");
                StringBuilder buf = new StringBuilder(StringUtils.isEmpty((CharSequence)val) ? "" : val);
                for (Object item : listData) {
                    buf.append(',');
                    buf.append(item instanceof Map ? ExportWriter.get((Map)item, subKeys) : item);
                }
                val = buf.toString();
                if (val.startsWith(",")) {
                    val = val.substring(1);
                }
            }
            if ("time".equals(inputType)) {
                ExportWriter.createCell(wb, row, startCol, styles.getTextStyle()).setCellValue(ExportWriter.formatTimeStr((Integer)dataObj));
            } else if ("date".equals(inputType)) {
                ExportWriter.createCell(wb, row, startCol, styles.getDateStyle()).setCellValue((String)dataObj);
            } else if ("datetime".equals(inputType)) {
                ExportWriter.createCell(wb, row, startCol, styles.getDatetimeStyle()).setCellValue((String)dataObj);
            } else if ("decimal".equals(inputType)) {
                WriteLogHelper.writeInfoLog(logger, "ExportWriter-writeData==>{}", dataObj);
                BigDecimal decimal = null;
                JSONObject dataMap = null;
                if (dataObj instanceof Map) {
                    dataMap = (JSONObject)JSONObject.toJSON((Object)dataObj);
                    decimal = new BigDecimal(dataMap.getOrDefault((Object)RESULT, (Object)0).toString());
                } else if (StringUtils.isNotBlank((Object)dataObj)) {
                    decimal = new BigDecimal(dataObj.toString());
                }
                if (decimal != null && ExportWriter.isBigDecimal(decimal.toPlainString())) {
                    ExportWriter.createCell(wb, row, startCol, styles.getTextStyle()).setCellValue(decimal.toPlainString());
                } else if (decimal != null) {
                    ExportWriter.createCell(wb, row, startCol, styles.getDecimalStyle(wb, (Map)dataMap)).setCellValue(decimal.doubleValue());
                }
            } else {
                ExportWriter.createCell(wb, row, startCol, styles.getTextStyle()).setCellValue(val);
            }
            ++startCol;
        }
        if (existAttachments && StringUtils.isNotBlank((CharSequence)attachment)) {
            SXSSFCell cell = ExportWriter.createCell(wb, row, nameRow.getLastCellNum() + 1, styles.getTextStyle());
            String zip_attach_url = String.format(ResManager.loadKDString((String)"%1$s_\u9644\u4ef6/pk-%2$s", (String)"ExportWriter_5", (String)"bos-export", (Object[])new Object[0]), attachment, data.getString("id"));
            cell.setCellValue(zip_attach_url);
            XSSFHyperlink link = (XSSFHyperlink)wb.getCreationHelper().createHyperlink(HyperlinkType.FILE);
            link.setAddress(zip_attach_url);
            cell.setHyperlink((Hyperlink)link);
            ExportWriter.bindCellTip(sheet, cell, nameRow.getLastCellNum() + 1, rowIndex, ResManager.loadKDString((String)"\u9884\u89c8\u65f6\u8bf7\u5c06\u9644\u4ef6\u538b\u7f29\u5305\u89e3\u538b\u4e3a\u5f53\u524d\u76ee\u5f55\u4e0b\u7684\u540c\u540d\u6587\u4ef6\u5939", (String)"ExportWriter_4", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            cell.setCellStyle(styles.getHlinkStyle());
        }
        int maxOffset = 0;
        for (ExportWriterFormat wr : format.next) {
            String entityName = entityRow.getCell(wr.col).getStringCellValue();
            if (entityName != null) {
                entityName = entityName.split(" # ")[1];
            }
            if (!data.containsKey((Object)entityName)) continue;
            JSONArray subData = data.getJSONArray(entityName);
            int offset = 0;
            for (int i = 0; i < subData.size(); ++i) {
                int subOffset = ExportWriter.writeData(wb, sheet, styles, subData.getJSONObject(i), rowIndex + offset, wr, false, null, fillParent);
                if (subOffset == 0) {
                    ++offset;
                    continue;
                }
                offset += subOffset;
            }
            if (maxOffset >= offset) continue;
            maxOffset = offset;
        }
        int rowCount = Math.max(flexRowCount, maxOffset);
        if (fillParent) {
            for (int i = 1; i < rowCount; ++i) {
                ExportWriter.fillRow(wb, sheet, styles, format, nameRow, row, ExportWriter.getRow(sheet, rowIndex + i));
            }
        }
        return rowCount;
    }

    private static String formatTimeStr(int time) {
        if (time < 0) {
            return null;
        }
        int second = time % 60;
        int minute = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        return String.format("%02d:%02d:%02d", hour, minute, second);
    }

    private static void fillRow(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, ExportWriterFormat format, SXSSFRow nameRow, SXSSFRow row, SXSSFRow nextRow) {
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int startCol = format.col;
        int last = ExportWriter.getLastCellNum(sheet, styles.getEntityRow(), startCol + 1, nameRow.getLastCellNum());
        while (startCol < last) {
            SXSSFCell oldCell = row.getCell(startCol);
            if (oldCell == null) continue;
            SXSSFCell newCell = ExportWriter.createCell(wb, nextRow, startCol, oldCell.getCellStyle());
            if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.STRING)) {
                newCell.setCellValue(oldCell.getStringCellValue());
            } else if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.NUMERIC)) {
                if (DateUtil.isCellDateFormatted((Cell)oldCell)) {
                    Date dt = DateUtil.getJavaDate((double)oldCell.getNumericCellValue());
                    newCell.setCellValue(sFormat.format(dt));
                } else {
                    newCell.setCellValue(oldCell.getNumericCellValue());
                }
            } else if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.BOOLEAN)) {
                newCell.setCellValue(oldCell.getBooleanCellValue());
            } else if (ExcelHelper.cellEqual((CellType)oldCell.getCellType(), (CellType)CellType.FORMULA)) {
                newCell.setCellValue(oldCell.getCellFormula());
            }
            ++startCol;
        }
    }

    private static Object get(Map<String, Object> map, String[] keys) {
        Map tempMap = map;
        for (int i = 0; i < keys.length - 1; ++i) {
            tempMap = (Map)tempMap.get(keys[i]);
        }
        return tempMap.get(keys[keys.length - 1]);
    }

    private static int getLastCellNum(SXSSFSheet sheet, SXSSFRow entityRow, int col, short last) {
        while (col < last) {
            String nextEntityName;
            SXSSFCell cell = entityRow.getCell(col);
            String string = nextEntityName = cell == null ? null : cell.getStringCellValue();
            if (StringUtils.isNotBlank((CharSequence)nextEntityName)) {
                return col;
            }
            ++col;
        }
        return last;
    }

    public static SXSSFRow getRow(SXSSFSheet sheet, int r) {
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    private static SXSSFCell createCell(SXSSFWorkbook wb, SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    @Deprecated
    public static void writeLine(SXSSFWorkbook wb, SXSSFSheet sheet, TreeMap<Integer, String> title, int r) {
        int col = 0;
        ExportSheetStyle styles = new ExportSheetStyle(wb);
        for (String caption : title.values()) {
            SXSSFCell cell = ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col, styles.getTextStyle());
            cell.setCellStyle(styles.getTitleStyle());
            cell.setCellValue(caption);
            sheet.setColumnWidth(col, Math.min(caption.getBytes(StandardCharsets.UTF_8).length * 2 * 160, 51200));
            ++col;
        }
    }

    @Deprecated
    public static void writeLine(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, TreeMap<Integer, Object[]> title, int r) {
        int col = 0;
        for (Object[] caption : title.values()) {
            SXSSFCell cell = ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col, styles.getTextStyle());
            cell.setCellStyle(styles.getTitleStyle());
            cell.setCellValue((String)caption[0]);
            int colWidth = Math.min(256 * Math.max(caption[1] == null ? 0 : ((JSONArray)caption[1]).getIntValue(1) / 8, ((String)caption[0]).length() * 2 + 4) + 184, 51200);
            sheet.setColumnWidth(col, colWidth);
            ++col;
        }
    }

    public static void writeLine(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, JSONArray titles, int r) {
        int col = 0;
        for (int i = 0; i < titles.size(); ++i) {
            JSONObject colInfo = titles.getJSONObject(i);
            int colWidth = 0;
            String align = "default";
            String value = colInfo.getString("value");
            if (colInfo.containsKey((Object)EXTEND)) {
                colWidth = colInfo.getJSONArray(EXTEND).getIntValue(1);
                align = colInfo.getJSONArray(EXTEND).getString(2);
            } else {
                value = JSON.parseObject((String)value).getString("key");
            }
            SXSSFCell cell = ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col, styles.getTitleStyle(align));
            cell.setCellValue(value);
            sheet.setColumnWidth(col, Math.min(256 * Math.max(colWidth / 8, Math.max(value.length(), 8)) * 2, 51200));
            ++col;
        }
    }

    @Deprecated
    public static void writeLine(SXSSFWorkbook wb, SXSSFSheet sheet, TreeMap<Integer, String> title, JSONArray data, int r) {
        int col = 0;
        for (Integer index : title.keySet()) {
            Object value = data.get(index.intValue());
            ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col++, new ExportSheetStyle(wb).getTextStyle()).setCellValue(value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : (value == null ? "" : value.toString()));
        }
    }

    @Deprecated
    public static void writeLine(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, TreeMap<Integer, Object[]> title, JSONArray data, int r) {
        int col = 0;
        for (Map.Entry<Integer, Object[]> kv : title.entrySet()) {
            Object value;
            if (kv.getKey() >= data.size() || (value = data.get(kv.getKey().intValue())) == null) {
                ++col;
                continue;
            }
            JSONArray colExtend = (JSONArray)kv.getValue()[1];
            if (colExtend != null && colExtend.getInteger(0).equals(2)) {
                if (value instanceof Map) {
                    JSONObject dataMap = (JSONObject)value;
                    ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col++, styles.getDecimalStyle(wb, (Map)dataMap)).setCellValue(dataMap.getDoubleValue(RESULT));
                    continue;
                }
                SXSSFCell cell = ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col++, styles.getDecimalStyle(wb, null));
                if (!StringUtils.isNotBlank((Object)value)) continue;
                cell.setCellValue(new BigDecimal(value.toString()).doubleValue());
                continue;
            }
            if (colExtend != null && colExtend.getInteger(0).equals(3)) {
                try {
                    Date datetime = new SimpleDateFormat("yyyy-MM-dd H:m:s").parse((String)value);
                    ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col++, styles.getDatetimeStyle()).setCellValue(datetime);
                }
                catch (ParseException e) {
                    ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col++, styles.getDateStyle()).setCellValue((String)value);
                    WriteLogHelper.writeErrorLog(logger, "ExportWriter-writeLine", e);
                }
                continue;
            }
            ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col++, styles.getTextStyle()).setCellValue(value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : (value == null ? "" : value.toString()));
        }
    }

    public static void writeLine(SXSSFWorkbook wb, SXSSFSheet sheet, ExportSheetStyle styles, JSONArray titles, JSONArray row, int r) {
        int col = 0;
        for (int i = 0; i < titles.size(); ++i) {
            Object value = row.get(i);
            if (StringUtils.isBlank((Object)value)) {
                ++col;
                continue;
            }
            JSONArray colExtend = titles.getJSONObject(i).getJSONArray(EXTEND);
            String align = "default";
            if (colExtend != null) {
                align = colExtend.getString(2);
                if (colExtend.getInteger(0).equals(2)) {
                    BigDecimal decimal = null;
                    JSONObject dataMap = null;
                    if (value instanceof Map) {
                        dataMap = (JSONObject)JSONObject.toJSON((Object)value);
                        decimal = new BigDecimal(dataMap.getOrDefault((Object)RESULT, (Object)0).toString());
                    } else {
                        if (!StringUtils.isNotBlank((Object)value)) continue;
                        decimal = new BigDecimal(value.toString());
                    }
                    if (ExportWriter.isBigDecimal(decimal.toPlainString())) {
                        ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col++, styles.getTextStyle(align)).setCellValue(decimal.toPlainString());
                        continue;
                    }
                    ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col++, styles.getDecimalStyle(wb, (Map)dataMap, align)).setCellValue(decimal.doubleValue());
                    continue;
                }
                if (colExtend.getInteger(0).equals(3)) {
                    try {
                        Date datetime = value instanceof Long ? new Date((Long)value) : new SimpleDateFormat("yyyy-MM-dd H:m:s").parse(value.toString());
                        ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col++, styles.getDatetimeStyle(align)).setCellValue(datetime);
                    }
                    catch (ParseException e) {
                        ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col++, styles.getDateStyle(align)).setCellValue(value.toString());
                        WriteLogHelper.writeErrorLog(logger, "ExportWriter-writeLine2", e);
                    }
                    continue;
                }
            }
            ExportWriter.createCell(wb, ExportWriter.getRow(sheet, r), col++, styles.getTextStyle(align)).setCellValue(value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : (value == null ? "" : value.toString()));
        }
    }

    private static boolean isBigDecimal(String decimalStr) {
        int i = decimalStr.lastIndexOf(46);
        int j = decimalStr.length();
        if (i >= 0) {
            --j;
            while (j > i && decimalStr.charAt(j) == '0') {
                --j;
            }
        }
        if (decimalStr.startsWith("-")) {
            --j;
        }
        return j > 15;
    }

    private static Boolean multipleColumnsField(Object inputType) {
        return "basedata".equals(inputType) || "flex".equals(inputType) || "multilang".equals(inputType) || "largetext".equals(inputType);
    }
}

