/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.common.constant.CommonConstant;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;
import kd.fi.cal.common.util.DynamicObjectUtils;

public class FeeShareHelper {
    public static final String MAIN_SETARRAY = "mainSetArray";
    public static final String ASST_SETARRAY = "asstSetArray";
    public static final String ASST_BIZBILLIDS = "asstbizbillids";
    public static final String MATCHINGCONDITION = "matchingcondition";
    public static final String SHARENUM = "shareNum";
    public static final String CALORG = "CALORG";
    public static final String EXRATETABLE = "exratetable";
    public static final String SHARESTANDARD = "sharestandard";
    public static final String SHAREDATE = "sharedate";
    public static final String SHARECURRENCY = "sharecurrency";
    public static final String ASSTQFILTER = "asstQfilter";

    public static boolean isFirstTimeShareFee(Long entryId) {
        DynamicObject costObj = QueryServiceHelper.queryOne((String)"cal_costrecord", (String)"entry.bizbillentryid", (QFilter[])new QFilter("entry.id", "=", (Object)entryId).toArray());
        return QueryServiceHelper.exists((String)"cal_fee_sharerecord", (QFilter[])new QFilter("entry.bizbillentryid", "=", (Object)costObj.getLong("entry.bizbillentryid")).and("entry.ismianbill", "=", (Object)"0").toArray());
    }

    public static boolean isEntryIdShare(Long entryId) {
        return QueryServiceHelper.exists((String)"cal_costrecord", (QFilter[])new QFilter("entry.id", "=", (Object)entryId).and("entry.isallocate", "=", (Object)"1").toArray());
    }

    public static Set<Long> queryIsFeeShare(Set<Long> entryIdSet) {
        long containId = 0L;
        DynamicObjectCollection containRecords = QueryServiceHelper.query((String)"cal_costrecord", (String)"entry.id", (QFilter[])new QFilter("entry.id", "in", entryIdSet).and("entry.isallocate", "=", (Object)"1").toArray());
        for (DynamicObject containRecord : containRecords) {
            containId = containRecord.getLong("entry.id");
            entryIdSet.remove(containId);
        }
        return entryIdSet;
    }

    public static boolean isFirstCostEst(Long entryId, Long expenseitemId) {
        boolean updateCostRecord = QueryServiceHelper.exists((String)"cal_fee_sharedetail", (QFilter[])new QFilter("entryid", "=", (Object)entryId).and("expenseitem", "=", (Object)expenseitemId).toArray());
        boolean createCostAdjustBill = QueryServiceHelper.exists((String)"cal_costadjustbill", (QFilter[])new QFilter("entryentity.invbillentryid", "=", (Object)entryId).and("entryentity.feeprojectid", "=", (Object)expenseitemId).and("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue()).toArray());
        return updateCostRecord || createCostAdjustBill;
    }

    public static String getCostRecordFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("id,calbillid,bizbillid,costaccount,costaccount.id,costaccount.calorg.id,costaccount.name,costaccount.ismainaccount,period,isfivoucher,istempvoucher,isdischargevoucher,isfeevoucher,iscostcarryover,isvoucher,");
        sb.append("entry.id,entry.calentryid,entry.bizbillentryid,storageorgunit,entry.seq,entry.accounttype,entry.materialcost,entry.invtype,");
        sb.append("calorg,adminorg,billno,billnumber,bizdate,bookdate,entry.ownertype,entry.owner,entry.assist,localcurrency,entry.material,entry.baseunit,entry.invstatus,entry.project,entry.tracknumber,entry.configuredcode,");
        sb.append("entry.baseqty,entry.fee,entry.unitstandardcost,entry.actualcost,billtype,entry.totalsharefee,entry.lot,entry.warehouse,entry.location,entry.adjustamount,");
        sb.append("currency,entry.tax,entry.unitactualcost,entry.standardcost,entry.unitmaterialcost,entry.unitfee,entry.taxamt,entry.loctaxamt,entry.unitprocesscost,entry.processcost,entry.localtax,");
        sb.append("supplier,entry.mainbillentity,entry.mainbillnumber,entry.mainbillid,entry.mainbillentryid,entry.srcbillentity,entry.srcbillnumber,entry.srcbillid,entry.srcbillentryid,entry.mversion,entry.ecostcenter");
        sb.append(",entry.noupdatecalfields");
        sb.append(",entry.stocktype");
        Set<String> exFieldSet = CommonSettingHelper.getExFieldSet();
        if (!exFieldSet.isEmpty()) {
            for (String exEntryField : exFieldSet) {
                sb.append(',').append("entry.").append(exEntryField);
            }
        }
        return sb.toString();
    }

    public static boolean isLastShareByBizEntryId(Long calEntryId) {
        DynamicObjectCollection feeShareRecords = QueryServiceHelper.query((String)"cal_fee_sharerecord", (String)"entry.bizbillentryid", (QFilter[])new QFilter("entry.bizbillentryid", "=", (Object)calEntryId).and("entry.ismianbill", "=", (Object)"0").toArray());
        return feeShareRecords != null && feeShareRecords.size() == 1;
    }

    public static List<Set<Long>> getExitemMaterialIdEntryId(Collection<List<DynamicObject>> mainCostRecordCollection, List<DynamicObject> asstUnMainAccount, Set<DynamicObject> mainBills) {
        ArrayList<Set<Long>> exitemAndEntryIdList = new ArrayList<Set<Long>>();
        HashSet<Long> exitemSet = new HashSet<Long>(16);
        HashSet<Long> materialIdSet = new HashSet<Long>();
        HashSet<Long> costTypeIdSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : mainBills) {
            long expenseitemId = dynamicObject.getLong("expenseitem_id");
            exitemSet.add(expenseitemId);
        }
        for (List list : mainCostRecordCollection) {
            for (DynamicObject costRecordEntry : list) {
                DynamicObject costRecord = (DynamicObject)costRecordEntry.getParent();
                costTypeIdSet.add(costRecord.getLong("costaccount.costtype.id"));
                long materialId = costRecordEntry.getLong("material_id");
                materialIdSet.add(materialId);
            }
        }
        for (DynamicObject dynamicObject : asstUnMainAccount) {
            costTypeIdSet.add(dynamicObject.getLong("costaccount.costtype.id"));
        }
        exitemAndEntryIdList.add(exitemSet);
        exitemAndEntryIdList.add(materialIdSet);
        exitemAndEntryIdList.add(costTypeIdSet);
        return exitemAndEntryIdList;
    }

    public static Map<String, Object> getElementMap(Collection<List<DynamicObject>> mainCostRecordCollection, List<DynamicObject> asstUnMainAccount, Set<DynamicObject> mainBills) {
        Map<Object, Object> exitemElementMap = new HashMap();
        Map<Object, Object> cosTypeMaterialMap = new HashMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List<Set<Long>> exitemAndEntryIdList = FeeShareHelper.getExitemMaterialIdEntryId(mainCostRecordCollection, asstUnMainAccount, mainBills);
        exitemElementMap = CostElementHelper.buildExitemElement(exitemAndEntryIdList.get(0), exitemAndEntryIdList.get(2));
        returnMap.put("exitemElementMap", exitemElementMap);
        Long[] costTypeIds = exitemAndEntryIdList.get(2).toArray(new Long[0]);
        Set<Long> materialSet = exitemAndEntryIdList.get(1);
        long calOrgId = 0L;
        for (List<DynamicObject> costRecordEntryList : mainCostRecordCollection) {
            if (costRecordEntryList.isEmpty()) continue;
            DynamicObject costRecord = (DynamicObject)costRecordEntryList.get(0).getParent();
            calOrgId = costRecord.getLong("costaccount.calorg.id");
            break;
        }
        if (calOrgId == 0L && !asstUnMainAccount.isEmpty()) {
            calOrgId = asstUnMainAccount.get(0).getLong("costaccount.calorg.id");
        }
        cosTypeMaterialMap = CostElementHelper.getCostElementsByMaterial(calOrgId, costTypeIds, materialSet.toArray(new Long[0]));
        returnMap.put("cosTypeMaterialMap", cosTypeMaterialMap);
        returnMap.put("exitemAndEntryIdList", exitemAndEntryIdList);
        long defaultId = CostElementHelper.getDefaultElement();
        returnMap.put("defaultId", defaultId);
        return returnMap;
    }

    public static String getAddCostRecordDetailSql() {
        return " update t_cal_costrecord_detail set factualcost = factualcost + ?   where fentryid = ? and fcostsubelementid = ?";
    }

    public static String getSubCostRecordDetailSql() {
        return " update t_cal_costrecord_detail set factualcost = factualcost - ?   where fentryid = ? and fcostsubelementid = ?";
    }

    public static Map<String, Object> getElementMap(DynamicObjectCollection costRecordCollection) {
        Map<Object, Object> exitemElementMap = new HashMap();
        Map<Object, Object> cosTypeMaterialMap = new HashMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List<Set<Long>> exitemAndEntryIdList = FeeShareHelper.getExitemMaterialIdEntryId(costRecordCollection);
        exitemElementMap = CostElementHelper.buildExitemElement(exitemAndEntryIdList.get(0), exitemAndEntryIdList.get(3));
        returnMap.put("exitemElementMap", exitemElementMap);
        Long[] costTypeIds = exitemAndEntryIdList.get(3).toArray(new Long[0]);
        Set<Long> materialSet = exitemAndEntryIdList.get(1);
        long calOrgId = ((DynamicObject)costRecordCollection.get(0)).getLong("costaccount.calorg.id");
        cosTypeMaterialMap = CostElementHelper.getCostElementsByMaterial(calOrgId, costTypeIds, materialSet.toArray(new Long[0]));
        returnMap.put("cosTypeMaterialMap", cosTypeMaterialMap);
        return returnMap;
    }

    private static List<Set<Long>> getExitemMaterialIdEntryId(DynamicObjectCollection costRecordCollection) {
        ArrayList<Set<Long>> exitemAndEntryIdList = new ArrayList<Set<Long>>();
        HashSet<Long> exitemSet = new HashSet<Long>();
        HashSet<Long> entryIdSet = new HashSet<Long>();
        HashSet<Long> materialIdSet = new HashSet<Long>();
        HashSet<Long> costTypeIdSet = new HashSet<Long>();
        for (DynamicObject costRecord : costRecordCollection) {
            costTypeIdSet.add(costRecord.getLong("costaccount.costtype.id"));
            DynamicObjectCollection costRecordEntrys = costRecord.getDynamicObjectCollection("entry");
            for (DynamicObject costRecordEntry : costRecordEntrys) {
                long entryId = costRecordEntry.getLong("id");
                entryIdSet.add(entryId);
                long materialId = costRecordEntry.getLong("material.id");
                materialIdSet.add(materialId);
                DynamicObjectCollection costRecordSubEntrys = costRecordEntry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject costRecordSubEntry : costRecordSubEntrys) {
                    long expenseitemId = costRecordSubEntry.getLong("expenseitem.id");
                    exitemSet.add(expenseitemId);
                }
            }
        }
        exitemAndEntryIdList.add(exitemSet);
        exitemAndEntryIdList.add(materialIdSet);
        exitemAndEntryIdList.add(entryIdSet);
        exitemAndEntryIdList.add(costTypeIdSet);
        return exitemAndEntryIdList;
    }

    public static Map<String, Object> getBackFeeShareElementMap(DynamicObjectCollection costRecordCollection) {
        Map<Object, Object> exitemElementMap = new HashMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List<Set<Long>> exitemAndEntryIdList = FeeShareHelper.getQueryExitemMaterialIdEntryId(costRecordCollection);
        exitemElementMap = CostElementHelper.buildExitemElement(exitemAndEntryIdList.get(0), exitemAndEntryIdList.get(3));
        returnMap.put("exitemElementMap", exitemElementMap);
        returnMap.put("defaultId", CostElementHelper.getDefaultElement());
        returnMap.put("defaultMateriaId", CostElementHelper.getDefalutMaterialId());
        return returnMap;
    }

    public static List<Set<Long>> getQueryExitemMaterialIdEntryId(DynamicObjectCollection costRecordCollection) {
        ArrayList<Set<Long>> exitemAndEntryIdList = new ArrayList<Set<Long>>();
        HashSet<Long> exitemSet = new HashSet<Long>();
        HashSet<Long> entryIdSet = new HashSet<Long>();
        HashSet<Long> materialIdSet = new HashSet<Long>();
        HashSet<Long> costTypeIdSet = new HashSet<Long>();
        for (DynamicObject costRecord : costRecordCollection) {
            costTypeIdSet.add(costRecord.getLong("costaccount.costtype.id"));
            long entryId = costRecord.getLong("entry.id");
            entryIdSet.add(entryId);
            long materialId = costRecord.getLong("entry.material.id");
            materialIdSet.add(materialId);
            long expenseitemId = costRecord.getLong("entry.subentryentity.expenseitem.id");
            exitemSet.add(expenseitemId);
        }
        exitemAndEntryIdList.add(exitemSet);
        exitemAndEntryIdList.add(materialIdSet);
        exitemAndEntryIdList.add(entryIdSet);
        exitemAndEntryIdList.add(costTypeIdSet);
        return exitemAndEntryIdList;
    }

    public static void caculateDetailUnitActual(Set<Long> entryIdSet) {
        DynamicObject[] costDetailArray;
        for (DynamicObject costDetail : costDetailArray = BusinessDataServiceHelper.load((String)"cal_costrecord_detail", (String)"id,entryid,costsubelement,actualcost,unitactualcost,costsubelement.id,baseqty,standardcost,unitstandardcost,currency.priceprecision", (QFilter[])new QFilter("entryid", "in", entryIdSet).toArray())) {
            BigDecimal actualcost = costDetail.getBigDecimal("actualcost");
            BigDecimal baseqty = costDetail.getBigDecimal("baseqty");
            if (baseqty.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal unitActualcost = actualcost.divide(baseqty, 10, 4);
            costDetail.set("unitactualcost", (Object)unitActualcost);
        }
        SaveServiceHelper.save((DynamicObject[])costDetailArray);
    }

    public static Map<String, Object> multiCostEstCostAdjust(Map<String, List<DynamicObject>> multiCostEstCostAdjustMap, Date maxDate, Date maxBookDate, Long asstBillId, Long shareId, Long supplierId) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String key = asstBillId.toString() + supplierId.toString();
        if (!multiCostEstCostAdjustMap.containsKey(key)) {
            return returnMap;
        }
        List<DynamicObject> costAdjustBillList = multiCostEstCostAdjustMap.get(key);
        ArrayList<DynamicObject> feeShareCostAdjustBill = new ArrayList<DynamicObject>(32);
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
        for (DynamicObject bill : costAdjustBillList) {
            DynamicObject newBill = FeeShareHelper.cloneDynamicBill(bill);
            newBill.set("bizdate", (Object)maxDate);
            newBill.set("bookdate", (Object)maxBookDate);
            newBill.set("period", (Object)PeriodHelper.getPeriodByDate(maxBookDate, bill.getLong("costaccount_id")));
            newBill.set("isvoucher", (Object)"0");
            newBill.set("vouchernum", null);
            long billId = bill.getLong("id");
            String billNo = bill.getString("billno");
            long entryId = ((DynamicObject)bill.getDynamicObjectCollection("entryentity").get(0)).getLong("id");
            String content = String.format(ResManager.loadKDString((String)"\u6682\u4f30\u51b2\u56de\u7684\u6210\u672c\u8c03\u6574\u5355\u7f16\u53f7:%1$s", (String)"FeeShareHelper_2", (String)"fi-cal-common", (Object[])new Object[0]), billNo);
            newBill.set("remark", (Object)content);
            DynamicObject newBillEntry = (DynamicObject)newBill.getDynamicObjectCollection("entryentity").get(0);
            newBillEntry.set("srcbillid", (Object)billId);
            newBillEntry.set("srcbillentryid", (Object)entryId);
            newBillEntry.set("srcbizentityobject", (Object)"cal_costadjust_subentity");
            newBillEntry.set("srcbilltype_id", (Object)986031578352241664L);
            feeShareCostAdjustBill.add(newBill);
            bill.set("checkstrikeaccount", (Object)Boolean.TRUE);
        }
        IDGenerator idGenerator = new IDGenerator("t_cal_calcostrecordentry");
        for (DynamicObject bill : feeShareCostAdjustBill) {
            bill.set("createtype", (Object)CostAdjustBilCreateTypeEnum.FEE_SHARE_RUSH_BACK.getValue());
            bill.set("feeshareflag", (Object)shareId);
            bill.set("billstatus", (Object)"B");
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            String adjustBillno = BillNoHelper.getBillNo("cal_costadjust_subentity", bill, bill.getString("calorg_id"));
            bill.set("billno", (Object)adjustBillno);
            for (DynamicObject entry : entryEntity) {
                BigDecimal adjustamt = entry.getBigDecimal("adjustamt");
                entry.set("adjustamt", (Object)adjustamt.negate());
                entry.set("id", (Object)idGenerator.getId());
                DynamicObjectCollection subentryEntity = entry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntity : subentryEntity) {
                    CostAdjustDetailParams param = new CostAdjustDetailParams();
                    param.setAdjustAmt(subEntity.getBigDecimal("sub_adjustamt").negate());
                    param.setEntryid(entry.getLong("id"));
                    param.setCostElementId(subEntity.getLong("costelement_id"));
                    param.setCostSubElementId(subEntity.getLong("costsubelement_id"));
                    paramsList.add(param);
                }
                subentryEntity.clear();
            }
        }
        returnMap.put("feeShareCostAdjustBill", feeShareCostAdjustBill);
        returnMap.put("costAdjustBillList", costAdjustBillList);
        returnMap.put("paramsList", paramsList);
        return returnMap;
    }

    public static Map<String, Object> multiCostEstStdCostDiffBill(Map<String, List<DynamicObject>> multiCostEstCostAdjustMap, Date maxDate, Date maxBookDate, Long asstBillId, Long shareId, Long supplierId) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String key = asstBillId.toString() + supplierId.toString();
        if (!multiCostEstCostAdjustMap.containsKey(key)) {
            return returnMap;
        }
        List<DynamicObject> costAdjustBillList = multiCostEstCostAdjustMap.get(key);
        ArrayList<DynamicObject> feeShareCostAdjustBill = new ArrayList<DynamicObject>(32);
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>();
        for (DynamicObject bill : costAdjustBillList) {
            DynamicObject newBill = FeeShareHelper.cloneDynamicBill(bill);
            newBill.set("bizdate", (Object)maxDate);
            newBill.set("bookdate", (Object)maxBookDate);
            newBill.set("period", (Object)PeriodHelper.getPeriodByDate(maxBookDate, bill.getLong("costaccount_id")));
            newBill.set("isvoucher", (Object)"0");
            newBill.set("vouchernum", null);
            long billId = bill.getLong("id");
            String billNo = bill.getString("billno");
            long entryId = ((DynamicObject)bill.getDynamicObjectCollection("entryentity").get(0)).getLong("id");
            String content = String.format(ResManager.loadKDString((String)"\u6682\u4f30\u51b2\u56de\u7684\u6210\u672c\u8c03\u6574\u5355\u7f16\u53f7:%1$s", (String)"FeeShareHelper_2", (String)"fi-cal-common", (Object[])new Object[0]), billNo);
            newBill.set("remark", (Object)content);
            DynamicObject newBillEntry = (DynamicObject)newBill.getDynamicObjectCollection("entryentity").get(0);
            newBillEntry.set("srcbillid", (Object)billId);
            newBillEntry.set("srcbillentryid", (Object)entryId);
            newBillEntry.set("srcbillnum", (Object)billNo);
            newBillEntry.set("srcbizentityobject", (Object)"cal_stdcostdiffbill");
            newBillEntry.set("srcbilltype_id", (Object)986031578352241664L);
            feeShareCostAdjustBill.add(newBill);
            bill.set("checkstrikeaccount", (Object)Boolean.TRUE);
        }
        IDGenerator idGenerator = new IDGenerator("t_cal_calcostrecordentry");
        for (DynamicObject bill : feeShareCostAdjustBill) {
            bill.set("createtype", (Object)CostAdjustBilCreateTypeEnum.FEE_SHARE_RUSH_BACK.getValue());
            bill.set("feeshareflag", (Object)shareId);
            bill.set("billstatus", (Object)"B");
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            String adjustBillno = BillNoHelper.getBillNo("cal_stdcostdiffbill", bill, bill.getString("calorg_id"));
            bill.set("billno", (Object)adjustBillno);
            for (DynamicObject entry : entryEntity) {
                BigDecimal adjustamt = entry.getBigDecimal("adjustamt");
                BigDecimal diff_k = entry.getBigDecimal("diff_k");
                entry.set("adjustamt", (Object)adjustamt.negate());
                entry.set("diff_k", (Object)diff_k.negate());
                entry.set("id", (Object)idGenerator.getId());
                DynamicObjectCollection subentryEntity = entry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntity : subentryEntity) {
                    CostAdjustDetailParams param = new CostAdjustDetailParams();
                    param.setAdjustAmt(subEntity.getBigDecimal("sub_adjustamt").negate());
                    param.setDdiff_k(subEntity.getBigDecimal("ddiff_k").negate());
                    param.setEntryid(entry.getLong("id"));
                    param.setCostElementId(subEntity.getLong("costelement_id"));
                    param.setCostSubElementId(subEntity.getLong("costsubelement_id"));
                    paramsList.add(param);
                }
                subentryEntity.clear();
            }
        }
        returnMap.put("feeShareStdCostDiffBill", feeShareCostAdjustBill);
        returnMap.put("stdCostDiffBillList", costAdjustBillList);
        returnMap.put("paramsStdCostDiffBillList", paramsList);
        return returnMap;
    }

    protected static DynamicObject cloneDynamicBill(DynamicObject dynamicBill) {
        DynamicObject newBill = BusinessDataServiceHelper.newDynamicObject((String)dynamicBill.getDataEntityType().getName());
        DynamicObjectUtils.copy(dynamicBill, newBill);
        return newBill;
    }

    public static Map<String, BigDecimal> getFirstCostEstCostMap(Set<Long> set, Long exitemId, Long supplierId) {
        HashSet<Long> costRecordEntryids = new HashSet<Long>(set);
        DynamicObjectCollection feeShareDetail = QueryServiceHelper.query((String)"cal_fee_sharedetail", (String)"entryid,expenseitem", (QFilter[])new QFilter("entryid", "in", set).and("expenseitem", "=", (Object)exitemId).and("asstact", "=", (Object)supplierId).toArray());
        for (Object entry : feeShareDetail) {
            set.remove(entry.getLong("entryid"));
        }
        DynamicObjectCollection costAdjustBills = QueryServiceHelper.query((String)"cal_costadjustbill", (String)"entryentity.invbillentryid,entryentity.feeprojectid", (QFilter[])new QFilter("entryentity.invbillentryid", "in", set).and("entryentity.feeprojectid", "=", (Object)exitemId).and("createtype", "=", (Object)CostAdjustBilCreateTypeEnum.FEE_SHARE.getValue()).and("entryentity.srcbizentityobject", "=", (Object)"ap_finapbill").and("custsupplier", "=", (Object)supplierId).toArray());
        for (DynamicObject costAdjustBill : costAdjustBills) {
            set.remove(costAdjustBill.getLong("entryentity.invbillentryid"));
        }
        QFilter feeRecordNotMainFilter = new QFilter("entry.ismianbill", "=", (Object)false);
        feeRecordNotMainFilter.and("entry.billentryid", "in", costRecordEntryids);
        feeRecordNotMainFilter.and("writeofftypeid", "in", (Object)new Long[]{0L, CommonConstant.HXLB_ACTUALFEE_SHARE});
        DataSet feeRecordNotMainDS = QueryServiceHelper.queryDataSet((String)FeeShareHelper.class.getName(), (String)"cal_feeshare_newrecord", (String)"id,entry.bizbillentryid,entry.bookdate", (QFilter[])feeRecordNotMainFilter.toArray(), null);
        HashSet<Long> existFeeShareIds = new HashSet<Long>(16);
        Date minBookDate = null;
        Date maxBookDate = null;
        HashSet<Long> bizBillEntryids = new HashSet<Long>(16);
        for (Row row : feeRecordNotMainDS.copy()) {
            Long id = row.getLong("id");
            existFeeShareIds.add(id);
            Date bookdate = row.getDate("entry.bookdate");
            bizBillEntryids.add(row.getLong("entry.bizbillentryid"));
            if (bookdate != null && (minBookDate == null || bookdate.before(minBookDate))) {
                minBookDate = bookdate;
            }
            if (bookdate == null || maxBookDate != null && !bookdate.after(maxBookDate)) continue;
            maxBookDate = bookdate;
        }
        if (!existFeeShareIds.isEmpty()) {
            QFilter feeRecordMainFilter = new QFilter("id", "in", existFeeShareIds);
            feeRecordMainFilter.and("entry.ismianbill", "=", (Object)true);
            feeRecordMainFilter.and("entry.expenseitem", "=", (Object)exitemId);
            feeRecordMainFilter.and("entry.asstact", "=", (Object)supplierId);
            DataSet feeRecordMainDS = QueryServiceHelper.queryDataSet((String)FeeShareHelper.class.getName(), (String)"cal_feeshare_newrecord", (String)"id,entry.asstact,entry.expenseitem", (QFilter[])feeRecordMainFilter.toArray(), null);
            QFilter costRecordFilter = new QFilter("bookdate", ">=", (Object)minBookDate);
            costRecordFilter.and("bookdate", "<=", (Object)maxBookDate);
            costRecordFilter.and("entry.bizbillentryid", "in", bizBillEntryids);
            DataSet costRecordDS = QueryServiceHelper.queryDataSet((String)FeeShareHelper.class.getName(), (String)"cal_costrecord", (String)"id,entry.id,entry.bizbillentryid", (QFilter[])costRecordFilter.toArray(), null);
            DataSet ds = costRecordDS.join(feeRecordNotMainDS, JoinType.INNER).on("entry.bizbillentryid", "entry.bizbillentryid").select(new String[]{"entry.id"}, new String[]{"id"}).finish().join(feeRecordMainDS, JoinType.INNER).on("id", "id").select(new String[]{"entry.id"}, new String[]{"entry.asstact", "entry.expenseitem"}).finish();
            for (Row row : ds) {
                set.remove(row.getLong("entry.id"));
            }
        }
        HashMap<String, BigDecimal> shareDetailAmtMap = new HashMap<String, BigDecimal>();
        if (set.isEmpty()) {
            return shareDetailAmtMap;
        }
        DynamicObjectCollection costEstRecord = QueryServiceHelper.query((String)"cal_costrecord", (String)"entry.id,entry.subentryentityest.sharedetailexitem.id,entry.subentryentityest.sharedetailamt,entry.subentryentityest.sharedetailasstact.id", (QFilter[])new QFilter("entry.id", "in", set).and("entry.subentryentityest.sharedetailexitem.id", "=", (Object)exitemId).toArray());
        BigDecimal shareDetailAmt = BigDecimal.ZERO;
        for (DynamicObject costEst : costEstRecord) {
            String entryId = costEst.getString("entry.id");
            String supperId = costEst.getString("entry.subentryentityest.sharedetailasstact.id");
            BigDecimal shareAmt = (BigDecimal)shareDetailAmtMap.get(entryId);
            BigDecimal shareAmtBySup = (BigDecimal)shareDetailAmtMap.get(entryId + supperId);
            shareDetailAmt = shareAmt != null ? shareAmt.add(costEst.getBigDecimal("entry.subentryentityest.sharedetailamt")) : costEst.getBigDecimal("entry.subentryentityest.sharedetailamt");
            shareDetailAmtMap.put(entryId, shareDetailAmt);
            shareAmtBySup = shareAmtBySup != null ? shareAmtBySup.add(costEst.getBigDecimal("entry.subentryentityest.sharedetailamt")) : costEst.getBigDecimal("entry.subentryentityest.sharedetailamt");
            shareDetailAmtMap.put(entryId + supperId, shareAmtBySup);
        }
        return shareDetailAmtMap;
    }
}

