/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.StandardCostHelper;
import kd.fi.cal.common.model.InitCalSubEntryInfo;
import kd.fi.cal.common.model.MaterialCostInfo;
import kd.fi.cal.common.util.DateUtils;

public class InitCalBillHelper {
    public static final String UPD_BAL_SQL = "update t_cal_balance set fperiodbeginqty = fperiodbeginqty + ?,fbeginstandardcost = fbeginstandardcost + ?,fperiodbeginactualcost = fperiodbeginactualcost + ?,fperiodbegincostdiff = fperiodbegincostdiff + ?,fyearinqty = fyearinqty + ?,fyearinstandradcost = fyearinstandradcost + ?,fyearinactualcost = fyearinactualcost + ?,fyearincostdiff = fyearincostdiff + ?,fyearissueqty = fyearissueqty + ?,fyearissuestandradcost = fyearissuestandradcost + ?,fyearissueactualcost = fyearissueactualcost + ?,fyearissuecostdiff = fyearissuecostdiff + ?,fperiodendqty = fperiodendqty + ?,fperiodendstandardcost = fperiodendstandardcost + ?,fperiodendactualcost = fperiodendactualcost + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fid = ?";
    public static final String UPD_BALDETAIL_SQL = "update t_cal_balance_detail set fperiodbeginqty = fperiodbeginqty + ?,fbeginstandardcost = fbeginstandardcost + ?,fperiodbeginactualcost = fperiodbeginactualcost + ?,fperiodbegincostdiff = fperiodbegincostdiff + ?,fyearinqty = fyearinqty + ?,fyearinstandradcost = fyearinstandradcost + ?,fyearinactualcost = fyearinactualcost + ?,fyearincostdiff = fyearincostdiff + ?,fyearissueqty = fyearissueqty + ?,fyearissuestandradcost = fyearissuestandradcost + ?,fyearissueactualcost = fyearissueactualcost + ?,fyearissuecostdiff = fyearissuecostdiff + ?,fperiodendqty = fperiodendqty + ?,fperiodendstandardcost = fperiodendstandardcost + ?,fperiodendactualcost = fperiodendactualcost + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fid = ? and fcostsubelementid = ?";
    public static final String UPD_BAL_ENDPERIOD_SQL = "update t_cal_balance set fendperiod = ? where fid = ?";
    public static final String UPD_STD_BAL_SQL = "update t_cal_purpricediff set fperiodbegincostdiff = fperiodbegincostdiff + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fid = ?";
    public static final String UPD_STD_BALDETAIL_SQL = "update t_cal_purdiff_detail set fperiodbegincostdiff = fperiodbegincostdiff + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fbalid = ? and fcostsubelementid = ?";
    public static final String UPD_STD_BAL_ENDPERIOD_SQL = "update t_cal_purpricediff set fendperiod = ? where fid = ?";

    public static String getEntryDimString(MainEntityType initCalEntityType, Set<String> dimFieldSet, DynamicObject info, DynamicObject entry) {
        StringBuilder billDimSb = new StringBuilder();
        for (String dimField : dimFieldSet) {
            if ("costaccount".equals(dimField)) {
                billDimSb.append(info.get("costaccount.id")).append('|');
                continue;
            }
            Object dimFieldValue = entry.get(dimField);
            if (initCalEntityType.findProperty(dimField) instanceof BasedataProp) {
                if (dimFieldValue == null) {
                    billDimSb.append('0').append('|');
                    continue;
                }
                billDimSb.append(entry.get(dimField + ".id")).append('|');
                continue;
            }
            if (dimFieldValue == null) {
                billDimSb.append('|');
                continue;
            }
            billDimSb.append(dimFieldValue).append('|');
        }
        return billDimSb.toString();
    }

    public static boolean isStd(DynamicObject costaccount, String accountType) {
        if (costaccount == null) {
            return false;
        }
        return costaccount.getBoolean("enablestandardcost") || AccountTypeEnum.STANDARDCOST.getValue().equals(accountType);
    }

    public static boolean isStd(boolean enableStd, String accountType) {
        return enableStd || AccountTypeEnum.STANDARDCOST.getValue().equals(accountType);
    }

    public static void handleUpdateStdBalList(Set<Long> balIds, DynamicObject entry, List<Object[]> updateList, List<Object[]> detailUpdateList, boolean isAudit) {
        for (Long balId : balIds) {
            BigDecimal costdiff = entry.getBigDecimal("costdiff");
            if (!isAudit) {
                costdiff = costdiff.negate();
            }
            updateList.add(new Object[]{costdiff, costdiff, balId});
            DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntry : subEntryColl) {
                long subElementId = subEntry.getLong("costsubelement.id");
                BigDecimal subcostdiff = subEntry.getBigDecimal("sub_costdiff");
                if (!isAudit) {
                    subcostdiff = subcostdiff.negate();
                }
                detailUpdateList.add(new Object[]{subcostdiff, subcostdiff, balId, subElementId});
            }
        }
    }

    public static void handleUpdateBalList(Set<Long> balIds, DynamicObject entry, List<Object[]> updateList, List<Object[]> detailUpdateList, boolean isStd, boolean isAudit) {
        BigDecimal baseqty = entry.getBigDecimal("baseqty");
        BigDecimal amount = entry.getBigDecimal("amount");
        BigDecimal costdiff = entry.getBigDecimal("costdiff");
        BigDecimal yearinqty = entry.getBigDecimal("yearinqty");
        BigDecimal yearinactualcost = entry.getBigDecimal("yearincost");
        BigDecimal yearincostdiff = entry.getBigDecimal("yearincostdiff");
        BigDecimal yearissueqty = entry.getBigDecimal("yearissueqty");
        BigDecimal yearissueactualcost = entry.getBigDecimal("yearissuecost");
        BigDecimal yearissuecostdiff = entry.getBigDecimal("yearissuecostdiff");
        if (!isAudit) {
            baseqty = baseqty.negate();
            amount = amount.negate();
            costdiff = costdiff.negate();
            yearinqty = yearinqty.negate();
            yearinactualcost = yearinactualcost.negate();
            yearincostdiff = yearincostdiff.negate();
            yearissueqty = yearissueqty.negate();
            yearissueactualcost = yearissueactualcost.negate();
            yearissuecostdiff = yearissuecostdiff.negate();
        }
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        for (Long balId : balIds) {
            if (isStd) {
                BigDecimal stdBeginActualcost = amount.add(costdiff);
                updateList.add(new Object[]{baseqty, amount, stdBeginActualcost, costdiff, yearinqty, yearinactualcost, yearinactualcost.add(yearincostdiff), yearincostdiff, yearissueqty, yearissueactualcost, yearissueactualcost.add(yearissuecostdiff), yearissuecostdiff, baseqty, amount, stdBeginActualcost, costdiff, balId});
                for (DynamicObject subEntry : subEntryColl) {
                    BigDecimal subStdAmount = subEntry.getBigDecimal("sub_amount");
                    BigDecimal subCostdiff = subEntry.getBigDecimal("sub_costdiff");
                    BigDecimal subYearinstdcost = subEntry.getBigDecimal("sub_yearincost");
                    BigDecimal subYearincostdiff = subEntry.getBigDecimal("sub_yearincostdiff");
                    BigDecimal subYearissuestdcost = subEntry.getBigDecimal("sub_yearissuecost");
                    BigDecimal subYearissuecostdiff = subEntry.getBigDecimal("sub_yearissuecostdiff");
                    if (!isAudit) {
                        subStdAmount = subStdAmount.negate();
                        subCostdiff = subCostdiff.negate();
                        subYearinstdcost = subYearinstdcost.negate();
                        subYearincostdiff = subYearincostdiff.negate();
                        subYearissuestdcost = subYearissuestdcost.negate();
                        subYearissuecostdiff = subYearissuecostdiff.negate();
                    }
                    BigDecimal subActualAmount = subStdAmount.add(subCostdiff);
                    BigDecimal subYearinactualcost = subYearinstdcost.add(subYearincostdiff);
                    BigDecimal subYearissueactualcost = subYearissuestdcost.add(subYearissuecostdiff);
                    detailUpdateList.add(new Object[]{baseqty, subStdAmount, subActualAmount, subCostdiff, yearinqty, subYearinstdcost, subYearinactualcost, subYearincostdiff, yearissueqty, subYearissuestdcost, subYearissueactualcost, subYearissuecostdiff, baseqty, subStdAmount, subActualAmount, subCostdiff, balId, subEntry.getLong("costsubelement.id")});
                }
                continue;
            }
            updateList.add(new Object[]{baseqty, BigDecimal.ZERO, amount, BigDecimal.ZERO, yearinqty, BigDecimal.ZERO, yearinactualcost, yearincostdiff, yearissueqty, BigDecimal.ZERO, yearissueactualcost, yearissuecostdiff, baseqty, BigDecimal.ZERO, amount, BigDecimal.ZERO, balId});
            for (DynamicObject subEntry : subEntryColl) {
                BigDecimal subAmount = subEntry.getBigDecimal("sub_amount");
                BigDecimal subYearinactualcost = subEntry.getBigDecimal("sub_yearincost");
                BigDecimal subYearissueactualcost = subEntry.getBigDecimal("sub_yearissuecost");
                if (!isAudit) {
                    subAmount = subAmount.negate();
                    subYearinactualcost = subYearinactualcost.negate();
                    subYearissueactualcost = subYearissueactualcost.negate();
                }
                detailUpdateList.add(new Object[]{baseqty, BigDecimal.ZERO, subAmount, BigDecimal.ZERO, yearinqty, BigDecimal.ZERO, subYearinactualcost, BigDecimal.ZERO, yearissueqty, BigDecimal.ZERO, subYearissueactualcost, BigDecimal.ZERO, baseqty, BigDecimal.ZERO, subAmount, BigDecimal.ZERO, balId, subEntry.getLong("costsubelement.id")});
            }
        }
    }

    public static DynamicObjectCollection queryOneMatCostInfo(long costTypeId, long stdMaterialId, long mversionId, long assistId, String selectFields, Date bookdate) {
        QFilter costInfoQ = new QFilter("costtype", "in", (Object)costTypeId);
        costInfoQ.and("material", "=", (Object)stdMaterialId);
        costInfoQ.and("matversion", "=", (Object)mversionId);
        costInfoQ.and("auxpty", "=", (Object)assistId);
        costInfoQ.and("effectdate", "<=", (Object)bookdate);
        costInfoQ.and("expdate", ">", (Object)bookdate);
        costInfoQ.and("status", "=", (Object)"C");
        costInfoQ.and("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"cad_matcostinfo", (String)selectFields, (QFilter[])costInfoQ.toArray());
    }

    public static Map<String, List<MaterialCostInfo>> queryCostInfo(DynamicObject[] billarr) {
        HashMap<String, List<MaterialCostInfo>> costInfoMap = new HashMap<String, List<MaterialCostInfo>>(16);
        MainEntityType initcalbillEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        Set<String> calDimensionSet = StandardCostHelper.getCalDimensionSet(CommonSettingHelper.getCalDimensionStr());
        HashMap<String, List<Map<String, Object>>> paramsMap = new HashMap<String, List<Map<String, Object>>>(16);
        for (DynamicObject bill : billarr) {
            Date bookdate = bill.getDate("bookdate");
            bookdate = DateUtils.getDayEndTime(bookdate);
            String costAccountId = bill.getString("costaccount_id");
            String calorgId = bill.getString("calorg_id");
            String paramKey = calorgId + "_" + costAccountId;
            DynamicObjectCollection coll = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryInfo : coll) {
                ArrayList params;
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                Long materialId = entryInfo.getLong("material_id");
                Long entryid = entryInfo.getLong("id");
                String storageorgunitId = entryInfo.getString("storageorgunit_id");
                param.put("uniqueID", entryid);
                param.put("invorg", storageorgunitId);
                param.put("date", bookdate);
                param.put("material", materialId);
                if (calDimensionSet != null && calDimensionSet.size() > 0) {
                    for (String calDimension : calDimensionSet) {
                        Object value = null;
                        IDataEntityProperty srcProperty = initcalbillEntityType.findProperty(calDimension);
                        if (srcProperty != null) {
                            DynamicObject calDimensionDy;
                            value = srcProperty instanceof BasedataProp ? ((calDimensionDy = entryInfo.getDynamicObject(calDimension)) != null ? entryInfo.getDynamicObject(calDimension).getPkValue() : entryInfo.get(calDimension + "_id")) : entryInfo.get(calDimension);
                        }
                        param.put(calDimension, value);
                    }
                }
                if (null == (params = (ArrayList)paramsMap.get(paramKey)) || params.size() == 0) {
                    params = new ArrayList(16);
                    params.add(param);
                    paramsMap.put(paramKey, params);
                    continue;
                }
                params.add(param);
            }
        }
        try (DataSet matCostDs = new StandardCostHelper().getStandardCost(paramsMap, false);){
            for (Row row : matCostDs) {
                long costElementId = row.getLong("element");
                long costSubElementId = row.getLong("subelement");
                long entryid = row.getLong("entryid");
                long materialId = row.getLong("material");
                BigDecimal unitStandardcost = row.getBigDecimal("standardprice");
                String dimKey = entryid + "|" + materialId;
                ArrayList<MaterialCostInfo> costInfList = (ArrayList<MaterialCostInfo>)costInfoMap.get(dimKey);
                if (costInfList == null) {
                    costInfList = new ArrayList<MaterialCostInfo>(8);
                }
                costInfList.add(new MaterialCostInfo(costElementId, costSubElementId, unitStandardcost));
                costInfoMap.put(dimKey, costInfList);
            }
        }
        return costInfoMap;
    }

    public static Map<String, List<MaterialCostInfo>> cacheMatCostInfoMap(DynamicObject[] dataEntities) {
        return InitCalBillHelper.queryCostInfo(dataEntities);
    }

    public static Set<Long> cacheCalDimSetHasMatVer(Set<Long> calDimensionIds) {
        HashSet<Long> hasMatVerCalDimIds = new HashSet<Long>(16);
        QFilter calDimensionFilter = new QFilter("id", "in", calDimensionIds);
        calDimensionFilter.and("caldimension", "like", (Object)"%mversion%");
        try (DataSet calDimensionDS = QueryServiceHelper.queryDataSet((String)InitCalBillHelper.class.getName(), (String)"cal_bd_caldimension", (String)"id", (QFilter[])calDimensionFilter.toArray(), null);){
            for (Row row : calDimensionDS) {
                hasMatVerCalDimIds.add(row.getLong("id"));
            }
        }
        return hasMatVerCalDimIds;
    }

    public static boolean calDimSetHasMatVer(long calDimensionId) {
        QFilter calDimFilter = new QFilter("id", "=", (Object)calDimensionId);
        calDimFilter.and("caldimension", "like", (Object)"%mversion%");
        DynamicObject calDimension = QueryServiceHelper.queryOne((String)"cal_bd_caldimension", (String)"id", (QFilter[])new QFilter[]{calDimFilter});
        return calDimension != null;
    }

    public static BigDecimal buildSubEntry4StdCalbyEle(DynamicObject entry, IDataModel model, List<MaterialCostInfo> costInfoColl, List<Long[]> allElement) {
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        BigDecimal price = BigDecimal.ZERO;
        long materialId = entry.getLong("material_id");
        long baseunitId = entry.getLong("baseunit_id");
        BigDecimal entryQty = entry.getBigDecimal("baseqty");
        BigDecimal yearinqty = entry.getBigDecimal("yearinqty");
        BigDecimal yearissueqty = entry.getBigDecimal("yearissueqty");
        int elementSize = allElement.size();
        DynamicObject localCurrency = (DynamicObject)model.getValue("localcurrency");
        int amtprecision = localCurrency.getInt("amtprecision");
        HashMap<Long, BigDecimal> subEle4StdCost = new HashMap<Long, BigDecimal>(8);
        if (costInfoColl != null) {
            for (MaterialCostInfo costInfo : costInfoColl) {
                subEle4StdCost.put(costInfo.getSubElementId(), costInfo.getStandardCost());
            }
        }
        model.beginInit();
        for (int i = 0; i < elementSize; ++i) {
            Long[] element = allElement.get(i);
            long elementId = element[1];
            long subelementId = element[0];
            subEntryColl.addNew();
            model.setValue("costelement", (Object)elementId, i);
            model.setValue("costsubelement", (Object)subelementId, i);
            InitCalBillHelper.setSubEntryCommonField4Bill(model, materialId, baseunitId, entryQty, yearinqty, yearissueqty, i);
            BigDecimal standardcost = (BigDecimal)subEle4StdCost.get(subelementId);
            if (standardcost == null) continue;
            model.setValue("sub_price", (Object)standardcost, i);
            if (entryQty.compareTo(BigDecimal.ZERO) != 0) {
                model.setValue("sub_amount", (Object)standardcost.multiply(entryQty).setScale(amtprecision, RoundingMode.HALF_UP), i);
            }
            price = price.add(standardcost);
        }
        model.endInit();
        return price;
    }

    public static void buildSubEntry4CalbyEle(DynamicObject entry, IDataModel model, List<Long[]> elements) {
        long materialId = entry.getLong("material_id");
        long baseunitId = entry.getLong("baseunit_id");
        BigDecimal entryQty = entry.getBigDecimal("baseqty");
        BigDecimal yearinqty = entry.getBigDecimal("yearinqty");
        BigDecimal yearissueqty = entry.getBigDecimal("yearissueqty");
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        int elementsSize = elements.size();
        model.beginInit();
        for (int i = 0; i < elementsSize; ++i) {
            subEntryColl.addNew();
            Long[] curElements = elements.get(i);
            long costSubElement = curElements[0];
            long costElement = curElements[1];
            model.setValue("costelement", (Object)costElement, i);
            model.setValue("costsubelement", (Object)costSubElement, i);
            InitCalBillHelper.setSubEntryCommonField4Bill(model, materialId, baseunitId, entryQty, yearinqty, yearissueqty, i);
            ((DynamicObject)subEntryColl.get(i)).set("seq", (Object)(i + 1));
        }
        model.endInit();
    }

    public static BigDecimal buildSubEntry4StdNotCalbyEle(DynamicObject entry, IDataModel model, List<MaterialCostInfo> costInfoColl, DynamicObject costAcc) {
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        BigDecimal price = BigDecimal.ZERO;
        long materialId = entry.getLong("material_id");
        long baseunitId = entry.getLong("baseunit_id");
        BigDecimal entryQty = entry.getBigDecimal("baseqty");
        BigDecimal yearinqty = entry.getBigDecimal("yearinqty");
        BigDecimal yearissueqty = entry.getBigDecimal("yearissueqty");
        DynamicObject localCurrency = (DynamicObject)model.getValue("localcurrency");
        int amtprecision = localCurrency.getInt("amtprecision");
        Long[] defaultElements = CostElementHelper.getDefaultMaterialElements();
        model.beginInit();
        if (costInfoColl != null) {
            for (MaterialCostInfo costInfo : costInfoColl) {
                price = price.add(costInfo.getStandardCost());
            }
        }
        subEntryColl.addNew();
        model.setValue("costelement", (Object)defaultElements[1], 0);
        model.setValue("costsubelement", (Object)defaultElements[0], 0);
        InitCalBillHelper.setSubEntryCommonField4Bill(model, materialId, baseunitId, entryQty, yearinqty, yearissueqty, 0);
        model.setValue("sub_price", (Object)price, 0);
        if (entryQty.compareTo(BigDecimal.ZERO) != 0) {
            model.setValue("sub_amount", (Object)price.multiply(entryQty).setScale(amtprecision, RoundingMode.HALF_UP), 0);
        }
        model.endInit();
        return price;
    }

    public static void buildSubEntry4NotStdNotbyEle(DynamicObject entry, IDataModel model, DynamicObject costAcc) {
        long materialId = entry.getLong("material_id");
        long baseunitId = entry.getLong("baseunit_id");
        BigDecimal entryQty = entry.getBigDecimal("baseqty");
        BigDecimal yearinqty = entry.getBigDecimal("yearinqty");
        BigDecimal yearissueqty = entry.getBigDecimal("yearissueqty");
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        subEntryColl.addNew();
        Long[] defaultElements = CostElementHelper.getDefaultMaterialElements();
        model.beginInit();
        model.setValue("costelement", (Object)defaultElements[1], 0);
        model.setValue("costsubelement", (Object)defaultElements[0], 0);
        InitCalBillHelper.setSubEntryCommonField4Bill(model, materialId, baseunitId, entryQty, yearinqty, yearissueqty, 0);
        ((DynamicObject)subEntryColl.get(0)).set("seq", (Object)1);
        model.endInit();
    }

    public static void setSubEntry4StdEntry(Map<String, List<MaterialCostInfo>> stdMaterialMap, DynamicObject costAccount, int amtPrecision, DynamicObject entry, Set<Long> assistEffectPriceMatIds, boolean calByCostElement, Map<String, Long[]> defaultEleMap, Map<String, InitCalSubEntryInfo> importSubEntry, List<Long[]> allElement, Set<Long> hasMatVerCalDimIds, long entityId) {
        long costTypeId = costAccount.getLong("costtype_id");
        List<MaterialCostInfo> costInfList = InitCalBillHelper.getStdCostInfFromMap(stdMaterialMap, entry);
        if (costInfList == null || costInfList.isEmpty()) {
            return;
        }
        if (calByCostElement) {
            InitCalBillHelper.setSubEntry4StdEntry(costInfList, amtPrecision, entry, importSubEntry, allElement, entityId);
        } else {
            InitCalBillHelper.setSubEntry4StdNotEle(costInfList, amtPrecision, entry, defaultEleMap, costTypeId);
        }
    }

    public static void setSubEntry4StdEntry(List<MaterialCostInfo> costInfList, int amtPrecision, DynamicObject entry, Map<String, InitCalSubEntryInfo> importSubEntry, List<Long[]> allElement, long entityId) {
        Object entrySeq = entry.get("seq");
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        subEntryColl.clear();
        long materialId = entry.getLong("material_id");
        long baseunitId = entry.getLong("baseunit_id");
        BigDecimal entryQty = entry.getBigDecimal("baseqty");
        BigDecimal yearinqty = entry.getBigDecimal("yearinqty");
        BigDecimal yearissueqty = entry.getBigDecimal("yearissueqty");
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal costdiff = BigDecimal.ZERO;
        BigDecimal yearincost = BigDecimal.ZERO;
        BigDecimal yearincostdiff = BigDecimal.ZERO;
        BigDecimal yearissuecost = BigDecimal.ZERO;
        BigDecimal yearissuecostdiff = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> subEle4StdCost = new HashMap<Long, BigDecimal>(8);
        for (MaterialCostInfo costInfo : costInfList) {
            subEle4StdCost.put(costInfo.getSubElementId(), costInfo.getStandardCost());
        }
        for (int i = 0; i < allElement.size(); ++i) {
            InitCalSubEntryInfo importInfo;
            DynamicObject subEntry = subEntryColl.addNew();
            Long[] element = allElement.get(i);
            subEntry.set("seq", (Object)(i + 1));
            long subElementId = element[0];
            subEntry.set("costelement", (Object)element[1]);
            subEntry.set("costsubelement", (Object)subElementId);
            InitCalBillHelper.setSubEntryCommonField(subEntry, materialId, baseunitId, entryQty, yearinqty, yearissueqty);
            BigDecimal standardcost = (BigDecimal)subEle4StdCost.get(subElementId);
            if (standardcost == null) continue;
            subEntry.set("sub_price", (Object)standardcost);
            if (entryQty.compareTo(BigDecimal.ZERO) != 0) {
                subEntry.set("sub_amount", (Object)standardcost.multiply(entryQty).setScale(amtPrecision, RoundingMode.HALF_UP));
            }
            price = price.add(standardcost);
            amount = amount.add(standardcost.multiply(entryQty).setScale(amtPrecision, RoundingMode.HALF_UP));
            if (importSubEntry == null || (importInfo = importSubEntry.get(entityId + "|" + entrySeq + "|" + subElementId)) == null) continue;
            subEntry.set("sub_costdiff", (Object)importInfo.getCostdiff());
            subEntry.set("sub_yearincost", (Object)importInfo.getYearincost());
            subEntry.set("sub_yearincostdiff", (Object)importInfo.getYearincostdiff());
            subEntry.set("sub_yearissuecost", (Object)importInfo.getYearissuecost());
            subEntry.set("sub_yearissuecostdiff", (Object)importInfo.getYearissuecostdiff());
            costdiff = costdiff.add(importInfo.getCostdiff());
            yearincost = yearincost.add(importInfo.getYearincost());
            yearissuecost = yearissuecost.add(importInfo.getYearissuecost());
            yearincostdiff = yearincostdiff.add(importInfo.getYearincostdiff());
            yearissuecostdiff = yearissuecostdiff.add(importInfo.getYearissuecostdiff());
        }
        entry.set("price", (Object)price.setScale(10, RoundingMode.HALF_UP));
        entry.set("amount", (Object)amount.setScale(amtPrecision, RoundingMode.HALF_UP));
        if (importSubEntry == null) {
            return;
        }
        entry.set("costdiff", (Object)costdiff.setScale(amtPrecision, RoundingMode.HALF_UP));
        entry.set("yearincost", (Object)yearincost.setScale(amtPrecision, RoundingMode.HALF_UP));
        entry.set("yearincostdiff", (Object)yearincostdiff.setScale(amtPrecision, RoundingMode.HALF_UP));
        entry.set("yearissuecost", (Object)yearissuecost.setScale(amtPrecision, RoundingMode.HALF_UP));
        entry.set("yearissuecostdiff", (Object)yearissuecostdiff.setScale(amtPrecision, RoundingMode.HALF_UP));
    }

    public static void setSynSubEntry4StdEntry(List<MaterialCostInfo> costInfList, int amtPrecision, DynamicObject entry, List<Long[]> allElement, boolean currencyTag, Map<String, Object> exchangeRateMap, String diffAmtRule) {
        block13: {
            BigDecimal subAmt;
            BigDecimal costDiffAmt;
            DynamicObjectCollection subEntryColl;
            block12: {
                subEntryColl = entry.getDynamicObjectCollection("subentryentity");
                subEntryColl.clear();
                long materialId = entry.getLong("material_id");
                long baseunitId = entry.getLong("baseunit_id");
                BigDecimal entryQty = entry.getBigDecimal("baseqty");
                BigDecimal yearinqty = entry.getBigDecimal("yearinqty");
                BigDecimal yearissueqty = entry.getBigDecimal("yearissueqty");
                BigDecimal resultAmount = entry.getBigDecimal("amount");
                BigDecimal price = BigDecimal.ZERO;
                BigDecimal amount = BigDecimal.ZERO;
                HashMap<Long, BigDecimal> subEle4StdCost = new HashMap<Long, BigDecimal>(8);
                for (MaterialCostInfo costInfo : costInfList) {
                    subEle4StdCost.put(costInfo.getSubElementId(), costInfo.getStandardCost());
                }
                for (int i = 0; i < allElement.size(); ++i) {
                    DynamicObject subEntry = subEntryColl.addNew();
                    Long[] element = allElement.get(i);
                    subEntry.set("seq", (Object)(i + 1));
                    long subElementId = element[0];
                    subEntry.set("costelement", (Object)element[1]);
                    subEntry.set("costsubelement", (Object)subElementId);
                    InitCalBillHelper.setSubEntryCommonField(subEntry, materialId, baseunitId, entryQty, yearinqty, yearissueqty);
                    BigDecimal standardcost = (BigDecimal)subEle4StdCost.get(subElementId);
                    if (standardcost == null) continue;
                    subEntry.set("sub_price", (Object)standardcost);
                    if (entryQty.compareTo(BigDecimal.ZERO) != 0) {
                        subEntry.set("sub_amount", (Object)standardcost.multiply(entryQty).setScale(amtPrecision, RoundingMode.HALF_UP));
                    }
                    price = price.add(standardcost);
                    amount = amount.add(standardcost.multiply(entryQty).setScale(amtPrecision, RoundingMode.HALF_UP));
                }
                entry.set("price", (Object)price.setScale(10, RoundingMode.HALF_UP));
                entry.set("amount", (Object)amount.setScale(amtPrecision, RoundingMode.HALF_UP));
                if (!currencyTag) {
                    resultAmount = InitCalBillHelper.getResultAmount(resultAmount, amtPrecision, exchangeRateMap);
                }
                costDiffAmt = resultAmount.subtract(amount).setScale(amtPrecision, RoundingMode.HALF_UP);
                entry.set("costdiff", (Object)costDiffAmt);
                entry.set("createtype", (Object)CostAdjustBillDiffTypeEnum.ORDER_DIFF.getValue());
                if (!"A".equals(diffAmtRule)) break block12;
                BigDecimal sumSubAmt = BigDecimal.ZERO;
                for (DynamicObject subEntry : subEntryColl) {
                    sumSubAmt = sumSubAmt.add(subEntry.getBigDecimal("sub_amount").abs());
                }
                int i = 1;
                BigDecimal accrueCostDiff = BigDecimal.ZERO;
                BigDecimal restDiffAmt = BigDecimal.ZERO;
                int lastDiffIndex = 0;
                for (DynamicObject subEntry : subEntryColl) {
                    BigDecimal subAmt2;
                    if (i == subEntryColl.size()) {
                        subAmt2 = subEntry.getBigDecimal("sub_amount");
                        if (subAmt2.compareTo(BigDecimal.ZERO) == 0) {
                            restDiffAmt = costDiffAmt.subtract(accrueCostDiff);
                            break;
                        }
                        subEntry.set("sub_costdiff", (Object)costDiffAmt.subtract(accrueCostDiff));
                        break;
                    }
                    ++i;
                    subAmt2 = subEntry.getBigDecimal("sub_amount");
                    if (subAmt2.compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal rate = subAmt2.abs().divide(sumSubAmt, 10, RoundingMode.HALF_UP);
                    BigDecimal subCostDiff = costDiffAmt.multiply(rate).setScale(amtPrecision, RoundingMode.HALF_UP);
                    subEntry.set("sub_costdiff", (Object)subCostDiff);
                    accrueCostDiff = accrueCostDiff.add(subCostDiff);
                    lastDiffIndex = i - 1;
                }
                if (restDiffAmt.compareTo(BigDecimal.ZERO) == 0) break block13;
                BigDecimal lastDiff = (BigDecimal)((DynamicObject)subEntryColl.get(lastDiffIndex - 1)).get("sub_costdiff");
                ((DynamicObject)subEntryColl.get(lastDiffIndex - 1)).set("sub_costdiff", (Object)lastDiff.add(restDiffAmt));
                break block13;
            }
            boolean isUseMatElement = true;
            for (DynamicObject subEntry : subEntryColl) {
                if (subEntry.getLong("costsubelement") != 773175233367685120L) continue;
                subAmt = subEntry.getBigDecimal("sub_amount");
                if (subAmt == null || BigDecimal.ZERO.compareTo(subAmt) == 0) {
                    isUseMatElement = false;
                    break;
                }
                subEntry.set("sub_costdiff", (Object)costDiffAmt);
                break;
            }
            if (!isUseMatElement) {
                for (DynamicObject subEntry : subEntryColl) {
                    subAmt = subEntry.getBigDecimal("sub_amount");
                    if (subAmt == null || BigDecimal.ZERO.compareTo(subAmt) == 0) continue;
                    subEntry.set("sub_costdiff", (Object)costDiffAmt);
                    break;
                }
            }
        }
    }

    public static BigDecimal getTargetAmount(BigDecimal exchangeRate, Boolean quoteType, BigDecimal sourceAmount, int amtPrecision) {
        BigDecimal targetAmount = BigDecimal.ZERO;
        if (sourceAmount == null || sourceAmount.compareTo(BigDecimal.ZERO) == 0) {
            return targetAmount;
        }
        if (exchangeRate != null) {
            targetAmount = quoteType != false ? sourceAmount.divide(exchangeRate, amtPrecision, 4) : sourceAmount.multiply(exchangeRate).setScale(amtPrecision, 4);
        }
        return targetAmount;
    }

    public static void setSubEntry4NotStdCalByEle(DynamicObject entry, List<Long[]> elements, Map<String, InitCalSubEntryInfo> importSubEntry, int amtPrecision, long entityId) {
        Object entrySeq = entry.get("seq");
        long materialId = entry.getLong("material_id");
        long baseunitId = entry.getLong("baseunit_id");
        BigDecimal entryQty = entry.getBigDecimal("baseqty");
        BigDecimal yearinqty = entry.getBigDecimal("yearinqty");
        BigDecimal yearissueqty = entry.getBigDecimal("yearissueqty");
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal yearincost = BigDecimal.ZERO;
        BigDecimal yearissuecost = BigDecimal.ZERO;
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        HashMap<String, DynamicObject> subEntryMap = new HashMap<String, DynamicObject>();
        if (subEntryColl != null && !subEntryColl.isEmpty()) {
            for (DynamicObject subEntry : subEntryColl) {
                long costsubelement = subEntry.getDynamicObject("costsubelement").getLong("id");
                if (costsubelement == 0L) continue;
                subEntryMap.put(entityId + "|" + entrySeq + "|" + costsubelement, subEntry);
            }
        }
        int elementsSize = elements.size();
        for (int i = 0; i < elementsSize; ++i) {
            InitCalSubEntryInfo importInfo;
            Long[] curElements = elements.get(i);
            long costSubElement = curElements[0];
            long costElement = curElements[1];
            String subKey = entityId + "|" + entrySeq + "|" + costSubElement;
            DynamicObject subEntry = subEntryMap.containsKey(subKey) ? (DynamicObject)subEntryMap.get(subKey) : subEntryColl.addNew();
            subEntry.set("seq", (Object)(i + 1));
            subEntry.set("costelement", (Object)costElement);
            subEntry.set("costsubelement", (Object)costSubElement);
            InitCalBillHelper.setSubEntryCommonField(subEntry, materialId, baseunitId, entryQty, yearinqty, yearissueqty);
            if (importSubEntry == null || (importInfo = importSubEntry.get(entityId + "|" + entrySeq + "|" + costSubElement)) == null) continue;
            BigDecimal importSubprice = importInfo.getPrice();
            BigDecimal importSubamout = importInfo.getAmount();
            if (importSubprice.compareTo(BigDecimal.ZERO) != 0) {
                subEntry.set("sub_price", (Object)importSubprice);
                if (entryQty.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal subamout = importSubprice.multiply(entryQty).setScale(amtPrecision, RoundingMode.HALF_UP);
                    subEntry.set("sub_amount", (Object)subamout);
                    amount = amount.add(subamout);
                }
            } else if (importSubamout.compareTo(BigDecimal.ZERO) != 0) {
                subEntry.set("sub_amount", (Object)importSubamout);
                if (entryQty.compareTo(BigDecimal.ZERO) != 0) {
                    subEntry.set("sub_price", (Object)importSubamout.divide(entryQty, 10, RoundingMode.HALF_UP));
                }
                amount = amount.add(importSubamout);
            }
            subEntry.set("sub_costdiff", (Object)importInfo.getCostdiff());
            subEntry.set("sub_yearincost", (Object)importInfo.getYearincost());
            subEntry.set("sub_yearincostdiff", (Object)importInfo.getYearincostdiff());
            subEntry.set("sub_yearissuecost", (Object)importInfo.getYearissuecost());
            subEntry.set("sub_yearissuecostdiff", (Object)importInfo.getYearissuecostdiff());
            yearincost = yearincost.add(importInfo.getYearincost());
            yearissuecost = yearissuecost.add(importInfo.getYearissuecost());
        }
        entry.set("amount", (Object)amount);
        if (entryQty.compareTo(BigDecimal.ZERO) == 0) {
            entry.set("price", (Object)BigDecimal.ZERO);
        } else {
            entry.set("price", (Object)amount.divide(entryQty, 10, RoundingMode.HALF_UP));
        }
        if (yearincost.compareTo(BigDecimal.ZERO) != 0) {
            entry.set("yearincost", (Object)yearincost.setScale(amtPrecision, RoundingMode.HALF_UP));
        }
        if (yearissuecost.compareTo(BigDecimal.ZERO) != 0) {
            entry.set("yearissuecost", (Object)yearissuecost.setScale(amtPrecision, RoundingMode.HALF_UP));
        }
    }

    public static void setSynSubEntry4NotStdCalByEle(DynamicObject entry, List<Long[]> elements, int amtPrecision, boolean currencyTag, Map<String, Object> exchangeRateMap) {
        long materialId = entry.getLong("material_id");
        long baseunitId = entry.getLong("baseunit_id");
        BigDecimal entryQty = entry.getBigDecimal("baseqty");
        BigDecimal yearinqty = entry.getBigDecimal("yearinqty");
        BigDecimal yearissueqty = entry.getBigDecimal("yearissueqty");
        BigDecimal resultAmount = entry.getBigDecimal("amount");
        if (!currencyTag) {
            resultAmount = InitCalBillHelper.getResultAmount(resultAmount, amtPrecision, exchangeRateMap);
        }
        entry.set("amount", (Object)resultAmount);
        if (entryQty.compareTo(BigDecimal.ZERO) == 0) {
            entry.set("price", (Object)BigDecimal.ZERO);
        } else {
            entry.set("price", (Object)resultAmount.divide(entryQty, 10, RoundingMode.HALF_UP));
        }
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        subEntryColl.clear();
        int elementsSize = elements.size();
        Long[] defaultMaterialElements = CostElementHelper.getDefaultMaterialElements();
        for (int i = 0; i < elementsSize; ++i) {
            DynamicObject subEntry = subEntryColl.addNew();
            Long[] curElements = elements.get(i);
            long costSubElement = curElements[0];
            long costElement = curElements[1];
            subEntry.set("seq", (Object)(i + 1));
            subEntry.set("costelement", (Object)costElement);
            subEntry.set("costsubelement", (Object)costSubElement);
            InitCalBillHelper.setSubEntryCommonField(subEntry, materialId, baseunitId, entryQty, yearinqty, yearissueqty);
            if (costSubElement != defaultMaterialElements[0]) continue;
            subEntry.set("sub_price", (Object)entry.getBigDecimal("price"));
            subEntry.set("sub_amount", (Object)resultAmount);
        }
    }

    public static void setSubEntry4StdNotEle(List<MaterialCostInfo> costInfList, int amtPrecision, DynamicObject entry, Map<String, Long[]> defaultEleMap, long costtypeId) {
        DynamicObject materialInfo = entry.getDynamicObject("material");
        long baseunitId = materialInfo.getLong("baseunit_id");
        BigDecimal entryQty = entry.getBigDecimal("baseqty");
        BigDecimal yearinqty = entry.getBigDecimal("yearinqty");
        BigDecimal yearissueqty = entry.getBigDecimal("yearissueqty");
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        subEntryColl.clear();
        DynamicObject subEntry = subEntryColl.addNew();
        long materialId = materialInfo.getLong("id");
        Long[] defaultElements = CostElementHelper.getDefaultMaterialElements();
        BigDecimal price = BigDecimal.ZERO;
        for (MaterialCostInfo costInfo : costInfList) {
            price = price.add(costInfo.getStandardCost());
        }
        subEntry.set("costelement", (Object)defaultElements[1]);
        subEntry.set("costsubelement", (Object)defaultElements[0]);
        subEntry.set("sub_material", (Object)materialId);
        subEntry.set("sub_baseunit", (Object)baseunitId);
        subEntry.set("sub_baseqty", (Object)entryQty);
        subEntry.set("sub_yearinqty", (Object)yearinqty);
        subEntry.set("sub_yearissueqty", (Object)yearissueqty);
        subEntry.set("sub_price", (Object)price);
        entry.set("price", (Object)price);
        if (entryQty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal amount = price.multiply(entryQty).setScale(amtPrecision, RoundingMode.HALF_UP);
            entry.set("amount", (Object)amount);
            subEntry.set("sub_amount", (Object)amount);
        }
        ((DynamicObject)subEntryColl.get(0)).set("seq", (Object)1);
    }

    public static void setSubEntry4NotStdNotEle(Map<String, Long[]> defaultEleMap, DynamicObject costAccount, DynamicObject entry) {
        DynamicObject materialInfo = entry.getDynamicObject("material");
        long baseunitId = materialInfo.getLong("baseunit_id");
        BigDecimal entryQty = entry.getBigDecimal("baseqty");
        BigDecimal yearinqty = entry.getBigDecimal("yearinqty");
        BigDecimal yearissueqty = entry.getBigDecimal("yearissueqty");
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        subEntryColl.clear();
        DynamicObject subEntry = subEntryColl.addNew();
        long materialId = materialInfo.getLong("id");
        Long[] defaultElements = CostElementHelper.getDefaultMaterialElements();
        subEntry.set("costelement", (Object)defaultElements[1]);
        subEntry.set("costsubelement", (Object)defaultElements[0]);
        subEntry.set("sub_material", (Object)materialId);
        subEntry.set("sub_baseunit", (Object)baseunitId);
        subEntry.set("sub_baseqty", (Object)entryQty);
        subEntry.set("sub_yearinqty", (Object)yearinqty);
        subEntry.set("sub_yearissueqty", (Object)yearissueqty);
        ((DynamicObject)subEntryColl.get(0)).set("seq", (Object)1);
    }

    public static void setSubEntry4NotCalByEle(DynamicObject entry, Long[] defaultElements, BigDecimal amount) {
        Long defaultSubEle = defaultElements[0];
        Long defaultEle = defaultElements[1];
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        DynamicObject subEntry = subEntryColl.addNew();
        subEntry.set("costelement", (Object)defaultEle);
        subEntry.set("costsubelement", (Object)defaultSubEle);
        if (amount != null) {
            subEntry.set("sub_price", (Object)entry.getBigDecimal("price"));
            subEntry.set("sub_amount", (Object)amount);
            subEntry.set("sub_costdiff", (Object)entry.getBigDecimal("costdiff"));
        }
        subEntry.set("sub_baseqty", (Object)entry.getBigDecimal("baseqty"));
        subEntry.set("sub_material", (Object)entry.getLong("material_id"));
        subEntry.set("sub_baseunit", (Object)entry.getLong("baseunit_id"));
        subEntry.set("sub_yearinqty", (Object)entry.getBigDecimal("yearinqty"));
        subEntry.set("sub_yearissueqty", (Object)entry.getBigDecimal("yearissueqty"));
        subEntry.set("seq", (Object)1);
    }

    public static void setSubEntryCommonField(DynamicObject subEntry, long materialId, long baseunitId, BigDecimal entryQty, BigDecimal yearinqty, BigDecimal yearissueqty) {
        subEntry.set("sub_material", (Object)materialId);
        subEntry.set("sub_baseunit", (Object)baseunitId);
        subEntry.set("sub_baseqty", (Object)entryQty);
        subEntry.set("sub_yearinqty", (Object)yearinqty);
        subEntry.set("sub_yearissueqty", (Object)yearissueqty);
    }

    public static void setSubEntryCommonField4Bill(IDataModel model, long materialId, long baseunitId, BigDecimal entryQty, BigDecimal yearinqty, BigDecimal yearissueqty, int rowIdx) {
        model.setValue("sub_material", (Object)materialId, rowIdx);
        model.setValue("sub_baseunit", (Object)baseunitId, rowIdx);
        model.setValue("sub_baseqty", (Object)entryQty, rowIdx);
        model.setValue("sub_yearinqty", (Object)yearinqty, rowIdx);
        model.setValue("sub_yearissueqty", (Object)yearissueqty, rowIdx);
    }

    public static boolean assistAffectMatPrice(long materialId) {
        QFilter qFilter = new QFilter("id", "=", (Object)materialId);
        qFilter.and("auxptyentry.isaffectprice", "=", (Object)true);
        DynamicObject material = QueryServiceHelper.queryOne((String)"bd_material", (String)"id", (QFilter[])qFilter.toArray());
        return material != null;
    }

    public static Set<Long> cacheAssistAffectPriceMatIds(Set<Long> materialIds) {
        HashSet<Long> assistEffectPriceMatIds = new HashSet<Long>(materialIds.size());
        if (materialIds.isEmpty()) {
            return assistEffectPriceMatIds;
        }
        QFilter qFilter = new QFilter("id", "in", materialIds);
        qFilter.and("auxptyentry.isaffectprice", "=", (Object)true);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)InitCalBillHelper.class.getName(), (String)"bd_material", (String)"id", (QFilter[])qFilter.toArray(), null);){
            for (Row row : ds) {
                assistEffectPriceMatIds.add(row.getLong("id"));
            }
        }
        return assistEffectPriceMatIds;
    }

    public static List<MaterialCostInfo> getStdCostInfFromMap(Map<String, List<MaterialCostInfo>> costInfoMap, DynamicObject entry) {
        Long entryId = entry.getLong("id");
        Long materialId = entry.getLong("material_id");
        String dimKey = entryId + "|" + materialId;
        return costInfoMap.get(dimKey);
    }

    public static BigDecimal getResultAmount(BigDecimal resultAmount, Integer amtPrecision, Map<String, Object> exchangeRateMap) {
        Boolean quoteType = (Boolean)exchangeRateMap.get("quoteType");
        BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get("exchangeRate");
        if (exchangeRate != null) {
            resultAmount = InitCalBillHelper.getTargetAmount(exchangeRate, quoteType, resultAmount, amtPrecision);
        } else if (exchangeRateMap.containsKey("exchangeRateTargetUSD") && exchangeRateMap.containsKey("exchangeRatesourceUSD")) {
            BigDecimal exchangeRateTargetUSD = (BigDecimal)exchangeRateMap.get("exchangeRateTargetUSD");
            BigDecimal exchangeRatesourceUSD = (BigDecimal)exchangeRateMap.get("exchangeRatesourceUSD");
            resultAmount = InitCalBillHelper.getTargetAmount(exchangeRatesourceUSD, quoteType, InitCalBillHelper.getTargetAmount(exchangeRateTargetUSD, quoteType, resultAmount, amtPrecision), amtPrecision);
        }
        return resultAmount;
    }
}

