/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.cal.common.helper.MaterialCategoryHelper;

public class MaterialCategoryHandle {
    private static Set<String> headStorageorgunitEntitys = new HashSet<String>(4);

    public static Set<String> getHeadStorageorgunitEntitys() {
        return headStorageorgunitEntitys;
    }

    public static void handle4Bill(DynamicObject[] bills) {
        if (bills == null || bills.length == 0) {
            return;
        }
        String entity = bills[0].getDataEntityType().getName();
        String entryKey = MaterialCategoryHandle.getBillEntryKey(entity);
        String orgName = MaterialCategoryHandle.getOrgName(bills[0]);
        Map<Long, Map<Long, Long>> org2Material2Category = MaterialCategoryHandle.getOrg2Material2Category(bills, entryKey);
        if (org2Material2Category == null || org2Material2Category.isEmpty()) {
            return;
        }
        for (DynamicObject bill : bills) {
            Long calorgId = bill.getLong(orgName + "_id");
            if (entryKey == null) {
                Long materialId;
                Long storageorgunit;
                Long ownerId = bill.getLong("owner_id");
                Long stocktypeId = MaterialCategoryHandle.getStocktypeId(org2Material2Category, calorgId, ownerId, storageorgunit = Long.valueOf(bill.getLong("storageorgunit_id")), materialId = Long.valueOf(bill.getLong("material_id")));
                if (stocktypeId == null) continue;
                bill.set("stocktype_id", (Object)stocktypeId);
                continue;
            }
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject entryRow : entry) {
                Long ownerId = entryRow.getLong("owner_id");
                Long materialId = entryRow.getLong("material_id");
                Long storageorgunit = 0L;
                storageorgunit = headStorageorgunitEntitys.contains(entity) ? Long.valueOf(bill.getLong("storageorgunit_id")) : Long.valueOf(entryRow.getLong("storageorgunit_id"));
                Long stocktypeId = MaterialCategoryHandle.getStocktypeId(org2Material2Category, calorgId, ownerId, storageorgunit, materialId);
                if (stocktypeId == null) continue;
                entryRow.set("stocktype_id", (Object)stocktypeId);
            }
        }
    }

    private static Long getStocktypeId(Map<Long, Map<Long, Long>> org2Material2Category, Long calorgId, Long ownerId, Long storageorgunit, Long materialId) {
        if (org2Material2Category == null) {
            return null;
        }
        Long stocktypeId = null;
        Map<Long, Long> map = org2Material2Category.get(storageorgunit);
        if (map != null) {
            stocktypeId = map.get(materialId);
        }
        if (stocktypeId != null) {
            return stocktypeId;
        }
        map = org2Material2Category.get(ownerId);
        if (map != null) {
            stocktypeId = map.get(materialId);
        }
        if (stocktypeId != null) {
            return stocktypeId;
        }
        map = org2Material2Category.get(calorgId);
        if (map != null) {
            stocktypeId = map.get(materialId);
        }
        if (stocktypeId != null) {
            return stocktypeId;
        }
        return null;
    }

    public static void handle4NullCategoryBill(DynamicObject[] bills) {
        if (bills == null || bills.length == 0) {
            return;
        }
        String entity = bills[0].getDataEntityType().getName();
        String entryKey = MaterialCategoryHandle.getBillEntryKey(entity);
        ArrayList<DynamicObject> nullCategoryBills = new ArrayList<DynamicObject>(16);
        block0: for (DynamicObject info : bills) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection(entryKey);
            for (DynamicObject entryinfo : entrys) {
                if (entryinfo.getDynamicObject("stocktype") != null) continue;
                nullCategoryBills.add(info);
                continue block0;
            }
        }
        if (!nullCategoryBills.isEmpty()) {
            MaterialCategoryHandle.handle4Bill(nullCategoryBills.toArray(new DynamicObject[0]));
        }
    }

    private static Map<Long, Map<Long, Long>> getOrg2Material2Category(DynamicObject[] bills, String entryKey) {
        HashSet<Long> costaccountids = new HashSet<Long>(4);
        HashSet<Long> orgIds = new HashSet<Long>(4);
        HashSet<Long> materialIds = new HashSet<Long>(4);
        String entity = bills[0].getDataEntityType().getName();
        for (DynamicObject bill : bills) {
            Long calorgId = bill.getLong("costaccount_id");
            costaccountids.add(calorgId);
            if (entryKey == null) {
                orgIds.add(bill.getLong("owner_id"));
                orgIds.add(bill.getLong("storageorgunit_id"));
                materialIds.add(bill.getLong("material_id"));
                continue;
            }
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject entryRow : entry) {
                Long ownerId = entryRow.getLong("owner_id");
                Long materialId = entryRow.getLong("material_id");
                orgIds.add(ownerId);
                materialIds.add(materialId);
                if (headStorageorgunitEntitys.contains(entity)) {
                    orgIds.add(bill.getLong("storageorgunit_id"));
                    continue;
                }
                orgIds.add(entryRow.getLong("storageorgunit_id"));
            }
        }
        MaterialCategoryHelper helper = MaterialCategoryHelper.getMaterialCategoryHelperByMat(costaccountids, orgIds, materialIds);
        Map<Long, Map<Long, Long>> org2Material2Category = helper.getOrg2Material2Category();
        return org2Material2Category;
    }

    private static String getBillEntryKey(String entity) {
        if ("cal_costadjust_subentity".equals(entity) || "cal_costadjustbill".equals(entity) || "cal_stdcostdiffbill".equals(entity) || "cal_initbill".equals(entity)) {
            return "entryentity";
        }
        if ("cal_bal".equals(entity) || "cal_balance".equals(entity) || "cal_standcost_bal".equals(entity) || "cal_costdiffgroupbill".equals(entity)) {
            return null;
        }
        return "entry";
    }

    private static String getOrgName(DynamicObject bill) {
        String entity = bill.getDataEntityType().getName();
        String orgName = "calorg";
        if ("cal_price_provbill".equals(entity) || "cal_price_revbill".equals(entity)) {
            orgName = "org";
        }
        return orgName;
    }

    static {
        headStorageorgunitEntitys.add("cal_bal");
        headStorageorgunitEntitys.add("cal_balance");
        headStorageorgunitEntitys.add("cal_standcost_bal");
        headStorageorgunitEntitys.add("cal_costrecord_subentity");
        headStorageorgunitEntitys.add("cal_costrecord");
        headStorageorgunitEntitys.add("cal_costdiffgroupbill");
    }
}

