/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.WriteLogHelper;

public class MaterialCategoryHelper
implements Serializable {
    private static final Log logger = LogFactory.getLog(MaterialCategoryHelper.class);
    private static final long serialVersionUID = -6742004376648861252L;
    private String cache_org2Category2MaterialidMap_id;
    private String cache_org2Material2CategoryMap_id;
    private Set<Long> calorgIds = new HashSet<Long>(16);
    private Set<Long> ownerIds = new HashSet<Long>(16);
    private Map<Long, Set<Long>> owner2calOrgIdMap = new HashMap<Long, Set<Long>>(16);
    private String cache_materialIds_id;
    private Map<Long, Set<Long>> params_orgmaterialcategory;
    private Map<Long, Set<Long>> params_orgmaterial;

    public static MaterialCategoryHelper getMaterialCategoryHelperByMat(Set<Long> costAccountIds, Set<Long> ownerIds, Set<Long> matIds) {
        DynamicObjectCollection costAccounts = MaterialCategoryHelper.getAcctDycs(costAccountIds);
        DynamicObjectCollection owners = MaterialCategoryHelper.getOwnerDycs(ownerIds);
        return new MaterialCategoryHelper(costAccounts, owners, matIds);
    }

    public static MaterialCategoryHelper getMaterialCategoryHelperByMatCat(Set<Long> costAccountIds, Set<Long> ownerIds, Set<Long> mulMatCategoryIds) {
        DynamicObjectCollection costAccounts = MaterialCategoryHelper.getAcctDycs(costAccountIds);
        DynamicObjectCollection owners = MaterialCategoryHelper.getOwnerDycs(ownerIds);
        DynamicObjectCollection mulMaterialCategory = MaterialCategoryHelper.getMatCatDycs(mulMatCategoryIds);
        MaterialCategoryHelper materialCategoryHelper = new MaterialCategoryHelper(costAccounts, owners, mulMaterialCategory);
        return materialCategoryHelper;
    }

    private static DynamicObjectCollection getMatCatDycs(Set<Long> mulMatCategoryIds) {
        DynamicObjectCollection mulMaterialCategory = new DynamicObjectCollection();
        DynamicObject[] mulMatCatDycs = new DynamicObject[]{};
        if (mulMatCategoryIds != null && mulMatCategoryIds.size() > 0) {
            QFilter matCatIdsF = new QFilter("id", "in", mulMatCategoryIds);
            mulMatCatDycs = BusinessDataServiceHelper.load((String)"bd_materialcategory", (String)"id", (QFilter[])matCatIdsF.toArray());
        }
        mulMaterialCategory.addAll(Arrays.asList(mulMatCatDycs));
        return mulMaterialCategory;
    }

    private static DynamicObjectCollection getOwnerDycs(Set<Long> ownerIds) {
        DynamicObjectCollection owners = new DynamicObjectCollection();
        DynamicObject[] ownerDycs = new DynamicObject[]{};
        if (ownerIds != null && ownerIds.size() > 0) {
            QFilter ownerIdsF = new QFilter("id", "in", ownerIds);
            ownerDycs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])ownerIdsF.toArray());
        }
        owners.addAll(Arrays.asList(ownerDycs));
        return owners;
    }

    private static DynamicObjectCollection getAcctDycs(Set<Long> costAccountIds) {
        DynamicObject[] acctDycs = new DynamicObject[]{};
        if (costAccountIds != null && costAccountIds.size() > 0) {
            QFilter acctIdsF = new QFilter("id", "in", costAccountIds);
            acctDycs = BusinessDataServiceHelper.load((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])acctIdsF.toArray());
        }
        DynamicObjectCollection costAccounts = new DynamicObjectCollection();
        costAccounts.addAll(Arrays.asList(acctDycs));
        return costAccounts;
    }

    public MaterialCategoryHelper(DynamicObjectCollection costAccounts, DynamicObjectCollection owners, DynamicObjectCollection mulMaterialCategory) {
        HashSet<Long> categoryIds = null;
        if (mulMaterialCategory != null && mulMaterialCategory.size() > 0) {
            categoryIds = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : mulMaterialCategory) {
                categoryIds.add(dynamicObject.getLong("id"));
            }
        }
        this.params_orgmaterialcategory = this.getParamMap(costAccounts, owners, categoryIds);
        this.queryCategory();
    }

    private void queryCategory() {
        HashSet<Long> materialids;
        if (this.params_orgmaterialcategory != null) {
            Map org2Category2MaterialidMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"MaterialCategoryService", (String)"getMaterialByOrgAndMaterialCategory", (Object[])new Object[]{this.params_orgmaterialcategory});
            this.cache_org2Category2MaterialidMap_id = this.create_org2Category2Material_CacheDataSet(org2Category2MaterialidMap);
            materialids = new HashSet<Long>(16);
            for (Map map : org2Category2MaterialidMap.values()) {
                for (Set value : map.values()) {
                    materialids.addAll(value);
                }
            }
            this.cache_materialIds_id = this.create_materialididCacheDataSet(materialids);
        }
        if (this.params_orgmaterial != null && !this.params_orgmaterial.isEmpty()) {
            Map org2Material2CategoryMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"MaterialCategoryService", (String)"getMaterialCategoryByOrgAndMaterial", (Object[])new Object[]{this.params_orgmaterial});
            this.cache_org2Material2CategoryMap_id = this.create_org2Material2Category_CacheDataSet(org2Material2CategoryMap);
            materialids = new HashSet(16);
            for (Map map : org2Material2CategoryMap.values()) {
                materialids.addAll(map.keySet());
            }
            this.cache_materialIds_id = this.create_materialididCacheDataSet(materialids);
        }
    }

    private Map<Long, Set<Long>> getParamMap(DynamicObjectCollection costAccounts, DynamicObjectCollection owners, Set<Long> categoryOrMatIds) {
        HashMap<Long, Set<Long>> params = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject costAccount : costAccounts) {
            Long[] calOrgid = Long.valueOf(costAccount.getDynamicObject("calorg").getLong("id"));
            this.calorgIds.add((Long)calOrgid);
            params.put((Long)calOrgid, categoryOrMatIds);
        }
        if (owners == null || owners.size() == 0) {
            for (DynamicObject costAccount : costAccounts) {
                for (Long id : AccountingSysHelper.getOwners(costAccount.getLong("id"))) {
                    this.ownerIds.add(id);
                    Set orgids = this.owner2calOrgIdMap.computeIfAbsent(id, k -> new HashSet(16));
                    orgids.add(costAccount.getDynamicObject("calorg").getLong("id"));
                    params.put(id, categoryOrMatIds);
                }
            }
        } else {
            for (DynamicObject dynamicObject : owners) {
                if (dynamicObject.getDataEntityType().getProperties().containsKey((Object)"fbasedataid")) {
                    dynamicObject = dynamicObject.getDynamicObject("fbasedataid");
                }
                long ownerid = dynamicObject.getLong("id");
                this.ownerIds.add(ownerid);
                params.put(ownerid, categoryOrMatIds);
                Long[] calorgid = AccountingSysHelper.getCalOrgIds(ownerid);
                this.owner2calOrgIdMap.put(ownerid, new HashSet<Long>(Arrays.asList(calorgid)));
            }
        }
        return params;
    }

    public MaterialCategoryHelper(DynamicObjectCollection costAccounts, DynamicObjectCollection owners, Set<Long> materialIdContainer) {
        this.params_orgmaterial = this.getParamMap(costAccounts, owners, materialIdContainer);
        this.queryCategory();
    }

    public DataSet getMaterialCategoryDataSet(boolean onlyCalOrg) {
        Map<Long, Map<Long, Long>> org2Material2CategoryMap = null;
        if (!StringUtils.isEmpty((String)this.cache_org2Material2CategoryMap_id)) {
            try {
                DataSet org2Material2CategoryMapDataSet = Algo.getCacheDataSet((String)this.cache_org2Material2CategoryMap_id).toDataSet(Algo.create((String)this.getClass().getName()), false);
                org2Material2CategoryMap = this.create_org2Material2CategoryMap(org2Material2CategoryMapDataSet);
            }
            catch (Exception e) {
                this.queryCategory();
                DataSet org2Material2CategoryMapDataSet = Algo.getCacheDataSet((String)this.cache_org2Material2CategoryMap_id).toDataSet(Algo.create((String)this.getClass().getName()), false);
                org2Material2CategoryMap = this.create_org2Material2CategoryMap(org2Material2CategoryMapDataSet);
                WriteLogHelper.writeErrorLog(logger, "MaterialCategoryHelper-getMaterialCategoryDataSet", e);
            }
        }
        if (org2Material2CategoryMap == null) {
            org2Material2CategoryMap = this.getOrg2Material2CategoryMap();
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("calorg", (DataType)DateType.LongType), new Field("owner", (DataType)DateType.LongType), new Field("material", (DataType)DateType.LongType), new Field("materialcategory", (DataType)DateType.LongType)});
        DataSetBuilder materialCategoryBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (Long materialid : this.getMaterialIds()) {
            if (onlyCalOrg) {
                for (Long calorgId : this.calorgIds) {
                    Long categoryid = org2Material2CategoryMap.get(calorgId).get(materialid);
                    materialCategoryBuilder.append(new Object[]{calorgId, calorgId, materialid, categoryid});
                }
                continue;
            }
            for (Long ownerId : this.ownerIds) {
                for (Long calorgId : this.owner2calOrgIdMap.get(ownerId)) {
                    Long categoryid = org2Material2CategoryMap.get(ownerId).get(materialid);
                    if (categoryid == null) {
                        categoryid = org2Material2CategoryMap.get(calorgId).get(materialid);
                    }
                    materialCategoryBuilder.append(new Object[]{calorgId, ownerId, materialid, categoryid});
                }
            }
        }
        DataSet ds = materialCategoryBuilder.build();
        return ds;
    }

    public Map<Long, Map<Long, Long>> getOrg2Material2Category() {
        Map<Long, Map<Long, Long>> org2Material2CategoryMap = null;
        if (!StringUtils.isEmpty((String)this.cache_org2Material2CategoryMap_id)) {
            try {
                DataSet org2Material2CategoryMapDataSet = Algo.getCacheDataSet((String)this.cache_org2Material2CategoryMap_id).toDataSet(Algo.create((String)this.getClass().getName()), false);
                org2Material2CategoryMap = this.create_org2Material2CategoryMap(org2Material2CategoryMapDataSet);
            }
            catch (Exception e) {
                this.queryCategory();
                DataSet org2Material2CategoryMapDataSet = Algo.getCacheDataSet((String)this.cache_org2Material2CategoryMap_id).toDataSet(Algo.create((String)this.getClass().getName()), false);
                org2Material2CategoryMap = this.create_org2Material2CategoryMap(org2Material2CategoryMapDataSet);
                WriteLogHelper.writeErrorLog(logger, "MaterialCategoryHelper-getOrg2Material2Category", e);
            }
        }
        return org2Material2CategoryMap;
    }

    private Map<Long, Map<Long, Long>> getOrg2Material2CategoryMap() {
        HashMap<Long, Map<Long, Long>> org2Material2CategoryMap = new HashMap<Long, Map<Long, Long>>(16);
        Map<Long, Map<Long, Set<Long>>> org2Category2MaterialidMap = null;
        try {
            DataSet org2Category2MaterialidMapDataSet = Algo.getCacheDataSet((String)this.cache_org2Category2MaterialidMap_id).toDataSet(Algo.create((String)this.getClass().getName()), false);
            org2Category2MaterialidMap = this.create_org2Category2MaterialMap(org2Category2MaterialidMapDataSet);
        }
        catch (Exception e) {
            this.queryCategory();
            DataSet org2Category2MaterialidMapDataSet = Algo.getCacheDataSet((String)this.cache_org2Category2MaterialidMap_id).toDataSet(Algo.create((String)this.getClass().getName()), false);
            org2Category2MaterialidMap = this.create_org2Category2MaterialMap(org2Category2MaterialidMapDataSet);
            WriteLogHelper.writeErrorLog(logger, "MaterialCategoryHelper-getOrg2Material2CategoryMap", e);
        }
        for (Map.Entry<Long, Map<Long, Set<Long>>> longMapEntry : org2Category2MaterialidMap.entrySet()) {
            Long orgid = longMapEntry.getKey();
            Map<Long, Set<Long>> category2MaterialMap = longMapEntry.getValue();
            Map material2CategoryMap = org2Material2CategoryMap.computeIfAbsent(orgid, k -> new HashMap());
            for (Map.Entry<Long, Set<Long>> longSetEntry : category2MaterialMap.entrySet()) {
                Long categoryId = longSetEntry.getKey();
                Set<Long> materialids = longSetEntry.getValue();
                for (Long materialid : materialids) {
                    material2CategoryMap.put(materialid, categoryId);
                }
            }
        }
        return org2Material2CategoryMap;
    }

    public Set<Long> getMaterialIds() {
        Set<Long> materialids = null;
        if (!StringUtils.isEmpty((String)this.cache_materialIds_id)) {
            try {
                DataSet materialidDataSet = Algo.getCacheDataSet((String)this.cache_materialIds_id).toDataSet(Algo.create((String)this.getClass().getName()), false);
                materialids = this.create_materialididSet(materialidDataSet);
            }
            catch (Exception e) {
                this.queryCategory();
                DataSet materialidDataSet = Algo.getCacheDataSet((String)this.cache_materialIds_id).toDataSet(Algo.create((String)this.getClass().getName()), false);
                materialids = this.create_materialididSet(materialidDataSet);
                WriteLogHelper.writeErrorLog(logger, "MaterialCategoryHelper-getMaterialIds", e);
            }
        }
        return materialids;
    }

    public static Long getMaterialCategory(Long calorgId, Long materialId) {
        HashMap params = new HashMap(16);
        HashSet<Long> materialids = new HashSet<Long>(4);
        materialids.add(materialId);
        params.put(calorgId, materialids);
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"MaterialCategoryService", (String)"getMaterialCategoryByOrgAndMaterial", (Object[])new Object[]{params});
        Map map = (Map)resMap.get(calorgId);
        if (map == null) {
            return null;
        }
        return (Long)map.get(materialId);
    }

    private String create_org2Category2Material_CacheDataSet(Map<Long, Map<Long, Set<Long>>> org2Category2Material) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("calorg", (DataType)DateType.LongType), new Field("materialcategory", (DataType)DateType.LongType), new Field("material", (DataType)DateType.LongType)});
        DataSetBuilder org2Category2MaterialBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, Map<Long, Set<Long>>> entry : org2Category2Material.entrySet()) {
            Long calorgid = entry.getKey();
            for (Map.Entry<Long, Set<Long>> sentry : entry.getValue().entrySet()) {
                Long materialcategoryid = sentry.getKey();
                for (Long materialid : sentry.getValue()) {
                    org2Category2MaterialBuilder.append(new Object[]{calorgid, materialcategoryid, materialid});
                }
            }
        }
        DataSet dataSet = org2Category2MaterialBuilder.build();
        Integer timeout = CalDbParamServiceHelper.getInteger(CalDbParamConstant.MATERIAL_CATEGORY_TIMEOUT);
        if (timeout == null || timeout <= 0) {
            timeout = 3600;
        }
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)timeout.intValue(), TimeUnit.SECONDS);
        CachedDataSet cache = dataSet.cache(cacheHint);
        String cacheId = cache.getCacheId();
        return cacheId;
    }

    private Map<Long, Map<Long, Set<Long>>> create_org2Category2MaterialMap(DataSet dataSet) {
        HashMap<Long, Map<Long, Set<Long>>> map = new HashMap<Long, Map<Long, Set<Long>>>();
        for (Row row : dataSet) {
            Long calorg = row.getLong("calorg");
            Long materialcategory = row.getLong("materialcategory");
            Long material = row.getLong("material");
            map.putIfAbsent(calorg, new HashMap());
            Map smap = (Map)map.get(calorg);
            smap.putIfAbsent(materialcategory, new HashSet());
            Set set = (Set)smap.get(materialcategory);
            set.add(material);
        }
        return map;
    }

    private String create_org2Material2Category_CacheDataSet(Map<Long, Map<Long, Long>> org2Material2Category) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("calorg", (DataType)DateType.LongType), new Field("material", (DataType)DateType.LongType), new Field("materialcategory", (DataType)DateType.LongType)});
        DataSetBuilder org2Material2CategoryBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, Map<Long, Long>> entry : org2Material2Category.entrySet()) {
            Long calorgid = entry.getKey();
            for (Map.Entry<Long, Long> sentry : entry.getValue().entrySet()) {
                Long materialid = sentry.getKey();
                Long materialcategoryid = sentry.getValue();
                org2Material2CategoryBuilder.append(new Object[]{calorgid, materialid, materialcategoryid});
            }
        }
        DataSet dataSet = org2Material2CategoryBuilder.build();
        Integer timeout = CalDbParamServiceHelper.getInteger(CalDbParamConstant.MATERIAL_CATEGORY_TIMEOUT);
        if (timeout == null || timeout <= 0) {
            timeout = 3600;
        }
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)timeout.intValue(), TimeUnit.SECONDS);
        CachedDataSet cache = dataSet.cache(cacheHint);
        String cacheId = cache.getCacheId();
        return cacheId;
    }

    private Map<Long, Map<Long, Long>> create_org2Material2CategoryMap(DataSet dataSet) {
        HashMap<Long, Map<Long, Long>> map = new HashMap<Long, Map<Long, Long>>();
        for (Row row : dataSet) {
            Long calorg = row.getLong("calorg");
            Long material = row.getLong("material");
            Long materialcategory = row.getLong("materialcategory");
            map.putIfAbsent(calorg, new HashMap());
            Map smap = (Map)map.get(calorg);
            smap.put(material, materialcategory);
        }
        return map;
    }

    private String create_materialididCacheDataSet(Set<Long> materialids) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("material", (DataType)DateType.LongType)});
        DataSetBuilder materialididBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        materialids.stream().forEach(materialid -> materialididBuilder.append(new Object[]{materialid}));
        DataSet dataSet = materialididBuilder.build();
        Integer timeout = CalDbParamServiceHelper.getInteger(CalDbParamConstant.MATERIAL_CATEGORY_TIMEOUT);
        if (timeout == null || timeout <= 0) {
            timeout = 3600;
        }
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)timeout.intValue(), TimeUnit.SECONDS);
        CachedDataSet cache = dataSet.cache(cacheHint);
        String cacheId = cache.getCacheId();
        return cacheId;
    }

    private Set<Long> create_materialididSet(DataSet data) {
        HashSet<Long> ids = new HashSet<Long>();
        for (Row row : data) {
            ids.add(row.getLong("material"));
        }
        return ids;
    }

    public void close() {
        if (!StringUtils.isEmpty((String)this.cache_org2Category2MaterialidMap_id)) {
            Algo.removeCacheDataSet((String)this.cache_org2Category2MaterialidMap_id);
            this.cache_org2Category2MaterialidMap_id = null;
        }
        if (!StringUtils.isEmpty((String)this.cache_org2Material2CategoryMap_id)) {
            Algo.removeCacheDataSet((String)this.cache_org2Material2CategoryMap_id);
            this.cache_org2Material2CategoryMap_id = null;
        }
        if (!StringUtils.isEmpty((String)this.cache_materialIds_id)) {
            Algo.removeCacheDataSet((String)this.cache_materialIds_id);
            this.cache_materialIds_id = null;
        }
    }
}

