/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class MaterialHelper {
    public static Set<Long> getAllMaterialByMaterialGroup(String groupLongNumber) {
        DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
        GroupProp group = (GroupProp)property;
        String longNumberDLM = "";
        if (group instanceof ParentBasedataProp) {
            longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
        }
        HashSet<Long> materialSet = new HashSet<Long>();
        QFilter q = new QFilter("standard", "=", (Object)730148448254487552L);
        q.and(new QFilter("group.longnumber", "like", (Object)(groupLongNumber + longNumberDLM + "%")).or("group.longnumber", "=", (Object)groupLongNumber));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)MaterialHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"id,material", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                materialSet.add(row.getLong("material"));
            }
        }
        return materialSet;
    }

    public static DynamicObject getMaterialInvInf(DynamicObject material, long storageOrgId) {
        QFilter filter = new QFilter("masterid", "=", (Object)material.getLong("id"));
        filter.and("enable", "=", (Object)Character.valueOf('1'));
        filter.and("status", "=", (Object)"C");
        filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)storageOrgId));
        return QueryServiceHelper.queryOne((String)"bd_materialinventoryinfo", (String)"enablelot", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getMaterialInvInf4Org(DynamicObject material, String selectFields, long storageOrgId) {
        QFilter filter = new QFilter("masterid", "=", (Object)material.getLong("id"));
        filter.and("enable", "=", (Object)Character.valueOf('1'));
        filter.and("status", "=", (Object)"C");
        filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)storageOrgId));
        DynamicObjectCollection invInfs = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)selectFields, (QFilter[])new QFilter[]{filter});
        for (DynamicObject invinf : invInfs) {
            if (storageOrgId != invinf.getLong("createorg")) continue;
            return invinf;
        }
        if (invInfs.isEmpty()) {
            return null;
        }
        return (DynamicObject)invInfs.get(0);
    }

    public static DynamicObjectCollection getMaterialInvInfs(Set<Long> materialIdSet, long storageOrgId) {
        QFilter filter = new QFilter("masterid", "in", materialIdSet);
        filter.and("enable", "=", (Object)Character.valueOf('1'));
        filter.and("status", "=", (Object)"C");
        filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)storageOrgId));
        return QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)"createorg,masterid,enablelot", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getMaterialInf(long materialId, String fields) {
        QFilter filter = new QFilter("id", "=", (Object)materialId);
        filter.and("enable", "=", (Object)Character.valueOf('1'));
        filter.and("status", "=", (Object)"C");
        return BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)fields, (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObjectCollection getMaterialInfs(Set materialIdSet, String fields) {
        QFilter filter = new QFilter("id", "in", (Object)materialIdSet);
        filter.and("enable", "=", (Object)Character.valueOf('1'));
        filter.and("status", "=", (Object)"C");
        return QueryServiceHelper.query((String)"bd_material", (String)fields, (QFilter[])new QFilter[]{filter});
    }

    public static Map<Long, List<String>> getMaterialAuxpty(Set materialIdSet) {
        HashMap<Long, List<String>> materialAux = new HashMap<Long, List<String>>(16);
        if (materialIdSet == null || materialIdSet.isEmpty()) {
            return materialAux;
        }
        List auxList = null;
        DynamicObjectCollection auxptyV = QueryServiceHelper.query((String)"bd_auxptyvalue", (String)"entryentity.auxptyvalueid as auxptyvalueid,material.id", (QFilter[])new QFilter[]{new QFilter("material", "in", (Object)materialIdSet), new QFilter("entryentity.isenable", "=", (Object)Boolean.TRUE)});
        for (DynamicObject aux : auxptyV) {
            long materialId = aux.getLong("material.id");
            List auxListValue = (List)materialAux.get(materialId);
            auxList = auxListValue != null ? auxListValue : new ArrayList(16);
            auxList.add(aux.getString("auxptyvalueid"));
            materialAux.put(materialId, auxList);
        }
        return materialAux;
    }

    public static Set<String> getAuxFlexfield(Set keySet) {
        DynamicObject[] auxpropertys;
        if (keySet == null) {
            return new HashSet<String>(1);
        }
        HashSet<String> flexFieldlist = new HashSet<String>(16);
        for (DynamicObject auxproperty : auxpropertys = BusinessDataServiceHelper.load((String)"bd_auxproperty", (String)"number", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", (Object)keySet)})) {
            flexFieldlist.add(auxproperty.getString("number"));
        }
        return flexFieldlist;
    }

    public static DynamicObjectCollection getMversionColl(Set<Long> materialIdSet) {
        QFilter mversionQ = new QFilter("material", "in", materialIdSet);
        Date now = new Date();
        mversionQ.and("effectdate", "<=", (Object)now);
        mversionQ.and("invaliddate", ">=", (Object)now);
        return QueryServiceHelper.query((String)"bd_bomversion", (String)"id,material", (QFilter[])mversionQ.toArray());
    }
}

