/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class MaterialNoUpdateFieldHelper {
    private static final Log logger = LogFactory.getLog(MaterialNoUpdateFieldHelper.class);

    private Map<String, Long> getStorageOrgMaterialAndInvInfo(DynamicObject[] bills) {
        HashMap<Long, HashSet<Long>> storageOrgIdAndMaterialId = new HashMap<Long, HashSet<Long>>();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            if (entrys == null) continue;
            for (DynamicObject dynamicObject : entrys) {
                Long storageorgunitId = dynamicObject.getLong("storageorgunit.id");
                Long materialId = dynamicObject.getLong("material.id");
                if (storageorgunitId == null || materialId == null) continue;
                HashSet<Long> materialIds = (HashSet<Long>)storageOrgIdAndMaterialId.get(storageorgunitId);
                if (materialIds == null) {
                    materialIds = new HashSet<Long>();
                    materialIds.add(materialId);
                    storageOrgIdAndMaterialId.put(storageorgunitId, materialIds);
                    continue;
                }
                materialIds.add(materialId);
            }
        }
        HashMap<String, Long> unionKeyAndStorageInvId = new HashMap<String, Long>();
        for (Map.Entry entry : storageOrgIdAndMaterialId.entrySet()) {
            long stoId = (Long)entry.getKey();
            Set matIds = (Set)entry.getValue();
            QFilter qFilter = new QFilter("masterid", "in", (Object)matIds);
            QFilter qf2 = new QFilter("status", "=", (Object)"C");
            QFilter qf3 = new QFilter("enable", "=", (Object)"1");
            QFilter q = qFilter.and(qf2).and(qf3);
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)stoId, (QFilter)q, (String)"id,masterid");
            for (DynamicObject dynamicObject : stockMaterialInfos) {
                Object matereial = dynamicObject.get("masterid");
                if (matereial instanceof DynamicObject) {
                    matereial = ((DynamicObject)matereial).getLong("id");
                }
                Long materialId = matereial == null ? Long.valueOf(0L) : (Long)matereial;
                Object id = dynamicObject.get("id");
                String idStr = id == null ? "0" : id.toString();
                Long storageInvId = Long.parseLong(idStr);
                String curUnionKey = stoId + "#" + materialId;
                unionKeyAndStorageInvId.put(curUnionKey, storageInvId);
            }
        }
        return unionKeyAndStorageInvId;
    }

    public Map<String, Long> getStorageOrgMaterialAndInvInfoMap(DynamicObject[] bills) {
        Map<String, Long> unionKeyAndStorageInvId = this.getStorageOrgMaterialAndInvInfo(bills);
        return unionKeyAndStorageInvId;
    }

    public Map<Object, String> getSDBNoUpdateInfoMap(Map<String, Long> unionKeyAndStorageInvId, String billName, String entityName) {
        HashSet<Long> materialInvInfoIds = new HashSet<Long>(unionKeyAndStorageInvId.values());
        Map storageInvIdAndNoUpdateStr = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"NoUpdateInvService", (String)"getNoUpdateFields", (Object[])new Object[]{billName, entityName, materialInvInfoIds});
        logger.info("CostAdjustBillSubmit_dispatch_sbd result : " + SerializationUtils.toJsonString((Object)storageInvIdAndNoUpdateStr));
        return storageInvIdAndNoUpdateStr;
    }

    public static String getNoupdateCalfieldBymateStoraId(long materialId, Long storageOrgId) {
        QFilter qFilter = new QFilter("masterid", "=", (Object)materialId);
        QFilter qf2 = new QFilter("status", "=", (Object)"C");
        QFilter qf3 = new QFilter("enable", "=", (Object)"1");
        QFilter q = qFilter.and(qf2).and(qf3);
        DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)storageOrgId, (QFilter)q, (String)"id");
        HashSet<Object> materialInvInfoIds = new HashSet<Object>(16);
        Object noUpdateInvId = null;
        for (DynamicObject stockMaterialInfo : stockMaterialInfos) {
            Object id = stockMaterialInfo.get("id");
            if (id == null) continue;
            materialInvInfoIds.add(id);
            noUpdateInvId = id;
            break;
        }
        Map storageInvIdAndNoUpdateStr = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"NoUpdateInvService", (String)"getNoUpdateFields", (Object[])new Object[]{"cal_initbill", "entryentity", materialInvInfoIds});
        String noupdatecalfields = null;
        if (storageInvIdAndNoUpdateStr != null && !storageInvIdAndNoUpdateStr.isEmpty()) {
            noupdatecalfields = (String)storageInvIdAndNoUpdateStr.get(noUpdateInvId);
        }
        return noupdatecalfields;
    }
}

