/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.common.helper.CalBillRuleHelper;
import kd.fi.cal.common.model.CalBillRule;
import kd.fi.cal.common.model.SynBillErrInfo;

public class MulCalBillSyncRuleHelper {
    public Map<Long, Set<Long>> getBillIdRuleIdMap(String entity, Set<Long> bizBillIds) {
        HashMap<Long, Set<Long>> billIdRuleIdsMap = new HashMap<Long, Set<Long>>(16);
        CalBillRuleHelper calBillRuleHelper = new CalBillRuleHelper();
        calBillRuleHelper.loadRulesByBills(new HashSet<String>(Collections.singletonList(entity)));
        Map<String, List<CalBillRule>> inCalBillRuleMap = calBillRuleHelper.getInCalBillRuleMap();
        ArrayList inCalBillRules = inCalBillRuleMap.get(entity);
        inCalBillRules = inCalBillRules == null ? new ArrayList(0) : inCalBillRules;
        Map<String, List<CalBillRule>> outCalBillRuleMap = calBillRuleHelper.getOutCalBillRuleMap();
        ArrayList outCalBillRules = outCalBillRuleMap.get(entity);
        outCalBillRules = outCalBillRules == null ? new ArrayList(0) : outCalBillRules;
        inCalBillRules.addAll(outCalBillRules);
        String selFormat = "id,%s as ruleid";
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("ruleid", (DataType)DataType.LongType)});
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        for (CalBillRule calBillRule : inCalBillRules) {
            List<QFilter> billFilters = calBillRule.getBillFilters();
            QFilter ruleFilter = billFilters.get(0);
            String billStatusField = "billstatus";
            this.skipStatusFilter(ruleFilter, billStatusField);
            billFilters.add(new QFilter("id", "in", bizBillIds));
            OrmInput input = new OrmInput(this.getClass().getName(), calBillRule.getEntity(), String.format(selFormat, calBillRule.getRuleId()), billFilters.toArray(new QFilter[0]), rowMeta);
            inputs.add(input);
        }
        DataSet billIdRuleIdDs = Algo.create((String)this.getClass().getName()).createDataSet(inputs.toArray(new Input[0]));
        for (Row row : billIdRuleIdDs) {
            Set ruleIds = billIdRuleIdsMap.computeIfAbsent(row.getLong("id"), k -> new HashSet(16));
            ruleIds.add(row.getLong("ruleid"));
        }
        return billIdRuleIdsMap;
    }

    public void skipStatusFilter(QFilter ruleFilter, String billStatusField) {
        if (ruleFilter != null) {
            if (billStatusField.equals(ruleFilter.getProperty())) {
                ruleFilter.__setProperty("1");
                ruleFilter.__setCP("=");
                ruleFilter.__setValue((Object)1);
            }
            List nests = ruleFilter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                QFilter curFilter = nest.getFilter();
                if (!billStatusField.equals(curFilter.getProperty())) continue;
                curFilter.__setProperty("1");
                curFilter.__setCP("=");
                curFilter.__setValue((Object)1);
            }
        }
    }

    public Map<Long, SynBillErrInfo> removeMulRuleCalBill(Set<Long> mulRuleBillIds, Map<String, DynamicObject> ownerBillIdCalBillMap) {
        HashMap<Long, SynBillErrInfo> billIdErrMap = new HashMap<Long, SynBillErrInfo>(32);
        Iterator<Map.Entry<String, DynamicObject>> iterator = ownerBillIdCalBillMap.entrySet().iterator();
        String mulRuleMsg = ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u540c\u6b65\u89c4\u5219\u540c\u65f6\u6ee1\u8db3\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u540c\u6b65\u914d\u7f6e\u3002", (String)"MulRuleHelper_0", (String)"fi-cal-common", (Object[])new Object[0]);
        while (iterator.hasNext()) {
            Map.Entry<String, DynamicObject> ownerBillIdCalBillEntry = iterator.next();
            String key = ownerBillIdCalBillEntry.getKey();
            long billId = Long.parseLong(key.split(",")[0]);
            if (!mulRuleBillIds.contains(billId)) continue;
            billIdErrMap.put(billId, new SynBillErrInfo("3", mulRuleMsg));
            iterator.remove();
        }
        return billIdErrMap;
    }
}

