/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.util.CommonUtils;

public class MustInputDimHelper {
    public static Map<Long, Set<String>> getOrgAndDiffDims(Set<Long> orgIdSet) {
        HashMap<Long, Set<String>> orgAndDiffDimsMap = new HashMap<Long, Set<String>>(16);
        for (Long orgId : orgIdSet) {
            String diffDimString = (String)ParamsHelper.getAppParam(orgId, "diffalloccols");
            if (diffDimString == null || StringUtils.isEmpty((String)(diffDimString = CommonUtils.trimComma(diffDimString)))) continue;
            HashSet<String> diffDimSet = new HashSet<String>(16);
            for (String diffDim : diffDimString.split(",")) {
                diffDimSet.add(diffDim);
            }
            orgAndDiffDimsMap.put(orgId, diffDimSet);
        }
        return orgAndDiffDimsMap;
    }

    public static Map<Long, Set<String>> getAccountDivideDims(Set<Long> accountIdSet) {
        HashMap<Long, Set<String>> accountDivideDimsMap = new HashMap<Long, Set<String>>(16);
        DataSet accountCalrangeDs = QueryServiceHelper.queryDataSet((String)"MustInputDimHelper-queryDivideDim", (String)"cal_bd_calrange", (String)"costaccount.id as costaccountid,dividebasis.dividebasis as dividestr", (QFilter[])new QFilter("costaccount", "in", accountIdSet).toArray(), null);
        for (Row row : accountCalrangeDs) {
            String divideStr;
            Long accountId = row.getLong("costaccountid");
            HashSet<String> divideDims = (HashSet<String>)accountDivideDimsMap.get(accountId);
            if (divideDims == null) {
                divideDims = new HashSet<String>(16);
            }
            if (!StringUtils.isEmpty((String)(divideStr = CommonUtils.trimComma(row.getString("dividestr"))))) {
                for (String dim : divideStr.split(",")) {
                    divideDims.add(dim);
                }
            }
            if (divideDims.isEmpty()) continue;
            accountDivideDimsMap.put(accountId, divideDims);
        }
        return accountDivideDimsMap;
    }

    public static Map<Long, String> getCalrangeDimensions(Set<Long> calrangeIdSet) {
        HashMap<Long, String> calrangeDimsMap = new HashMap<Long, String>(16);
        DataSet calrangeDs = QueryServiceHelper.queryDataSet((String)"MustInputDimHelper-queryCalrange", (String)"cal_bd_calrange", (String)"id,caldimension.caldimension as dimstr", (QFilter[])new QFilter("id", "in", calrangeIdSet).toArray(), null);
        for (Row row : calrangeDs) {
            String dimStr = row.getString("dimstr");
            if (StringUtils.isEmpty((String)dimStr)) continue;
            calrangeDimsMap.put(row.getLong("id"), dimStr);
        }
        return calrangeDimsMap;
    }

    public static void initEnableLotMap(ExtendedDataEntity[] billInfos, Map<String, Boolean> privateEnableLotMap, Map<String, Boolean> publiceEnableLotMap) {
        HashMap<Long, HashSet<Long>> storgMaterialsMap = new HashMap<Long, HashSet<Long>>(16);
        for (ExtendedDataEntity billInfo : billInfos) {
            DynamicObject bill = billInfo.getDataEntity();
            for (DynamicObject dynamicObject : bill.getDynamicObjectCollection("entryentity")) {
                Long storageorgunitId = dynamicObject.getLong("storageorgunit.id");
                Long materialId = dynamicObject.getLong("material.id");
                HashSet<Long> materials = (HashSet<Long>)storgMaterialsMap.get(storageorgunitId);
                if (materials == null) {
                    materials = new HashSet<Long>(16);
                    storgMaterialsMap.put(storageorgunitId, materials);
                }
                materials.add(materialId);
            }
        }
        for (Map.Entry entry : storgMaterialsMap.entrySet()) {
            Long stoId = (Long)entry.getKey();
            Set matIds = (Set)entry.getValue();
            QFilter qFilter = new QFilter("masterid", "in", (Object)matIds);
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)stoId, (QFilter)qFilter, (String)"id,masterid,createorg,enablelot");
            for (DynamicObject dynamicObject : stockMaterialInfos) {
                Object createOrg;
                Object material = dynamicObject.get("masterid");
                if (material instanceof DynamicObject) {
                    material = ((DynamicObject)material).get("id");
                }
                if ((createOrg = dynamicObject.get("createorg")) instanceof DynamicObject) {
                    createOrg = ((DynamicObject)createOrg).get("id");
                }
                String key = stoId + "_" + material;
                boolean enableLot = dynamicObject.getBoolean("enablelot");
                if (stoId.equals(createOrg)) {
                    privateEnableLotMap.put(key, enableLot);
                    continue;
                }
                publiceEnableLotMap.put(key, enableLot);
            }
        }
    }
}

