/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.cal.common.helper.SCMHelper;

public class OrgHelper {
    private static final Log logger = LogFactory.getLog(OrgHelper.class);

    public static List<Long> getStorageOrgUnitByCalOrg(Long calOrgid) {
        ArrayList<Long> list = new ArrayList();
        try {
            list = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)calOrgid);
        }
        catch (Exception e) {
            logger.error("OrgHelper getStorageOrgUnitByCalOrg", (Throwable)e);
        }
        return list;
    }

    public static List<Long> getStorageOrgUnitByAllCalOrg(Long userId, String entityNum, String permItem) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)"/KIUHEXROK3D", (String)entityNum, (String)permItem);
        List calorgids = result.getHasPermOrgs();
        ArrayList<Long> invorgIdlist = new ArrayList<Long>(16);
        try {
            for (Long calorgid : calorgids) {
                invorgIdlist.addAll(OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)calorgid));
            }
        }
        catch (Exception e) {
            logger.error("OrgHelper getStorageOrgUnitByAllCalOrg", (Throwable)e);
        }
        invorgIdlist.addAll(PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"05", (String)"/KIUHEXROK3D", (String)entityNum, (String)permItem).getHasPermOrgs());
        return invorgIdlist;
    }

    public static Long getCalOrgByUserOrg(Long userId, Long orgId, String entityNum) {
        return OrgHelper.getCalOrgByUserOrg(userId, orgId, entityNum, "47150e89000000ac");
    }

    public static DynamicObject getCostAccountByCalOrg(Long calOrgId) {
        QFilter q = new QFilter("calorg", "=", (Object)calOrgId).and("enable", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name,calorg,calsystem,calpolicy,calpolicy.currency,dividebasis,ismainaccount,enable", (QFilter[])q.toArray());
        DynamicObject mainCostAccount = null;
        if (costAccounts == null || costAccounts.isEmpty()) {
            return mainCostAccount;
        }
        mainCostAccount = (DynamicObject)costAccounts.get(0);
        for (DynamicObject costAccount : costAccounts) {
            if (!costAccount.getBoolean("ismainaccount")) continue;
            mainCostAccount = costAccount;
            break;
        }
        return mainCostAccount;
    }

    public static Long getInvOrgByUserOrg(Long userId, Long orgId, String entityNum, String permItem) {
        int hasPermissin;
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"05") && (hasPermissin = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"05", (String)"/KIUHEXROK3D", (String)entityNum, (String)permItem)) == 1) {
            return orgId;
        }
        List<Long> allInvOrgIds = OrgHelper.getStorageOrgUnitByAllCalOrg(userId, entityNum, permItem);
        if (!allInvOrgIds.isEmpty()) {
            return allInvOrgIds.get(0);
        }
        return null;
    }

    public static Long getCalOrgByUserOrg(Long userId, Long orgId, String entityNum, String permItem) {
        List permOrgIds;
        List permCalOrgIds;
        Long calOrgByPurOrg;
        List allFromSccToCalOrgIds;
        List allFromInvToCalOrgIds;
        int hasPermissin;
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10") && (hasPermissin = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"10", (String)"/KIUHEXROK3D", (String)entityNum, (String)permItem)) == 1) {
            return orgId;
        }
        HashSet<Long> allCalOrgIds = new HashSet<Long>();
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"05") && (allFromInvToCalOrgIds = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)orgId, (String)"10")) != null) {
            allCalOrgIds.addAll(allFromInvToCalOrgIds);
        }
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"12") && (allFromSccToCalOrgIds = OrgUnitServiceHelper.getFromOrgs((String)"12", (Long)orgId, (String)"10")) != null) {
            allCalOrgIds.addAll(allFromSccToCalOrgIds);
        }
        if ((calOrgByPurOrg = (Long)OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE).get("id")) != null) {
            allCalOrgIds.add(calOrgByPurOrg);
        }
        if (allCalOrgIds.size() > 0) {
            for (Long CalOrgId : allCalOrgIds) {
                int hasPermissin2 = PermissionServiceHelper.checkPermission((Long)userId, (Long)CalOrgId, (String)"10", (String)"/KIUHEXROK3D", (String)entityNum, (String)permItem);
                if (hasPermissin2 != 1) continue;
                return CalOrgId;
            }
        }
        if ((permCalOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)(permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)userId).getHasPermOrgs()), (String)"10")).size() > 0) {
            for (Long CalOrgId : permCalOrgIds) {
                int hasPermissin3 = PermissionServiceHelper.checkPermission((Long)userId, (Long)CalOrgId, (String)"10", (String)"/KIUHEXROK3D", (String)entityNum, (String)permItem);
                if (hasPermissin3 != 1) continue;
                return CalOrgId;
            }
        }
        return null;
    }

    public static boolean checkWarehs(DynamicObject info) {
        String number = info.getString("storageorgunit.number");
        long warehsID = info.getLong("warehouse.id");
        Long[] warehsInfos = SCMHelper.getAllInUseWarehouseIDs(number);
        return OrgHelper.checkWarehs(warehsInfos, warehsID);
    }

    public static boolean checkWarehs(Long[] warehsInfos, long warehsID) {
        if (warehsInfos == null) {
            return false;
        }
        boolean hasData = false;
        for (Long value : warehsInfos) {
            if (warehsID != value) continue;
            hasData = true;
            break;
        }
        return hasData;
    }

    public static Set<Long> getCostAccountIdsByCalOrg(Set<Long> calOrgIds) {
        QFilter q = new QFilter("calorg", "in", calOrgIds).and("enable", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name,calorg,calsystem,calpolicy,calpolicy.currency,dividebasis,ismainaccount,enable", (QFilter[])q.toArray());
        if (costAccounts == null || costAccounts.isEmpty()) {
            return null;
        }
        HashSet<Long> idset = new HashSet<Long>(16);
        HashMap<Long, Long> calorgCostAccountMap = new HashMap<Long, Long>(16);
        for (int i = 0; i < costAccounts.size(); ++i) {
            boolean ismainaccount = ((DynamicObject)costAccounts.get(i)).getBoolean("ismainaccount");
            Long costAccountId = ((DynamicObject)costAccounts.get(i)).getLong("id");
            Long calorgId = ((DynamicObject)costAccounts.get(i)).getLong("calorg");
            if (ismainaccount) {
                calorgCostAccountMap.put(calorgId, costAccountId);
                continue;
            }
            if (calorgCostAccountMap.containsKey(calorgId)) continue;
            calorgCostAccountMap.put(calorgId, costAccountId);
        }
        for (Map.Entry mapEntry : calorgCostAccountMap.entrySet()) {
            idset.add((Long)mapEntry.getValue());
        }
        return idset;
    }

    public static Boolean isOrgLeafNode(Long orgId, Long calSysId) {
        Boolean isLeaf = true;
        Long orgViewId = OrgHelper.getOrgViewId(calSysId);
        QFilter q = new QFilter("org.id", "=", (Object)orgId);
        q.and("view.id", "=", (Object)orgViewId);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-bos_org_structure", (String)"bos_org_structure", (String)"isleaf", (QFilter[])new QFilter[]{q}, null);
        for (Row row : dataSet) {
            isLeaf = row.getBoolean("isleaf");
        }
        return isLeaf;
    }

    public static Long getOrgViewId(Long calSysId) {
        Long orgViewId = 0L;
        QFilter q = new QFilter("accountingsys.id", "=", (Object)calSysId);
        q.and("ismainview", "=", (Object)Boolean.TRUE);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-bos_org_view", (String)"bd_accountingsysviewsch", (String)"id", (QFilter[])new QFilter[]{q}, null);
        for (Row row : dataSet) {
            orgViewId = row.getLong("id");
        }
        return orgViewId;
    }
}

