/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PeriodHelper {
    public static Set<Long> getEndInitCostAccountByCalOrg(Long calOrg) {
        HashSet<Long> costaccSet = new HashSet<Long>(32);
        if (calOrg == null) {
            return costaccSet;
        }
        QFilter filter = new QFilter("org", "=", (Object)calOrg);
        filter.and("entry.isenabled", "=", (Object)true);
        DynamicObjectCollection sysEntitys = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount", (QFilter[])filter.toArray());
        for (DynamicObject sysEntity : sysEntitys) {
            costaccSet.add(sysEntity.getLong("entry.costaccount"));
        }
        return costaccSet;
    }

    public static DynamicObject getCurrentPeriod(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDynamicObject("currentperiod");
        }
        return null;
    }

    public static Map<Long, Set<Long>> getCurrentPeriod2EnableCostAccountMap(Set<Long> costAccountids) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(4);
        QFilter filter = new QFilter("entry.isenabled", "=", (Object)true);
        filter.and("entry.costaccount.enable", "=", (Object)true);
        if (costAccountids != null && !costAccountids.isEmpty()) {
            filter.and("entry.costaccount", "in", costAccountids);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PeriodHelper.class.getName(), (String)"cal_sysctrlentity", (String)"entry.currentperiod,entry.costaccount", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                Long costaccountid = row.getLong("entry.costaccount");
                Long curperiod = row.getLong("entry.currentperiod");
                Set costaccountids = map.computeIfAbsent(curperiod, k -> new HashSet(4));
                costaccountids.add(costaccountid);
            }
        }
        return map;
    }

    public static Map<Date, Set<Long>> getCurBeginDate2EnableCostAccountMap(Set<Long> calOrgids) {
        HashMap<Date, Set<Long>> map = new HashMap<Date, Set<Long>>(4);
        QFilter filter = new QFilter("entry.isenabled", "=", (Object)true);
        filter.and("entry.costaccount.enable", "=", (Object)true);
        if (calOrgids != null && !calOrgids.isEmpty()) {
            filter.and("org", "in", calOrgids);
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PeriodHelper.class.getName(), (String)"cal_sysctrlentity", (String)"entry.currentperiod.begindate,entry.costaccount", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                Long costaccountid = row.getLong("entry.costaccount");
                Date curBegindate = row.getDate("entry.currentperiod.begindate");
                Set costaccountids = map.computeIfAbsent(curBegindate, k -> new HashSet(4));
                costaccountids.add(costaccountid);
            }
        }
        return map;
    }

    public static Map<Long, DynamicObject> getCurrentPeriods(Set<Long> costAccountID) {
        return PeriodHelper.getSysPeriods(costAccountID);
    }

    public static DynamicObject getCurrentPeriodType(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDynamicObject("calpolicy.periodtype");
        }
        return null;
    }

    public static Date getCurrentPeriodenddate(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDate("currentperiod.enddate");
        }
        return null;
    }

    public static DynamicObject getPeriodByDate(Date date, Long costAccountID) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        DynamicObject period = PeriodHelper.getPeriodByDate(date, null, value.getLong("calpolicy.periodtype"));
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u5355\u540c\u6b65\u914d\u7f6e\u7684\u8bb0\u8d26\u65e5\u671f\u4e3a\u7a7a\u6216\u8005\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u4e0d\u5230\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"PeriodHelper_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        return period;
    }

    public static DynamicObject getPeriodByDateNotCheck(Date date, Long costAccountID) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        return PeriodHelper.getPeriodByDate(date, null, value.getLong("calpolicy.periodtype"));
    }

    public static int compare2period(DynamicObject period1, DynamicObject period2) {
        int result = 1;
        if (period1.get("begindate").equals(period2.get("begindate")) && period1.get("enddate").equals(period2.get("enddate"))) {
            result = 0;
        } else if (period1.getDate("begindate").after(period2.getDate("enddate")) || period1.get("begindate").equals(period2.get("enddate"))) {
            result = 1;
        } else if (period1.getDate("enddate").before(period2.getDate("begindate")) || period1.get("enddate").equals(period2.get("begindate"))) {
            result = -1;
        }
        return result;
    }

    public static DynamicObject getPeriodByDate(Date date, String selectField, long periodType) {
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate,periodyear,periodnumber";
        }
        QFilter f = new QFilter("beginDate", "<=", (Object)date);
        QFilter g = new QFilter("enddate", ">=", (Object)date);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t, q});
    }

    public static DynamicObject getPeriodByNumber(int year, int periodNum, String selectField, long periodType) {
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        QFilter g = new QFilter("periodnumber", "=", (Object)periodNum);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        return QueryServiceHelper.queryOne((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t});
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", "<", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear desc, periodnumber desc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static DynamicObject getNextPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", ">", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", ">", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear asc, periodnumber asc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static DynamicObject getStartPeriod(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDynamicObject("startperiod");
        }
        return null;
    }

    public static DynamicObject getSysCtrlEntity(Long costAccountID) {
        DynamicObject retValue = null;
        QFilter filter = new QFilter("entry.costaccount.id", "=", (Object)costAccountID);
        String fields = "org,entry.currentperiod,entry.startperiod,entry.costaccount,entry.currentperiod.begindate,entry.currentperiod.enddate,entry.currentperiod.periodyear,entry.currentperiod.periodnumber,entry.startperiod.id,entry.startperiod.begindate,entry.startperiod.enddate,entry.calpolicy,entry.calpolicy.periodtype,entry.isenabled";
        DynamicObject sysPeriod = BusinessDataServiceHelper.loadSingle((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
        if (sysPeriod == null) {
            return null;
        }
        DynamicObjectCollection entrys = sysPeriod.getDynamicObjectCollection("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)entrys.get(i);
            long recordCostAccountID = entryInfo.getLong("costaccount.id");
            if (costAccountID != recordCostAccountID) continue;
            retValue = entryInfo;
            break;
        }
        return retValue;
    }

    public static Map<Long, DynamicObject> getSysPeriods(Set<Long> costAccountIdSet) {
        DynamicObject[] sysPeriod = PeriodHelper.loadSysPeriods(costAccountIdSet);
        HashMap<Long, DynamicObject> periodMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject period : sysPeriod) {
            DynamicObjectCollection entrys = period.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entrys) {
                Long recordCostAccountID = entryInfo.getLong("costaccount.id");
                if (!costAccountIdSet.contains(recordCostAccountID)) continue;
                periodMap.put(recordCostAccountID, entryInfo.getDynamicObject("currentperiod"));
            }
        }
        return periodMap;
    }

    public static Map<Long, DynamicObject> getStartPeriods(Set<Long> costAccountIdSet) {
        DynamicObject[] sysPeriodDycs = PeriodHelper.loadSysPeriods(costAccountIdSet);
        HashMap<Long, DynamicObject> accountIdStartPeriodMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject period : sysPeriodDycs) {
            DynamicObjectCollection entrys = period.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entrys) {
                Long recordCostAccountID = entryInfo.getLong("costaccount.id");
                accountIdStartPeriodMap.put(recordCostAccountID, entryInfo.getDynamicObject("startperiod"));
            }
        }
        return accountIdStartPeriodMap;
    }

    private static DynamicObject[] loadSysPeriods(Set<Long> costAccountIdSet) {
        QFilter filter = new QFilter("entry.costaccount.id", "in", costAccountIdSet);
        String fields = "org,entry.currentperiod,entry.startperiod,entry.costaccount,entry.currentperiod.begindate,entry.currentperiod.enddate,entry.startperiod.begindate,entry.startperiod.enddate,entry.startperiod.periodyear,entry.startperiod.periodnumber,entry.calpolicy,entry.calpolicy.periodtype,entry.isenabled";
        return BusinessDataServiceHelper.load((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getPeriodByYearMonth(long costAccountID, String selectField, int year, int month) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        QFilter g = new QFilter("periodnumber", "=", (Object)month);
        QFilter t = new QFilter("periodtype", "=", (Object)value.getLong("calpolicy.periodtype"));
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t, q});
    }

    public static DynamicObjectCollection getSysCtrlEntity(Long[] costAccountIds, String selects) {
        QFilter filter = new QFilter("entry.costaccount.id", "in", (Object)costAccountIds);
        if (selects == null) {
            selects = "org,entry.currentperiod as currentperiod,entry.startperiod as startperiod,entry.costaccount as costaccount";
        }
        DynamicObjectCollection sysPeriods = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)selects, (QFilter[])new QFilter[]{filter});
        return sysPeriods;
    }

    public static boolean isEndInit(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getBoolean("isenabled");
        }
        return false;
    }

    public static DynamicObject[] getMultiPreviousPeriod(Object curPeriodId, int top) {
        if (curPeriodId == null) {
            return null;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bd_period");
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", "<", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        DynamicObjectCollection multiPeriod = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear desc, periodnumber desc", (int)top);
        HashSet<Long> idSet = new HashSet<Long>();
        for (DynamicObject entrity : multiPeriod) {
            idSet.add(entrity.getLong("id"));
        }
        return BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)type);
    }

    public static QFilter getNextPeriodQf(Object curPeriodId) {
        if (curPeriodId == null || curPeriodId.equals(0L)) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", ">=", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", ">", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        return filterType.and(pfilter).and(q);
    }

    public static QFilter getCostAccountNextPeriodQf(DynamicObject costAccount) {
        if (costAccount == null) {
            return new QFilter("id", "=", (Object)-1L);
        }
        Long beginPeriodId = PeriodHelper.getBeginPeriod(costAccount);
        return PeriodHelper.getNextPeriodQf(beginPeriodId);
    }

    private static Long getBeginPeriod(DynamicObject costAccount) {
        if (costAccount == null) {
            return null;
        }
        DynamicObject startPeriod = PeriodHelper.getSysCtrlEntity(costAccount.getLong("id"));
        Long startPeriodId = null;
        if (startPeriod != null) {
            startPeriodId = startPeriod.getLong("startperiod.id");
        }
        return startPeriodId;
    }

    public static boolean isSamePeriod(DynamicObject record, Date bookDate) {
        boolean isSamePeriod = true;
        Long recordPeriodId = record.getDynamicObject("period").getLong("id");
        DynamicObject recordPeriod = BusinessDataServiceHelper.loadSingle((Object)recordPeriodId, (String)"bd_period", (String)"id,begindate,enddate");
        Date startDate = recordPeriod.getDate("begindate");
        Date endDate = recordPeriod.getDate("enddate");
        if (bookDate.compareTo(startDate) < 0 || !bookDate.before(endDate)) {
            isSamePeriod = false;
        }
        return isSamePeriod;
    }

    public static Long getCostAccountByCalOrgAndSysctrlentity(Long calOrgId) {
        Long costAccountId = null;
        if (null == calOrgId) {
            return costAccountId;
        }
        QFilter filter = new QFilter("org", "=", (Object)calOrgId);
        filter.and("entry.isenabled", "=", (Object)true);
        DataSet sysEntitys = QueryServiceHelper.queryDataSet((String)PeriodHelper.class.getName(), (String)"cal_sysctrlentity", (String)"entry.costaccount,entry.costaccount.ismainaccount", (QFilter[])filter.toArray(), (String)"entry.costaccount.ismainaccount desc");
        Iterator iterator = sysEntitys.iterator();
        if (iterator.hasNext()) {
            return ((Row)iterator.next()).getLong("entry.costaccount");
        }
        return null;
    }

    public static Date[] getPeriodStartAndEndTime(Long periodId) {
        QFilter filter = new QFilter("id", "=", (Object)periodId);
        DynamicObject[] periods = BusinessDataServiceHelper.load((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{filter});
        if (periods == null || periods.length < 1) {
            return null;
        }
        Date[] dates = new Date[]{periods[0].getDate("begindate"), periods[0].getDate("enddate")};
        return dates;
    }
}

