/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.cal.common.enums.DischargeTypeEnum;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;

public class PeriodVoucherValidHelper {
    private Map<Long, DynamicObject> allCurPeriod = new HashMap<Long, DynamicObject>();
    private Set<String> purBills;

    public PeriodVoucherValidHelper(Set<Long> costAccountIdSet) {
        this.init(costAccountIdSet);
    }

    private void init(Set<Long> costAccountIdSet) {
        this.allCurPeriod = PeriodHelper.getCurrentPeriods(costAccountIdSet);
        this.purBills = CommonSettingHelper.getBizEntityNumbers("purbiztype");
        this.purBills.addAll(CommonSettingHelper.getBizEntityNumbers("ominbiztype"));
    }

    public String doValidate(DynamicObject costRecord, boolean isDeleteVoucher) {
        Object costAccount = costRecord.get("costaccount");
        long costAccountId = 0L;
        if (costAccount instanceof DynamicObject) {
            costAccountId = ((DynamicObject)costAccount).getLong("id");
        } else if (costAccount instanceof Long) {
            costAccountId = (Long)costAccount;
        }
        Date writeoffTime = costRecord.getDate("writeoffdate");
        String dischargeType = costRecord.getString("dischargetype");
        String writeoffType = costRecord.getString("writeofftype");
        Object bizEntityObject = costRecord.get("bizentityobject");
        boolean issplitcreate = costRecord.getBoolean("issplitcreate");
        String bizEntityObjectNumber = null;
        if (bizEntityObject instanceof DynamicObject) {
            bizEntityObjectNumber = ((DynamicObject)bizEntityObject).getString("number");
        } else if (bizEntityObject instanceof String) {
            bizEntityObjectNumber = (String)bizEntityObject;
        }
        if (this.purBills != null && this.purBills.contains(bizEntityObjectNumber)) {
            Date beginDate;
            if (DischargeTypeEnum.UNCLEAR.getValue().equals(dischargeType) && issplitcreate) {
                return ResManager.loadKDString((String)"\u751f\u6210\u6b63\u5f0f\u51ed\u8bc1\u8981\u6c42\u5f53\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u5dee\u989d\u8c03\u6574\u201d\u65f6\uff0c\u4e0d\u80fd\u662f\u62c6\u5355\u751f\u6210\u3002", (String)"PeriodVoucherValidHelper_20", (String)"fi-cal-common", (Object[])new Object[0]);
            }
            DynamicObject curPeriod = this.allCurPeriod.get(costAccountId);
            if (curPeriod == null) {
                return ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_5", (String)"fi-cal-common", (Object[])new Object[0]);
            }
            if ((DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargeType) || DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType)) && "A".equals(writeoffType) && writeoffTime.compareTo(beginDate = curPeriod.getDate("begindate")) < 0) {
                if (isDeleteVoucher) {
                    return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u6708\u521d\u4e00\u6b21\u51b2\u56de\u3001\u5355\u5230\u51b2\u56de\u4e14\u6838\u9500\u7c7b\u578b\u4e3a\u7ea2\u84dd\u6838\u9500\u65f6\uff0c\u4e0d\u80fd\u5220\u9664\u6838\u7b97\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u51ed\u8bc1", (String)"PeriodVoucherValidHelper_22", (String)"fi-cal-common", (Object[])new Object[0]);
                }
                return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u6708\u521d\u4e00\u6b21\u51b2\u56de\u3001\u5355\u5230\u51b2\u56de\u201d\u4e14\u6838\u9500\u7c7b\u578b\u4e3a\u201c\u7ea2\u84dd\u6838\u9500\u201d\u65f6\uff0c\u6838\u9500\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_0", (String)"fi-cal-common", (Object[])new Object[0]);
            }
            if ((DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargeType) || DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType)) && "B".equals(writeoffType)) {
                beginDate = curPeriod.getDate("begindate");
                if (writeoffTime.compareTo(beginDate) < 0) {
                    if (isDeleteVoucher) {
                        return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u6708\u521d\u4e00\u6b21\u51b2\u56de\u3001\u5355\u5230\u51b2\u56de\u4e14\u6838\u9500\u7c7b\u578b\u4e3a\u53d1\u7968\u6838\u9500\u65f6\uff0c\u4e0d\u80fd\u5220\u9664\u6838\u7b97\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u51ed\u8bc1", (String)"PeriodVoucherValidHelper_23", (String)"fi-cal-common", (Object[])new Object[0]);
                    }
                    return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u6708\u521d\u4e00\u6b21\u51b2\u56de\u3001\u5355\u5230\u51b2\u56de\u201d\u4e14\u6838\u9500\u7c7b\u578b\u4e3a\u201c\u53d1\u7968\u6838\u9500\u201d\u65f6\uff0c\u6838\u9500\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_15", (String)"fi-cal-common", (Object[])new Object[0]);
                }
            } else {
                Date beginDate2;
                Date bizTime = costRecord.getDate("bookdate");
                if (bizTime.compareTo(beginDate2 = curPeriod.getDate("begindate")) < 0) {
                    if (isDeleteVoucher) {
                        return ResManager.loadKDString((String)"\u51ed\u8bc1\u6765\u6e90\u7cfb\u7edf\u4e3a\u5b58\u8d27\u6838\u7b97\uff0c\u4e0d\u80fd\u5220\u9664\u6838\u7b97\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u51ed\u8bc1", (String)"PeriodVoucherValidHelper_21", (String)"fi-cal-common", (Object[])new Object[0]);
                    }
                    return ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_2", (String)"fi-cal-common", (Object[])new Object[0]);
                }
            }
        } else {
            if ("im_saloutbill".equals(bizEntityObjectNumber) || "im_salreturnbill".equals(bizEntityObjectNumber)) {
                return this.doSaleIssueValidate(costRecord, isDeleteVoucher);
            }
            return this.doOtherValidate(costRecord, isDeleteVoucher);
        }
        return null;
    }

    public String doTempValidate(DynamicObject costRecord) {
        Object costAccount = costRecord.get("costaccount");
        long costAccountId = 0L;
        if (costAccount instanceof DynamicObject) {
            costAccountId = ((DynamicObject)costAccount).getLong("id");
        } else if (costAccount instanceof Long) {
            costAccountId = (Long)costAccount;
        }
        Date bookdate = costRecord.getDate("bookdate");
        DynamicObject curPeriod = this.allCurPeriod.get(costAccountId);
        Date endDate = curPeriod.getDate("enddate");
        String dischargeType = costRecord.getString("dischargetype");
        String writeoffStatus = costRecord.getString("writeoffstatus");
        boolean isInitBill = costRecord.getBoolean("isinitbill");
        boolean isContain = false;
        Object bizEntityObject = costRecord.get("bizentityobject");
        String bizEntityObjectNumber = null;
        if (bizEntityObject instanceof DynamicObject) {
            bizEntityObjectNumber = ((DynamicObject)bizEntityObject).getString("number");
        } else if (bizEntityObject instanceof String) {
            bizEntityObjectNumber = (String)bizEntityObject;
        }
        if (this.purBills != null && this.purBills.contains(bizEntityObjectNumber)) {
            if (DischargeTypeEnum.UNCLEAR.getValue().equals(dischargeType)) {
                return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u5dee\u989d\u8c03\u6574\u201d\u65f6\uff0c\u4e0d\u652f\u6301\u751f\u6210\u6682\u4f30\u51ed\u8bc1\u3002", (String)"PeriodVoucherValidHelper_6", (String)"fi-cal-common", (Object[])new Object[0]);
            }
            if (DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargeType) && ("B".equals(writeoffStatus) || "".equals(writeoffStatus))) {
                isContain = true;
                if (bookdate.compareTo(endDate) > 0) {
                    return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u6708\u521d\u4e00\u6b21\u51b2\u56de\u201d\u4e14\u6838\u9500\u72b6\u6001\u4e3a\u201c\u672a\u6838\u9500\u201d\u65f6\uff0c\u8bb0\u8d26\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_7", (String)"fi-cal-common", (Object[])new Object[0]);
                }
            }
            if (DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType) && ("B".equals(writeoffStatus) || "".equals(writeoffStatus))) {
                isContain = true;
                if (!isInitBill && bookdate.compareTo(endDate) > 0) {
                    return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u5355\u5230\u51b2\u56de\u201d\u4e14\u6838\u9500\u72b6\u6001\u4e3a\u201c\u672a\u6838\u9500\u201d\u4e14\u521d\u59cb\u5316\u5355\u636e\u6807\u8bc6\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u8bb0\u8d26\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_8", (String)"fi-cal-common", (Object[])new Object[0]);
                }
            }
        }
        if (!isContain) {
            return ResManager.loadKDString((String)"\u8be5\u8bb0\u5f55\u4e0d\u7b26\u5408\u6682\u4f30\u51ed\u8bc1\u7684\u8fc7\u6ee4\u89c4\u5219\uff0c\u4e0d\u80fd\u751f\u6210\u6682\u4f30\u51ed\u8bc1\u3002", (String)"PeriodVoucherValidHelper_11", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        return null;
    }

    public String doDischargeValidate(DynamicObject costRecord) {
        Object costAccount = costRecord.get("costaccount");
        long costAccountId = 0L;
        if (costAccount instanceof DynamicObject) {
            costAccountId = ((DynamicObject)costAccount).getLong("id");
        } else if (costAccount instanceof Long) {
            costAccountId = (Long)costAccount;
        }
        Date writeoffTime = costRecord.getDate("writeoffdate");
        String dischargeType = costRecord.getString("dischargetype");
        boolean isTempVoucher = costRecord.getBoolean("istempvoucher");
        String writeoffStatus = costRecord.getString("writeoffstatus");
        boolean issplitcreate = costRecord.getBoolean("issplitcreate");
        boolean isContain = false;
        Object bizEntityObject = costRecord.get("bizentityobject");
        String bizEntityObjectNumber = null;
        if (bizEntityObject instanceof DynamicObject) {
            bizEntityObjectNumber = ((DynamicObject)bizEntityObject).getString("number");
        } else if (bizEntityObject instanceof String) {
            bizEntityObjectNumber = (String)bizEntityObject;
        }
        if (this.purBills != null && this.purBills.contains(bizEntityObjectNumber)) {
            if (DischargeTypeEnum.UNCLEAR.getValue().equals(dischargeType)) {
                return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u5dee\u989d\u8c03\u6574\u201d\u65f6\uff0c\u4e0d\u652f\u6301\u751f\u6210\u51b2\u56de\u51ed\u8bc1\u3002", (String)"PeriodVoucherValidHelper_9", (String)"fi-cal-common", (Object[])new Object[0]);
            }
            if (isTempVoucher && DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargeType) && "A".equals(writeoffStatus)) {
                isContain = true;
                DynamicObject curPeriod = this.allCurPeriod.get(costAccountId);
                if (curPeriod == null) {
                    return ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_5", (String)"fi-cal-common", (Object[])new Object[0]);
                }
                Date beginDate = curPeriod.getDate("begindate");
                if (writeoffTime.compareTo(beginDate) < 0) {
                    return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e3a\u201c\u5355\u5230\u51b2\u56de\u201d\u4e14\u6682\u4f30\u6807\u8bc6\u4e3a\u201c\u662f\u201d\u4e14\u6838\u9500\u72b6\u6001\u4e3a\u201c\u5df2\u6838\u9500\u201d\u65f6\uff0c\u6838\u9500\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_1", (String)"fi-cal-common", (Object[])new Object[0]);
                }
            }
            if (DischargeTypeEnum.BEGINPERIODCLEAR.getValue().equals(dischargeType) && !issplitcreate) {
                isContain = true;
            }
        }
        if (!isContain) {
            return ResManager.loadKDString((String)"\u8be5\u8bb0\u5f55\u4e0d\u7b26\u5408\u51b2\u56de\u51ed\u8bc1\u7684\u8fc7\u6ee4\u89c4\u5219\uff0c\u4e0d\u80fd\u751f\u6210\u51b2\u56de\u51ed\u8bc1\u3002", (String)"PeriodVoucherValidHelper_12", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        return null;
    }

    public String doSaleIssueValidate(DynamicObject costRecord, boolean isDeleteVoucher) {
        Object costAccount = costRecord.get("costaccount");
        long costAccountId = 0L;
        if (costAccount instanceof DynamicObject) {
            costAccountId = ((DynamicObject)costAccount).getLong("id");
        } else if (costAccount instanceof Long) {
            costAccountId = (Long)costAccount;
        }
        Date bizTime = costRecord.getDate("bookdate");
        DynamicObject curPeriod = this.allCurPeriod.get(costAccountId);
        if (curPeriod == null) {
            return ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_5", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        Date beginDate = curPeriod.getDate("begindate");
        if (bizTime.compareTo(beginDate) < 0) {
            if (isDeleteVoucher) {
                return ResManager.loadKDString((String)"\u51ed\u8bc1\u6765\u6e90\u7cfb\u7edf\u4e3a\u5b58\u8d27\u6838\u7b97\uff0c\u4e0d\u80fd\u5220\u9664\u6838\u7b97\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u51ed\u8bc1", (String)"PeriodVoucherValidHelper_21", (String)"fi-cal-common", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_2", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        return null;
    }

    public String doSaleCarryOverValidate(DynamicObject costRecord, boolean isDeleteVoucher) {
        Object costAccount = costRecord.get("costaccount");
        long costAccountId = 0L;
        if (costAccount instanceof DynamicObject) {
            costAccountId = ((DynamicObject)costAccount).getLong("id");
        } else if (costAccount instanceof Long) {
            costAccountId = (Long)costAccount;
        }
        Date writeOffDate = costRecord.getDate("writeoffdate");
        DynamicObject curPeriod = this.allCurPeriod.get(costAccountId);
        if (curPeriod == null) {
            return ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_5", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        Date beginDate = curPeriod.getDate("begindate");
        String writeoffStatus = costRecord.getString("writeoffstatus");
        String writeoffType = costRecord.getString("writeofftype");
        boolean isContain = false;
        Object bizEntityObject = costRecord.get("bizentityobject");
        String bizEntityObjectNumber = null;
        if (bizEntityObject instanceof DynamicObject) {
            bizEntityObjectNumber = ((DynamicObject)bizEntityObject).getString("number");
        } else if (bizEntityObject instanceof String) {
            bizEntityObjectNumber = (String)bizEntityObject;
        }
        if (("im_saloutbill".equals(bizEntityObjectNumber) || "im_salreturnbill".equals(bizEntityObjectNumber)) && "A".equals(writeoffStatus) && "B".equals(writeoffType)) {
            isContain = true;
            if (writeOffDate.compareTo(beginDate) < 0) {
                if (isDeleteVoucher) {
                    return ResManager.loadKDString((String)"\u6838\u9500\u65e5\u671f\u5c0f\u4e8e\u6838\u7b97\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u80fd\u5220\u9664\u6838\u7b97\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u51ed\u8bc1", (String)"PeriodVoucherValidHelper_25", (String)"fi-cal-common", (Object[])new Object[0]);
                }
                return ResManager.loadKDString((String)"\u6838\u9500\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_3", (String)"fi-cal-common", (Object[])new Object[0]);
            }
        }
        if (!isContain) {
            return ResManager.loadKDString((String)"\u8be5\u8bb0\u5f55\u4e0d\u7b26\u5408\u7ed3\u8f6c\u51ed\u8bc1\u7684\u8fc7\u6ee4\u89c4\u5219\uff0c\u4e0d\u80fd\u751f\u6210\u7ed3\u8f6c\u51ed\u8bc1\u3002", (String)"PeriodVoucherValidHelper_13", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        return null;
    }

    public String doFeeValidate(DynamicObject costRecord, boolean isDeleteVoucher) {
        Object costAccount = costRecord.get("costaccount");
        long costAccountId = 0L;
        if (costAccount instanceof DynamicObject) {
            costAccountId = ((DynamicObject)costAccount).getLong("id");
        } else if (costAccount instanceof Long) {
            costAccountId = (Long)costAccount;
        }
        Date bizTime = costRecord.getDate("bookdate");
        String dischargeType = costRecord.getString("dischargetype");
        boolean issplitcreate = costRecord.getBoolean("issplitcreate");
        String calbilltype = costRecord.getString("calbilltype");
        boolean isContain = false;
        Object bizEntityObject = costRecord.get("bizentityobject");
        String bizEntityObjectNumber = null;
        if (bizEntityObject instanceof DynamicObject) {
            bizEntityObjectNumber = ((DynamicObject)bizEntityObject).getString("number");
        } else if (bizEntityObject instanceof String) {
            bizEntityObjectNumber = (String)bizEntityObject;
        }
        if (this.purBills != null && this.purBills.contains(bizEntityObjectNumber) && !DischargeTypeEnum.UNCLEAR.getValue().equals(dischargeType) && !issplitcreate && "IN".equals(calbilltype)) {
            isContain = true;
            DynamicObject curPeriod = this.allCurPeriod.get(costAccountId);
            if (curPeriod == null) {
                return ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_5", (String)"fi-cal-common", (Object[])new Object[0]);
            }
            Date beginDate = curPeriod.getDate("begindate");
            if (bizTime.compareTo(beginDate) < 0) {
                if (isDeleteVoucher) {
                    return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e0d\u7b49\u4e8e\u5dee\u989d\u8c03\u6574\u65f6\uff0c\u4e0d\u80fd\u5220\u9664\u6838\u7b97\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u51ed\u8bc1", (String)"PeriodVoucherValidHelper_24", (String)"fi-cal-common", (Object[])new Object[0]);
                }
                return ResManager.loadKDString((String)"\u51b2\u56de\u65b9\u5f0f\u4e0d\u7b49\u4e8e\u201c\u5dee\u989d\u8c03\u6574\u201d\u65f6\uff0c\u8bb0\u8d26\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_4", (String)"fi-cal-common", (Object[])new Object[0]);
            }
        }
        if (!isContain) {
            return ResManager.loadKDString((String)"\u8be5\u8bb0\u5f55\u4e0d\u7b26\u5408\u8d39\u7528\u51ed\u8bc1\u7684\u8fc7\u6ee4\u89c4\u5219\uff0c\u4e0d\u80fd\u751f\u6210\u8d39\u7528\u51ed\u8bc1\u3002", (String)"PeriodVoucherValidHelper_14", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        return null;
    }

    public String doOtherValidate(DynamicObject costRecord, boolean isDeleteVoucher) {
        Object costAccount = costRecord.get("costaccount");
        long costAccountId = 0L;
        if (costAccount instanceof DynamicObject) {
            costAccountId = ((DynamicObject)costAccount).getLong("id");
        } else if (costAccount instanceof Long) {
            costAccountId = (Long)costAccount;
        }
        Date bizTime = costRecord.getDate("bookdate");
        DynamicObject curPeriod = this.allCurPeriod.get(costAccountId);
        if (curPeriod == null) {
            return ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_5", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        Date beginDate = curPeriod.getDate("begindate");
        if (bizTime.compareTo(beginDate) < 0) {
            if (isDeleteVoucher) {
                return ResManager.loadKDString((String)"\u51ed\u8bc1\u6765\u6e90\u7cfb\u7edf\u4e3a\u5b58\u8d27\u6838\u7b97\uff0c\u4e0d\u80fd\u5220\u9664\u6838\u7b97\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u51ed\u8bc1", (String)"PeriodVoucherValidHelper_21", (String)"fi-cal-common", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u671f\u95f4\u3002", (String)"PeriodVoucherValidHelper_2", (String)"fi-cal-common", (Object[])new Object[0]);
        }
        return null;
    }

    public Map<Long, DynamicObject> getAllCurPeriod() {
        return this.allCurPeriod;
    }

    public void setAllCurPeriod(Map<Long, DynamicObject> allCurPeriod) {
        this.allCurPeriod = allCurPeriod;
    }
}

