/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.PrintServicePluginProxy;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.validation.FieldScanner;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.print.dataprovider.ReportDataProvider;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class PrintHelper {
    public static Object getDefaultTemplateId(String formId) {
        QFilter[] qFilters;
        DynamicObject defaultObj;
        DynamicObject preferenceScheme;
        Object dTemplateId = null;
        Map<String, Object> printSetting = PrintHelper.getPrintSetting(formId);
        if (!printSetting.isEmpty()) {
            dTemplateId = printSetting.get("templateid");
        }
        if (ObjectUtils.isEmpty(dTemplateId) && (preferenceScheme = PrintHelper.getEnableScheme(formId)) != null) {
            dTemplateId = preferenceScheme.get("defaultprinter");
        }
        if (ObjectUtils.isEmpty((Object)dTemplateId) && (defaultObj = QueryServiceHelper.queryOne((String)"bas_manageprinttpl", (String)"printtplid.id", (QFilter[])(qFilters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)}))) != null) {
            dTemplateId = (String)defaultObj.get("printtplid.id");
        }
        return dTemplateId;
    }

    private static Map<String, Object> getPrintSetting(String formId) {
        Map<String, Object> myPrintSetting = new HashMap<String, Object>();
        String configKey = formId;
        String userId = RequestContext.get().getUserId();
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)configKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            myPrintSetting = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return myPrintSetting;
    }

    private static DynamicObject getEnableScheme(String formId) {
        Optional firstScheme;
        DynamicObject scheme = null;
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("ispreference", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        Map schemes = BusinessDataServiceHelper.loadFromCache((String)"bos_printingscheme", (QFilter[])filters);
        if (!schemes.isEmpty() && (firstScheme = schemes.values().stream().findFirst()).isPresent()) {
            scheme = (DynamicObject)firstScheme.get();
        }
        return scheme;
    }

    public static FormShowParameter buildParameter(String pdfUrl) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_printpreview");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.setCustomParam("src", (Object)pdfUrl);
        return para;
    }

    public static ReportDataProvider createReportDataProvider(String pageId, String formId, PrintMetadata printMeta) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        ArrayList pluginMap = new ArrayList();
        for (Plugin p : printMeta.getRootAp().getPlugins()) {
            if (!p.isEnabled()) continue;
            HashMap<String, Object> mp = new HashMap<String, Object>(1);
            mp.put("type", p.getType());
            mp.put("className", p.getClassName());
            pluginMap.add(mp);
        }
        PrintServicePluginProxy proxy = null;
        Map customFields = null;
        if (!pluginMap.isEmpty()) {
            proxy = new PrintServicePluginProxy(pluginMap);
            FieldScanner fieldScanner = new FieldScanner(printMeta);
            customFields = fieldScanner.scanCustomFields();
        }
        return new ReportDataProvider(pageId, entityType, customFields, proxy);
    }

    public static boolean isPerm(String entityId, String permType) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appId = AppMetadataCache.getAppInfo((String)"cal").getId();
        HasPermOrgResult hasPermOrg = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"/KIUHEXROK3D", (String)appId, (String)entityId, (String)permType);
        return hasPermOrg != null && (hasPermOrg.hasAllOrgPerm() || !hasPermOrg.getHasPermOrgs().isEmpty());
    }

    public static void registerStringProperty(DynamicObjectType dt, String ... fieldKeys) {
        for (int i = 0; i < fieldKeys.length; ++i) {
            String fieldKey = fieldKeys[i];
            dt.registerProperty(fieldKey, String.class, (Object)"", false);
        }
    }

    public static void registerStringProperty(DynamicObjectType dt, String[] ... allFieldKeys) {
        String[][] fieldKeys = allFieldKeys;
        for (int i = 0; i < allFieldKeys.length; ++i) {
            String[] fieldKey = fieldKeys[i];
            for (int j = 0; j < fieldKey.length; ++j) {
                String fieldName = fieldKey[j];
                dt.registerProperty(fieldName, String.class, (Object)"", false);
            }
        }
    }

    public static String[] getExistFromPrintAndCurrent(CustomPrintDataEntitiesArgs e, String[] allFields) {
        Set<String> allFieldSet = Stream.of(allFields).collect(Collectors.toSet());
        Set customFields = e.getCustomFields();
        if (customFields != null) {
            allFieldSet.retainAll(customFields);
        }
        return allFieldSet.toArray(new String[0]);
    }

    public static String[] getExistFromPrintAndCurrent(List<String> cusField, String[] allFields) {
        Set<String> allFieldSet = Stream.of(allFields).collect(Collectors.toSet());
        if (cusField != null) {
            allFieldSet.retainAll(cusField);
        }
        return allFieldSet.toArray(new String[0]);
    }

    public static void setListValueToPrint(DynamicObject rowData, DynamicObject printRow, String ... fieldKeys) {
        List<String> existPropertys = PrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            printRow.set(fieldKey, (Object)rowData.getString(fieldKey));
        }
    }

    public static void setListValueToPrint(DynamicObject rowData, DataRowSet printDyn, String ... filterItems) {
        String[] var3 = filterItems;
        int var4 = filterItems.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            String itemKey = var3[var5];
            printDyn.add(itemKey, (Field)new TextField(rowData.getString(itemKey)));
        }
    }

    public static List<String> existProperty(DynamicObject rowData, String ... fieldKeys) {
        DataEntityPropertyCollection properties = rowData.getDataEntityType().getProperties();
        ArrayList<String> existFieldKeys = new ArrayList<String>(fieldKeys.length);
        String[] filelds = fieldKeys;
        for (int i = 0; i < fieldKeys.length; ++i) {
            IDataEntityProperty property;
            String fieldKey;
            String key = fieldKey = filelds[i];
            if (fieldKey.contains(".")) {
                String[] split = fieldKey.split("\\.");
                key = split[0];
            }
            if ((property = (IDataEntityProperty)properties.get((Object)key)) == null) continue;
            existFieldKeys.add(fieldKey);
        }
        return existFieldKeys;
    }

    public static void setFilterValueToPrint(FilterInfo filterInfo, DynamicObject printObject, String ... filterItems) {
        String[] selfDefinitionField = filterItems;
        for (int i = 0; i < filterItems.length; ++i) {
            String itemKey = selfDefinitionField[i];
            DynamicObject filterObj = filterInfo.getDynamicObject(itemKey);
            if (filterObj == null) continue;
            printObject.set(itemKey, (Object)filterObj.getString("name"));
        }
    }

    public static void setFilterValueToPrint(FilterInfo filterInfo, DataRowSet printObject, String ... filterItems) {
        String[] selfDefinitionField = filterItems;
        for (int i = 0; i < filterItems.length; ++i) {
            String itemKey = selfDefinitionField[i];
            DynamicObject filterObj = filterInfo.getDynamicObject(itemKey);
            if (filterObj == null) continue;
            printObject.add(itemKey, (Field)new TextField(filterObj.getString("name")));
        }
    }

    public static String getPageNumType(String formId) {
        String userId = RequestContext.get().getUserId();
        String key = formId + "_printsetting";
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)key);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
            Object pageNumType = jsonData.get("pageNumType");
            return pageNumType == null ? "2" : (String)pageNumType;
        }
        return "2";
    }
}

