/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.SCMHelper;

public class ReportF7Helper {
    public static Set<Object> beforeF7Warehouse(DynamicObjectCollection storageOrgs, Object calOrgObj) {
        HashSet<Object> set = new HashSet<Object>();
        if (storageOrgs != null && storageOrgs.size() > 0) {
            for (DynamicObject info : storageOrgs) {
                Long[] warehouseIds = SCMHelper.getAllWarehouseIDs(info.getDynamicObject("fbasedataid").getString("number"));
                if (warehouseIds == null) continue;
                Long[] longArray = warehouseIds;
                int n = longArray.length;
                for (int i = 0; i < n; ++i) {
                    long id = longArray[i];
                    set.add(id);
                }
            }
        } else if (calOrgObj != null) {
            Long[] warehouseIds;
            List<Object> wareHouseList = new ArrayList(16);
            if (calOrgObj instanceof DynamicObject) {
                wareHouseList = OrgHelper.getStorageOrgUnitByCalOrg(((DynamicObject)calOrgObj).getLong("id"));
            } else if (calOrgObj instanceof DynamicObjectCollection) {
                for (DynamicObject calOrg : (DynamicObjectCollection)calOrgObj) {
                    List<Long> list = OrgHelper.getStorageOrgUnitByCalOrg(calOrg.getDynamicObject("fbasedataid").getLong("id"));
                    wareHouseList.addAll(list);
                }
            }
            Long[] longArray = warehouseIds = SCMHelper.getAllWarehouseIDs(wareHouseList.toArray());
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long id = longArray[i];
                set.add(id);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ReportF7Helper_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        return set;
    }

    public static void beforeF7Select4Material(BeforeF7SelectEvent e) {
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        formShowParameter.setF7ClickByFilter(true);
        formShowParameter.setShowApproved(false);
        formShowParameter.setShowUsed(false);
        formShowParameter.getListFilterParameter();
    }

    public static void beforeF7Select4StandardMatGroup(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Long mgs = 730148448254487552L;
        QFilter qFilter = new QFilter("standard", "=", (Object)mgs);
        showParameter.setCustomParam("groupStandard", (Object)mgs);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public static void beforeF7Select4NewMaterial(BeforeF7SelectEvent e, List<Long> orgIds) {
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        if (orgIds.isEmpty()) {
            params.put("isShowAllNoOrg", "true");
            formShowParameter.setCustomParams(params);
        } else {
            params.put("useOrgs", orgIds);
            formShowParameter.setCustomParams(params);
        }
        formShowParameter.setF7ClickByFilter(true);
        formShowParameter.setShowApproved(false);
        formShowParameter.setShowUsed(false);
        formShowParameter.getListFilterParameter();
    }
}

