/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SCMHelper {
    public static Long[] getAllWarehouseIDs(String orgNumber) {
        Long[] warehsIds = (Long[])DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"getAllFinishInitWarehouseIDs", (Object[])new Object[]{orgNumber});
        return warehsIds;
    }

    public static Long[] getAllInUseWarehouseIDs(String orgNumber) {
        Long[] warehsIds = (Long[])DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvService", (String)"getAllWarehouseIDs", (Object[])new Object[]{orgNumber});
        return warehsIds;
    }

    public static List<Long> getAllInUseWarehouseIDs(List<Object> orgIds) {
        return (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IWareHouseService", (String)"getAllSetupWarehouseIDs", (Object[])new Object[]{orgIds});
    }

    public static Long[] getAllWarehouseIDs(Object[] orgIds) {
        ArrayList<Long> list = new ArrayList<Long>();
        Long[] orgid = new Long[orgIds.length];
        for (int i = 0; i < orgIds.length; ++i) {
            orgid[i] = Long.valueOf(orgIds[i].toString());
        }
        Map warehouseIdsMap = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IWareHouseService", (String)"getAllFinishInitWarehouseIDsByOrgIDs", (Object[])new Object[]{orgid});
        for (Long[] warehouseIds : warehouseIdsMap.values()) {
            if (warehouseIds == null) continue;
            list.addAll(Arrays.asList(warehouseIds));
        }
        return list.toArray(new Long[0]);
    }

    public static Long[] getAllLocationIDs(Object[] warehouseIds) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_warehouse", (String)"entryentity.location", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)warehouseIds)});
        HashSet<Long> set = new HashSet<Long>();
        for (DynamicObject info : coll) {
            set.add(info.getLong("entryentity.location"));
        }
        return set.toArray(new Long[0]);
    }

    public static List<Long> getAllLocationIDs(DynamicObject warehouse) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (warehouse == null) {
            return ids;
        }
        DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject location : locationCol) {
            ids.add(location.getLong("location.id"));
        }
        return ids;
    }

    public static String getEntryKey(String entityname) {
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)entityname);
        for (Map.Entry entryItem : bizEntityType.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entryItem.getValue();
            if (!(entityType instanceof EntryType) || entityType instanceof LinkEntryType || entityType instanceof SubEntryType) continue;
            return entityType.getName();
        }
        return null;
    }

    public static Set<Long> getCalInvSchemes() {
        HashSet<Long> invSchemeIdSet = new HashSet<Long>(16);
        DynamicObjectCollection invSchemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id", (QFilter[])new QFilter("isforwardamount", "=", (Object)Character.valueOf('1')).toArray());
        for (DynamicObject invScheme : invSchemes) {
            invSchemeIdSet.add(invScheme.getLong("id"));
        }
        return invSchemeIdSet;
    }

    public static Set<Long> getCalInvTypes() {
        HashSet<Long> invTypeIdSet = new HashSet<Long>(16);
        DynamicObjectCollection invTypes = QueryServiceHelper.query((String)"bd_invtype", (String)"id", (QFilter[])new QFilter("isforwardamount", "=", (Object)Character.valueOf('1')).toArray());
        for (DynamicObject invType : invTypes) {
            invTypeIdSet.add(invType.getLong("id"));
        }
        return invTypeIdSet;
    }

    public static Long[] getAllLocationIDsByNumber(Object[] warehouseNumbers) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_warehouse", (String)"entryentity.location", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)warehouseNumbers)});
        HashSet<Long> set = new HashSet<Long>();
        for (DynamicObject info : coll) {
            set.add(info.getLong("entryentity.location"));
        }
        return set.toArray(new Long[0]);
    }
}

