/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.input.OrmInput;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.model.ScmFetchParam;
import kd.fi.cal.common.util.DateUtils;

public class ScmFetchHelper {
    private Set<String> SPBILLS = new HashSet<String>(8);
    private static final String CALBAL = "2";
    private static String invDimStr = "estorageorg,ewarehs,elocation,eownertype,eowner,einvtype,einvstatus,eauxpty,eproject,elot,ematerial,ebaseunit,econfiguredcode,tracknumber";
    private String[] invDimFields;
    private ScmFetchParam param;
    private Date firstDayOfMonth;
    private Date firstDayOfYear;
    private Map<String, String> mdcBillTypeMap = new HashMap<String, String>(5);

    public ScmFetchHelper(ScmFetchParam params) {
        this.init(params);
    }

    private void init(ScmFetchParam param) {
        this.SPBILLS.add("im_adjustbill");
        this.SPBILLS.add("im_assembbill");
        this.SPBILLS.add("im_locationtransfer");
        this.param = param;
        this.invDimFields = invDimStr.split(",");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.param.getEnddate());
        int year = calendar.get(1);
        calendar.set(5, 1);
        Date firstDayOfMonth = calendar.getTime();
        this.firstDayOfMonth = DateUtils.getDayStartTime(firstDayOfMonth);
        calendar.clear();
        calendar.set(1, year);
        Date currentYear = calendar.getTime();
        this.firstDayOfYear = DateUtils.getDayStartTime(currentYear);
        this.mdcBillTypeMap.put("im_mdc_mftmanuinbill", "im_mdc_mftmanuinbill_BT_S");
        this.mdcBillTypeMap.put("im_mdc_mftreturnbill", "im_mdc_mftreturnbill_BT_S");
        this.mdcBillTypeMap.put("im_mdc_mftproorder", "im_mdc_mftproorder_BT_S");
        this.mdcBillTypeMap.put("im_mdc_mftreturnorder", "im_mdc_mftreturnorder_BT_S_R");
        this.mdcBillTypeMap.put("im_mdc_mftfeedorder", "im_mdc_mftfeedorder_BT_R");
    }

    public DataSet fetchScmData() {
        DataSet invDs = this.getInvBgnQtyDataSet();
        if (this.param.isFirstDay() && this.param.isFirstMonth()) {
            invDs = invDs.filter("endperiod >= " + this.param.getInvPeriod()).select(invDimStr + ",invbgnqty,0 as inbaseqty,0 as outbaseqty").orderBy(new String[]{"estorageorg", "ematerial"});
            return invDs;
        }
        DataSet yearDs = invDs.copy();
        yearDs = yearDs.filter("period >= " + this.param.getInvYearFirstPeriod()).groupBy(this.invDimFields).sum("inbaseqty").sum("outbaseqty").finish();
        yearDs = yearDs.select(invDimStr + ",inbaseqty as yearinbaseqty,outbaseqty as yearoutbaseqty");
        invDs = invDs.filter("endperiod >= " + this.param.getInvPeriod()).select(invDimStr + ",invbgnqty,case when period < " + this.param.getInvYearFirstPeriod() + " then 0.0 else inbaseqty end as inbaseqty,case when period < " + this.param.getInvYearFirstPeriod() + " then 0.0 else outbaseqty end as outbaseqty");
        invDs = invDs.groupBy(this.invDimFields).sum("invbgnqty").max("inbaseqty").max("outbaseqty").finish();
        invDs = invDs.addField("0", "invrecqty");
        invDs = invDs.addField("0", "invsedqty");
        if (!yearDs.isEmpty()) {
            JoinDataSet invJoinYearDs = invDs.join(yearDs, JoinType.LEFT);
            for (String invDim : this.invDimFields) {
                invJoinYearDs = invJoinYearDs.on(invDim, invDim);
            }
            invDs = invJoinYearDs.select((invDimStr + ",invbgnqty,invrecqty,invsedqty,inbaseqty,outbaseqty").split(","), new String[]{"yearinbaseqty", "yearoutbaseqty"}).finish();
            invDs = invDs.select(invDimStr + ",invbgnqty,invrecqty,invsedqty,case when yearinbaseqty is null or yearinbaseqty = 0 then inbaseqty else yearinbaseqty end as inbaseqty,case when yearoutbaseqty is null or yearoutbaseqty = 0 then outbaseqty else yearoutbaseqty end as outbaseqty");
        }
        DataSet initBillDs = this.getInitBillDataSet();
        if (!(initBillDs = initBillDs.groupBy(this.invDimFields).sum("yreceivebaseqty").sum("ysendbaseqty").finish()).copy().isEmpty()) {
            JoinDataSet joinDataSet = invDs.join(initBillDs, JoinType.LEFT);
            for (String invDim : this.invDimFields) {
                joinDataSet = joinDataSet.on(invDim, invDim);
            }
            invDs = joinDataSet.select((invDimStr + ",invbgnqty,invrecqty,invsedqty,inbaseqty,outbaseqty").split(","), new String[]{"yreceivebaseqty", "ysendbaseqty"}).finish();
            invDs = invDs.select(invDimStr + ",invbgnqty,invrecqty,invsedqty,case when yreceivebaseqty is null then inbaseqty else yreceivebaseqty + inbaseqty end as inbaseqty,case when ysendbaseqty is null then outbaseqty else ysendbaseqty + outbaseqty end as outbaseqty");
        }
        if (!this.param.isFirstDay()) {
            DataSet invRecDs = this.getInvRecQtyDataSet();
            invDs = this.unionDataSet(invDs, invRecDs);
            DataSet invSedDs = this.getInvSedQtyDataSet();
            if (!invSedDs.isEmpty()) {
                invSedDs = invSedDs.filter(new QFilter("eowner", "in", (Object)this.param.getOwners()).toString());
                invDs = this.unionDataSet(invDs, invSedDs);
            }
            invDs = this.param.isFirstMonth() ? invDs.groupBy(this.invDimFields).sum("invbgnqty + invrecqty - invsedqty", "invbgnqty").sum("invrecqty", "inbaseqty").sum("invsedqty", "outbaseqty").finish() : invDs.groupBy(this.invDimFields).sum("invbgnqty + invrecqty - invsedqty", "invbgnqty").sum("invrecqty+inbaseqty", "inbaseqty").sum("invsedqty+outbaseqty", "outbaseqty").finish();
        }
        invDs = invDs.filter("invbgnqty <> 0 or inbaseqty <> 0 or outbaseqty <> 0").orderBy(new String[]{"estorageorg", "ematerial"});
        return invDs;
    }

    private DataSet getInitBillDataSet() {
        QFilter initBillF = new QFilter("biztime", "<", (Object)this.param.getEnddate());
        initBillF.and(new QFilter("biztime", ">=", (Object)this.firstDayOfYear));
        initBillF.and(new QFilter("billstatus", "=", (Object)BillStatus.C));
        initBillF.and(new QFilter("org", "in", this.param.getStorageOrgIds()));
        initBillF.and(new QFilter("billentry.owner", "in", (Object)this.param.getOwners()));
        initBillF.and(new QFilter("billentry.ownertype", "=", (Object)"bos_org"));
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".getInitBillDataSet"), (String)"im_initbill", (String)this.getInitSelect(), (QFilter[])new QFilter[]{initBillF}, null);
    }

    private DataSet getInvSedQtyDataSet() {
        Map<String, String> billRecSelectFields = this.getBillSedSelectFields();
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(billRecSelectFields.size());
        for (Map.Entry<String, String> item : billRecSelectFields.entrySet()) {
            String mdcBillType;
            QFilter sedOrgBasef = this.getInvBaseFilter(false, false);
            QFilter sedOutOrgBasef = this.getInvBaseFilter(true, false);
            QFilter filters = item.getKey().equalsIgnoreCase("im_transdirbill") ? sedOutOrgBasef : sedOrgBasef;
            filters = this.filterIsInitBill(item.getKey(), filters);
            filters = this.filterSedIsCal(item.getKey(), filters);
            if (!this.SPBILLS.contains(item.getKey())) {
                filters.and(new QFilter("invscheme.isoutupdate", "=", (Object)true));
            }
            if ((mdcBillType = this.mdcBillTypeMap.get(item.getKey())) != null) {
                filters.and(new QFilter("billtype.number", "=", (Object)mdcBillType));
            }
            OrmInput billIO = new OrmInput(this.getClass().getName() + item.getKey(), item.getKey(), item.getValue(), new QFilter[]{filters});
            billsIO.add(billIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        return algo.createDataSet((Input[])billsIO.toArray(new OrmInput[0]));
    }

    private QFilter filterSedIsCal(String formId, QFilter filters) {
        if (!this.SPBILLS.contains(formId)) {
            filters.and(new QFilter("invscheme.isforwardamount", "=", (Object)true));
            filters.and(new QFilter("billentry.outinvtype.isforwardamount", "=", (Object)true));
        } else {
            String invCalf = "im_assembbill".equals(formId) ? "billentry.afterentity.invtype1.isforwardamount" : "billentry.invtype.isforwardamount";
            filters.and(new QFilter(invCalf, "=", (Object)true));
        }
        if (!this.SPBILLS.contains(formId) || "im_locationtransfer".equals(formId)) {
            filters.and(new QFilter("billentry.logisticsbill", "=", (Object)false));
        }
        return filters;
    }

    private Map<String, String> getBillSedSelectFields() {
        HashMap<String, String> billSedFields = new HashMap<String, String>(32);
        String tplSedSelects = this.getTplSedSelects();
        billSedFields.put("im_purinbill", tplSedSelects);
        billSedFields.put("im_otherinbill", tplSedSelects);
        billSedFields.put("im_productinbill", tplSedSelects);
        billSedFields.put("im_purreceivebill", tplSedSelects);
        billSedFields.put("im_transdirbill", tplSedSelects.replaceAll("org(?=[\\.\\s])", "outorg").replace("billentry.location", "billentry.outlocation").replace("billentry.warehouse", "billentry.outwarehouse"));
        billSedFields.put("im_transoutbill", tplSedSelects);
        billSedFields.put("im_transinbill", tplSedSelects);
        billSedFields.put("im_saloutbill", tplSedSelects);
        billSedFields.put("im_materialreqoutbill", tplSedSelects);
        billSedFields.put("im_otheroutbill", tplSedSelects);
        for (String item : this.mdcBillTypeMap.keySet()) {
            billSedFields.put(item, tplSedSelects);
        }
        String adjSedSelects = tplSedSelects.replace("billentry.outownertype", "billentry.ownertype").replace("billentry.outowner", "billentry.owner").replace("billentry.outinvtype", "billentry.invtype").replace("billentry.outinvstatus", "billentry.invstatus");
        billSedFields.put("im_adjustbill", adjSedSelects);
        String assSedSelects = adjSedSelects.replaceAll("billentry\\.[a-zA-Z0-9_]*?(?=[\\s\\.])", "$01").replace("billentry", "billentry.afterentity").replace("material.masterid1", "material1.masterid");
        billSedFields.put("im_assembbill", assSedSelects);
        billSedFields.put("im_locationtransfer", adjSedSelects.replace("billentry.location", "billentry.outlocation"));
        return billSedFields;
    }

    private DataSet unionDataSet(DataSet oneDataSet, DataSet otherDataSet) {
        oneDataSet = oneDataSet == null ? otherDataSet : (otherDataSet == null ? oneDataSet : oneDataSet.union(otherDataSet));
        return oneDataSet;
    }

    private DataSet getInvBgnQtyDataSet() {
        Boolean isNewPeriodBal = (Boolean)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBalanceService", (String)"isNewPeriodBal", (Object[])new Object[0]);
        String selectFields = this.getInvBalanceSelector(isNewPeriodBal);
        QFilter filter = new QFilter("org", "in", this.param.getStorageOrgIds());
        filter.and(new QFilter("ownertype", "=", (Object)"bos_org"));
        QFilter periodf = new QFilter("period", "<", (Object)this.param.getInvPeriod());
        filter.and(periodf);
        if (!isNewPeriodBal.booleanValue()) {
            filter.and(new QFilter("balancetype", "=", (Object)CALBAL));
        }
        filter.and(new QFilter("owner", "in", (Object)this.param.getOwners()));
        String entityName = "im_invbalance";
        if (isNewPeriodBal.booleanValue()) {
            entityName = "im_cal_periodbalance";
        }
        return QueryServiceHelper.queryDataSet((String)(ScmFetchHelper.class + "getInvBalanceDataSet"), (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"org,material");
    }

    private DataSet getInvRecQtyDataSet() {
        Map<String, String> billRecSelectFields = this.getBillRecSelectFields();
        ArrayList<OrmInput> billsIO = new ArrayList<OrmInput>(billRecSelectFields.size());
        for (Map.Entry<String, String> item : billRecSelectFields.entrySet()) {
            String mdcBillType;
            String billType = item.getKey();
            QFilter filters = this.getInvBaseFilter(false, true);
            this.filterIsInitBill(billType, filters);
            this.filterRecIsCal(billType, filters);
            if (!this.SPBILLS.contains(billType)) {
                filters.and(new QFilter("invscheme.isinupdate", "=", (Object)true));
            }
            if ((mdcBillType = this.mdcBillTypeMap.get(item.getKey())) != null) {
                filters.and(new QFilter("billtype.number", "=", (Object)mdcBillType));
            }
            OrmInput billIO = new OrmInput(this.getClass().getName() + billType, billType, item.getValue(), new QFilter[]{filters});
            billsIO.add(billIO);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        return algo.createDataSet((Input[])billsIO.toArray(new OrmInput[0]));
    }

    private QFilter getInvBaseFilter(boolean isOutOrg, boolean isRec) {
        QFilter basef = new QFilter("biztime", "<", (Object)this.param.getEnddate());
        basef.and(new QFilter("biztime", ">=", (Object)this.firstDayOfMonth));
        basef.and(new QFilter("billstatus", "=", (Object)BillStatus.C));
        basef.and(new QFilter(isOutOrg ? "outorg" : "org", "in", this.param.getStorageOrgIds()));
        if (isRec) {
            basef.and(new QFilter("billentry.owner", "in", (Object)this.param.getOwners()));
        }
        return basef;
    }

    private QFilter filterIsInitBill(String formId, QFilter balfs) {
        if (formId.equalsIgnoreCase("im_purinbill") || formId.equalsIgnoreCase("im_saloutbill")) {
            balfs.and(new QFilter("isinitbill", "=", (Object)false));
        }
        return balfs;
    }

    private QFilter filterRecIsCal(String formId, QFilter filters) {
        String invCalf = "im_adjustbill".equals(formId) ? "billentry.afterentity.invtype1.isforwardamount" : "billentry.invtype.isforwardamount";
        filters.and(new QFilter(invCalf, "=", (Object)true));
        if (!this.SPBILLS.contains(formId)) {
            filters.and(new QFilter("invscheme.isforwardamount", "=", (Object)true));
        }
        if (!this.SPBILLS.contains(formId) || "im_locationtransfer".equals(formId)) {
            filters.and(new QFilter("billentry.logisticsbill", "=", (Object)false));
        }
        return filters;
    }

    private Map<String, String> getBillRecSelectFields() {
        HashMap<String, String> billRecFields = new HashMap<String, String>(32);
        String tplRecSelects = this.getTplRecSelects();
        billRecFields.put("im_purinbill", tplRecSelects);
        billRecFields.put("im_otherinbill", tplRecSelects);
        billRecFields.put("im_productinbill", tplRecSelects);
        billRecFields.put("im_purreceivebill", tplRecSelects);
        billRecFields.put("im_transdirbill", tplRecSelects.replace("billentry.lotnumber", "billentry.inlotnumber").replace("billentry.project", "billentry.inproject"));
        billRecFields.put("im_transoutbill", tplRecSelects);
        billRecFields.put("im_transinbill", tplRecSelects);
        billRecFields.put("im_saloutbill", tplRecSelects);
        billRecFields.put("im_materialreqoutbill", tplRecSelects);
        billRecFields.put("im_otheroutbill", tplRecSelects);
        for (String item : this.mdcBillTypeMap.keySet()) {
            billRecFields.put(item, tplRecSelects);
        }
        String adjRecSelects = tplRecSelects.replaceAll("billentry\\.[a-zA-Z0-9_]*?(?=[\\s\\.])", "$01").replace("billentry", "billentry.afterentity").replace("material.masterid1", "material1.masterid");
        billRecFields.put("im_adjustbill", adjRecSelects);
        billRecFields.put("im_assembbill", tplRecSelects);
        billRecFields.put("im_locationtransfer", tplRecSelects);
        return billRecFields;
    }

    private String getInvBalanceSelector(Boolean isNewPeriodBal) {
        StringBuilder sb = new StringBuilder();
        sb.append("org as estorageorg,warehouse as ewarehs,");
        sb.append("location as elocation,ownertype as eownertype,owner as eowner,");
        sb.append("invtype as einvtype,invstatus as einvstatus,auxpty as eauxpty,");
        sb.append("project as eproject,lotnumber as elot,");
        sb.append("material as ematerial,material.number as ematerialnum,baseunit as ebaseunit,");
        if (isNewPeriodBal.booleanValue()) {
            sb.append("configuredcode as econfiguredcode,tracknumber,isnull(baseqty_bal ,0) as invbgnqty,0 as invrecqty,0 as invsedqty,baseqty_in as inbaseqty,baseqty_out as outbaseqty,period,endperiod");
        } else {
            sb.append("0 as econfiguredcode,0 as tracknumber,isnull(endbaseqty ,0) as invbgnqty,0 as invrecqty,0 as invsedqty,inbaseqty,outbaseqty,period,endperiod");
        }
        return sb.toString();
    }

    public String getTplRecSelects() {
        StringBuilder sb = new StringBuilder();
        sb.append("org as estorageorg,billentry.warehouse as ewarehs,");
        sb.append("billentry.location as elocation,billentry.ownertype as eownertype,billentry.owner as eowner,");
        sb.append("billentry.invtype as einvtype,billentry.invstatus as einvstatus,billentry.auxpty as eauxpty,");
        sb.append("billentry.project as eproject,billentry.lotnumber as elot,");
        sb.append("billentry.material.masterid as ematerial,billentry.baseunit as ebaseunit,billentry.configuredcode as econfiguredcode,billentry.tracknumber as tracknumber,");
        sb.append("0 as invbgnqty,billentry.baseqty as invrecqty,0 as invsedqty,0 as inbaseqty,0 as outbaseqty");
        return sb.toString();
    }

    private String getTplSedSelects() {
        StringBuilder sb = new StringBuilder();
        sb.append("org as estorageorg,billentry.warehouse as ewarehs,");
        sb.append("billentry.location as elocation,billentry.outownertype as eownertype,billentry.outowner as eowner,");
        sb.append("billentry.outinvtype as einvtype,billentry.outinvstatus as einvstatus,billentry.auxpty as eauxpty,");
        sb.append("billentry.project as eproject,billentry.lotnumber as elot,");
        sb.append("billentry.material.masterid as ematerial,billentry.baseunit as ebaseunit,billentry.configuredcode as econfiguredcode,billentry.tracknumber as tracknumber,");
        sb.append("0 as invbgnqty,0 as invrecqty,billentry.baseqty as invsedqty,0 as inbaseqty,0 as outbaseqty");
        return sb.toString();
    }

    private String getInitSelect() {
        StringBuilder sb = new StringBuilder();
        sb.append("org as estorageorg,billentry.warehouse as ewarehs,");
        sb.append("billentry.location as elocation,billentry.ownertype as eownertype,billentry.owner as eowner,");
        sb.append("billentry.invtype as einvtype,billentry.invstatus as einvstatus,billentry.auxpty as eauxpty,");
        sb.append("billentry.project as eproject,billentry.lotnumber as elot,");
        sb.append("billentry.material.masterid as ematerial,billentry.baseunit as ebaseunit,billentry.configuredcode as econfiguredcode,billentry.tracknumber as tracknumber,");
        sb.append("billentry.yreceivebaseqty as yreceivebaseqty,billentry.ysendbaseqty as ysendbaseqty");
        return sb.toString();
    }
}

